/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.exceptions.NotAMatrix2DException;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DFeatures;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public abstract class Matrix3DReadOnlyTest<T extends Matrix3DReadOnly> {
    public static final double SMALL_EPS = 1.0E-12;

    public abstract T createEmptyMatrix();

    public abstract T createMatrix(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);

    public abstract T createRandomMatrix(Random var1);

    @Test
    public void testGettersForIndividualComponents() throws Exception {
        Random random = new Random(32424L);
        double m00 = random.nextDouble();
        double m01 = random.nextDouble();
        double m02 = random.nextDouble();
        double m10 = random.nextDouble();
        double m11 = random.nextDouble();
        double m12 = random.nextDouble();
        double m20 = random.nextDouble();
        double m21 = random.nextDouble();
        double m22 = random.nextDouble();
        Object matrix = this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        Assertions.assertEquals((double)m00, (double)matrix.getM00(), (double)1.0E-12);
        Assertions.assertEquals((double)m01, (double)matrix.getM01(), (double)1.0E-12);
        Assertions.assertEquals((double)m02, (double)matrix.getM02(), (double)1.0E-12);
        Assertions.assertEquals((double)m10, (double)matrix.getM10(), (double)1.0E-12);
        Assertions.assertEquals((double)m11, (double)matrix.getM11(), (double)1.0E-12);
        Assertions.assertEquals((double)m12, (double)matrix.getM12(), (double)1.0E-12);
        Assertions.assertEquals((double)m20, (double)matrix.getM20(), (double)1.0E-12);
        Assertions.assertEquals((double)m21, (double)matrix.getM21(), (double)1.0E-12);
        Assertions.assertEquals((double)m22, (double)matrix.getM22(), (double)1.0E-12);
        Assertions.assertEquals((double)m00, (double)matrix.getElement(0, 0), (double)1.0E-12);
        Assertions.assertEquals((double)m01, (double)matrix.getElement(0, 1), (double)1.0E-12);
        Assertions.assertEquals((double)m02, (double)matrix.getElement(0, 2), (double)1.0E-12);
        Assertions.assertEquals((double)m10, (double)matrix.getElement(1, 0), (double)1.0E-12);
        Assertions.assertEquals((double)m11, (double)matrix.getElement(1, 1), (double)1.0E-12);
        Assertions.assertEquals((double)m12, (double)matrix.getElement(1, 2), (double)1.0E-12);
        Assertions.assertEquals((double)m20, (double)matrix.getElement(2, 0), (double)1.0E-12);
        Assertions.assertEquals((double)m21, (double)matrix.getElement(2, 1), (double)1.0E-12);
        Assertions.assertEquals((double)m22, (double)matrix.getElement(2, 2), (double)1.0E-12);
        int j = 0;
        while (j < 3) {
            int jFinal = j++;
            EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getElement(jFinal, 3), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
            EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getElement(3, jFinal), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
        }
    }

    @Test
    public void testGetArray() throws Exception {
        Random random = new Random(4356L);
        T matrix = this.createRandomMatrix(random);
        double[] matrixArray = new double[9];
        matrix.get(matrixArray);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((matrix.getElement(row, column) == matrixArray[row * 3 + column] ? 1 : 0) != 0);
            }
        }
        int startIndex = random.nextInt(10);
        matrixArray = new double[9 + startIndex];
        matrix.get(startIndex, matrixArray);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((matrix.getElement(row, column) == matrixArray[row * 3 + column + startIndex] ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetDenseMatrix() throws Exception {
        Random random = new Random(4356L);
        Matrix3D matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        matrix.get((DMatrix)denseMatrix);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((matrix.getElement(row, column) == denseMatrix.get(row, column) ? 1 : 0) != 0);
            }
        }
        int startRow = random.nextInt(10);
        int startColumn = random.nextInt(10);
        denseMatrix = new DMatrixRMaj(3 + startRow, 3 + startColumn);
        matrix.get(startRow, startColumn, (DMatrix)denseMatrix);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((matrix.getElement(row, column) == denseMatrix.get(row + startRow, column + startColumn) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetColumn() throws Exception {
        Random random = new Random(655L);
        Object matrix = this.createRandomMatrix(random);
        double[] columnArray = new double[3];
        matrix.getColumn(0, columnArray);
        Assertions.assertTrue((matrix.getM00() == columnArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM10() == columnArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM20() == columnArray[2] ? 1 : 0) != 0);
        matrix.getColumn(1, columnArray);
        Assertions.assertTrue((matrix.getM01() == columnArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == columnArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == columnArray[2] ? 1 : 0) != 0);
        matrix.getColumn(2, columnArray);
        Assertions.assertTrue((matrix.getM02() == columnArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == columnArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == columnArray[2] ? 1 : 0) != 0);
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getColumn(-1, columnArray), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getColumn(3, columnArray), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
        Vector3D columnVector = new Vector3D();
        matrix.getColumn(0, (Tuple3DBasics)columnVector);
        Assertions.assertTrue((matrix.getM00() == columnVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM10() == columnVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM20() == columnVector.getElement(2) ? 1 : 0) != 0);
        matrix.getColumn(1, (Tuple3DBasics)columnVector);
        Assertions.assertTrue((matrix.getM01() == columnVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == columnVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == columnVector.getElement(2) ? 1 : 0) != 0);
        matrix.getColumn(2, (Tuple3DBasics)columnVector);
        Assertions.assertTrue((matrix.getM02() == columnVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == columnVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == columnVector.getElement(2) ? 1 : 0) != 0);
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getColumn(-1, (Tuple3DBasics)columnVector), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getColumn(3, (Tuple3DBasics)columnVector), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
    }

    @Test
    public void testGetRow() throws Exception {
        Random random = new Random(6465L);
        Matrix3D matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        double[] rowArray = new double[3];
        matrix.getRow(0, rowArray);
        Assertions.assertTrue((matrix.getM00() == rowArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM01() == rowArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM02() == rowArray[2] ? 1 : 0) != 0);
        matrix.getRow(1, rowArray);
        Assertions.assertTrue((matrix.getM10() == rowArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == rowArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == rowArray[2] ? 1 : 0) != 0);
        matrix.getRow(2, rowArray);
        Assertions.assertTrue((matrix.getM20() == rowArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == rowArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == rowArray[2] ? 1 : 0) != 0);
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getRow(-1, rowArray), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getRow(3, rowArray), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
        Vector3D rowVector = new Vector3D();
        matrix.getRow(0, (Tuple3DBasics)rowVector);
        Assertions.assertTrue((matrix.getM00() == rowVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM01() == rowVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM02() == rowVector.getElement(2) ? 1 : 0) != 0);
        matrix.getRow(1, (Tuple3DBasics)rowVector);
        Assertions.assertTrue((matrix.getM10() == rowVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == rowVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == rowVector.getElement(2) ? 1 : 0) != 0);
        matrix.getRow(2, (Tuple3DBasics)rowVector);
        Assertions.assertTrue((matrix.getM20() == rowVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == rowVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == rowVector.getElement(2) ? 1 : 0) != 0);
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getRow(-1, (Tuple3DBasics)rowVector), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix.getRow(3, (Tuple3DBasics)rowVector), (Class[])new Class[]{ArrayIndexOutOfBoundsException.class});
    }

    @Test
    public void testContainsNaN() throws Exception {
        Assertions.assertFalse((boolean)this.createMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN).containsNaN());
    }

    @Test
    public void testDeterminant() throws Exception {
        Random random = new Random(51665L);
        for (int i = 0; i < 1000; ++i) {
            T matrix = this.createRandomMatrix(random);
            double actualDeterminant = matrix.determinant();
            double expectedDeterminant = Matrix3DFeatures.determinant((double)matrix.getM00(), (double)matrix.getM01(), (double)matrix.getM02(), (double)matrix.getM10(), (double)matrix.getM11(), (double)matrix.getM12(), (double)matrix.getM20(), (double)matrix.getM21(), (double)matrix.getM22());
            Assertions.assertEquals((double)expectedDeterminant, (double)actualDeterminant, (double)1.0E-12);
        }
    }

    @Test
    public void testCheckIfRotationMatrix() throws Exception {
        Object matrix1 = this.createMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix1.checkIfRotationMatrix(), (String)("The matrix is not a rotation matrix: \n" + String.valueOf(matrix1)), (Class[])new Class[]{NotARotationMatrixException.class});
        T matrix2 = this.createMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        matrix2.checkIfRotationMatrix();
    }

    @Test
    public void testCheckIfMatrix2D() throws Exception {
        Random random = new Random(3242L);
        double d = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
        Object matrix1 = this.createMatrix(0.0, 0.0, d, 0.0, 0.0, d, d, d, d);
        EuclidCoreTestTools.assertExceptionIsThrown(() -> matrix1.checkIfMatrix2D(), (String)("The matrix is not in XY plane: \n" + String.valueOf(matrix1)), (Class[])new Class[]{NotAMatrix2DException.class});
        T matrix2 = this.createMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        matrix2.checkIfMatrix2D();
        matrix2 = this.createMatrix(d, d, 0.0, d, d, 0.0, 0.0, 0.0, 1.0);
        matrix2.checkIfMatrix2D();
    }

    @Test
    public void testIsIdentity() throws Exception {
        T matrix = this.createMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)matrix.isIdentity());
        Assertions.assertTrue((boolean)matrix.isIdentity(1.0E-12));
        matrix = this.createMatrix(1.0, 0.1, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertFalse((boolean)matrix.isIdentity());
        Assertions.assertFalse((boolean)matrix.isIdentity(1.0E-12));
    }

    @Test
    public void testIsRotationMatrix() throws Exception {
        T matrix = this.createMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)matrix.isRotationMatrix());
        Assertions.assertTrue((boolean)matrix.isRotationMatrix(1.0E-12));
        matrix = this.createMatrix(1.0, 0.1, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertFalse((boolean)matrix.isRotationMatrix());
        Assertions.assertFalse((boolean)matrix.isRotationMatrix(1.0E-12));
    }

    @Test
    public void testIsMatrix2D() throws Exception {
        Random random = new Random(3242L);
        double d = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
        T matrix = this.createMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)matrix.isMatrix2D());
        Assertions.assertTrue((boolean)matrix.isMatrix2D(1.0E-12));
        matrix = this.createMatrix(0.0, 0.0, d, 0.0, 0.0, d, d, d, d);
        Assertions.assertFalse((boolean)matrix.isMatrix2D());
        Assertions.assertFalse((boolean)matrix.isMatrix2D(1.0E-12));
        matrix = this.createMatrix(d, d, 0.0, d, d, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)matrix.isMatrix2D());
        Assertions.assertTrue((boolean)matrix.isMatrix2D(1.0E-12));
    }

    @Test
    public void testMatrixSkewSymmetric() throws Exception {
        Random random = new Random(3242L);
        double d = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
        T matrix = this.createMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertFalse((boolean)matrix.isMatrixSkewSymmetric());
        Assertions.assertFalse((boolean)matrix.isMatrixSkewSymmetric(1.0E-12));
        matrix = this.createMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.isMatrixSkewSymmetric());
        Assertions.assertTrue((boolean)matrix.isMatrixSkewSymmetric(1.0E-12));
        matrix = this.createMatrix(0.0, d, 0.0, -d, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.isMatrixSkewSymmetric());
        Assertions.assertTrue((boolean)matrix.isMatrixSkewSymmetric(1.0E-12));
    }

    @Test
    public void testTransform() throws Exception {
        T matrix;
        double sYaw;
        double cYaw;
        T matrix2;
        Vector3D expected;
        Vector3D actual;
        Vector3D original;
        int i;
        Random random = new Random(43535L);
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new Vector3D();
            expected = new Vector3D();
            matrix2 = this.createRandomMatrix(random);
            Matrix3DTools.transform(matrix2, (Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            actual.set(original);
            matrix2.transform((Tuple3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new Vector3D();
            expected = new Vector3D();
            matrix2 = this.createRandomMatrix(random);
            Matrix3DTools.transform(matrix2, (Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            matrix2.transform((Tuple3DReadOnly)original, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new Vector3D();
            expected = new Vector3D();
            matrix2 = this.createRandomMatrix(random);
            expected.set(original);
            Matrix3DTools.addTransform(matrix2, (Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            actual.set(original);
            matrix2.addTransform((Tuple3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = EuclidCoreRandomTools.nextVector3D((Random)random);
            expected = new Vector3D((Tuple3DReadOnly)actual);
            matrix2 = this.createRandomMatrix(random);
            Matrix3DTools.addTransform(matrix2, (Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            matrix2.addTransform((Tuple3DReadOnly)original, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new Vector2D();
            expected = new Vector2D();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            cYaw = EuclidCoreTools.cos((double)yaw);
            sYaw = EuclidCoreTools.sin((double)yaw);
            matrix = this.createMatrix(cYaw, -sYaw, 0.0, sYaw, cYaw, 0.0, 0.0, 0.0, 1.0);
            Matrix3DTools.transform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            actual.set((Vector2D)original);
            matrix.transform((Tuple2DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testTransform$12(random, (Vector2D)actual), (Class[])new Class[]{NotAMatrix2DException.class, NotAnOrientation2DException.class});
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new Vector2D();
            expected = new Vector2D();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            cYaw = EuclidCoreTools.cos((double)yaw);
            sYaw = EuclidCoreTools.sin((double)yaw);
            matrix = this.createMatrix(cYaw, -sYaw, 0.0, sYaw, cYaw, 0.0, 0.0, 0.0, 1.0);
            Matrix3DTools.transform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            matrix.transform((Tuple2DReadOnly)original, (Tuple2DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testTransform$13(random, (Vector2D)original, (Vector2D)actual), (Class[])new Class[]{NotAMatrix2DException.class, NotAnOrientation2DException.class});
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new Vector2D();
            expected = new Vector2D();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            cYaw = EuclidCoreTools.cos((double)yaw);
            sYaw = EuclidCoreTools.sin((double)yaw);
            matrix = this.createMatrix(cYaw, -sYaw, 0.0, sYaw, cYaw, 0.0, 0.0, 0.0, 1.0);
            Matrix3DTools.transform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            actual.set((Vector2D)original);
            matrix.transform((Tuple2DBasics)actual, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testTransform$14(random, (Vector2D)actual), (Class[])new Class[]{NotAMatrix2DException.class, NotAnOrientation2DException.class});
            matrix = this.createRandomMatrix(random);
            Matrix3DTools.transform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)false);
            actual.set((Vector2D)original);
            matrix.transform((Tuple2DBasics)actual, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new Vector2D();
            expected = new Vector2D();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            cYaw = EuclidCoreTools.cos((double)yaw);
            sYaw = EuclidCoreTools.sin((double)yaw);
            matrix = this.createMatrix(cYaw, -sYaw, 0.0, sYaw, cYaw, 0.0, 0.0, 0.0, 1.0);
            Matrix3DTools.transform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            matrix.transform((Tuple2DReadOnly)original, (Tuple2DBasics)actual, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testTransform$15(random, (Vector2D)original, (Vector2D)actual), (Class[])new Class[]{NotAMatrix2DException.class, NotAnOrientation2DException.class});
            matrix = this.createRandomMatrix(random);
            Matrix3DTools.transform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)false);
            actual.set((Vector2D)original);
            matrix.transform((Tuple2DReadOnly)original, (Tuple2DBasics)actual, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            T matrix3 = this.createRandomMatrix(random);
            Matrix3DTools.transform(matrix3, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            actual.set((Matrix3D)original);
            matrix3.transform((Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            T matrix4 = this.createRandomMatrix(random);
            Matrix3DTools.transform(matrix4, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            matrix4.transform((Matrix3DReadOnly)original, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-11);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            T matrix5 = this.createRandomMatrix(random);
            Matrix3DTools.transform(matrix5, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            actual.set((Vector4D)original);
            matrix5.transform((Vector4DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            T matrix6 = this.createRandomMatrix(random);
            Matrix3DTools.transform(matrix6, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            matrix6.transform((Vector4DReadOnly)original, (Vector4DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testInverseTransform() throws Exception {
        Matrix3D matrixInverse;
        T matrix;
        double sYaw;
        double cYaw;
        Matrix3D matrixInverse2;
        T matrix2;
        Vector3D expected;
        Vector3D actual;
        Vector3D original;
        int i;
        Random random = new Random(43535L);
        double epsilonMatrix = 1.0E-7;
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new Vector3D();
            expected = new Vector3D();
            matrix2 = this.createRandomMatrix(random);
            while (Math.abs(matrix2.determinant()) < 0.001) {
                matrix2 = this.createRandomMatrix(random);
            }
            Matrix3DTools.inverseTransform(matrix2, (Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            actual.set(original);
            matrix2.inverseTransform((Tuple3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            matrixInverse2 = new Matrix3D();
            matrixInverse2.setAndInvert(matrix2);
            matrixInverse2.transform((Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new Vector3D();
            expected = new Vector3D();
            matrix2 = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform(matrix2, (Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            matrix2.inverseTransform((Tuple3DReadOnly)original, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-11);
            matrixInverse2 = new Matrix3D();
            matrixInverse2.setAndInvert(matrix2);
            matrixInverse2.transform((Tuple3DReadOnly)original, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new Vector2D();
            expected = new Vector2D();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            cYaw = EuclidCoreTools.cos((double)yaw);
            sYaw = EuclidCoreTools.sin((double)yaw);
            matrix = this.createMatrix(cYaw, -sYaw, 0.0, sYaw, cYaw, 0.0, 0.0, 0.0, 1.0);
            Matrix3DTools.inverseTransform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            actual.set((Vector2D)original);
            matrix.inverseTransform((Tuple2DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            matrixInverse = new Matrix3D();
            matrixInverse.setAndInvert(matrix);
            matrixInverse.transform((Tuple2DReadOnly)original, (Tuple2DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testInverseTransform$16(random, (Vector2D)actual), (Class[])new Class[]{NotAMatrix2DException.class, NotAnOrientation2DException.class});
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new Vector2D();
            expected = new Vector2D();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            cYaw = EuclidCoreTools.cos((double)yaw);
            sYaw = EuclidCoreTools.sin((double)yaw);
            matrix = this.createMatrix(cYaw, -sYaw, 0.0, sYaw, cYaw, 0.0, 0.0, 0.0, 1.0);
            Matrix3DTools.inverseTransform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            matrix.inverseTransform((Tuple2DReadOnly)original, (Tuple2DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            matrixInverse = new Matrix3D();
            matrixInverse.setAndInvert(matrix);
            matrixInverse.transform((Tuple2DReadOnly)original, (Tuple2DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testInverseTransform$17(random, (Vector2D)original, (Vector2D)actual), (Class[])new Class[]{NotAMatrix2DException.class, NotAnOrientation2DException.class});
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new Vector2D();
            expected = new Vector2D();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            cYaw = EuclidCoreTools.cos((double)yaw);
            sYaw = EuclidCoreTools.sin((double)yaw);
            matrix = this.createMatrix(cYaw, -sYaw, 0.0, sYaw, cYaw, 0.0, 0.0, 0.0, 1.0);
            Matrix3DTools.inverseTransform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            actual.set((Vector2D)original);
            matrix.inverseTransform((Tuple2DBasics)actual, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            matrixInverse = new Matrix3D();
            matrixInverse.setAndInvert(matrix);
            matrixInverse.transform((Tuple2DReadOnly)original, (Tuple2DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testInverseTransform$18(random, (Vector2D)actual), (Class[])new Class[]{NotAMatrix2DException.class, NotAnOrientation2DException.class});
            matrix = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)false);
            actual.set((Vector2D)original);
            matrix.inverseTransform((Tuple2DBasics)actual, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new Vector2D();
            expected = new Vector2D();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            cYaw = EuclidCoreTools.cos((double)yaw);
            sYaw = EuclidCoreTools.sin((double)yaw);
            matrix = this.createMatrix(cYaw, -sYaw, 0.0, sYaw, cYaw, 0.0, 0.0, 0.0, 1.0);
            Matrix3DTools.inverseTransform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)true);
            matrix.inverseTransform((Tuple2DReadOnly)original, (Tuple2DBasics)actual, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            matrixInverse = new Matrix3D();
            matrixInverse.setAndInvert(matrix);
            matrixInverse.transform((Tuple2DReadOnly)original, (Tuple2DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testInverseTransform$19(random, (Vector2D)original, (Vector2D)actual), (Class[])new Class[]{NotAMatrix2DException.class, NotAnOrientation2DException.class});
            matrix = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform(matrix, (Tuple2DReadOnly)original, (Tuple2DBasics)expected, (boolean)false);
            actual.set((Vector2D)original);
            matrix.inverseTransform((Tuple2DReadOnly)original, (Tuple2DBasics)actual, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            T matrix3 = this.createRandomMatrix(random);
            while (Math.abs(matrix3.determinant()) < 0.001) {
                matrix3 = this.createRandomMatrix(random);
            }
            Matrix3DTools.inverseTransform(matrix3, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            actual.set((Matrix3D)original);
            matrix3.inverseTransform((Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)epsilonMatrix);
            matrixInverse2 = new Matrix3D();
            matrixInverse2.setAndInvert(matrix3);
            matrixInverse2.transform((Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)epsilonMatrix);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            T matrix4 = this.createRandomMatrix(random);
            while (Math.abs(matrix4.determinant()) < 0.001) {
                matrix4 = this.createRandomMatrix(random);
            }
            Matrix3DTools.inverseTransform(matrix4, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            matrix4.inverseTransform((Matrix3DReadOnly)original, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)epsilonMatrix);
            matrixInverse2 = new Matrix3D();
            matrixInverse2.setAndInvert(matrix4);
            matrixInverse2.transform((Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)(Math.max(1.0, expected.maxAbsElement()) * epsilonMatrix));
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            T matrix5 = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform(matrix5, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            actual.set((Vector4D)original);
            matrix5.inverseTransform((Vector4DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            matrixInverse2 = new Matrix3D();
            matrixInverse2.setAndInvert(matrix5);
            matrixInverse2.transform((Vector4DReadOnly)original, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            T matrix6 = this.createRandomMatrix(random);
            Matrix3DTools.inverseTransform(matrix6, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            matrix6.inverseTransform((Vector4DReadOnly)original, (Vector4DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            matrixInverse2 = new Matrix3D();
            matrixInverse2.setAndInvert(matrix6);
            matrixInverse2.transform((Vector4DReadOnly)original, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        T matrix = this.createRandomMatrix(random);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        double small = 0.999 * epsilon;
        double big = 1.001 * epsilon;
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00 + small, m01, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01 + small, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02 + small, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10 + small, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11 + small, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12 + small, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20 + small, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21 + small, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22 + small), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00 - small, m01, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01 - small, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02 - small, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10 - small, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11 - small, m12, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12 - small, m20, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20 - small, m21, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21 - small, m22), epsilon));
        Assertions.assertTrue((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22 - small), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00 + big, m01, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01 + big, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02 + big, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10 + big, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11 + big, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12 + big, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20 + big, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21 + big, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22 + big), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00 - big, m01, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01 - big, m02, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02 - big, m10, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10 - big, m11, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11 - big, m12, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12 - big, m20, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20 - big, m21, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21 - big, m22), epsilon));
        Assertions.assertFalse((boolean)matrix.epsilonEquals(this.createMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22 - big), epsilon));
    }

    private /* synthetic */ void lambda$testInverseTransform$19(Random random, Vector2D original, Vector2D actual) {
        this.createRandomMatrix(random).inverseTransform((Tuple2DReadOnly)original, (Tuple2DBasics)actual, true);
    }

    private /* synthetic */ void lambda$testInverseTransform$18(Random random, Vector2D actual) {
        this.createRandomMatrix(random).inverseTransform((Tuple2DBasics)actual, true);
    }

    private /* synthetic */ void lambda$testInverseTransform$17(Random random, Vector2D original, Vector2D actual) {
        this.createRandomMatrix(random).inverseTransform((Tuple2DReadOnly)original, (Tuple2DBasics)actual);
    }

    private /* synthetic */ void lambda$testInverseTransform$16(Random random, Vector2D actual) {
        this.createRandomMatrix(random).inverseTransform((Tuple2DBasics)actual);
    }

    private /* synthetic */ void lambda$testTransform$15(Random random, Vector2D original, Vector2D actual) {
        this.createRandomMatrix(random).transform((Tuple2DReadOnly)original, (Tuple2DBasics)actual, true);
    }

    private /* synthetic */ void lambda$testTransform$14(Random random, Vector2D actual) {
        this.createRandomMatrix(random).transform((Tuple2DBasics)actual, true);
    }

    private /* synthetic */ void lambda$testTransform$13(Random random, Vector2D original, Vector2D actual) {
        this.createRandomMatrix(random).transform((Tuple2DReadOnly)original, (Tuple2DBasics)actual);
    }

    private /* synthetic */ void lambda$testTransform$12(Random random, Vector2D actual) {
        this.createRandomMatrix(random).transform((Tuple2DBasics)actual);
    }
}

