/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public abstract class Tuple3DReadOnlyTest<T extends Tuple3DReadOnly> {
    public abstract T createEmptyTuple();

    public abstract T createTuple(double var1, double var3, double var5);

    public abstract T createRandomTuple(Random var1);

    public abstract double getEpsilon();

    @Test
    public void testGetters() throws Exception {
        Object tuple;
        float y;
        Object tuple2;
        double z;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y2 = random.nextDouble();
            z = random.nextDouble();
            tuple2 = this.createTuple(x, y2, z);
            Assertions.assertEquals((double)tuple2.getX(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple2.getY(), (double)y2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple2.getZ(), (double)z, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            y = random.nextFloat();
            float z2 = random.nextFloat();
            tuple = this.createTuple(x, y, z2);
            Assertions.assertEquals((double)tuple.getX32(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getY32(), (double)y, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getZ32(), (double)z2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y3 = random.nextDouble();
            z = random.nextDouble();
            tuple2 = this.createTuple(x, y3, z);
            Assertions.assertEquals((double)tuple2.getElement(0), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple2.getElement(1), (double)y3, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple2.getElement(2), (double)z, (double)this.getEpsilon());
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple2.getElement(-1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple2.getElement(3));
        }
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y4 = random.nextDouble();
            z = random.nextDouble();
            tuple2 = this.createTuple(x, y4, z);
            Assertions.assertEquals((double)tuple2.getElement(Axis3D.X), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple2.getElement(Axis3D.Y), (double)y4, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple2.getElement(Axis3D.Z), (double)z, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float z3;
            float x = random.nextFloat();
            tuple = this.createTuple(x, y = random.nextFloat(), z3 = random.nextFloat());
            Assertions.assertTrue((tuple.getElement32(0) == x ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getElement32(1) == y ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getElement32(2) == z3 ? 1 : 0) != 0);
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple.getElement32(-1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple.getElement32(3));
        }
        for (i = 0; i < 1000; ++i) {
            T tuple3 = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple3.get(tupleArray);
            Assertions.assertTrue((tuple3.getX() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple3.getY() == tupleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple3.getZ() == tupleArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple4 = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple4.get(2, tupleArray);
            Assertions.assertTrue((tuple4.getX() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple4.getY() == tupleArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple4.getZ() == tupleArray[4] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple5 = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple5.get(tupleArray);
            Assertions.assertTrue((tuple5.getX32() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple5.getY32() == tupleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple5.getZ32() == tupleArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple6 = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple6.get(2, tupleArray);
            Assertions.assertTrue((tuple6.getX32() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple6.getY32() == tupleArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple6.getZ32() == tupleArray[4] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple7 = this.createRandomTuple(random);
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple7.get((DMatrix)matrix);
            Assertions.assertTrue((tuple7.getX() == matrix.get(0, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple7.getY() == matrix.get(1, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple7.getZ() == matrix.get(2, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple8 = this.createRandomTuple(random);
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple8.get(2, (DMatrix)matrix);
            Assertions.assertTrue((tuple8.getX() == matrix.get(2, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple8.getY() == matrix.get(3, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple8.getZ() == matrix.get(4, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple9 = this.createRandomTuple(random);
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple9.get(2, 4, (DMatrix)matrix);
            Assertions.assertTrue((tuple9.getX() == matrix.get(2, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple9.getY() == matrix.get(3, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple9.getZ() == matrix.get(4, 4) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNorm() {
        Random random = new Random(312310L);
        for (int i = 0; i < 1000; ++i) {
            T tuple1 = this.createRandomTuple(random);
            double norm1 = tuple1.norm();
            double scalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            T tuple2 = this.createTuple(scalar * tuple1.getX(), scalar * tuple1.getY(), scalar * tuple1.getZ());
            double expectedNorm2 = scalar * norm1;
            double actualNorm2 = tuple2.norm();
            Assertions.assertEquals((double)expectedNorm2, (double)actualNorm2, (double)(Math.max(5.0, expectedNorm2) * this.getEpsilon()));
        }
    }

    @Test
    public void testNormSquared() {
        Random random = new Random(312310L);
        for (int i = 0; i < 1000; ++i) {
            T tuple1 = this.createRandomTuple(random);
            double norm1 = tuple1.norm();
            double scalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            T tuple2 = this.createTuple(scalar * tuple1.getX(), scalar * tuple1.getY(), scalar * tuple1.getZ());
            double expectedNorm2 = scalar * norm1;
            double actualNorm2 = tuple2.normSquared();
            Assertions.assertEquals((double)expectedNorm2, (double)EuclidCoreTools.squareRoot((double)actualNorm2), (double)(Math.max(5.0, expectedNorm2) * this.getEpsilon()));
        }
    }

    @Test
    public void testDot() {
        Random random = new Random(5461L);
        for (int i = 0; i < 1000; ++i) {
            T tuple1 = this.createRandomTuple(random);
            double scalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            tuple1 = this.createTuple(scalar * tuple1.getX(), scalar * tuple1.getY(), scalar * tuple1.getZ());
            Vector3D axis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(tuple1), (boolean)true);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)Math.PI);
            if (random.nextBoolean()) {
                angle = -angle;
            }
            RotationMatrix rotationMatrix = new RotationMatrix((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, angle));
            Vector3D rotated_tuple1 = new Vector3D();
            rotationMatrix.transform(tuple1, (Tuple3DBasics)rotated_tuple1);
            scalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)2.0);
            T tuple2 = this.createTuple(scalar * rotated_tuple1.getX(), scalar * rotated_tuple1.getY(), scalar * rotated_tuple1.getZ());
            double expectedDot = tuple1.norm() * tuple2.norm() * EuclidCoreTools.cos((double)angle);
            double actualDot = tuple1.dot(tuple2);
            Assertions.assertEquals((double)expectedDot, (double)actualDot, (double)(Math.max(5.0, Math.abs(expectedDot)) * this.getEpsilon()), (String)("Iteration: " + i + ", error: " + Math.abs(expectedDot - actualDot)));
        }
    }

    @Test
    public void testContainsNaN() throws Exception {
        Assertions.assertFalse((boolean)this.createTuple(0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(Double.NaN, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(0.0, Double.NaN, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(0.0, 0.0, Double.NaN).containsNaN());
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        T tuple = this.createRandomTuple(random);
        double x = tuple.getX();
        double y = tuple.getY();
        double z = tuple.getZ();
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x + 0.999 * epsilon, y, z), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x - 0.999 * epsilon, y, z), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y + 0.999 * epsilon, z), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y - 0.999 * epsilon, z), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y, z + 0.999 * epsilon), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y, z - 0.999 * epsilon), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x + 1.001 * epsilon, y, z), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x - 1.001 * epsilon, y, z), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y + 1.001 * epsilon, z), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y - 1.001 * epsilon, z), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y, z + 1.001 * epsilon), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y, z - 1.001 * epsilon), epsilon));
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(621541L);
        T tuple = this.createRandomTuple(random);
        Assertions.assertFalse((boolean)tuple.equals(this.createEmptyTuple()));
        Assertions.assertFalse((boolean)tuple.equals(null));
        Assertions.assertFalse((boolean)tuple.equals(new double[5]));
        double x = tuple.getX();
        double y = tuple.getY();
        double z = tuple.getZ();
        Assertions.assertTrue((boolean)tuple.equals(this.createTuple(x, y, z)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x + this.getEpsilon(), y, z)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x - this.getEpsilon(), y, z)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y + this.getEpsilon(), z)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y - this.getEpsilon(), z)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y, z + this.getEpsilon())));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y, z - this.getEpsilon())));
    }
}

