/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Capsule3D;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidFrameShapeToolsTest {
    private static final int ITERATIONS = 5000;
    private static final double EPSILON = 1.0E-12;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Test
    public void testBoundingBoxBox3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Box3D boxInFrame = EuclidShapeRandomTools.nextBox3D((Random)random);
            boxInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Box3D boxInWorld = new Box3D((Box3DReadOnly)boxInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxBox3D((Point3DReadOnly)boxInWorld.getPosition(), (RotationMatrixReadOnly)boxInWorld.getOrientation(), (Vector3DReadOnly)boxInWorld.getSize(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxBox3D((ReferenceFrame)worldFrame, (Box3DReadOnly)boxInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            boxInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Box3D boxInFrame = EuclidShapeRandomTools.nextBox3D((Random)random);
            boxInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Box3D boxInWorld = new Box3D((Box3DReadOnly)boxInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)boxInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxBox3D((Point3DReadOnly)boxInWorld.getPosition(), (RotationMatrixReadOnly)boxInWorld.getOrientation(), (Vector3DReadOnly)boxInWorld.getSize(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxBox3D((ReferenceFrame)shapeFrame, (Box3DReadOnly)boxInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            boxInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Box3D boxInFrame = EuclidShapeRandomTools.nextBox3D((Random)random);
            boxInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Box3D boxInBBXFrame = new Box3D((Box3DReadOnly)boxInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)boxInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxBox3D((Point3DReadOnly)boxInBBXFrame.getPosition(), (RotationMatrixReadOnly)boxInBBXFrame.getOrientation(), (Vector3DReadOnly)boxInBBXFrame.getSize(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxBox3D((ReferenceFrame)shapeFrame, (Box3DReadOnly)boxInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            boxInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxCapsule3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Capsule3D capsuleInFrame = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D capsuleInWorld = new Capsule3D((Capsule3DReadOnly)capsuleInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            capsuleInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCapsule3D((ReferenceFrame)worldFrame, (Capsule3DReadOnly)capsuleInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            capsuleInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Capsule3D capsuleInFrame = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D capsuleInWorld = new Capsule3D((Capsule3DReadOnly)capsuleInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)capsuleInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            capsuleInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCapsule3D((ReferenceFrame)shapeFrame, (Capsule3DReadOnly)capsuleInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            capsuleInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Capsule3D capsuleInFrame = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D capsuleInBBX = new Capsule3D((Capsule3DReadOnly)capsuleInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)capsuleInBBX);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            capsuleInBBX.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCapsule3D((ReferenceFrame)shapeFrame, (Capsule3DReadOnly)capsuleInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            capsuleInBBX.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxCylinder3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Cylinder3D cylinderInFrame = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Cylinder3D cylinderInWorld = new Cylinder3D((Cylinder3DReadOnly)cylinderInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            cylinderInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCylinder3D((ReferenceFrame)worldFrame, (Cylinder3DReadOnly)cylinderInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            cylinderInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Cylinder3D cylinderInFrame = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Cylinder3D cylinderInWorld = new Cylinder3D((Cylinder3DReadOnly)cylinderInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)cylinderInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            cylinderInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCylinder3D((ReferenceFrame)shapeFrame, (Cylinder3DReadOnly)cylinderInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            cylinderInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Cylinder3D cylinderInFrame = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Cylinder3D cylinderInBBX = new Cylinder3D((Cylinder3DReadOnly)cylinderInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)cylinderInBBX);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            cylinderInBBX.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCylinder3D((ReferenceFrame)shapeFrame, (Cylinder3DReadOnly)cylinderInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            cylinderInBBX.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxEllipsoid3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Ellipsoid3D ellipsoidInFrame = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            ellipsoidInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ellipsoid3D ellipsoidInWorld = new Ellipsoid3D((Ellipsoid3DReadOnly)ellipsoidInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxEllipsoid3D((Point3DReadOnly)ellipsoidInWorld.getPosition(), (RotationMatrixReadOnly)ellipsoidInWorld.getOrientation(), (Vector3DReadOnly)ellipsoidInWorld.getRadii(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxEllipsoid3D((ReferenceFrame)worldFrame, (Ellipsoid3DReadOnly)ellipsoidInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            ellipsoidInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Ellipsoid3D ellipsoidInFrame = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            ellipsoidInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ellipsoid3D ellipsoidInWorld = new Ellipsoid3D((Ellipsoid3DReadOnly)ellipsoidInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)ellipsoidInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxEllipsoid3D((Point3DReadOnly)ellipsoidInWorld.getPosition(), (RotationMatrixReadOnly)ellipsoidInWorld.getOrientation(), (Vector3DReadOnly)ellipsoidInWorld.getRadii(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxEllipsoid3D((ReferenceFrame)shapeFrame, (Ellipsoid3DReadOnly)ellipsoidInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            ellipsoidInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Ellipsoid3D ellipsoidInFrame = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            ellipsoidInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ellipsoid3D ellipsoidInBBXFrame = new Ellipsoid3D((Ellipsoid3DReadOnly)ellipsoidInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)ellipsoidInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxEllipsoid3D((Point3DReadOnly)ellipsoidInBBXFrame.getPosition(), (RotationMatrixReadOnly)ellipsoidInBBXFrame.getOrientation(), (Vector3DReadOnly)ellipsoidInBBXFrame.getRadii(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxEllipsoid3D((ReferenceFrame)shapeFrame, (Ellipsoid3DReadOnly)ellipsoidInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            ellipsoidInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxRamp3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Ramp3D rampInFrame = EuclidShapeRandomTools.nextRamp3D((Random)random);
            rampInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ramp3D rampInWorld = new Ramp3D((Ramp3DReadOnly)rampInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            rampInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxRamp3D((ReferenceFrame)worldFrame, (Ramp3DReadOnly)rampInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            rampInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Ramp3D rampInFrame = EuclidShapeRandomTools.nextRamp3D((Random)random);
            rampInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ramp3D rampInWorld = new Ramp3D((Ramp3DReadOnly)rampInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)rampInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            rampInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxRamp3D((ReferenceFrame)shapeFrame, (Ramp3DReadOnly)rampInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            rampInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Ramp3D rampInFrame = EuclidShapeRandomTools.nextRamp3D((Random)random);
            rampInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ramp3D rampInBBXFrame = new Ramp3D((Ramp3DReadOnly)rampInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)rampInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            rampInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxRamp3D((ReferenceFrame)shapeFrame, (Ramp3DReadOnly)rampInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            rampInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxSphere3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Sphere3D sphereInFrame = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D sphereInWorld = new Sphere3D((Sphere3DReadOnly)sphereInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            sphereInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxSphere3D((ReferenceFrame)worldFrame, (Sphere3DReadOnly)sphereInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            sphereInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Sphere3D sphereInFrame = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D sphereInWorld = new Sphere3D((Sphere3DReadOnly)sphereInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)sphereInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            sphereInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxSphere3D((ReferenceFrame)shapeFrame, (Sphere3DReadOnly)sphereInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            sphereInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Sphere3D sphereInFrame = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D sphereInBBXFrame = new Sphere3D((Sphere3DReadOnly)sphereInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)sphereInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            sphereInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxSphere3D((ReferenceFrame)shapeFrame, (Sphere3DReadOnly)sphereInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            sphereInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxConvexPolytope3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            ConvexPolytope3D convexPolytopeInFrame = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            convexPolytopeInFrame.applyTransform((Transform)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            ConvexPolytope3D convexPolytopeInWorld = new ConvexPolytope3D((ConvexPolytope3DReadOnly)convexPolytopeInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            convexPolytopeInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxConvexPolytope3D((ReferenceFrame)worldFrame, (ConvexPolytope3DReadOnly)convexPolytopeInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            convexPolytopeInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ConvexPolytope3D convexPolytopeInFrame = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            convexPolytopeInFrame.applyTransform((Transform)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            ConvexPolytope3D convexPolytopeInWorld = new ConvexPolytope3D((ConvexPolytope3DReadOnly)convexPolytopeInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)convexPolytopeInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            convexPolytopeInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxConvexPolytope3D((ReferenceFrame)shapeFrame, (ConvexPolytope3DReadOnly)convexPolytopeInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            convexPolytopeInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            ConvexPolytope3D convexPolytopeInFrame = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            convexPolytopeInFrame.applyTransform((Transform)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            ConvexPolytope3D convexPolytopeInBBXFrame = new ConvexPolytope3D((ConvexPolytope3DReadOnly)convexPolytopeInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)convexPolytopeInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            convexPolytopeInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxConvexPolytope3D((ReferenceFrame)shapeFrame, (ConvexPolytope3DReadOnly)convexPolytopeInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            convexPolytopeInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidCoreTestTools.assertEquals((String)("Iteration " + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testGetDistanceBetweenPointAndPlane1() {
        FramePoint3D pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FrameVector3D planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        FramePoint3D point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 3.0);
        double actual = EuclidFrameShapeTools.distanceFromPointToPlane((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal);
        double expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 3.0, 3.0, -3.0);
        actual = EuclidFrameShapeTools.distanceFromPointToPlane((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal);
        expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -3.0);
        actual = EuclidFrameShapeTools.distanceFromPointToPlane((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal);
        expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 3.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -3.0);
        actual = EuclidFrameShapeTools.distanceFromPointToPlane((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal);
        expected = 6.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 1.0, 0.0, 0.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 3.0, 0.0, 0.0);
        actual = EuclidFrameShapeTools.distanceFromPointToPlane((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal);
        expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 1.0, 0.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 3.0, 0.0);
        actual = EuclidFrameShapeTools.distanceFromPointToPlane((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal);
        expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 1.0, 1.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 1.0, 0.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 3.0, 0.0);
        actual = EuclidFrameShapeTools.distanceFromPointToPlane((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal);
        expected = 2.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12, (String)"FAILED: Distance from point to plane");
    }

    @Test
    public void testIsLineSegmentIntersectingPlane1() {
        FramePoint3D pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FrameVector3D planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        FramePoint3D lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -1.0);
        FramePoint3D lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 3.0);
        Assertions.assertTrue((boolean)EuclidFrameShapeTools.isLineSegmentIntersectingPlane((FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal, (FramePoint3DReadOnly)lineStart, (FramePoint3DReadOnly)lineEnd));
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 1.0, 0.0, 0.0);
        lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), -6.0, 3.0, -3.0);
        lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, 3.0, 6.0);
        Assertions.assertTrue((boolean)EuclidFrameShapeTools.isLineSegmentIntersectingPlane((FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal, (FramePoint3DReadOnly)lineStart, (FramePoint3DReadOnly)lineEnd));
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 1.0, 0.0);
        lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, -3.0, -3.0);
        lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, 3.0, 6.0);
        Assertions.assertTrue((boolean)EuclidFrameShapeTools.isLineSegmentIntersectingPlane((FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal, (FramePoint3DReadOnly)lineStart, (FramePoint3DReadOnly)lineEnd));
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, -3.0, 3.0);
        lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, 3.0, 6.0);
        Assertions.assertFalse((boolean)EuclidFrameShapeTools.isLineSegmentIntersectingPlane((FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal, (FramePoint3DReadOnly)lineStart, (FramePoint3DReadOnly)lineEnd));
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, -3.0, -3.0);
        lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, 3.0, -1.0);
        Assertions.assertFalse((boolean)EuclidFrameShapeTools.isLineSegmentIntersectingPlane((FramePoint3DReadOnly)pointOnPlane, (FrameVector3DReadOnly)planeNormal, (FramePoint3DReadOnly)lineStart, (FramePoint3DReadOnly)lineEnd));
    }

    @Test
    public void testGetPerpendicularVectorFromLineToPoint1() {
        FramePoint3D point0 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FramePoint3D lineStart0 = new FramePoint3D(ReferenceFrame.getWorldFrame(), -10.0, 10.0, 0.0);
        FramePoint3D lineEnd0 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 0.0);
        FramePoint3D intersectionPoint0 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 10.0, 0.0);
        FrameVector3D x0 = new FrameVector3D(point0.getReferenceFrame());
        x0.sub((FrameTuple3DReadOnly)point0, (FrameTuple3DReadOnly)intersectionPoint0);
        FrameVector3D expectedReturn0 = x0;
        FrameVector3D actualReturn0 = EuclidFrameShapeTools.getPerpendicularVectorFromLineToPoint((FramePoint3DReadOnly)point0, (FramePoint3DReadOnly)lineStart0, (FramePoint3DReadOnly)lineEnd0, (FramePoint3DBasics)intersectionPoint0);
        Assertions.assertTrue((boolean)expectedReturn0.epsilonEquals((EuclidFrameGeometry)actualReturn0, 1.0E-12), (String)"Test Failed");
        FramePoint3D point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 4.0, 2.0, 0.0);
        FramePoint3D lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FramePoint3D lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 0.0);
        FramePoint3D intersectionPoint = new FramePoint3D(ReferenceFrame.getWorldFrame(), 3.0, 3.0, 0.0);
        FrameVector3D x = new FrameVector3D(point.getReferenceFrame());
        x.sub((FrameTuple3DReadOnly)point, (FrameTuple3DReadOnly)intersectionPoint);
        FrameVector3D expectedReturn = x;
        FrameVector3D actualReturn = EuclidFrameShapeTools.getPerpendicularVectorFromLineToPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)lineStart, (FramePoint3DReadOnly)lineEnd, (FramePoint3DBasics)intersectionPoint);
        Assertions.assertTrue((boolean)expectedReturn.epsilonEquals((EuclidFrameGeometry)actualReturn, 1.0E-12), (String)"Test Failed");
        FramePoint3D point1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), -2.5, 1.5, 0.0);
        FramePoint3D lineStart1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FramePoint3D lineEnd1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), -4.0, 4.0, 0.0);
        FramePoint3D intersectionPoint1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), -2.0, 2.0, 0.0);
        EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)new Point2D(-2.5, 1.5), (Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(-4.0, 4.0));
        FrameVector3D x1 = new FrameVector3D(point1.getReferenceFrame());
        x1.sub((FrameTuple3DReadOnly)point1, (FrameTuple3DReadOnly)intersectionPoint1);
        FrameVector3D expectedReturn1 = x1;
        FrameVector3D actualReturn1 = EuclidFrameShapeTools.getPerpendicularVectorFromLineToPoint((FramePoint3DReadOnly)point1, (FramePoint3DReadOnly)lineStart1, (FramePoint3DReadOnly)lineEnd1, (FramePoint3DBasics)intersectionPoint1);
        Assertions.assertTrue((boolean)expectedReturn1.epsilonEquals((EuclidFrameGeometry)actualReturn1, 1.0E-12), (String)"Test Failed");
    }

    @Test
    public void testGetPlaneNormalGivenThreePoints() {
        FramePoint3D point1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 0.0);
        FramePoint3D point2 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 0.0);
        FramePoint3D point3 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 0.0);
        Object expectedReturn = null;
        FrameVector3D actualReturn = EuclidFrameShapeTools.getPlaneNormalGivenThreePoints((FramePoint3DReadOnly)point1, (FramePoint3DReadOnly)point2, (FramePoint3DReadOnly)point3);
        Assertions.assertEquals(expectedReturn, (Object)actualReturn, (String)"test failed");
        FramePoint3D point91 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 3.0, 0.0);
        FramePoint3D point92 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 0.0);
        FramePoint3D point93 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 1.0, 0.0);
        Object expectedReturn9 = null;
        FrameVector3D actualReturn9 = EuclidFrameShapeTools.getPlaneNormalGivenThreePoints((FramePoint3DReadOnly)point91, (FramePoint3DReadOnly)point92, (FramePoint3DReadOnly)point93);
        Assertions.assertEquals(expectedReturn9, (Object)actualReturn9, (String)"test failed");
        FramePoint3D point81 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 9.0, 0.0, 0.0);
        FramePoint3D point82 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 7.0, 0.0, 0.0);
        FramePoint3D point83 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 4.0, 0.0, 0.0);
        Object expectedReturn8 = null;
        FrameVector3D actualReturn8 = EuclidFrameShapeTools.getPlaneNormalGivenThreePoints((FramePoint3DReadOnly)point81, (FramePoint3DReadOnly)point82, (FramePoint3DReadOnly)point83);
        Assertions.assertEquals(expectedReturn8, (Object)actualReturn8, (String)"test failed");
        FramePoint3D point71 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 4.0);
        FramePoint3D point72 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 6.0);
        FramePoint3D point73 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 7.0);
        Object expectedReturn7 = null;
        FrameVector3D actualReturn7 = EuclidFrameShapeTools.getPlaneNormalGivenThreePoints((FramePoint3DReadOnly)point71, (FramePoint3DReadOnly)point72, (FramePoint3DReadOnly)point73);
        Assertions.assertEquals(expectedReturn7, (Object)actualReturn7, (String)"test failed");
        FramePoint3D point11 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 46.0);
        FramePoint3D point12 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 587.0, 3.0);
        FramePoint3D point13 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 18.0, 8.0);
        FramePoint3D p1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 5.0);
        FramePoint3D v1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 5.0, 5.0);
        FrameVector3D expectedReturn1 = new FrameVector3D(p1.getReferenceFrame());
        expectedReturn1.sub((FrameTuple3DReadOnly)p1, (FrameTuple3DReadOnly)v1);
        FrameVector3D actualReturn1 = EuclidFrameShapeTools.getPlaneNormalGivenThreePoints((FramePoint3DReadOnly)point11, (FramePoint3DReadOnly)point12, (FramePoint3DReadOnly)point13);
        Assertions.assertTrue((boolean)expectedReturn1.epsilonEquals((EuclidFrameGeometry)actualReturn1, 1.0E-12), (String)"Test Failed");
        FramePoint3D point21 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 65.0, 0.0, 46.0);
        FramePoint3D point22 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 43.0, 0.0, 3.0);
        FramePoint3D point23 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 13.0, 0.0, 8.0);
        FramePoint3D p2 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 1.0, 5.0);
        FramePoint3D v2 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 5.0);
        FrameVector3D expectedReturn2 = new FrameVector3D(p2.getReferenceFrame());
        expectedReturn2.sub((FrameTuple3DReadOnly)p2, (FrameTuple3DReadOnly)v2);
        FrameVector3D actualReturn2 = EuclidFrameShapeTools.getPlaneNormalGivenThreePoints((FramePoint3DReadOnly)point21, (FramePoint3DReadOnly)point22, (FramePoint3DReadOnly)point23);
        Assertions.assertTrue((boolean)expectedReturn2.epsilonEquals((EuclidFrameGeometry)actualReturn2, 1.0E-12), (String)"Test Failed");
        FramePoint3D point31 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 65.0, 56.0, 0.0);
        FramePoint3D point32 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 43.0, 3.0, 0.0);
        FramePoint3D point33 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 13.0, 87.0, 0.0);
        FramePoint3D p3 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 55.0, 0.0);
        FramePoint3D v3 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 55.0, 1.0);
        FrameVector3D expectedReturn3 = new FrameVector3D(p3.getReferenceFrame());
        expectedReturn3.sub((FrameTuple3DReadOnly)p3, (FrameTuple3DReadOnly)v3);
        FrameVector3D actualReturn3 = EuclidFrameShapeTools.getPlaneNormalGivenThreePoints((FramePoint3DReadOnly)point31, (FramePoint3DReadOnly)point32, (FramePoint3DReadOnly)point33);
        Assertions.assertTrue((boolean)expectedReturn3.epsilonEquals((EuclidFrameGeometry)actualReturn3, 1.0E-12), (String)"Test Failed");
    }

    private static RigidBodyTransform nextRigidBodyTransformWithIdentityEdgeCase(Random random, double rotationIdentityPercentage, double positionZeroPercentage) {
        RigidBodyTransform next = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        next.getRotation().setToZero();
        if (random.nextDouble() < positionZeroPercentage) {
            next.getTranslation().setToZero();
        }
        return next;
    }
}

