/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameQuaternionReadOnlyTest;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.QuaternionBasicsTest;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public final class FrameQuaternionTest
extends FrameQuaternionReadOnlyTest<FrameQuaternion> {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    public static final double EPSILON = 1.0E-10;

    @Override
    public FrameQuaternion createFrameTuple(ReferenceFrame referenceFrame, Tuple4DReadOnly tuple4DReadOnly) {
        if (tuple4DReadOnly instanceof QuaternionReadOnly) {
            return new FrameQuaternion(referenceFrame, (QuaternionReadOnly)tuple4DReadOnly);
        }
        return new FrameQuaternion(referenceFrame, tuple4DReadOnly);
    }

    @Override
    public FrameQuaternion createFrameTuple(ReferenceFrame referenceFrame, double x, double y, double z, double s) {
        Quaternion quaternion = new Quaternion();
        quaternion.setUnsafe(x, y, z, s);
        return new FrameQuaternion(referenceFrame, (QuaternionReadOnly)quaternion);
    }

    @Test
    public void testConstructors() throws Exception {
        Quaternion expectedQuaternion;
        FrameQuaternion frameQuaternion;
        FrameQuaternion frameQuaternion2;
        Quaternion randomQuaternion;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        FrameQuaternion frameQuaternion3 = new FrameQuaternion();
        Assertions.assertTrue((frameQuaternion3.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)frameQuaternion3);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion frameQuaternion4 = new FrameQuaternion(randomFrame);
            Assertions.assertTrue((frameQuaternion4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)frameQuaternion4);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameQuaternion2 = new FrameQuaternion(randomFrame, (randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random)).getX(), randomQuaternion.getY(), randomQuaternion.getZ(), randomQuaternion.getS());
            Assertions.assertTrue((frameQuaternion2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomQuaternion, (EuclidGeometry)frameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double[] array = new double[4];
            randomQuaternion.get(array);
            frameQuaternion = new FrameQuaternion(randomFrame, array);
            Assertions.assertTrue((frameQuaternion.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomQuaternion, (EuclidGeometry)frameQuaternion, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            DMatrixRMaj denseMatrix = new DMatrixRMaj(4, 1);
            randomQuaternion.get((DMatrix)denseMatrix);
            frameQuaternion = new FrameQuaternion(randomFrame, (DMatrix)denseMatrix);
            Assertions.assertTrue((frameQuaternion.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomQuaternion, (EuclidGeometry)frameQuaternion, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameQuaternion2 = new FrameQuaternion(randomFrame, (QuaternionReadOnly)(randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random)));
            Assertions.assertTrue((frameQuaternion2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomQuaternion, (EuclidGeometry)frameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector4D randomTuple = EuclidCoreRandomTools.nextVector4D((Random)random);
            expectedQuaternion = new Quaternion((Tuple4DReadOnly)randomTuple);
            frameQuaternion = new FrameQuaternion(randomFrame, (Tuple4DReadOnly)randomTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)frameQuaternion, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            RotationMatrix randomRotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expectedQuaternion = new Quaternion((Orientation3DReadOnly)randomRotationMatrix);
            frameQuaternion = new FrameQuaternion(randomFrame, (Orientation3DReadOnly)randomRotationMatrix);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)frameQuaternion, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            AxisAngle randomAxisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expectedQuaternion = new Quaternion((Orientation3DReadOnly)randomAxisAngle);
            frameQuaternion = new FrameQuaternion(randomFrame, (Orientation3DReadOnly)randomAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)frameQuaternion, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomRotationVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            expectedQuaternion = new Quaternion((Vector3DReadOnly)randomRotationVector);
            frameQuaternion = new FrameQuaternion(randomFrame, (Vector3DReadOnly)randomRotationVector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion, (EuclidGeometry)frameQuaternion, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            Quaternion expectedQuaternion2 = new Quaternion(yaw, pitch, roll);
            FrameQuaternion frameQuaternion5 = new FrameQuaternion(randomFrame, yaw, pitch, roll);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQuaternion2, (EuclidGeometry)frameQuaternion5, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion randomFrameTuple4D = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)randomFrame);
            frameQuaternion2 = new FrameQuaternion((FrameTuple4DReadOnly)randomFrameTuple4D);
            Assertions.assertTrue((frameQuaternion2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomFrameTuple4D, (EuclidGeometry)frameQuaternion2, (double)1.0E-10);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)randomFrameTuple4D, (EuclidFrameGeometry)frameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion randomFrameQuaternion = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)randomFrame);
            frameQuaternion2 = new FrameQuaternion((FrameQuaternionReadOnly)randomFrameQuaternion);
            Assertions.assertTrue((frameQuaternion2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomFrameQuaternion, (EuclidGeometry)frameQuaternion2, (double)1.0E-10);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)randomFrameQuaternion, (EuclidFrameGeometry)frameQuaternion2, (double)1.0E-10);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            Quaternion expectedGeometryObject = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expectedGeometryObject.setToZero();
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FrameQuaternion frameGeometryObject = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals((EuclidGeometry)frameGeometryObject, 1.0E-10));
            frameGeometryObject.setToZero();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedGeometryObject, (EuclidGeometry)frameGeometryObject, (double)1.0E-10);
            frameGeometryObject = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals((EuclidGeometry)frameGeometryObject, 1.0E-10));
            frameGeometryObject.setToZero(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedGeometryObject, (EuclidGeometry)frameGeometryObject, (double)1.0E-10);
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(574L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FrameQuaternion frameGeometryObject = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN();
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)frameGeometryObject);
            frameGeometryObject = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)frameGeometryObject);
        }
    }

    @Test
    public void testMatchingFrame() throws Exception {
        FrameQuaternion actual;
        ReferenceFrame destinationFrame;
        ReferenceFrame sourceFrame;
        int i;
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameQuaternion, 10);
        Random random = new Random(3225L);
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion expected = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)sourceFrame);
            actual = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)destinationFrame);
            actual.setMatchingFrame((FrameQuaternionReadOnly)expected);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion source = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)sourceFrame);
            actual = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)destinationFrame);
            actual.setMatchingFrame((FrameTuple4DReadOnly)source);
            FrameQuaternion expected = new FrameQuaternion((FrameTuple4DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            double x = EuclidCoreRandomTools.nextDouble((Random)random);
            double y = EuclidCoreRandomTools.nextDouble((Random)random);
            double z = EuclidCoreRandomTools.nextDouble((Random)random);
            double s = EuclidCoreRandomTools.nextDouble((Random)random);
            FrameQuaternion actual2 = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)destinationFrame);
            actual2.setMatchingFrame(sourceFrame, x, y, z, s);
            FrameQuaternion expected = new FrameQuaternion(sourceFrame, x, y, z, s);
            expected.setIncludingFrame(sourceFrame, x, y, z, s);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual2, (double)1.0E-10);
        }
    }

    @Test
    public void testSetIncludingFrame() throws Exception {
        Quaternion quaternion;
        FrameQuaternion frameQuaternion;
        ReferenceFrame newFrame;
        Quaternion quaternion2;
        FrameQuaternion frameQuaternion2;
        ReferenceFrame newFrame2;
        int i;
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("setIncludingFrame", new Class[]{FrameVector3DReadOnly.class}));
        signaturesToIgnore.add(new MethodSignature("setIncludingFrame", new Class[]{ReferenceFrame.class, Vector3DReadOnly.class}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameQuaternion, methodFilter, 10);
        Random random = new Random(2342L);
        ReferenceFrame initialFrame = ReferenceFrame.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameQuaternion2 = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)frameQuaternion2.getReferenceFrame());
            frameQuaternion2.setIncludingFrame(newFrame2, (Orientation3DReadOnly)axisAngle);
            quaternion2.set((Orientation3DReadOnly)axisAngle);
            Assertions.assertEquals((Object)newFrame2, (Object)frameQuaternion2.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion2, (EuclidGeometry)frameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameQuaternion2 = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)frameQuaternion2.getReferenceFrame());
            frameQuaternion2.setIncludingFrame(newFrame2, (Orientation3DReadOnly)rotationMatrix);
            quaternion2.set((Orientation3DReadOnly)rotationMatrix);
            Assertions.assertEquals((Object)newFrame2, (Object)frameQuaternion2.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion2, (EuclidGeometry)frameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameQuaternion2 = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)frameQuaternion2.getReferenceFrame());
            frameQuaternion2.setRotationVectorIncludingFrame(newFrame2, (Vector3DReadOnly)rotationVector);
            quaternion2.setRotationVector((Vector3DReadOnly)rotationVector);
            Assertions.assertEquals((Object)newFrame2, (Object)frameQuaternion2.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion2, (EuclidGeometry)frameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame newFrame3 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D rotationVector = new FrameVector3D(newFrame3, (Tuple3DReadOnly)EuclidCoreRandomTools.nextRotationVector((Random)random));
            frameQuaternion2 = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)frameQuaternion2.getReferenceFrame());
            frameQuaternion2.setRotationVectorIncludingFrame((FrameVector3DReadOnly)rotationVector);
            quaternion2.setRotationVector((Vector3DReadOnly)rotationVector);
            Assertions.assertEquals((Object)newFrame3, (Object)frameQuaternion2.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion2, (EuclidGeometry)frameQuaternion2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameQuaternion = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)frameQuaternion.getReferenceFrame());
            frameQuaternion.setYawPitchRollIncludingFrame(newFrame, yaw, pitch, roll);
            quaternion.setYawPitchRoll(yaw, pitch, roll);
            Assertions.assertEquals((Object)newFrame, (Object)frameQuaternion.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)frameQuaternion, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D eulerAngles = EuclidCoreRandomTools.nextRotationVector((Random)random);
            eulerAngles.setY(EuclidCoreTools.clamp((double)eulerAngles.getY(), (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE));
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameQuaternion frameQuaternion3 = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion2 = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)frameQuaternion3.getReferenceFrame());
            frameQuaternion3.setEulerIncludingFrame(newFrame2, (Vector3DReadOnly)eulerAngles);
            quaternion2.setEuler((Vector3DReadOnly)eulerAngles);
            Assertions.assertEquals((Object)newFrame2, (Object)frameQuaternion3.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion2, (EuclidGeometry)frameQuaternion3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double rotX = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double rotY = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double rotZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameQuaternion = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            quaternion = new Quaternion();
            Assertions.assertEquals((Object)initialFrame, (Object)frameQuaternion.getReferenceFrame());
            frameQuaternion.setEulerIncludingFrame(newFrame, rotX, rotY, rotZ);
            quaternion.setEuler(rotX, rotY, rotZ);
            Assertions.assertEquals((Object)newFrame, (Object)frameQuaternion.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)frameQuaternion, (double)1.0E-10);
        }
    }

    @Test
    public void testConsistencyWithQuaternion() {
        FrameTypeCopier frameTypeBuilder = (frame, quaternion) -> this.createFrameTuple(frame, (Tuple4DReadOnly)((QuaternionReadOnly)quaternion));
        RandomFramelessTypeBuilder framelessTypeBuilder = EuclidCoreRandomTools::nextQuaternion;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilder, methodFilter, 10);
        RandomFramelessTypeBuilder frameless2DTypeBuilder = random -> new Quaternion(this.createRandom2DFrameTuple(random, ReferenceFrame.getWorldFrame()));
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, frameless2DTypeBuilder, methodFilter, 10);
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Quaternion.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Quaternion.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Quaternion.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameQuaternion.class, Quaternion.class, true, 1, methodFilter);
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Quaternion expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            FrameQuaternion quaternion = new FrameQuaternion(initialFrame, (QuaternionReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            quaternion.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == quaternion.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expected, (Orientation3DReadOnly)quaternion, (double)1.0E-10);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                quaternion.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSet() throws Exception {
        Random random = new Random(3452L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            Quaternion expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            int initialFrameIndex = random.nextInt(referenceFrames.length);
            ReferenceFrame initialFrame = referenceFrames[initialFrameIndex];
            FrameQuaternion actual = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-10));
            actual.set(initialFrame, (QuaternionReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-10));
            expected.set((QuaternionReadOnly)actual);
            int differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            ReferenceFrame differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, (QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetFromReferenceFrame() throws Exception {
        Random random = new Random(6572L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FrameQuaternion expected = (FrameQuaternion)this.createEmptyFrameTuple(anotherFrame);
            expected.changeFrame(initialFrame);
            FrameQuaternion actual = (FrameQuaternion)this.createRandomFrameTuple(random, initialFrame);
            actual.setFromReferenceFrame(anotherFrame);
            Assertions.assertTrue((initialFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            FrameQuaternion frameQuaternion1 = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameQuaternion frameQuaternion2 = new FrameQuaternion(worldFrame);
            double epsilon = random.nextDouble();
            AxisAngle axisAngleDiff = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 0.99 * epsilon);
            Quaternion difference = new Quaternion((Orientation3DReadOnly)axisAngleDiff);
            frameQuaternion2.multiply((FrameQuaternionReadOnly)frameQuaternion1, (QuaternionReadOnly)difference);
            Assertions.assertTrue((boolean)frameQuaternion1.geometricallyEquals((EuclidFrameGeometry)frameQuaternion2, epsilon));
            axisAngleDiff = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 1.01 * epsilon);
            difference = new Quaternion((Orientation3DReadOnly)axisAngleDiff);
            frameQuaternion2.multiply((FrameQuaternionReadOnly)frameQuaternion1, (QuaternionReadOnly)difference);
            Assertions.assertFalse((boolean)frameQuaternion1.geometricallyEquals((EuclidFrameGeometry)frameQuaternion2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (int)100);
        FrameQuaternion q = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frames[random.nextInt(frames.length)]);
        int newHashCode = q.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)q.hashCode());
        int previousHashCode = q.hashCode();
        for (int i = 0; i < 1000; ++i) {
            double qx = q.getX();
            double qy = q.getY();
            double qz = q.getZ();
            double qs = q.getS();
            switch (random.nextInt(4)) {
                case 0: {
                    qx = random.nextDouble();
                    break;
                }
                case 1: {
                    qy = random.nextDouble();
                    break;
                }
                case 2: {
                    qz = random.nextDouble();
                    break;
                }
                case 3: {
                    qs = random.nextDouble();
                }
            }
            q.setUnsafe(qx, qy, qz, qs);
            newHashCode = q.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
            ReferenceFrame oldFrame = q.getReferenceFrame();
            ReferenceFrame newFrame = frames[random.nextInt(frames.length)];
            q.setReferenceFrame(newFrame);
            newHashCode = q.hashCode();
            if (oldFrame != newFrame) {
                Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            }
            previousHashCode = newHashCode;
        }
    }

    @Test
    public void testQuaternionBasicsFeatures() throws Exception {
        QuaternionBasicsTest<FrameQuaternion> quaternionBasicsTest = new QuaternionBasicsTest<FrameQuaternion>(){

            @Override
            public FrameQuaternion createEmptyTuple() {
                return new FrameQuaternion();
            }

            @Override
            public FrameQuaternion createTuple(double v, double v1, double v2, double v3) {
                FrameQuaternion ret = new FrameQuaternion(ReferenceFrame.getWorldFrame());
                ret.setUnsafe(v, v1, v2, v3);
                return ret;
            }

            @Override
            public FrameQuaternion createRandomTuple(Random random) {
                return EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            }

            @Override
            public double getEpsilon() {
                return 1.0E-10;
            }
        };
        for (Method testMethod : quaternionBasicsTest.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            testMethod.invoke((Object)quaternionBasicsTest, new Object[0]);
        }
    }
}

