/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision;

import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.EuclidShapeCollisionTools;
import us.ihmc.euclid.shape.collision.GilbertJohnsonKeerthiCollisionDetectorTest;
import us.ihmc.euclid.shape.collision.epa.ExpandingPolytopeAlgorithm;
import us.ihmc.euclid.shape.collision.gjk.GilbertJohnsonKeerthiCollisionDetector;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.HalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.Vertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeFactories;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Capsule3D;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.PointShape3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

class ExpandingPolytopeAlgorithmTest {
    private static final int ITERATIONS = 5000;
    private static final double EPSILON = 1.0E-12;

    ExpandingPolytopeAlgorithmTest() {
    }

    @Test
    void testNonCollidingCubeAndTetrahedron() {
        Random random = new Random(34534L);
        ConvexPolytope3D cube = EuclidPolytopeFactories.newCube((double)1.0);
        for (int i = 0; i < 5000; ++i) {
            Point3D tetrahedronClosest = new Point3D(0.5, 0.0, 0.0);
            Point3D tetrahedronFarthest0 = new Point3D(1.0, 1.0, 0.0);
            Point3D tetrahedronFarthest1 = new Point3D(1.0, 0.0, 1.0);
            Point3D tetrahedronFarthest2 = new Point3D(1.0, -1.0, 0.0);
            Vector3D translation = new Vector3D();
            translation.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            translation.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5));
            translation.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5));
            Arrays.asList(tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2).forEach(p -> p.add((Tuple3DReadOnly)translation));
            ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2}));
            double distance = Double.POSITIVE_INFINITY;
            for (Vertex3D tetraVertex : tetrahedron.getVertices()) {
                Assertions.assertFalse((boolean)cube.isPointInside((Point3DReadOnly)tetraVertex));
                for (Face3D cubeFace : cube.getFaces()) {
                    distance = Math.min(distance, cubeFace.distance((Point3DReadOnly)tetraVertex));
                }
            }
            for (Vertex3D cubeVertex : cube.getVertices()) {
                Assertions.assertFalse((boolean)tetrahedron.isPointInside((Point3DReadOnly)cubeVertex));
                for (Face3D tetraFace : tetrahedron.getFaces()) {
                    distance = Math.min(distance, tetraFace.distance((Point3DReadOnly)cubeVertex));
                }
            }
            Assertions.assertEquals((double)translation.getX(), (double)distance, (double)1.0E-12);
            ExpandingPolytopeAlgorithm epa = new ExpandingPolytopeAlgorithm();
            EuclidShape3DCollisionResult result = epa.evaluateCollision((Shape3DReadOnly)cube, (Shape3DReadOnly)tetrahedron);
            Point3D pointOnCube = result.getPointOnA();
            Point3D pointOnTetrahedron = result.getPointOnB();
            double separatingDistance = result.getSignedDistance();
            Assertions.assertEquals((double)0.0, (double)cube.distance((Point3DReadOnly)pointOnCube), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)tetrahedron.distance((Point3DReadOnly)pointOnTetrahedron), (double)1.0E-12);
            Assertions.assertEquals((double)cube.distance((Point3DReadOnly)tetrahedronClosest), (double)separatingDistance, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tetrahedronClosest, (EuclidGeometry)pointOnTetrahedron, (double)1.0E-12);
            Assertions.assertEquals((double)tetrahedronClosest.getY(), (double)pointOnCube.getY(), (double)1.0E-12);
            Assertions.assertEquals((double)tetrahedronClosest.getZ(), (double)pointOnCube.getZ(), (double)1.0E-12);
        }
    }

    @Test
    void testCollidingCubeAndPoint() {
        Random random = new Random(34534L);
        ConvexPolytope3D cube = EuclidPolytopeFactories.newCube((double)1.0);
        Point3D point = new Point3D(0.25, 0.0, 0.0);
        ConvexPolytope3D singleton = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{point}));
        ExpandingPolytopeAlgorithm epa = new ExpandingPolytopeAlgorithm();
        EuclidShape3DCollisionResult result = epa.evaluateCollision((Shape3DReadOnly)cube, (Shape3DReadOnly)singleton);
        Point3D pointOnCube = result.getPointOnA();
        Point3D pointOnSingleton = result.getPointOnB();
        Assertions.assertEquals((double)0.0, (double)cube.distance((Point3DReadOnly)pointOnCube), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)singleton.distance((Point3DReadOnly)pointOnSingleton), (double)1.0E-12);
        Assertions.assertEquals((double)0.25, (double)(-result.getSignedDistance()), (double)1.0E-12);
        Assertions.assertEquals((double)pointOnCube.distance((Point3DReadOnly)pointOnSingleton), (double)(-result.getSignedDistance()), (double)1.0E-12);
        Assertions.assertEquals((double)cube.signedDistance((Point3DReadOnly)point), (double)result.getSignedDistance(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)point, (EuclidGeometry)pointOnSingleton, (double)1.0E-12);
        Assertions.assertEquals((double)point.getY(), (double)pointOnCube.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)point.getZ(), (double)pointOnCube.getZ(), (double)1.0E-12);
        for (int i = 0; i < 5000; ++i) {
            Point3D point2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-0.5, (double)0.5);
            ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{point2}));
            ExpandingPolytopeAlgorithm epa2 = new ExpandingPolytopeAlgorithm();
            EuclidShape3DCollisionResult result2 = epa2.evaluateCollision((Shape3DReadOnly)cube, (Shape3DReadOnly)tetrahedron);
            Point3D pointOnCube2 = result2.getPointOnA();
            Point3D pointOnSingleton2 = result2.getPointOnB();
            Assertions.assertEquals((double)pointOnCube2.distance((Point3DReadOnly)pointOnSingleton2), (double)(-result2.getSignedDistance()), (double)1.0E-12);
            Assertions.assertEquals((double)cube.signedDistance((Point3DReadOnly)point2), (double)result2.getSignedDistance(), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)cube.distance((Point3DReadOnly)pointOnCube2), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)tetrahedron.distance((Point3DReadOnly)pointOnSingleton2), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)point2, (EuclidGeometry)pointOnSingleton2, (double)1.0E-12);
        }
    }

    @Test
    void testCollidingCubeAndTetrahedron() {
        Point3D tetrahedronFarthest2;
        Point3D tetrahedronFarthest1;
        Point3D tetrahedronFarthest0;
        Point3D tetrahedronClosest;
        int i;
        Random random = new Random(34534L);
        ConvexPolytope3D cube = EuclidPolytopeFactories.newCube((double)1.0);
        for (i = 0; i < 5000; ++i) {
            tetrahedronClosest = new Point3D(0.5, 0.0, 0.0);
            tetrahedronFarthest0 = new Point3D(100.0, 0.02, 0.0);
            tetrahedronFarthest1 = new Point3D(100.0, 0.0, 0.02);
            tetrahedronFarthest2 = new Point3D(100.0, -0.02, 0.0);
            Vector3D translation = new Vector3D();
            translation.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)-0.25, (double)0.0));
            translation.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.25));
            translation.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.25));
            Arrays.asList(tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2).forEach(p -> p.add((Tuple3DReadOnly)translation));
            ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2}));
            ExpandingPolytopeAlgorithm epa = new ExpandingPolytopeAlgorithm();
            EuclidShape3DCollisionResult result = epa.evaluateCollision((Shape3DReadOnly)cube, (Shape3DReadOnly)tetrahedron);
            Point3D pointOnCube = result.getPointOnA();
            Point3D pointOnTetrahedron = result.getPointOnB();
            Assertions.assertEquals((double)pointOnCube.distance((Point3DReadOnly)pointOnTetrahedron), (double)(-result.getSignedDistance()), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)cube.distance((Point3DReadOnly)pointOnCube), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)tetrahedron.distance((Point3DReadOnly)pointOnTetrahedron), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tetrahedronClosest, (EuclidGeometry)pointOnTetrahedron, (double)1.0E-12);
            Assertions.assertEquals((double)cube.signedDistance((Point3DReadOnly)tetrahedronClosest), (double)result.getSignedDistance(), (double)1.0E-12);
            Assertions.assertEquals((double)tetrahedronClosest.getY(), (double)pointOnCube.getY(), (double)1.0E-12);
            Assertions.assertEquals((double)tetrahedronClosest.getZ(), (double)pointOnCube.getZ(), (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            tetrahedronClosest = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.5);
            tetrahedronFarthest0 = new Point3D(1.0, 1.2, 0.0);
            tetrahedronFarthest1 = new Point3D(1.0, 0.0, 1.2);
            tetrahedronFarthest2 = new Point3D(1.0, -1.2, 0.0);
            ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2}));
            ExpandingPolytopeAlgorithmTest.assertResolvingCollision("Iteration " + i, (ConvexPolytope3DReadOnly)cube, (ConvexPolytope3DReadOnly)tetrahedron);
        }
    }

    @Test
    void testNonCollidingConvexPolytope3DWithTetrahedron() throws Exception {
        Random random = new Random(45345L);
        for (int i = 0; i < 5000; ++i) {
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random), null, null);
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random), (ConvexPolytope3DReadOnly)convexPolytope3D, null, null);
            } else {
                Face3D face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
                HalfEdge3D edge2 = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
                Point3D closestOnConvexPolytope3D = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination());
                Point3D closestOnTetrahedron = new Point3D((Tuple3DReadOnly)closestOnConvexPolytope3D);
                closestOnTetrahedron.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)closestOnTetrahedron);
                ConvexPolytope3D tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)closestOnTetrahedron, (Vector3DReadOnly)face.getNormal(), 1.0);
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, (Point3DReadOnly)closestOnConvexPolytope3D, (Point3DReadOnly)closestOnTetrahedron);
            }
            if (convexPolytope3D.isEmpty()) {
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random), null, null);
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random), (ConvexPolytope3DReadOnly)convexPolytope3D, null, null);
            } else {
                Face3D firstFace = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
                HalfEdge3D closestEdge = (HalfEdge3D)firstFace.getEdge(random.nextInt(firstFace.getNumberOfEdges()));
                Vector3D towardOutside = new Vector3D();
                if (closestEdge.getTwin() != null) {
                    Face3D secondFace = (Face3D)((HalfEdge3D)closestEdge.getTwin()).getFace();
                    towardOutside.interpolate((Tuple3DReadOnly)firstFace.getNormal(), (Tuple3DReadOnly)secondFace.getNormal(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                } else {
                    Vector3D faceNormal = new Vector3D((Tuple3DReadOnly)firstFace.getNormal());
                    towardOutside.cross((Tuple3DReadOnly)faceNormal, (Tuple3DReadOnly)closestEdge.getDirection(false));
                    if (random.nextBoolean()) {
                        faceNormal.negate();
                    }
                    towardOutside.interpolate((Tuple3DReadOnly)faceNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                }
                towardOutside.normalize();
                Point3D pointOnEdge = new Point3D();
                pointOnEdge.interpolate((Tuple3DReadOnly)closestEdge.getOrigin(), (Tuple3DReadOnly)closestEdge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                Point3D pointOutside = new Point3D();
                pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
                ConvexPolytope3D tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointOutside, (Vector3DReadOnly)towardOutside, 1.0);
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, (Point3DReadOnly)pointOnEdge, (Point3DReadOnly)pointOutside);
            }
            if (convexPolytope3D.isEmpty()) {
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random), null, null);
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random), (ConvexPolytope3DReadOnly)convexPolytope3D, null, null);
                continue;
            }
            Vertex3D closestVertex = (Vertex3D)convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            Vector3D towardOutside = new Vector3D();
            closestVertex.getAssociatedEdges().stream().forEach(edge -> towardOutside.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)((Face3D)edge.getFace()).getNormal(), (Tuple3DReadOnly)towardOutside));
            towardOutside.normalize();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)closestVertex);
            ConvexPolytope3D tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointOutside, (Vector3DReadOnly)towardOutside, 1.0);
            ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, (Point3DReadOnly)closestVertex, (Point3DReadOnly)pointOutside);
        }
    }

    @Test
    void testVertexCollidingConvexPolytope3DWithTetrahedron() throws Exception {
        Random random = new Random(453451L);
        for (int i = 0; i < 5000; ++i) {
            Point3D pointInside;
            Point3D pointOnFace;
            Face3D face;
            LineSegment3D secondTetraSegment;
            LineSegment3D firstTetraSegment;
            Vector3D secondOrthogonalToEdge;
            Vector3D firstOrthogonalToEdge;
            Vector3DBasics edgeDirection;
            HalfEdge3D edge;
            ConvexPolytope3D tetrahedron;
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), null, null);
            } else {
                if (convexPolytope3D.getNumberOfVertices() == 1) {
                    tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)convexPolytope3D.getVertex(0));
                    Assertions.assertTrue((boolean)tetrahedron.isPointInside((Point3DReadOnly)convexPolytope3D.getVertex(0)));
                } else if (convexPolytope3D.getNumberOfVertices() == 2) {
                    edge = (HalfEdge3D)convexPolytope3D.getHalfEdge(0);
                    edgeDirection = edge.getDirection(true);
                    firstOrthogonalToEdge = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)edgeDirection, (boolean)true);
                    secondOrthogonalToEdge = new Vector3D();
                    secondOrthogonalToEdge.cross((Tuple3DReadOnly)firstOrthogonalToEdge, (Tuple3DReadOnly)edgeDirection);
                    firstTetraSegment = new LineSegment3D();
                    firstTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                    firstTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                    firstTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                    secondTetraSegment = new LineSegment3D();
                    secondTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                    secondTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                    firstOrthogonalToEdge.negate();
                    secondTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                    tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{firstTetraSegment.getFirstEndpoint(), firstTetraSegment.getSecondEndpoint(), secondTetraSegment.getFirstEndpoint(), secondTetraSegment.getSecondEndpoint()}));
                } else if (convexPolytope3D.getNumberOfFaces() == 1) {
                    face = (Face3D)convexPolytope3D.getFace(0);
                    pointOnFace = EuclidShapeRandomTools.nextPoint3DOnFace3D((Random)random, (Face3DReadOnly)face);
                    tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)pointOnFace);
                } else {
                    face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
                    HalfEdge3D edge2 = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
                    pointInside = EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)convexPolytope3D.getCentroid(), (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination());
                    tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointInside, (Vector3DReadOnly)face.getNormal(), 1.0);
                }
                ExpandingPolytopeAlgorithmTest.assertResolvingCollision("Iteration " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron);
            }
            if (convexPolytope3D.isEmpty()) {
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), null, null);
            } else {
                if (convexPolytope3D.getNumberOfVertices() == 1) {
                    tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)convexPolytope3D.getVertex(0));
                    Assertions.assertTrue((boolean)tetrahedron.isPointInside((Point3DReadOnly)convexPolytope3D.getVertex(0)));
                } else if (convexPolytope3D.getNumberOfVertices() == 2) {
                    edge = (HalfEdge3D)convexPolytope3D.getHalfEdge(0);
                    edgeDirection = edge.getDirection(true);
                    firstOrthogonalToEdge = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)edgeDirection, (boolean)true);
                    secondOrthogonalToEdge = new Vector3D();
                    secondOrthogonalToEdge.cross((Tuple3DReadOnly)firstOrthogonalToEdge, (Tuple3DReadOnly)edgeDirection);
                    firstTetraSegment = new LineSegment3D();
                    firstTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                    firstTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                    firstTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                    secondTetraSegment = new LineSegment3D();
                    secondTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                    secondTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                    firstOrthogonalToEdge.negate();
                    secondTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                    tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{firstTetraSegment.getFirstEndpoint(), firstTetraSegment.getSecondEndpoint(), secondTetraSegment.getFirstEndpoint(), secondTetraSegment.getSecondEndpoint()}));
                } else if (convexPolytope3D.getNumberOfFaces() == 1) {
                    face = (Face3D)convexPolytope3D.getFace(0);
                    pointOnFace = EuclidShapeRandomTools.nextPoint3DOnFace3D((Random)random, (Face3DReadOnly)face);
                    tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)pointOnFace);
                } else {
                    Face3D firstFace = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
                    HalfEdge3D closestEdge = (HalfEdge3D)firstFace.getEdge(random.nextInt(firstFace.getNumberOfEdges()));
                    Point3D pointOnEdge = new Point3D();
                    pointOnEdge.interpolate((Tuple3DReadOnly)closestEdge.getOrigin(), (Tuple3DReadOnly)closestEdge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                    Vector3D towardInside = new Vector3D();
                    towardInside.sub((Tuple3DReadOnly)convexPolytope3D.getCentroid(), (Tuple3DReadOnly)pointOnEdge);
                    towardInside.normalize();
                    Point3D pointInside2 = new Point3D();
                    double distanceInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.001);
                    pointInside2.scaleAdd(distanceInside, (Tuple3DReadOnly)towardInside, (Tuple3DReadOnly)pointOnEdge);
                    tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointInside2, (Vector3DReadOnly)towardInside, 1.0);
                }
                ExpandingPolytopeAlgorithmTest.assertResolvingCollision("Iteration " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron);
            }
            if (convexPolytope3D.isEmpty()) {
                ExpandingPolytopeAlgorithmTest.performAssertionsOnEPA(random, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), null, null);
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 1) {
                tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)convexPolytope3D.getVertex(0));
                Assertions.assertTrue((boolean)tetrahedron.isPointInside((Point3DReadOnly)convexPolytope3D.getVertex(0)));
            } else if (convexPolytope3D.getNumberOfVertices() == 2) {
                edge = (HalfEdge3D)convexPolytope3D.getHalfEdge(0);
                edgeDirection = edge.getDirection(true);
                firstOrthogonalToEdge = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)edgeDirection, (boolean)true);
                secondOrthogonalToEdge = new Vector3D();
                secondOrthogonalToEdge.cross((Tuple3DReadOnly)firstOrthogonalToEdge, (Tuple3DReadOnly)edgeDirection);
                firstTetraSegment = new LineSegment3D();
                firstTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                firstTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                firstTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                secondTetraSegment = new LineSegment3D();
                secondTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                secondTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                firstOrthogonalToEdge.negate();
                secondTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{firstTetraSegment.getFirstEndpoint(), firstTetraSegment.getSecondEndpoint(), secondTetraSegment.getFirstEndpoint(), secondTetraSegment.getSecondEndpoint()}));
            } else if (convexPolytope3D.getNumberOfFaces() == 1) {
                face = (Face3D)convexPolytope3D.getFace(0);
                pointOnFace = EuclidShapeRandomTools.nextPoint3DOnFace3D((Random)random, (Face3DReadOnly)face);
                tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)pointOnFace);
            } else {
                Vertex3D closestVertex = (Vertex3D)convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
                Vector3D towardInside = new Vector3D();
                towardInside.sub((Tuple3DReadOnly)convexPolytope3D.getCentroid(), (Tuple3DReadOnly)closestVertex);
                pointInside = new Point3D();
                double distanceInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.001);
                pointInside.scaleAdd(distanceInside, (Tuple3DReadOnly)towardInside, (Tuple3DReadOnly)closestVertex);
                tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointInside, (Vector3DReadOnly)towardInside, 1.0);
            }
            ExpandingPolytopeAlgorithmTest.assertResolvingCollision("Iteration " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron);
        }
    }

    public static void performAssertionsOnEPA(Random random, ConvexPolytope3DReadOnly polytopeA, ConvexPolytope3DReadOnly polytopeB, Point3DReadOnly expectedPointOnA, Point3DReadOnly expectedPointOnB) {
        ExpandingPolytopeAlgorithm epa = new ExpandingPolytopeAlgorithm();
        EuclidShape3DCollisionResult result = epa.evaluateCollision((Shape3DReadOnly)polytopeA, (Shape3DReadOnly)polytopeB);
        Assertions.assertTrue((polytopeA == result.getShapeA() ? 1 : 0) != 0);
        Assertions.assertTrue((polytopeB == result.getShapeB() ? 1 : 0) != 0);
        if (polytopeA.isEmpty() || polytopeB.isEmpty()) {
            Assertions.assertFalse((boolean)result.areShapesColliding());
            Assertions.assertTrue((boolean)Double.isNaN(result.getSignedDistance()));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)result.getPointOnA());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)result.getPointOnB());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)result.getNormalOnA());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)result.getNormalOnB());
        } else {
            Point3D actualPointOnA = result.getPointOnA();
            Point3D actualPointOnB = result.getPointOnB();
            Assertions.assertEquals((double)0.0, (double)polytopeA.distance((Point3DReadOnly)actualPointOnA), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)polytopeB.distance((Point3DReadOnly)actualPointOnB), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnA, (EuclidGeometry)actualPointOnA, (double)1.0E-11);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPointOnB, (EuclidGeometry)actualPointOnB, (double)1.0E-11);
        }
    }

    public static void assertResolvingCollision(String messagePrefix, ConvexPolytope3DReadOnly polytopeA, ConvexPolytope3DReadOnly polytopeB) {
        GilbertJohnsonKeerthiCollisionDetector gjkDetector = new GilbertJohnsonKeerthiCollisionDetector();
        EuclidShape3DCollisionResult result = gjkDetector.evaluateCollision((Shape3DReadOnly)polytopeA, (Shape3DReadOnly)polytopeB);
        Assertions.assertTrue((boolean)result.areShapesColliding());
        ExpandingPolytopeAlgorithm epa = new ExpandingPolytopeAlgorithm();
        result = epa.evaluateCollision((Shape3DReadOnly)polytopeA, (Shape3DReadOnly)polytopeB);
        Point3D pointOnA = result.getPointOnA();
        Point3D pointOnB = result.getPointOnB();
        Assertions.assertEquals((double)0.0, (double)polytopeA.distance((Point3DReadOnly)pointOnA), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)polytopeB.distance((Point3DReadOnly)pointOnB), (double)1.0E-12);
        Vector3D collisionVector = new Vector3D();
        collisionVector.sub((Tuple3DReadOnly)pointOnA, (Tuple3DReadOnly)pointOnB);
        Vector3D augmentedCollisionVector = new Vector3D();
        augmentedCollisionVector.setAndScale(0.99, (Tuple3DReadOnly)collisionVector);
        ConvexPolytope3D polytopeBTranslated = new ConvexPolytope3D(polytopeB);
        polytopeBTranslated.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)augmentedCollisionVector));
        result = gjkDetector.evaluateCollision((Shape3DReadOnly)polytopeA, (Shape3DReadOnly)polytopeBTranslated);
        Assertions.assertTrue((boolean)result.areShapesColliding(), (String)messagePrefix);
        augmentedCollisionVector.setAndNormalize((Tuple3DReadOnly)collisionVector);
        augmentedCollisionVector.scale(Math.max(1.0E-4, 0.01 * collisionVector.norm()) + collisionVector.norm());
        polytopeBTranslated = new ConvexPolytope3D(polytopeB);
        polytopeBTranslated.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)augmentedCollisionVector));
        result = gjkDetector.evaluateCollision((Shape3DReadOnly)polytopeA, (Shape3DReadOnly)polytopeBTranslated);
        Assertions.assertFalse((boolean)result.areShapesColliding(), (String)messagePrefix);
    }

    @Test
    void testSphere3DToSphere3D() throws Exception {
        Random random = new Random(1382635L);
        double distanceMaxEpsilon = 1.0E-7;
        double positionMaxEpsilon = 0.001;
        double distanceMeanEpsilon = 1.0E-12;
        double positionMeanEpsilon = 1.0E-6;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Sphere3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Sphere3D>(() -> {
            Sphere3D sphereA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D sphereB = EuclidShapeRandomTools.nextSphere3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<Sphere3D, Sphere3D>(sphereA, sphereB);
        }, EuclidShapeCollisionTools::evaluateSphere3DSphere3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testPointShape3DBox3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-15;
        double positionMaxEpsilon = 1.0E-15;
        double distanceMeanEpsilon = 1.0E-18;
        double positionMeanEpsilon = 1.0E-17;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Box3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Box3D>(() -> {
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Box3D shapeB = EuclidShapeRandomTools.nextBox3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<PointShape3D, Box3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DBox3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testSphere3DBox3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-8;
        double positionMaxEpsilon = 0.001;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-6;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Box3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Box3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Box3D shapeB = EuclidShapeRandomTools.nextBox3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<Sphere3D, Box3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DBox3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testPointShape3DCapsule3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-8;
        double positionMaxEpsilon = 0.001;
        double distanceMeanEpsilon = 1.0E-11;
        double positionMeanEpsilon = 1.0E-6;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Capsule3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Capsule3D>(() -> {
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Capsule3D shapeB = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<PointShape3D, Capsule3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DCapsule3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testCapsule3DCapsule3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-8;
        double positionMaxEpsilon = 0.001;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-6;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Capsule3D, Capsule3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Capsule3D, Capsule3D>(() -> {
            Capsule3D shapeA = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D shapeB = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<Capsule3D, Capsule3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateCapsule3DCapsule3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testSphere3DCapsule3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-8;
        double positionMaxEpsilon = 0.001;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-6;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Capsule3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Capsule3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Capsule3D shapeB = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<Sphere3D, Capsule3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DCapsule3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testPointShape3DCylinder3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-7;
        double positionMaxEpsilon = 1.0E-4;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-7;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Cylinder3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Cylinder3D>(() -> {
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Cylinder3D shapeB = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<PointShape3D, Cylinder3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DCylinder3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testSphere3DCylinder3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 0.01;
        double positionMaxEpsilon = 0.03;
        double distanceMeanEpsilon = 2.0E-7;
        double positionMeanEpsilon = 5.0E-5;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Cylinder3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Cylinder3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Cylinder3D shapeB = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<Sphere3D, Cylinder3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DCylinder3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testPointShape3DEllipsoid3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-10;
        double positionMaxEpsilon = 1.0E-4;
        double distanceMeanEpsilon = 1.0E-12;
        double positionMeanEpsilon = 1.0E-7;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Ellipsoid3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Ellipsoid3D>(() -> {
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Ellipsoid3D shapeB = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<PointShape3D, Ellipsoid3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DEllipsoid3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testSphere3DEllipsoid3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-7;
        double positionMaxEpsilon = 0.001;
        double distanceMeanEpsilon = 1.0E-11;
        double positionMeanEpsilon = 1.0E-6;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Ellipsoid3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Ellipsoid3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Ellipsoid3D shapeB = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<Sphere3D, Ellipsoid3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DEllipsoid3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testPointShape3DRamp3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-14;
        double positionMaxEpsilon = 1.0E-14;
        double distanceMeanEpsilon = 1.0E-18;
        double positionMeanEpsilon = 1.0E-18;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Ramp3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<PointShape3D, Ramp3D>(() -> {
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Ramp3D shapeB = EuclidShapeRandomTools.nextRamp3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<PointShape3D, Ramp3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DRamp3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testSphere3DRamp3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-8;
        double positionMaxEpsilon = 3.0E-4;
        double distanceMeanEpsilon = 1.0E-11;
        double positionMeanEpsilon = 1.0E-6;
        double depthThresholdCollisionDetection = 0.0;
        GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Ramp3D> function = new GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<Sphere3D, Ramp3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Ramp3D shapeB = EuclidShapeRandomTools.nextRamp3D((Random)random);
            return new GilbertJohnsonKeerthiCollisionDetectorTest.Pair<Sphere3D, Ramp3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DRamp3DCollision);
        ExpandingPolytopeAlgorithmTest.assertAgainstAnalyticalFunction(function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon, depthThresholdCollisionDetection);
    }

    @Test
    void testShapeTransformOptimization() {
        Random random = new Random(3456L);
        double distanceEpsilon = 5.0E-5;
        double pointTangentialEpsilon = 0.01;
        for (int i = 0; i < 50000; ++i) {
            Shape3DBasics shapeA = EuclidShapeRandomTools.nextConvexShape3D((Random)random);
            Shape3DBasics shapeB = EuclidShapeRandomTools.nextConvexShape3D((Random)random);
            ExpandingPolytopeAlgorithm detector = new ExpandingPolytopeAlgorithm();
            EuclidShape3DCollisionResult expectedResult = detector.evaluateCollision((SupportingVertexHolder)shapeA, (SupportingVertexHolder)shapeB);
            expectedResult.setShapeA((Shape3DReadOnly)shapeA);
            expectedResult.setShapeB((Shape3DReadOnly)shapeB);
            EuclidShape3DCollisionResult actualResult = detector.evaluateCollision((Shape3DReadOnly)shapeA, (Shape3DReadOnly)shapeB);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)distanceEpsilon, (double)pointTangentialEpsilon, (double)0.0);
        }
    }

    private static <A extends Shape3DReadOnly, B extends Shape3DReadOnly> void assertAgainstAnalyticalFunction(GilbertJohnsonKeerthiCollisionDetectorTest.AnalyticalShapeCollisionDetection<A, B> function, double distanceMaxEpsilon, double positionMaxEpsilon, double distanceMeanEpsilon, double positionMeanEpsilon, double depthThresholdCollisionDetection) {
        boolean verbose = false;
        double meanDistanceError = 0.0;
        double meanPositionError = 0.0;
        double maxDistanceError = 0.0;
        double maxPositionError = 0.0;
        int numberOfCollidingSamples = 0;
        for (int i = 0; i < 5000; ++i) {
            String iterationPrefix = "Iteration #" + i;
            GilbertJohnsonKeerthiCollisionDetectorTest.Pair shapes = function.shapeSupplier.get();
            Shape3DReadOnly shapeA = (Shape3DReadOnly)shapes.a;
            Shape3DReadOnly shapeB = (Shape3DReadOnly)shapes.b;
            EuclidShape3DCollisionResult expectedResult = function.collisionFunction.apply(shapeA, shapeB);
            EuclidShape3DCollisionResult epaResult = new EuclidShape3DCollisionResult();
            ExpandingPolytopeAlgorithm epaDetector = new ExpandingPolytopeAlgorithm();
            epaDetector.evaluateCollision(shapeA, shapeB, (EuclidShape3DCollisionResultBasics)epaResult);
            double distanceError = Math.abs(expectedResult.getSignedDistance() - epaResult.getSignedDistance());
            if (verbose && i % 5000 == 0) {
                System.out.println(iterationPrefix + " Analytical: " + expectedResult.getSignedDistance() + ", EPA: " + epaResult.getSignedDistance() + ", diff: " + distanceError);
            }
            if (expectedResult.getSignedDistance() > 0.0 || expectedResult.getSignedDistance() < -depthThresholdCollisionDetection) {
                Assertions.assertEquals((Object)expectedResult.areShapesColliding(), (Object)epaResult.areShapesColliding(), (String)(iterationPrefix + " Analytical: " + expectedResult.getSignedDistance() + ", EPA: " + epaResult.getSignedDistance() + ", diff: " + distanceError));
            }
            if (epaResult.areShapesColliding()) {
                double positionErrorOnA = expectedResult.getPointOnA().distance((Point3DReadOnly)epaResult.getPointOnA());
                double positionErrorOnB = expectedResult.getPointOnB().distance((Point3DReadOnly)epaResult.getPointOnB());
                Assertions.assertEquals((double)expectedResult.getSignedDistance(), (double)epaResult.getSignedDistance(), (double)distanceMaxEpsilon, (String)(iterationPrefix + " difference: " + distanceError));
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)iterationPrefix, (Point3DReadOnly)expectedResult.getPointOnA(), (Point3DReadOnly)epaResult.getPointOnA(), (double)positionMaxEpsilon);
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)iterationPrefix, (Point3DReadOnly)expectedResult.getPointOnB(), (Point3DReadOnly)epaResult.getPointOnB(), (double)positionMaxEpsilon);
                ++numberOfCollidingSamples;
                meanDistanceError += distanceError;
                meanPositionError += positionErrorOnA;
                meanPositionError += positionErrorOnB;
                maxDistanceError = Math.max(maxDistanceError, distanceError);
                maxPositionError = EuclidCoreTools.max((double)maxPositionError, (double)positionErrorOnA, (double)positionErrorOnB);
            }
            Assertions.assertTrue((boolean)epaResult.getNormalOnA().containsNaN(), (String)iterationPrefix);
            Assertions.assertTrue((boolean)epaResult.getNormalOnB().containsNaN(), (String)iterationPrefix);
        }
        meanDistanceError /= 5000.0;
        meanPositionError /= 10000.0;
        if (verbose) {
            System.out.println("Number of iterations: 5000, number of colliding samples: " + numberOfCollidingSamples);
            System.out.println("Max error for the distance: " + maxDistanceError + ", position: " + maxPositionError);
            System.out.println("Average error for the distance: " + meanDistanceError + ", position: " + meanPositionError);
        }
        Assertions.assertTrue((meanDistanceError < distanceMeanEpsilon ? 1 : 0) != 0, (String)("mean distance error: " + meanDistanceError + " expected less than: " + distanceMeanEpsilon));
        Assertions.assertTrue((meanPositionError < positionMeanEpsilon ? 1 : 0) != 0, (String)("mean position error: " + meanPositionError + " expected less than: " + positionMeanEpsilon));
    }
}

