/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class ConvexPolygon2DTest {
    private static final double epsilon = 1.0E-7;

    @Test
    public void testTranslatePolygon1() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(10.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 10.0));
        polygon.update();
        Vector2D translation1 = new Vector2D(0.0, 0.0);
        ConvexPolygon2DBasics polygon1 = polygon.translateCopy((Tuple2DReadOnly)translation1);
        Assertions.assertTrue((boolean)polygon1.epsilonEquals((EuclidGeometry)polygon, 1.0E-7));
        Vector2D translation2 = new Vector2D(1.0, 0.5);
        ConvexPolygon2DBasics polygon2 = polygon.translateCopy((Tuple2DReadOnly)translation2);
        Assertions.assertTrue((boolean)polygon2.getVertex(2).epsilonEquals((EuclidGeometry)new Point2D(1.0, 0.5), 1.0E-7));
        Assertions.assertTrue((boolean)polygon2.getVertex(1).epsilonEquals((EuclidGeometry)new Point2D(11.0, 0.5), 1.0E-7));
        Assertions.assertTrue((boolean)polygon2.getVertex(0).epsilonEquals((EuclidGeometry)new Point2D(1.0, 10.5), 1.0E-7));
    }
}

