/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameTuple3DBasicsTest;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FrameVector3DTest
extends FrameTuple3DBasicsTest<FrameVector3D> {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Override
    public Tuple3DBasics createRandomFramelessTuple(Random random) {
        return EuclidCoreRandomTools.nextVector3D((Random)random);
    }

    @Override
    public FrameVector3D createFrameTuple(ReferenceFrame referenceFrame, double x, double y, double z) {
        return new FrameVector3D(referenceFrame, x, y, z);
    }

    @Test
    public void testConstructors() throws Exception {
        FrameVector3D frameVector3D;
        Vector3D randomTuple;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        FrameVector3D frameVector3D2 = new FrameVector3D();
        Assertions.assertTrue((frameVector3D2.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)frameVector3D2);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D frameVector3D3 = new FrameVector3D(randomFrame);
            Assertions.assertTrue((frameVector3D3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)frameVector3D3);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameVector3D = new FrameVector3D(randomFrame, (randomTuple = EuclidCoreRandomTools.nextVector3D((Random)random)).getX(), randomTuple.getY(), randomTuple.getZ());
            Assertions.assertTrue((frameVector3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)frameVector3D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            double[] array = new double[3];
            randomTuple.get(array);
            FrameVector3D frameVector3D4 = new FrameVector3D(randomFrame, array);
            Assertions.assertTrue((frameVector3D4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)frameVector3D4, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameVector3D = new FrameVector3D(randomFrame, (Tuple3DReadOnly)(randomTuple = EuclidCoreRandomTools.nextVector3D((Random)random)));
            Assertions.assertTrue((frameVector3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)frameVector3D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Vector2D randomTuple2D;
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameVector3D = new FrameVector3D(randomFrame, (Tuple2DReadOnly)(randomTuple2D = EuclidCoreRandomTools.nextVector2D((Random)random)));
            Assertions.assertTrue((frameVector3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple2D, (EuclidGeometry)new Vector2D((Tuple3DReadOnly)frameVector3D), (double)1.0E-15);
            Assertions.assertTrue((frameVector3D.getZ() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector2D randomFrameTuple2D = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)randomFrame);
            frameVector3D = new FrameVector3D((FrameTuple2DReadOnly)randomFrameTuple2D);
            Assertions.assertTrue((frameVector3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomFrameTuple2D, (EuclidGeometry)new Vector2D((Tuple3DReadOnly)frameVector3D), (double)1.0E-15);
            Assertions.assertTrue((frameVector3D.getZ() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            frameVector3D = new FrameVector3D((FrameTuple3DReadOnly)randomTuple);
            Assertions.assertTrue((frameVector3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)frameVector3D, (double)1.0E-15);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)randomTuple, (EuclidFrameGeometry)frameVector3D, (double)1.0E-15);
        }
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        FrameVector3D source;
        ReferenceFrame destinationFrame;
        ReferenceFrame sourceFrame;
        int i;
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameVector3D, 10);
        Random random = new Random(544354L);
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            source = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            FrameVector3D actual = (FrameVector3D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple3DReadOnly)source);
            FrameVector3D expected = new FrameVector3D((FrameTuple3DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            source = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)sourceFrame);
            double z = EuclidCoreRandomTools.nextDouble((Random)random);
            FrameVector3D actual = (FrameVector3D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple2DReadOnly)source, z);
            FrameVector3D expected = new FrameVector3D();
            expected.setIncludingFrame((FrameTuple2DReadOnly)source, z);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-15);
        }
    }

    @Override
    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameVector3D, 10);
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            FrameVector3D actual = new FrameVector3D(initialFrame, (Tuple3DReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            actual.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                actual.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            FrameVector3D frameVector1 = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D frameVector2 = new FrameVector3D(worldFrame);
            double epsilon = random.nextDouble();
            Vector3D difference = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            frameVector2.add((FrameTuple3DReadOnly)frameVector1, (Tuple3DReadOnly)difference);
            Assertions.assertTrue((boolean)frameVector1.geometricallyEquals((EuclidFrameGeometry)frameVector2, epsilon));
            difference = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            frameVector2.add((FrameTuple3DReadOnly)frameVector1, (Tuple3DReadOnly)difference);
            Assertions.assertFalse((boolean)frameVector1.geometricallyEquals((EuclidFrameGeometry)frameVector2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (int)100);
        FrameVector3D tuple = new FrameVector3D();
        tuple.setX(random.nextDouble());
        tuple.setY(random.nextDouble());
        tuple.setZ(random.nextDouble());
        tuple.setReferenceFrame(frames[random.nextInt(frames.length)]);
        int newHashCode = tuple.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple.hashCode());
        int previousHashCode = tuple.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple.setElement(i % 3, random.nextDouble());
            newHashCode = tuple.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
            ReferenceFrame oldFrame = tuple.getReferenceFrame();
            ReferenceFrame newFrame = frames[random.nextInt(frames.length)];
            tuple.setReferenceFrame(newFrame);
            newHashCode = tuple.hashCode();
            if (oldFrame != newFrame) {
                Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            }
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Vector3D.class}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameVector3D.class, Vector3D.class, true, 1, methodFilter);
    }
}

