/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion32;
import us.ihmc.euclid.tuple4D.Vector4D32;
import us.ihmc.euclid.tuple4D.Vector4DBasicsTest;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class Vector4D32Test
extends Vector4DBasicsTest<Vector4D32> {
    private static final double EPS = 1.0E-10;

    @Test
    public void testConstructors() throws Exception {
        int i;
        Random random = new Random(3453L);
        Vector4D32 vector = new Vector4D32();
        Assertions.assertTrue((vector.getX32() == 0.0f ? 1 : 0) != 0);
        Assertions.assertTrue((vector.getY32() == 0.0f ? 1 : 0) != 0);
        Assertions.assertTrue((vector.getZ32() == 0.0f ? 1 : 0) != 0);
        Assertions.assertTrue((vector.getS32() == 0.0f ? 1 : 0) != 0);
        float x = random.nextFloat();
        float y = random.nextFloat();
        float z = random.nextFloat();
        float s = random.nextFloat();
        Vector4D32 vector2 = new Vector4D32(x, y, z, s);
        Assertions.assertTrue((vector2.getX32() == x ? 1 : 0) != 0);
        Assertions.assertTrue((vector2.getY32() == y ? 1 : 0) != 0);
        Assertions.assertTrue((vector2.getZ32() == z ? 1 : 0) != 0);
        Assertions.assertTrue((vector2.getS32() == s ? 1 : 0) != 0);
        x = random.nextFloat();
        y = random.nextFloat();
        z = random.nextFloat();
        s = random.nextFloat();
        float[] vectorArray = new float[]{x, y, z, s};
        Vector4D32 vector3 = new Vector4D32(vectorArray);
        Assertions.assertTrue((vector3.getX32() == x ? 1 : 0) != 0);
        Assertions.assertTrue((vector3.getY32() == y ? 1 : 0) != 0);
        Assertions.assertTrue((vector3.getZ32() == z ? 1 : 0) != 0);
        Assertions.assertTrue((vector3.getS32() == s ? 1 : 0) != 0);
        Quaternion32 quaternion = EuclidCoreRandomTools.nextQuaternion32((Random)random);
        Vector4D32 vector4 = new Vector4D32((Tuple4DReadOnly)quaternion);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)vector4, (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion32((Random)random);
        vector4 = new Vector4D32((Tuple4DReadOnly)quaternion);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)vector4, (double)1.0E-10);
        Vector3D vector3D = EuclidCoreRandomTools.nextVector3D((Random)random);
        vector4 = new Vector4D32((Vector3DReadOnly)vector3D);
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((vector4.getElement32(i) == vector3D.getElement32(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((vector4.getS32() == 0.0f ? 1 : 0) != 0);
        Point3D point3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
        vector4 = new Vector4D32((Point3DReadOnly)point3D);
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((vector4.getElement32(i) == point3D.getElement32(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((vector4.getS32() == 1.0f ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Vector4D32 vector = this.createRandomTuple(random);
        int newHashCode = vector.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)vector.hashCode());
        int previousHashCode = vector.hashCode();
        for (int i = 0; i < 1000; ++i) {
            vector.setElement(i % 4, random.nextDouble());
            newHashCode = vector.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Vector4D32 vectorB;
            Vector4D32 vectorA = EuclidCoreRandomTools.nextVector4D32((Random)random);
            if (vectorA.geometricallyEquals((EuclidGeometry)(vectorB = EuclidCoreRandomTools.nextVector4D32((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
        }
    }

    @Override
    public Vector4D32 createEmptyTuple() {
        return new Vector4D32();
    }

    @Override
    public Vector4D32 createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextVector4D32((Random)random);
    }

    @Override
    public Vector4D32 createTuple(double x, double y, double z, double s) {
        return new Vector4D32((float)x, (float)y, (float)z, (float)s);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-6;
    }
}

