/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.collision.epa;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.euclid.referenceFrame.collision.epa.FrameExpandingPolytopeAlgorithm;
import us.ihmc.euclid.referenceFrame.collision.gjk.FrameGilbertJohnsonKeerthiCollisionDetectorTest;
import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.epa.ExpandingPolytopeAlgorithm;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;

public class FrameExpandingPolytopeAlgorithmTest {
    private static final boolean VERBOSE = false;
    private static final int ITERATIONS = 10000;
    private static final double DISTANCE_EPSILON = 0.0;
    private static final double POINT_TANGENTIAL_EPSILON = 0.0;
    private static final double LARGE_DISTANCE_EPSILON = 5.0E-4;
    private static final double LARGE_POINT_TANGENTIAL_EPSILON = 0.01;
    private static final double DISTANCE_AVERAGE_EPSILON = 1.0E-8;
    private static final double POINT_NORMAL_ERROR_AVERAGE_EPSILON = 1.0E-8;
    private static final double POINT_TANGENTIAL_ERROR_AVERAGE_EPSILON = 1.0E-5;

    @BeforeEach
    public void disableNameRestriction() {
        ReferenceFrame.getWorldFrame().setNameRestrictionLevel(FrameNameRestrictionLevel.NONE);
    }

    @Test
    public void testCompareAgainstFramelessEPA() {
        FrameShape3DBasics shapeB;
        FrameShape3DBasics shapeA;
        ReferenceFrame frameB;
        ReferenceFrame frameA;
        FrameShape3DBasics shapeB2;
        FrameShape3DBasics shapeA2;
        Random random = new Random(3407L);
        EuclidShape3DCollisionResult expectedResult = new EuclidShape3DCollisionResult();
        EuclidFrameShape3DCollisionResult actualResult = new EuclidFrameShape3DCollisionResult();
        ArrayList<FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError> errors = new ArrayList<FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError>();
        for (int i = 0; i < 10000; ++i) {
            ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
            shapeA2 = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)worldFrame);
            shapeB2 = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)worldFrame);
            FrameExpandingPolytopeAlgorithmTest.computeResults(shapeA2, shapeB2, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)0.0, (double)0.0, (double)0.0);
            errors.add(FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError average = FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-8, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-8, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-5, (String)"average point tangential error too large: ");
        errors = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            ReferenceFrame shapeFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            shapeA2 = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)shapeFrame);
            shapeB2 = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)shapeFrame);
            FrameExpandingPolytopeAlgorithmTest.computeResults(shapeA2, shapeB2, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)0.0, (double)0.0, (double)0.0);
            errors.add(FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        average = FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-8, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-8, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-5, (String)"average point tangential error too large: ");
        errors = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            frameA = ReferenceFrame.getWorldFrame();
            frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            shapeA = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameA);
            shapeB = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameB);
            FrameExpandingPolytopeAlgorithmTest.computeResults(shapeA, shapeB, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)5.0E-4, (double)0.01, (double)0.0);
            errors.add(FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        average = FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-8, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-8, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-5, (String)"average point tangential error too large: ");
        errors = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameB = ReferenceFrame.getWorldFrame();
            shapeA = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameA);
            shapeB = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameB);
            FrameExpandingPolytopeAlgorithmTest.computeResults(shapeA, shapeB, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)5.0E-4, (double)0.01, (double)0.0);
            errors.add(FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        average = FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-8, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-8, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-5, (String)"average point tangential error too large: ");
        errors = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            shapeA = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameA);
            shapeB = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameB);
            FrameExpandingPolytopeAlgorithmTest.computeResults(shapeA, shapeB, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)5.0E-4, (double)0.01, (double)0.0);
            errors.add(FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        average = FrameGilbertJohnsonKeerthiCollisionDetectorTest.ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-8, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-8, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-5, (String)"average point tangential error too large: ");
    }

    private static void computeResults(FrameShape3DBasics shapeA, FrameShape3DBasics shapeB, EuclidShape3DCollisionResult framelessResultToPack, EuclidFrameShape3DCollisionResult frameResultToPack) {
        ReferenceFrame frameA = shapeA.getReferenceFrame();
        ReferenceFrame frameB = shapeB.getReferenceFrame();
        FrameExpandingPolytopeAlgorithm frameDetector = new FrameExpandingPolytopeAlgorithm();
        frameDetector.evaluateCollision((FrameShape3DReadOnly)shapeA, (FrameShape3DReadOnly)shapeB, (EuclidFrameShape3DCollisionResultBasics)frameResultToPack);
        Assertions.assertTrue((frameDetector.getDetectorFrame() == frameA || frameDetector.getDetectorFrame() == frameB ? 1 : 0) != 0);
        frameResultToPack.getPointOnA().checkReferenceFrameMatch(frameDetector.getDetectorFrame());
        frameResultToPack.getPointOnB().checkReferenceFrameMatch(frameDetector.getDetectorFrame());
        ExpandingPolytopeAlgorithm framelessDetector = new ExpandingPolytopeAlgorithm();
        FrameShape3DBasics shapeBInDetectorFrame = shapeB.copy();
        shapeBInDetectorFrame.changeFrame(frameDetector.getDetectorFrame());
        FrameShape3DBasics shapeAInDetectorFrame = shapeA.copy();
        shapeAInDetectorFrame.changeFrame(frameDetector.getDetectorFrame());
        framelessDetector.evaluateCollision((Shape3DReadOnly)shapeAInDetectorFrame, (Shape3DReadOnly)shapeBInDetectorFrame, (EuclidShape3DCollisionResultBasics)framelessResultToPack);
        framelessResultToPack.setShapeA((Shape3DReadOnly)shapeA);
        framelessResultToPack.setShapeB((Shape3DReadOnly)shapeB);
    }
}

