/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class Vertex3DSupplierTest {
    public static final double EPSILON = 1.0E-12;

    @Test
    public void testCreatingEmptySupplier() {
        Vertex3DSupplier expected = Vertex3DSupplier.emptyVertex3DSupplier();
        Vertex3DSupplier actual = Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[0]);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
        actual = Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[0], (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
        actual = Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[0], (int)0, (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
        actual = Vertex3DSupplier.asVertex3DSupplier(Collections.emptyList());
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
        actual = Vertex3DSupplier.asVertex3DSupplier(Collections.emptyList(), (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
        actual = Vertex3DSupplier.asVertex3DSupplier(Collections.emptyList(), (int)0, (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
    }

    @Test
    public void testAsVertex3DSupplier() throws Exception {
        int j;
        Vertex3DSupplier supplier;
        List subList;
        int listSize;
        int numberOfVertices;
        int i;
        Random random = new Random(23423L);
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(200);
            ArrayList<Point3D> original = new ArrayList<Point3D>();
            while (original.size() < numberOfVertices) {
                original.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            }
            Vertex3DSupplier supplier2 = Vertex3DSupplier.asVertex3DSupplier(original);
            Assertions.assertEquals((int)numberOfVertices, (int)supplier2.getNumberOfVertices());
            for (int j2 = 0; j2 < numberOfVertices; ++j2) {
                Assertions.assertTrue((original.get(j2) == supplier2.getVertex(j2) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices2 = random.nextInt(listSize);
            ArrayList<Point3D> original = new ArrayList<Point3D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            }
            Vertex3DSupplier supplier3 = Vertex3DSupplier.asVertex3DSupplier(original, (int)numberOfVertices2);
            Assertions.assertEquals((int)numberOfVertices2, (int)supplier3.getNumberOfVertices());
            subList = original.subList(0, numberOfVertices2);
            for (int j3 = 0; j3 < numberOfVertices2; ++j3) {
                Assertions.assertTrue((subList.get(j3) == supplier3.getVertex(j3) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices3 = random.nextInt(listSize);
            int startIndex = random.nextInt(listSize - numberOfVertices3);
            ArrayList<Point3D> original = new ArrayList<Point3D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            }
            supplier = Vertex3DSupplier.asVertex3DSupplier(original, (int)startIndex, (int)numberOfVertices3);
            Assertions.assertEquals((int)numberOfVertices3, (int)supplier.getNumberOfVertices());
            List subList2 = original.subList(startIndex, startIndex + numberOfVertices3);
            for (j = 0; j < numberOfVertices3; ++j) {
                Assertions.assertTrue((subList2.get(j) == supplier.getVertex(j) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(200);
            ArrayList<Point3D> original = new ArrayList<Point3D>();
            while (original.size() < numberOfVertices) {
                original.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            }
            Vertex3DSupplier supplier4 = Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])original.toArray(new Point3DReadOnly[0]));
            Assertions.assertEquals((int)numberOfVertices, (int)supplier4.getNumberOfVertices());
            for (int j4 = 0; j4 < numberOfVertices; ++j4) {
                Assertions.assertTrue((original.get(j4) == supplier4.getVertex(j4) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices4 = random.nextInt(listSize);
            ArrayList<Point3D> original = new ArrayList<Point3D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            }
            Vertex3DSupplier supplier5 = Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])original.toArray(new Point3DReadOnly[0]), (int)numberOfVertices4);
            Assertions.assertEquals((int)numberOfVertices4, (int)supplier5.getNumberOfVertices());
            subList = original.subList(0, numberOfVertices4);
            for (int j5 = 0; j5 < numberOfVertices4; ++j5) {
                Assertions.assertTrue((subList.get(j5) == supplier5.getVertex(j5) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices5 = random.nextInt(listSize);
            int startIndex = random.nextInt(listSize - numberOfVertices5);
            ArrayList<Point3D> original = new ArrayList<Point3D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint3D((Random)random));
            }
            supplier = Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])original.toArray(new Point3DReadOnly[0]), (int)startIndex, (int)numberOfVertices5);
            Assertions.assertEquals((int)numberOfVertices5, (int)supplier.getNumberOfVertices());
            List subList3 = original.subList(startIndex, startIndex + numberOfVertices5);
            for (j = 0; j < numberOfVertices5; ++j) {
                Assertions.assertTrue((subList3.get(j) == supplier.getVertex(j) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(9017L);
        for (int i = 0; i < 1000; ++i) {
            int sizeA = random.nextInt(100) + 1;
            List listA = IntStream.range(0, sizeA).mapToObj(v -> EuclidCoreRandomTools.nextPoint3D((Random)random)).collect(Collectors.toList());
            List listAPrime = listA.stream().map(Point3D::new).collect(Collectors.toList());
            List listSizeA = IntStream.range(0, sizeA).mapToObj(v -> EuclidCoreRandomTools.nextPoint3D((Random)random)).collect(Collectors.toList());
            int sizeB = random.nextInt(100) + 1;
            List listB = IntStream.range(0, sizeB).mapToObj(v -> EuclidCoreRandomTools.nextPoint3D((Random)random)).collect(Collectors.toList());
            Assertions.assertTrue((boolean)Vertex3DSupplier.asVertex3DSupplier(listA).equals((EuclidGeometry)Vertex3DSupplier.asVertex3DSupplier(listA)));
            Assertions.assertTrue((boolean)Vertex3DSupplier.asVertex3DSupplier(listA).equals((EuclidGeometry)Vertex3DSupplier.asVertex3DSupplier(listAPrime)));
            Assertions.assertFalse((boolean)Vertex3DSupplier.asVertex3DSupplier(listA).equals((EuclidGeometry)Vertex3DSupplier.asVertex3DSupplier(listSizeA)));
            Assertions.assertFalse((boolean)Vertex3DSupplier.asVertex3DSupplier(listA).equals((EuclidGeometry)Vertex3DSupplier.asVertex3DSupplier(listB)));
        }
    }

    @Test
    public void testEpsilonquals() throws Exception {
        Random random = new Random(9017L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            int sizeA = random.nextInt(100) + 1;
            List listA = IntStream.range(0, sizeA).mapToObj(v -> EuclidCoreRandomTools.nextPoint3D((Random)random)).collect(Collectors.toList());
            List<Point3D> listAPrime = listA.stream().map(Point3D::new).collect(Collectors.toList());
            listAPrime.forEach(p -> p.add(EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon), EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon), EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon)));
            List<Point3D> listSizeA = listA.stream().map(Point3D::new).collect(Collectors.toList());
            listSizeA.forEach(p -> p.add((random.nextBoolean() ? -1.0 : 1.0) * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(epsilon + 1.0)), (random.nextBoolean() ? -1.0 : 1.0) * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(epsilon + 1.0)), (random.nextBoolean() ? -1.0 : 1.0) * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(epsilon + 1.0))));
            int sizeB = random.nextInt(100) + 1;
            List listB = IntStream.range(0, sizeB).mapToObj(v -> EuclidCoreRandomTools.nextPoint3D((Random)random)).collect(Collectors.toList());
            Assertions.assertTrue((boolean)Vertex3DSupplier.asVertex3DSupplier(listA).epsilonEquals((EuclidGeometry)Vertex3DSupplier.asVertex3DSupplier(listA), epsilon), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)Vertex3DSupplier.asVertex3DSupplier(listA).epsilonEquals((EuclidGeometry)Vertex3DSupplier.asVertex3DSupplier(listAPrime), epsilon), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)Vertex3DSupplier.asVertex3DSupplier(listA).epsilonEquals((EuclidGeometry)Vertex3DSupplier.asVertex3DSupplier(listSizeA), epsilon), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)Vertex3DSupplier.asVertex3DSupplier(listA).epsilonEquals((EuclidGeometry)Vertex3DSupplier.asVertex3DSupplier(listB), epsilon), (String)("Iteration: " + i));
        }
    }
}

