/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.FramePointShape3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameShapeAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePointShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.shape.primitives.PointShape3D;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FramePointShape3DTest {
    @BeforeEach
    public void disableNameRestriction() {
        ReferenceFrame.getWorldFrame().setNameRestrictionLevel(FrameNameRestrictionLevel.NONE);
    }

    @Test
    public void testAPIOverloading() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FramePointShape3DReadOnly.class, PointShape3DReadOnly.class, false);
        tester.assertOverloadingWithFrameObjects(FixedFramePointShape3DBasics.class, PointShape3DBasics.class, false);
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{PointShape3D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{PointShape3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{PointShape3D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FramePointShape3D.class, PointShape3D.class, false, 1, methodFilter);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("getBoundingBox", new Class[]{FixedFrameBoundingBox3DBasics.class}));
        signaturesToIgnore.add(new MethodSignature("getBoundingBox", new Class[]{ReferenceFrame.class, FrameBoundingBox3DBasics.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(EuclidFrameShapeRandomTools::nextFramePointShape3D, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithPointShape3D() {
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality((frame, pointShape) -> new FramePointShape3D(frame, (Tuple3DReadOnly)((PointShape3D)pointShape)), EuclidShapeRandomTools::nextPointShape3D, methodFilter, 10);
    }

    @Test
    public void testSetMatchingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameShapeRandomTools::nextFramePointShape3D, 10);
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameShapeRandomTools::nextFramePointShape3D, 10);
    }
}

