/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.Vector3DBasicsTest;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Vector3D32Test
extends Vector3DBasicsTest<Vector3D32> {
    @Test
    public void testVector32() {
        int i;
        Random random = new Random(621541L);
        Vector3D32 vector = new Vector3D32();
        Assertions.assertTrue((0.0f == vector.getX32() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0f == vector.getY32() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0f == vector.getZ32() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            float newZ;
            float newY;
            float newX = random.nextFloat();
            Assertions.assertTrue((newX == (vector = new Vector3D32(newX, newY = random.nextFloat(), newZ = random.nextFloat())).getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((newY == vector.getY32() ? 1 : 0) != 0);
            Assertions.assertTrue((newZ == vector.getZ32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            float[] randomVector32Array = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat()};
            float[] copyRandomVector32Array = new float[]{randomVector32Array[0], randomVector32Array[1], randomVector32Array[2]};
            Vector3D32 vectorArray = new Vector3D32(randomVector32Array);
            Assertions.assertTrue((randomVector32Array[0] == vectorArray.getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((randomVector32Array[1] == vectorArray.getY32() ? 1 : 0) != 0);
            Assertions.assertTrue((randomVector32Array[2] == vectorArray.getZ32() ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomVector32Array[0] == randomVector32Array[0] ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomVector32Array[1] == randomVector32Array[1] ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomVector32Array[2] == randomVector32Array[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D32 vector2 = EuclidCoreRandomTools.nextVector3D32((Random)random);
            vector = new Vector3D32((Tuple3DReadOnly)vector2);
            Assertions.assertTrue((vector.getX32() == vector2.getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY32() == vector2.getY32() ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ32() == vector2.getZ32() ? 1 : 0) != 0);
        }
    }

    @Override
    public void testSetters() throws Exception {
        int i;
        super.testSetters();
        Random random = new Random(621541L);
        Vector3D32 tuple1 = this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            tuple1.setX(x);
            Assertions.assertEquals((double)tuple1.getX32(), (double)x, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float y = random.nextFloat();
            tuple1.setY(y);
            Assertions.assertEquals((double)tuple1.getY32(), (double)y, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float z = random.nextFloat();
            tuple1.setZ(z);
            Assertions.assertEquals((double)tuple1.getZ32(), (double)z, (double)this.getEpsilon());
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Vector3D32 tuple1 = this.createRandomTuple(random);
        int newHashCode = tuple1.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple1.hashCode());
        int previousHashCode = tuple1.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple1.setElement(i % 3, (double)random.nextFloat());
            newHashCode = tuple1.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Vector3D32 vectorB;
            Vector3D32 vectorA = EuclidCoreRandomTools.nextVector3D32((Random)random);
            if (vectorA.geometricallyEquals((EuclidGeometry)(vectorB = EuclidCoreRandomTools.nextVector3D32((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
        }
    }

    @Override
    public Vector3D32 createEmptyTuple() {
        return new Vector3D32();
    }

    @Override
    public Vector3D32 createTuple(double x, double y, double z) {
        return new Vector3D32((float)x, (float)y, (float)z);
    }

    @Override
    public Vector3D32 createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextVector3D32((Random)random);
    }

    @Override
    public double getEpsilon() {
        return 2.0E-7;
    }
}

