/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class AxisAngleToolsTest {
    private static final double EPSILON = 1.0E-14;

    @Test
    public void testDistance() {
        Quaternion converted;
        AxisAngle axisAngle;
        int i;
        Random random = new Random(32434L);
        for (i = 0; i < 1000; ++i) {
            AxisAngle aa1 = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            AxisAngle aa2 = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)aa1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)aa2);
            double actualDistance = AxisAngleTools.distance((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)aa2, (boolean)false);
            double expectedDistance = q1.distance((Orientation3DReadOnly)q2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-14);
            Assertions.assertEquals((double)0.0, (double)aa1.distance((Orientation3DReadOnly)aa1), (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D u1 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0));
            Vector3D u2 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0));
            AxisAngle aa1 = new AxisAngle((Vector3DReadOnly)u1, EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            AxisAngle aa2 = new AxisAngle((Vector3DReadOnly)u2, EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)aa1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)aa2);
            double actualDistance = AxisAngleTools.distance((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)aa2, (boolean)false);
            double expectedDistance = q1.distance((Orientation3DReadOnly)q2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-14);
            Assertions.assertEquals((double)0.0, (double)aa1.distance((Orientation3DReadOnly)aa1), (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            converted = new Quaternion((Orientation3DReadOnly)axisAngle);
            double actualDistance = AxisAngleTools.distance((AxisAngleReadOnly)axisAngle, (QuaternionReadOnly)quaternion, (boolean)false);
            double expectedDistance = QuaternionTools.distance((QuaternionReadOnly)converted, (QuaternionReadOnly)quaternion, (boolean)false);
            Assertions.assertEquals((double)actualDistance, (double)expectedDistance, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            converted = new RotationMatrix((Orientation3DReadOnly)axisAngle);
            double actualDistance = AxisAngleTools.distance((AxisAngleReadOnly)axisAngle, (RotationMatrixReadOnly)rotationMatrix);
            double expectedDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)converted, (RotationMatrixReadOnly)rotationMatrix);
            Assertions.assertEquals((double)actualDistance, (double)expectedDistance, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            YawPitchRoll yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            converted = new AxisAngle((Orientation3DReadOnly)yawPitchRoll);
            double actualDistance = AxisAngleTools.distance((AxisAngleReadOnly)axisAngle, (YawPitchRollReadOnly)yawPitchRoll, (boolean)false);
            double expectedDistance = AxisAngleTools.distance((AxisAngleReadOnly)converted, (AxisAngleReadOnly)axisAngle, (boolean)false);
            Assertions.assertEquals((double)actualDistance, (double)expectedDistance, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            double withQuaternionResult = AxisAngleTools.distance((AxisAngleReadOnly)axisAngle, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)orientation), (boolean)false);
            double withRotationMatrixResult = AxisAngleTools.distance((AxisAngleReadOnly)axisAngle, (Orientation3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false);
            double notCastedResult = AxisAngleTools.distance((AxisAngleReadOnly)axisAngle, (Orientation3DReadOnly)orientation, (boolean)false);
            if (Math.abs(notCastedResult) <= Math.PI) {
                Assertions.assertEquals((double)notCastedResult, (double)withRotationMatrixResult, (double)1.0E-14);
                continue;
            }
            Assertions.assertEquals((double)notCastedResult, (double)withQuaternionResult, (double)1.0E-14);
        }
        double min = Math.PI;
        double max = 2.0 * min;
        for (int i2 = 0; i2 < 1000; ++i2) {
            double randomAngle = ThreadLocalRandom.current().nextDouble(min, max);
            AxisAngle aa1 = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            AxisAngle distance = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            distance.setAngle(randomAngle);
            AxisAngle aa2 = new AxisAngle();
            AxisAngleTools.multiply((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)distance, (AxisAngleBasics)aa2);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)aa1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)aa2);
            double expected = QuaternionTools.distance((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (boolean)true);
            double actual = AxisAngleTools.distance((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)aa2, (boolean)true);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-14);
            Orientation3DBasics orientation3D = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            double distanceLimit = AxisAngleTools.distance((AxisAngleReadOnly)aa1, (Orientation3DReadOnly)orientation3D, (boolean)true);
            double distanceLimitFromQuaternion = QuaternionTools.distance((QuaternionReadOnly)q1, (Orientation3DReadOnly)orientation3D, (boolean)true);
            double distanceNoLimit = AxisAngleTools.distance((AxisAngleReadOnly)aa1, (Orientation3DReadOnly)orientation3D, (boolean)false);
            double distanceNoLimitFromQuaternion = QuaternionTools.distance((QuaternionReadOnly)q1, (Orientation3DReadOnly)orientation3D, (boolean)false);
            Assertions.assertEquals((double)distanceLimit, (double)distanceLimitFromQuaternion, (double)1.0E-14);
            Assertions.assertEquals((double)distanceNoLimit, (double)distanceNoLimitFromQuaternion, (double)1.0E-14);
        }
    }
}

