/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.HalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.Vertex3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Face3DTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testSimpleConstruction2D() throws Exception {
        Point3D p0 = new Point3D(0.0, 0.0, 0.0);
        Point3D p1 = new Point3D(1.0, 0.0, 0.0);
        Point3D p2 = new Point3D(1.0, 1.0, 0.0);
        Point3D p3 = new Point3D(0.0, 1.0, 0.0);
        Face3D face = new Face3D((Vector3DReadOnly)Axis3D.Z);
        face.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)p0));
        Assertions.assertEquals((Object)p0, face.getVertices().get(0));
        Assertions.assertEquals((int)1, (int)face.getNumberOfEdges());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
        face.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)p1));
        Assertions.assertEquals((Object)p0, face.getVertices().get(0));
        Assertions.assertEquals((Object)p1, face.getVertices().get(1));
        Assertions.assertEquals((int)2, (int)face.getNumberOfEdges());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
        face.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)p2));
        Assertions.assertEquals((Object)p1, face.getVertices().get(0));
        Assertions.assertEquals((Object)p0, face.getVertices().get(1));
        Assertions.assertEquals((Object)p2, face.getVertices().get(2));
        Assertions.assertEquals((int)3, (int)face.getNumberOfEdges());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
        face.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)p3));
        Assertions.assertEquals((Object)p1, face.getVertices().get(0));
        Assertions.assertEquals((Object)p0, face.getVertices().get(1));
        Assertions.assertEquals((Object)p3, face.getVertices().get(2));
        Assertions.assertEquals((Object)p2, face.getVertices().get(3));
        Assertions.assertEquals((int)4, (int)face.getNumberOfEdges());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
    }

    @Test
    public void testCircleBasedConstruction2D() throws Exception {
        double radius = 1.0;
        double numberOfPoints = 10.0;
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        int i = 0;
        while ((double)i < numberOfPoints) {
            double theta = (double)i * 2.0 * Math.PI / numberOfPoints;
            double x = -radius * EuclidCoreTools.cos((double)theta);
            double y = radius * EuclidCoreTools.sin((double)theta);
            points.add(new Point3D(x, y, 0.0));
            ++i;
        }
        Face3D face = new Face3D((Vector3DReadOnly)Axis3D.Z);
        int i2 = 0;
        while ((double)i2 < numberOfPoints) {
            face.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)points.get(i2)));
            Assertions.assertEquals((int)(i2 + 1), (int)face.getNumberOfEdges());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)points.get(i2)), (EuclidGeometry)((EuclidGeometry)face.getVertices().get(i2)), (double)1.0E-12);
            ++i2;
        }
        EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
        Random random = new Random(3453L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        points.forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
        face = new Face3D((Vector3DReadOnly)Axis3D.Z);
        int i3 = 0;
        while ((double)i3 < numberOfPoints) {
            face.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)points.get(i3)));
            Assertions.assertEquals((int)(i3 + 1), (int)face.getNumberOfEdges());
            ++i3;
        }
        Vector3D expectedNormal = new Vector3D();
        transform.getRotation().getColumn(2, (Tuple3DBasics)expectedNormal);
        if (expectedNormal.getZ() < 0.0) {
            expectedNormal.negate();
        }
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
    }

    @Test
    public void testLineOfSight() throws Exception {
        Point2DBasics[] lineOfSightVertices2D;
        int[] expectedLineOfSightIndices;
        Point2D observer2D;
        Point2D pointOnEdge2D;
        Point2DReadOnly nextVertex2D;
        Point2DReadOnly vertex2D;
        int edgeIndex;
        int numberOfVertices;
        Point2D centroid2D;
        ConvexPolygon2D convexPolygon2D;
        int i;
        Random random = new Random(1951L);
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)5.0, (int)(random.nextInt(25) + 3));
            centroid2D = new Point2D((Tuple2DReadOnly)convexPolygon2D.getCentroid());
            numberOfVertices = convexPolygon2D.getNumberOfVertices();
            edgeIndex = random.nextInt(numberOfVertices);
            vertex2D = convexPolygon2D.getVertex(edgeIndex);
            nextVertex2D = convexPolygon2D.getNextVertex(edgeIndex);
            pointOnEdge2D = new Point2D();
            pointOnEdge2D.interpolate((Tuple2DReadOnly)vertex2D, (Tuple2DReadOnly)nextVertex2D, random.nextDouble());
            Assertions.assertEquals((double)0.0, (double)convexPolygon2D.distance((Point2DReadOnly)pointOnEdge2D), (double)1.0E-12);
            observer2D = new Point2D();
            observer2D.interpolate((Tuple2DReadOnly)centroid2D, (Tuple2DReadOnly)pointOnEdge2D, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            Assertions.assertFalse((boolean)convexPolygon2D.isPointInside((Point2DReadOnly)observer2D));
            expectedLineOfSightIndices = convexPolygon2D.lineOfSightIndices((Point2DReadOnly)observer2D);
            lineOfSightVertices2D = convexPolygon2D.lineOfSightVertices((Point2DReadOnly)observer2D);
            Assertions.assertNotNull((Object)lineOfSightVertices2D);
            Assertions.assertEquals((int)2, (int)lineOfSightVertices2D.length);
            Assertions.assertNotNull((Object)lineOfSightVertices2D[0]);
            Assertions.assertNotNull((Object)lineOfSightVertices2D[1]);
            Face3D face3D = new Face3D((Vector3DReadOnly)Axis3D.Z);
            convexPolygon2D.getPolygonVerticesView().stream().map(Point3D::new).map(Vertex3D::new).forEach(v -> face3D.addVertex((AbstractVertex3D)v));
            Assertions.assertEquals((int)numberOfVertices, (int)face3D.getNumberOfEdges());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)face3D.getNormal(), (double)1.0E-12);
            Point3D[] expectedLineOfSightVertices3D = (Point3D[])Stream.of(lineOfSightVertices2D).map(Point3D::new).toArray(Point3D[]::new);
            Point3D observer3D = new Point3D((Tuple2DReadOnly)observer2D);
            Assertions.assertFalse((boolean)face3D.isPointInside((Point3DReadOnly)observer3D, 0.0));
            Assertions.assertTrue((boolean)face3D.isPointInFaceSupportPlane((Point3DReadOnly)observer3D, 1.0E-12));
            Vertex3DReadOnly expectedLineOfSightStartVertex3D = (Vertex3DReadOnly)face3D.getVertices().get(expectedLineOfSightIndices[0]);
            Vertex3DReadOnly expectedLineOfSightEndVertex3D = (Vertex3DReadOnly)face3D.getVertices().get(expectedLineOfSightIndices[1]);
            HalfEdge3D expectedLineOfSightStartEdge3D = (HalfEdge3D)face3D.getEdge(expectedLineOfSightIndices[0]);
            HalfEdge3D expectedLineOfSightEndEdge3D = (HalfEdge3D)((HalfEdge3D)face3D.getEdge(expectedLineOfSightIndices[1])).getPrevious();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[0], (EuclidGeometry)expectedLineOfSightStartVertex3D, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[0], (EuclidGeometry)expectedLineOfSightStartEdge3D.getOrigin(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[1], (EuclidGeometry)expectedLineOfSightEndVertex3D, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[1], (EuclidGeometry)expectedLineOfSightEndEdge3D.getDestination(), (double)1.0E-12);
            int visibleEdgeIndex = expectedLineOfSightIndices[0];
            for (HalfEdge3D visibleEdge = expectedLineOfSightStartEdge3D; visibleEdge != expectedLineOfSightEndEdge3D.getNext(); visibleEdge = (HalfEdge3D)visibleEdge.getNext()) {
                Assertions.assertTrue((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)observer3D, visibleEdgeIndex));
                Assertions.assertTrue((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)observer3D, (HalfEdge3DReadOnly)visibleEdge));
                visibleEdgeIndex = (visibleEdgeIndex + 1) % face3D.getNumberOfEdges();
            }
            int hiddenEdgeIndex = expectedLineOfSightIndices[1];
            for (HalfEdge3D hiddenEdge = (HalfEdge3D)expectedLineOfSightEndEdge3D.getNext(); hiddenEdge != expectedLineOfSightStartEdge3D; hiddenEdge = (HalfEdge3D)hiddenEdge.getNext()) {
                Assertions.assertFalse((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)observer3D, hiddenEdgeIndex));
                Assertions.assertFalse((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)observer3D, (HalfEdge3DReadOnly)hiddenEdge));
                hiddenEdgeIndex = (hiddenEdgeIndex + 1) % face3D.getNumberOfEdges();
            }
            String errorMessage = "Iteration: " + i;
            Assertions.assertNotNull((Object)face3D.lineOfSightStart((Point3DReadOnly)observer3D), (String)errorMessage);
            EuclidCoreTestTools.assertEquals((String)errorMessage, (EuclidGeometry)expectedLineOfSightVertices3D[0], (EuclidGeometry)((HalfEdge3D)face3D.lineOfSightStart((Point3DReadOnly)observer3D)).getOrigin(), (double)1.0E-12);
            Assertions.assertNotNull((Object)face3D.lineOfSightEnd((Point3DReadOnly)observer3D), (String)errorMessage);
            EuclidCoreTestTools.assertEquals((String)errorMessage, (EuclidGeometry)expectedLineOfSightVertices3D[1], (EuclidGeometry)((HalfEdge3D)face3D.lineOfSightEnd((Point3DReadOnly)observer3D)).getDestination(), (double)1.0E-12);
            List lineOfSight3D = face3D.lineOfSight((Point3DReadOnly)observer3D);
            Assertions.assertFalse((boolean)lineOfSight3D.isEmpty(), (String)errorMessage);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[0], (EuclidGeometry)((HalfEdge3D)lineOfSight3D.get(0)).getOrigin(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[1], (EuclidGeometry)((HalfEdge3D)lineOfSight3D.get(lineOfSight3D.size() - 1)).getDestination(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)5.0, (int)(random.nextInt(25) + 3));
            centroid2D = new Point2D((Tuple2DReadOnly)convexPolygon2D.getCentroid());
            numberOfVertices = convexPolygon2D.getNumberOfVertices();
            edgeIndex = random.nextInt(numberOfVertices);
            vertex2D = convexPolygon2D.getVertex(edgeIndex);
            nextVertex2D = convexPolygon2D.getNextVertex(edgeIndex);
            pointOnEdge2D = new Point2D();
            pointOnEdge2D.interpolate((Tuple2DReadOnly)vertex2D, (Tuple2DReadOnly)nextVertex2D, random.nextDouble());
            Assertions.assertEquals((double)0.0, (double)convexPolygon2D.distance((Point2DReadOnly)pointOnEdge2D), (double)1.0E-12);
            observer2D = new Point2D();
            observer2D.interpolate((Tuple2DReadOnly)centroid2D, (Tuple2DReadOnly)pointOnEdge2D, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            Assertions.assertFalse((boolean)convexPolygon2D.isPointInside((Point2DReadOnly)observer2D));
            expectedLineOfSightIndices = convexPolygon2D.lineOfSightIndices((Point2DReadOnly)observer2D);
            lineOfSightVertices2D = convexPolygon2D.lineOfSightVertices((Point2DReadOnly)observer2D);
            Assertions.assertNotNull((Object)lineOfSightVertices2D);
            Assertions.assertEquals((int)2, (int)lineOfSightVertices2D.length);
            Assertions.assertNotNull((Object)lineOfSightVertices2D[0]);
            Assertions.assertNotNull((Object)lineOfSightVertices2D[1]);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Vector3D faceNormal = new Vector3D();
            transform.getRotation().getColumn(2, (Tuple3DBasics)faceNormal);
            Face3D face3D = new Face3D((Vector3DReadOnly)faceNormal);
            convexPolygon2D.getPolygonVerticesView().stream().map(Point3D::new).map(Vertex3D::new).peek(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0)).forEach(v -> face3D.addVertex((AbstractVertex3D)v));
            Assertions.assertEquals((int)numberOfVertices, (int)face3D.getNumberOfEdges());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)faceNormal, (EuclidGeometry)face3D.getNormal(), (double)1.0E-12);
            Point3D[] expectedLineOfSightVertices3D = (Point3D[])Stream.of(lineOfSightVertices2D).map(Point3D::new).peek(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0)).toArray(Point3D[]::new);
            Point3D observer3D = new Point3D((Tuple2DReadOnly)observer2D);
            observer3D.applyTransform((Transform)transform);
            Assertions.assertFalse((boolean)face3D.isPointInside((Point3DReadOnly)observer3D, 0.0));
            Assertions.assertTrue((boolean)face3D.isPointInFaceSupportPlane((Point3DReadOnly)observer3D, 1.0E-12));
            Vertex3DReadOnly expectedLineOfSightStartVertex3D = (Vertex3DReadOnly)face3D.getVertices().get(expectedLineOfSightIndices[0]);
            Vertex3DReadOnly expectedLineOfSightEndVertex3D = (Vertex3DReadOnly)face3D.getVertices().get(expectedLineOfSightIndices[1]);
            HalfEdge3D expectedLineOfSightStartEdge3D = (HalfEdge3D)face3D.getEdge(expectedLineOfSightIndices[0]);
            HalfEdge3D expectedLineOfSightEndEdge3D = (HalfEdge3D)((HalfEdge3D)face3D.getEdge(expectedLineOfSightIndices[1])).getPrevious();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[0], (EuclidGeometry)expectedLineOfSightStartVertex3D, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[0], (EuclidGeometry)expectedLineOfSightStartEdge3D.getOrigin(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[1], (EuclidGeometry)expectedLineOfSightEndVertex3D, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[1], (EuclidGeometry)expectedLineOfSightEndEdge3D.getDestination(), (double)1.0E-12);
            int visibleEdgeIndex = expectedLineOfSightIndices[0];
            for (HalfEdge3D visibleEdge = expectedLineOfSightStartEdge3D; visibleEdge != expectedLineOfSightEndEdge3D.getNext(); visibleEdge = (HalfEdge3D)visibleEdge.getNext()) {
                Assertions.assertTrue((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)observer3D, visibleEdgeIndex));
                Assertions.assertTrue((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)observer3D, (HalfEdge3DReadOnly)visibleEdge));
                visibleEdgeIndex = (visibleEdgeIndex + 1) % face3D.getNumberOfEdges();
            }
            int hiddenEdgeIndex = expectedLineOfSightIndices[1];
            for (HalfEdge3D hiddenEdge = (HalfEdge3D)expectedLineOfSightEndEdge3D.getNext(); hiddenEdge != expectedLineOfSightStartEdge3D; hiddenEdge = (HalfEdge3D)hiddenEdge.getNext()) {
                Assertions.assertFalse((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)observer3D, hiddenEdgeIndex));
                Assertions.assertFalse((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)observer3D, (HalfEdge3DReadOnly)hiddenEdge));
                hiddenEdgeIndex = (hiddenEdgeIndex + 1) % face3D.getNumberOfEdges();
            }
            String errorMessage = "Iteration: " + i;
            Assertions.assertNotNull((Object)face3D.lineOfSightStart((Point3DReadOnly)observer3D), (String)errorMessage);
            EuclidCoreTestTools.assertEquals((String)errorMessage, (EuclidGeometry)expectedLineOfSightVertices3D[0], (EuclidGeometry)((HalfEdge3D)face3D.lineOfSightStart((Point3DReadOnly)observer3D)).getOrigin(), (double)1.0E-12);
            Assertions.assertNotNull((Object)face3D.lineOfSightEnd((Point3DReadOnly)observer3D), (String)errorMessage);
            EuclidCoreTestTools.assertEquals((String)errorMessage, (EuclidGeometry)expectedLineOfSightVertices3D[1], (EuclidGeometry)((HalfEdge3D)face3D.lineOfSightEnd((Point3DReadOnly)observer3D)).getDestination(), (double)1.0E-12);
            List lineOfSight3D = face3D.lineOfSight((Point3DReadOnly)observer3D);
            Assertions.assertFalse((boolean)lineOfSight3D.isEmpty(), (String)errorMessage);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[0], (EuclidGeometry)((HalfEdge3D)lineOfSight3D.get(0)).getOrigin(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineOfSightVertices3D[1], (EuclidGeometry)((HalfEdge3D)lineOfSight3D.get(lineOfSight3D.size() - 1)).getDestination(), (double)1.0E-12);
        }
    }

    @Test
    public void testHalfEdgeAreSetProperly() throws Exception {
        HalfEdge3D edge;
        HalfEdge3D nextEdge;
        HalfEdge3D prevEdge;
        int nextIndex;
        int previousIndex;
        List edges;
        Face3D face;
        int numberOfVertices;
        int i;
        Random random = new Random(2342L);
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = 10;
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)1.0, (double)1.0, (int)numberOfVertices, (Vector3DReadOnly)Axis3D.Z);
            Assertions.assertEquals((int)numberOfVertices, (int)face.getNumberOfEdges());
            edges = face.getEdges();
            for (int edgeIndex = 0; edgeIndex < numberOfVertices; ++edgeIndex) {
                previousIndex = EuclidCoreTools.previous((int)edgeIndex, (int)edges.size());
                nextIndex = EuclidCoreTools.next((int)edgeIndex, (int)edges.size());
                prevEdge = (HalfEdge3D)edges.get(previousIndex);
                nextEdge = (HalfEdge3D)edges.get(nextIndex);
                edge = (HalfEdge3D)edges.get(edgeIndex);
                Assertions.assertTrue((edge.getPrevious() == prevEdge ? 1 : 0) != 0);
                Assertions.assertTrue((edge.getNext() == nextEdge ? 1 : 0) != 0);
                Assertions.assertTrue((edge.getFace() == face ? 1 : 0) != 0);
                Assertions.assertTrue((prevEdge.getDestination() == edge.getOrigin() ? 1 : 0) != 0);
                Assertions.assertTrue((nextEdge.getOrigin() == edge.getDestination() ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = 10;
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)1.0, (double)1.0, (int)numberOfVertices, (Vector3DReadOnly)Axis3D.Z);
            Assertions.assertEquals((int)numberOfVertices, (int)face.getNumberOfEdges());
            face.flip();
            edges = face.getEdges();
            for (int edgeIndex = 0; edgeIndex < numberOfVertices; ++edgeIndex) {
                previousIndex = EuclidCoreTools.previous((int)edgeIndex, (int)edges.size());
                nextIndex = EuclidCoreTools.next((int)edgeIndex, (int)edges.size());
                prevEdge = (HalfEdge3D)edges.get(previousIndex);
                nextEdge = (HalfEdge3D)edges.get(nextIndex);
                edge = (HalfEdge3D)edges.get(edgeIndex);
                Assertions.assertTrue((edge.getPrevious() == prevEdge ? 1 : 0) != 0);
                Assertions.assertTrue((edge.getNext() == nextEdge ? 1 : 0) != 0);
                Assertions.assertTrue((edge.getFace() == face ? 1 : 0) != 0);
                Assertions.assertTrue((prevEdge.getDestination() == edge.getOrigin() ? 1 : 0) != 0);
                Assertions.assertTrue((nextEdge.getOrigin() == edge.getDestination() ? 1 : 0) != 0);
            }
            Vector3D originalNormal = new Vector3D((Tuple3DReadOnly)face.getNormal());
            face.updateNormal();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalNormal, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = 10;
            Vector3D faceNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            List vertices = EuclidShapeRandomTools.nextCircleBasedConvexPolygon3D((Random)random, (double)1.0, (double)1.0, (int)numberOfVertices, (Vector3DReadOnly)faceNormal);
            Collections.shuffle(vertices, random);
            Face3D face2 = new Face3D((Vector3DReadOnly)faceNormal);
            vertices.forEach(vertex -> face2.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)vertex)));
            Assertions.assertEquals((int)numberOfVertices, (int)face2.getNumberOfEdges());
            List edges2 = face2.getEdges();
            for (int edgeIndex = 0; edgeIndex < numberOfVertices; ++edgeIndex) {
                int previousIndex2 = EuclidCoreTools.previous((int)edgeIndex, (int)edges2.size());
                int nextIndex2 = EuclidCoreTools.next((int)edgeIndex, (int)edges2.size());
                HalfEdge3D prevEdge2 = (HalfEdge3D)edges2.get(previousIndex2);
                HalfEdge3D nextEdge2 = (HalfEdge3D)edges2.get(nextIndex2);
                HalfEdge3D edge2 = (HalfEdge3D)edges2.get(edgeIndex);
                Assertions.assertTrue((edge2.getPrevious() == prevEdge2 ? 1 : 0) != 0);
                Assertions.assertTrue((edge2.getNext() == nextEdge2 ? 1 : 0) != 0);
                Assertions.assertTrue((edge2.getFace() == face2 ? 1 : 0) != 0);
                Assertions.assertTrue((prevEdge2.getDestination() == edge2.getOrigin() ? 1 : 0) != 0);
                Assertions.assertTrue((nextEdge2.getOrigin() == edge2.getDestination() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testAddVertexWithConvexVertices() {
        Random random = new Random(366L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D faceNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            List points = EuclidShapeRandomTools.nextCircleBasedConvexPolygon3D((Random)random, (double)5.0, (double)1.0, (int)6, (Vector3DReadOnly)faceNormal);
            Face3D face3D = new Face3D((Vector3DReadOnly)Axis3D.Z);
            for (int j = 0; j < points.size(); ++j) {
                Point3D point = (Point3D)points.get(j);
                face3D.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)point));
            }
            Assertions.assertEquals((int)points.size(), (int)face3D.getNumberOfEdges(), (String)("Iteration: " + i));
        }
    }

    @Test
    public void testNormalConsistencyWithEdgeOrdering() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D expectedNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Face3D face3D = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15, (Vector3DReadOnly)expectedNormal);
            Assertions.assertTrue((face3D.getNumberOfEdges() >= 3 ? 1 : 0) != 0);
            Vector3D actualNormal = face3D.getNormal();
            String errorMessage = "Iteration: " + i + ", angle between the vectors: " + expectedNormal.angle((Vector3DReadOnly)actualNormal);
            Assertions.assertTrue((boolean)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)expectedNormal, (Vector3DReadOnly)actualNormal, (double)1.0E-5), (String)errorMessage);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)expectedNormal, (Vector3DReadOnly)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    public void testCanObserverSeeEdge() throws Exception {
        Face3D face3D;
        Vector3D faceNormal;
        int i;
        Random random = new Random(34534L);
        for (i = 0; i < 1000; ++i) {
            faceNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            face3D = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15, (Vector3DReadOnly)faceNormal);
            for (int edgeIndex = 0; edgeIndex < face3D.getNumberOfEdges(); ++edgeIndex) {
                Assertions.assertFalse((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)face3D.getCentroid(), edgeIndex));
            }
        }
        for (i = 0; i < 1000; ++i) {
            faceNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            face3D = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15, (Vector3DReadOnly)faceNormal);
            List vertices = face3D.getVertices();
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Collection)vertices);
            for (int edgeIndex = 0; edgeIndex < face3D.getNumberOfEdges(); ++edgeIndex) {
                Assertions.assertFalse((boolean)face3D.canObserverSeeEdge((Point3DReadOnly)pointInside, edgeIndex));
            }
        }
        for (i = 0; i < 1000; ++i) {
            int edgeIndex;
            faceNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Face3D face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15, (Vector3DReadOnly)faceNormal);
            HalfEdge3D edge = (HalfEdge3D)face.getEdge(edgeIndex = random.nextInt(face.getNumberOfEdges()));
            Assertions.assertTrue((edge == face.getEdges().get(edgeIndex) ? 1 : 0) != 0);
            Assertions.assertTrue((face.getNumberOfEdges() >= 3 ? 1 : 0) != 0);
            Point3D centroid = face.getCentroid();
            Vector3D towardOutside = new Vector3D();
            Vector3DBasics edgeDirection = edge.getDirection(true);
            towardOutside.sub((Tuple3DReadOnly)EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)centroid, (Point3DReadOnly)edge.getOrigin(), (Vector3DReadOnly)edgeDirection), (Tuple3DReadOnly)centroid);
            towardOutside.normalize();
            Assertions.assertEquals((double)0.0, (double)towardOutside.dot((Tuple3DReadOnly)faceNormal), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)towardOutside.dot((Tuple3DReadOnly)edgeDirection), (double)1.0E-12);
            Point3D pointInside = new Point3D((Tuple3DReadOnly)edge.midpoint());
            pointInside.scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointInside);
            pointInside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)faceNormal, (Tuple3DReadOnly)pointInside);
            pointInside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)pointInside);
            Assertions.assertFalse((boolean)face.canObserverSeeEdge((Point3DReadOnly)pointInside, edgeIndex), (String)("Iteration: " + i));
            Assertions.assertEquals((double)0.0, (double)towardOutside.dot((Tuple3DReadOnly)faceNormal), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)towardOutside.dot((Tuple3DReadOnly)edgeDirection), (double)1.0E-12);
            Point3D pointOutside = new Point3D((Tuple3DReadOnly)edge.midpoint());
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOutside);
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)faceNormal, (Tuple3DReadOnly)pointOutside);
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)pointOutside);
            Assertions.assertTrue((boolean)face.canObserverSeeEdge((Point3DReadOnly)pointOutside, edgeIndex), (String)("Iteration: " + i));
        }
    }

    @Test
    public void testDistance() throws Exception {
        Face3D face;
        int i;
        Random random = new Random(3453456L);
        for (i = 0; i < 1000; ++i) {
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15);
            Point3D pointOnFace = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Collection)face.getVertices());
            Assertions.assertEquals((double)0.0, (double)face.distance((Point3DReadOnly)pointOnFace), (double)1.0E-12);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point3D pointDirectlyAbove = new Point3D();
            pointDirectlyAbove.scaleAdd(expectedDistance, (Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)pointOnFace);
            Assertions.assertEquals((double)expectedDistance, (double)face.distance((Point3DReadOnly)pointDirectlyAbove), (double)1.0E-12);
            Point3D pointDirectlyBelow = new Point3D();
            pointDirectlyBelow.scaleAdd(-expectedDistance, (Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)pointOnFace);
            Assertions.assertEquals((double)expectedDistance, (double)face.distance((Point3DReadOnly)pointDirectlyBelow), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15);
            HalfEdge3D edge = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            Vector3D outsideDirection = new Vector3D();
            outsideDirection.cross((Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)edge.getDirection(false));
            outsideDirection.normalize();
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.interpolate((Tuple3DReadOnly)edge.getOrigin(), (Tuple3DReadOnly)edge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(expectedDistance, (Tuple3DReadOnly)outsideDirection, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance, (double)face.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15);
            HalfEdge3D prevEdge = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            HalfEdge3D nextEdge = (HalfEdge3D)prevEdge.getNext();
            Vertex3D closestVertex = (Vertex3D)prevEdge.getDestination();
            Vector3D prevOutsideDirection = new Vector3D();
            prevOutsideDirection.cross((Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)prevEdge.getDirection(false));
            prevOutsideDirection.normalize();
            Vector3D nextOutsideDirection = new Vector3D();
            nextOutsideDirection.cross((Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)nextEdge.getDirection(false));
            nextOutsideDirection.normalize();
            Vector3D outsideDirection = new Vector3D();
            outsideDirection.interpolate((Tuple3DReadOnly)prevOutsideDirection, (Tuple3DReadOnly)nextOutsideDirection, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            outsideDirection.normalize();
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(expectedDistance, (Tuple3DReadOnly)outsideDirection, (Tuple3DReadOnly)closestVertex);
            Assertions.assertEquals((double)expectedDistance, (double)face.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    public void testGetClosestEdgeTo() throws Exception {
        String errorMessage;
        int actualEdgeIndex;
        HalfEdge3D actualEdge;
        double distance;
        int expectedEdgeIndex;
        HalfEdge3D expectedEdge;
        HalfEdge3D edge;
        Point3D pointOutside;
        Face3D face;
        int i;
        Random random = new Random(43654L);
        for (i = 0; i < 1000; ++i) {
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)3);
            pointOutside = new Point3D();
            edge = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            Vector3D outsideDirection = new Vector3D();
            outsideDirection.cross((Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)edge.getDirection(false));
            outsideDirection.normalize();
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.interpolate((Tuple3DReadOnly)edge.getOrigin(), (Tuple3DReadOnly)edge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)outsideDirection, (Tuple3DReadOnly)pointOnEdge);
            expectedEdge = null;
            expectedEdgeIndex = -1;
            distance = Double.POSITIVE_INFINITY;
            for (int edgeIndex = 0; edgeIndex < face.getNumberOfEdges(); ++edgeIndex) {
                HalfEdge3D candidate = (HalfEdge3D)face.getEdge(edgeIndex);
                double candidateDistance = candidate.distance((Point3DReadOnly)pointOutside);
                if (!(candidateDistance < distance)) continue;
                expectedEdge = candidate;
                expectedEdgeIndex = edgeIndex;
                distance = candidateDistance;
            }
            actualEdge = (HalfEdge3D)face.getClosestEdge((Point3DReadOnly)pointOutside);
            actualEdgeIndex = face.getEdges().indexOf(actualEdge);
            errorMessage = "Iteration: " + i + ", distance from: expected: " + expectedEdge.distance((Point3DReadOnly)pointOutside) + ", actual: " + actualEdge.distance((Point3DReadOnly)pointOutside);
            Assertions.assertEquals((int)expectedEdgeIndex, (int)actualEdgeIndex, (String)errorMessage);
            Assertions.assertTrue((expectedEdge == actualEdge ? 1 : 0) != 0, (String)errorMessage);
        }
        for (i = 0; i < 1000; ++i) {
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15);
            pointOutside = new Point3D();
            edge = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
            Vector3D outsideDirection = new Vector3D();
            outsideDirection.cross((Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)edge.getDirection(false));
            outsideDirection.normalize();
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.interpolate((Tuple3DReadOnly)edge.getOrigin(), (Tuple3DReadOnly)edge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)outsideDirection, (Tuple3DReadOnly)pointOnEdge);
            expectedEdge = null;
            expectedEdgeIndex = -1;
            distance = Double.POSITIVE_INFINITY;
            for (int edgeIndex = 0; edgeIndex < face.getNumberOfEdges(); ++edgeIndex) {
                HalfEdge3D candidate = (HalfEdge3D)face.getEdge(edgeIndex);
                double candidateDistance = candidate.distance((Point3DReadOnly)pointOutside);
                if (!(candidateDistance < distance)) continue;
                expectedEdge = candidate;
                expectedEdgeIndex = edgeIndex;
                distance = candidateDistance;
            }
            actualEdge = (HalfEdge3D)face.getClosestEdge((Point3DReadOnly)pointOutside);
            actualEdgeIndex = face.getEdges().indexOf(actualEdge);
            errorMessage = "Iteration: " + i + ", distance from: expected: " + expectedEdge.distance((Point3DReadOnly)pointOutside) + ", actual: " + actualEdge.distance((Point3DReadOnly)pointOutside);
            Assertions.assertEquals((int)expectedEdgeIndex, (int)actualEdgeIndex, (String)errorMessage);
            Assertions.assertTrue((expectedEdge == actualEdge ? 1 : 0) != 0, (String)errorMessage);
        }
        for (i = 0; i < 1000; ++i) {
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15);
            int expectedEdgeIndex2 = random.nextInt(face.getNumberOfEdges());
            expectedEdge = (HalfEdge3D)face.getEdge(expectedEdgeIndex2);
            Vector3D outsideDirection = new Vector3D();
            outsideDirection.cross((Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)expectedEdge.getDirection(false));
            outsideDirection.normalize();
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.interpolate((Tuple3DReadOnly)expectedEdge.getOrigin(), (Tuple3DReadOnly)expectedEdge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point3D pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)outsideDirection, (Tuple3DReadOnly)pointOnEdge);
            actualEdge = (HalfEdge3D)face.getClosestEdge((Point3DReadOnly)pointOutside2);
            actualEdgeIndex = face.getEdges().indexOf(actualEdge);
            Assertions.assertEquals((int)expectedEdgeIndex2, (int)actualEdgeIndex, (String)("Iteration: " + i));
            Assertions.assertTrue((expectedEdge == actualEdge ? 1 : 0) != 0, (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15);
            Point3D point = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Collection)face.getVertices());
            expectedEdge = null;
            int expectedEdgeIndex3 = -1;
            double distance2 = Double.POSITIVE_INFINITY;
            for (int edgeIndex = 0; edgeIndex < face.getNumberOfEdges(); ++edgeIndex) {
                HalfEdge3D candidate = (HalfEdge3D)face.getEdge(edgeIndex);
                double candidateDistance = candidate.distance((Point3DReadOnly)point);
                if (!(candidateDistance < distance2)) continue;
                expectedEdge = candidate;
                expectedEdgeIndex3 = edgeIndex;
                distance2 = candidateDistance;
            }
            actualEdge = (HalfEdge3D)face.getClosestEdge((Point3DReadOnly)point);
            actualEdgeIndex = face.getEdges().indexOf(actualEdge);
            errorMessage = "Iteration: " + i + ", distance from: expected: " + expectedEdge.distance((Point3DReadOnly)point) + ", actual: " + actualEdge.distance((Point3DReadOnly)point);
            Assertions.assertEquals((int)expectedEdgeIndex3, (int)actualEdgeIndex, (String)errorMessage);
            Assertions.assertTrue((expectedEdge == actualEdge ? 1 : 0) != 0, (String)errorMessage);
        }
    }

    @Test
    public void testGetSupportingVertex() throws Exception {
        Vertex3DReadOnly actual;
        Vertex3DReadOnly expected;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            List vertices2D = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)5.0, (double)1.0, (int)15);
            Face3D face = new Face3D((Vector3DReadOnly)Axis3D.Z);
            vertices2D.forEach(vertex2D -> face.addVertex((AbstractVertex3D)new Vertex3D((Point3DReadOnly)new Point3D((Tuple2DReadOnly)vertex2D))));
            Vector3D supportVector = new Vector3D();
            supportVector.set((Tuple3DReadOnly)Axis3D.X);
            expected = (Vertex3DReadOnly)face.getVertices().stream().sorted((v1, v2) -> -Double.compare(v1.getX(), v2.getX())).findFirst().get();
            actual = face.getSupportingVertex((Vector3DReadOnly)supportVector);
            Assertions.assertEquals((Object)expected, (Object)actual, (String)("Iteration: " + i));
            supportVector.setAndNegate((Tuple3DReadOnly)Axis3D.X);
            expected = (Vertex3DReadOnly)face.getVertices().stream().sorted((v1, v2) -> Double.compare(v1.getX(), v2.getX())).findFirst().get();
            actual = face.getSupportingVertex((Vector3DReadOnly)supportVector);
            Assertions.assertEquals((Object)expected, (Object)actual, (String)("Iteration: " + i));
            supportVector.set((Tuple3DReadOnly)Axis3D.Y);
            expected = (Vertex3DReadOnly)face.getVertices().stream().sorted((v1, v2) -> -Double.compare(v1.getY(), v2.getY())).findFirst().get();
            actual = face.getSupportingVertex((Vector3DReadOnly)supportVector);
            Assertions.assertEquals((Object)expected, (Object)actual, (String)("Iteration: " + i));
            supportVector.setAndNegate((Tuple3DReadOnly)Axis3D.Y);
            expected = (Vertex3DReadOnly)face.getVertices().stream().sorted((v1, v2) -> Double.compare(v1.getY(), v2.getY())).findFirst().get();
            actual = face.getSupportingVertex((Vector3DReadOnly)supportVector);
            Assertions.assertEquals((Object)expected, (Object)actual, (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            Face3D face = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random, (double)5.0, (double)1.0, (int)15);
            Vector3D supportVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            LinePercentageComparator comparator = new LinePercentageComparator(new Line3D((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)supportVector));
            comparator.flipDirection();
            expected = (Vertex3DReadOnly)face.getVertices().stream().sorted(comparator::compare).findFirst().get();
            actual = face.getSupportingVertex((Vector3DReadOnly)supportVector);
            Assertions.assertEquals((Object)expected, (Object)actual, (String)("Iteration: " + i));
        }
    }

    @Test
    void testOrhtogonalProjection() throws Exception {
        Point3DBasics actualProjection;
        Point3D expectedProjection;
        HalfEdge3D edge;
        Face3D face3D;
        int i;
        Random random = new Random(34534L);
        for (i = 0; i < 1000; ++i) {
            face3D = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random);
            edge = (HalfEdge3D)face3D.getEdge(random.nextInt(face3D.getNumberOfEdges()));
            Point3D pointAbove = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face3D.getCentroid(), (Point3DReadOnly)edge.getOrigin(), (Point3DReadOnly)edge.getDestination());
            pointAbove.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)face3D.getNormal(), (Tuple3DReadOnly)pointAbove);
            expectedProjection = EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointAbove, (Point3DReadOnly)face3D.getCentroid(), (Vector3DReadOnly)face3D.getNormal());
            actualProjection = face3D.orthogonalProjectionCopy((Point3DReadOnly)pointAbove);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            face3D = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random);
            edge = (HalfEdge3D)face3D.getEdge(random.nextInt(face3D.getNumberOfEdges()));
            Point3D pointBelow = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face3D.getCentroid(), (Point3DReadOnly)edge.getOrigin(), (Point3DReadOnly)edge.getDestination());
            pointBelow.scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)face3D.getNormal(), (Tuple3DReadOnly)pointBelow);
            expectedProjection = EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointBelow, (Point3DReadOnly)face3D.getCentroid(), (Vector3DReadOnly)face3D.getNormal());
            actualProjection = face3D.orthogonalProjectionCopy((Point3DReadOnly)pointBelow);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            face3D = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random);
            edge = (HalfEdge3D)face3D.getEdge(random.nextInt(face3D.getNumberOfEdges()));
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.interpolate((Tuple3DReadOnly)edge.getOrigin(), (Tuple3DReadOnly)edge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Vector3D towardOutside = new Vector3D();
            towardOutside.cross((Tuple3DReadOnly)face3D.getNormal(), (Tuple3DReadOnly)edge.getDirection(true));
            towardOutside.normalize();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)face3D.getNormal(), (Tuple3DReadOnly)pointOutside);
            Point3D expectedProjection2 = EuclidGeometryTools.orthogonalProjectionOnLine3D((Point3DReadOnly)pointOutside, (Point3DReadOnly)edge.getOrigin(), (Vector3DReadOnly)edge.getDirection(true));
            Point3DBasics actualProjection2 = face3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection2, (EuclidGeometry)actualProjection2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            face3D = EuclidShapeRandomTools.nextCircleBasedFace3D((Random)random);
            edge = (HalfEdge3D)face3D.getEdge(random.nextInt(face3D.getNumberOfEdges()));
            HalfEdge3D next = (HalfEdge3D)edge.getNext();
            Vertex3D closestVertex = (Vertex3D)edge.getDestination();
            Vector3D edgeOut = new Vector3D();
            edgeOut.cross((Tuple3DReadOnly)face3D.getNormal(), (Tuple3DReadOnly)edge.getDirection(true));
            edgeOut.normalize();
            Vector3D nextOut = new Vector3D();
            nextOut.cross((Tuple3DReadOnly)face3D.getNormal(), (Tuple3DReadOnly)next.getDirection(true));
            nextOut.normalize();
            Vector3D towardOutside = new Vector3D();
            towardOutside.interpolate((Tuple3DReadOnly)edgeOut, (Tuple3DReadOnly)nextOut, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            towardOutside.normalize();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)nextOut, (Tuple3DReadOnly)closestVertex);
            pointOutside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)face3D.getNormal(), (Tuple3DReadOnly)pointOutside);
            Vertex3D expectedProjection3 = closestVertex;
            Point3DBasics actualProjection3 = face3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection3, (EuclidGeometry)actualProjection3, (double)1.0E-12);
        }
    }

    @Test
    void testFlipNormalBug() throws Exception {
        Vector3D initialGuessNormal = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
        Vertex3D v0 = new Vertex3D(-3.312, -1.978, -4.144);
        Vertex3D v1 = new Vertex3D(-1.407, -0.586, 5.206);
        Vertex3D v2 = new Vertex3D(-2.234, -2.474, -0.586);
        Face3D face = new Face3D((Vector3DReadOnly)initialGuessNormal, 1.0E-10);
        face.addVertex((AbstractVertex3D)v0);
        face.addVertex((AbstractVertex3D)v1);
        face.addVertex((AbstractVertex3D)v2);
        Assertions.assertTrue((v0 == face.getVertex(0) ? 1 : 0) != 0);
        Assertions.assertTrue((v1 == face.getVertex(1) ? 1 : 0) != 0);
        Assertions.assertTrue((v2 == face.getVertex(2) ? 1 : 0) != 0);
        Assertions.assertTrue((v0 == ((HalfEdge3D)face.getEdge(0)).getOrigin() ? 1 : 0) != 0);
        Assertions.assertTrue((v1 == ((HalfEdge3D)face.getEdge(0)).getDestination() ? 1 : 0) != 0);
        Assertions.assertTrue((v1 == ((HalfEdge3D)face.getEdge(1)).getOrigin() ? 1 : 0) != 0);
        Assertions.assertTrue((v2 == ((HalfEdge3D)face.getEdge(1)).getDestination() ? 1 : 0) != 0);
        Assertions.assertTrue((v2 == ((HalfEdge3D)face.getEdge(2)).getOrigin() ? 1 : 0) != 0);
        Assertions.assertTrue((v0 == ((HalfEdge3D)face.getEdge(2)).getDestination() ? 1 : 0) != 0);
        Vector3D faceNormalBeforeFlip = new Vector3D((Tuple3DReadOnly)face.getNormal());
        face.flip();
        Assertions.assertTrue((v0 == face.getVertex(0) ? 1 : 0) != 0);
        Assertions.assertTrue((v2 == face.getVertex(1) ? 1 : 0) != 0);
        Assertions.assertTrue((v1 == face.getVertex(2) ? 1 : 0) != 0);
        Assertions.assertTrue((v0 == ((HalfEdge3D)face.getEdge(0)).getOrigin() ? 1 : 0) != 0);
        Assertions.assertTrue((v2 == ((HalfEdge3D)face.getEdge(0)).getDestination() ? 1 : 0) != 0);
        Assertions.assertTrue((v2 == ((HalfEdge3D)face.getEdge(1)).getOrigin() ? 1 : 0) != 0);
        Assertions.assertTrue((v1 == ((HalfEdge3D)face.getEdge(1)).getDestination() ? 1 : 0) != 0);
        Assertions.assertTrue((v1 == ((HalfEdge3D)face.getEdge(2)).getOrigin() ? 1 : 0) != 0);
        Assertions.assertTrue((v0 == ((HalfEdge3D)face.getEdge(2)).getDestination() ? 1 : 0) != 0);
        Assertions.assertEquals((double)-1.0, (double)faceNormalBeforeFlip.dot((Tuple3DReadOnly)face.getNormal()));
        face.updateNormal();
        Assertions.assertEquals((double)-1.0, (double)faceNormalBeforeFlip.dot((Tuple3DReadOnly)face.getNormal()));
    }

    private static class LinePercentageComparator
    implements Comparator<Point3DReadOnly> {
        private final Line3D line;

        public LinePercentageComparator(Line3D line) {
            this.line = line;
        }

        public void flipDirection() {
            this.line.getDirection().negate();
        }

        @Override
        public int compare(Point3DReadOnly o1, Point3DReadOnly o2) {
            double p1 = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)o1, (Point3DReadOnly)this.line.getPoint(), (Vector3DReadOnly)this.line.getDirection());
            double p2 = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)o2, (Point3DReadOnly)this.line.getPoint(), (Vector3DReadOnly)this.line.getDirection());
            return Double.compare(p1, p2);
        }
    }
}

