/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.UnitVector2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public class EuclidGeometryPolygonToolsTest {
    private static final double SMALL_EPSILON = 1.0E-9;
    private static final double SMALLEST_EPSILON = 1.0E-12;

    @Test
    public void testIssue17() throws Exception {
        int actualHullSize;
        ArrayList<Point2D> points;
        Point2D pointB;
        Point2D pointA;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            pointB = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            points = new ArrayList<Point2D>();
            points.add(pointA);
            points.add(pointA);
            points.add(pointB);
            points.add(pointB);
            Assertions.assertFalse((boolean)pointA.epsilonEquals((EuclidGeometry)pointB, 1.0E-7));
            actualHullSize = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(points, (int)4);
            Assertions.assertEquals((int)2, (int)actualHullSize);
            if (((Point2D)points.get(0)).equals((EuclidGeometry)pointA)) {
                Assertions.assertEquals(points.get(1), (Object)pointB);
            } else {
                Assertions.assertEquals(points.get(0), (Object)pointB);
                Assertions.assertEquals(points.get(1), (Object)pointA);
            }
            actualHullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D(points, (int)4);
            Assertions.assertEquals((int)2, (int)actualHullSize);
            if (((Point2D)points.get(0)).equals((EuclidGeometry)pointA)) {
                Assertions.assertEquals(points.get(1), (Object)pointB);
                continue;
            }
            Assertions.assertEquals(points.get(0), (Object)pointB);
            Assertions.assertEquals(points.get(1), (Object)pointA);
        }
        for (i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            pointB = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            points = new ArrayList();
            points.add(pointA);
            points.add(pointB);
            points.add(pointA);
            points.add(pointB);
            Assertions.assertFalse((boolean)pointA.epsilonEquals((EuclidGeometry)pointB, 1.0E-7));
            actualHullSize = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(points, (int)4);
            Assertions.assertEquals((int)2, (int)actualHullSize);
            if (((Point2D)points.get(0)).equals((EuclidGeometry)pointA)) {
                Assertions.assertEquals(points.get(1), (Object)pointB);
            } else {
                Assertions.assertEquals(points.get(0), (Object)pointB);
                Assertions.assertEquals(points.get(1), (Object)pointA);
            }
            actualHullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D(points, (int)4);
            Assertions.assertEquals((int)2, (int)actualHullSize);
            if (((Point2D)points.get(0)).equals((EuclidGeometry)pointA)) {
                Assertions.assertEquals(points.get(1), (Object)pointB);
                continue;
            }
            Assertions.assertEquals(points.get(0), (Object)pointB);
            Assertions.assertEquals(points.get(1), (Object)pointA);
        }
    }

    @Test
    public void testIsPolygon2DConvexAtVertex() throws Exception {
        Random random = new Random(345345L);
        int n = 4;
        ArrayList<Point2D> clockwiseSquareVertices = new ArrayList<Point2D>();
        clockwiseSquareVertices.add(new Point2D(0.0, 1.0));
        clockwiseSquareVertices.add(new Point2D(1.0, 1.0));
        clockwiseSquareVertices.add(new Point2D(1.0, 0.0));
        clockwiseSquareVertices.add(new Point2D(0.0, 0.0));
        ArrayList counterClockwiseSquareVertices = new ArrayList(clockwiseSquareVertices);
        Collections.reverse(counterClockwiseSquareVertices);
        for (int index = 0; index < n; ++index) {
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, clockwiseSquareVertices, (boolean)true));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, clockwiseSquareVertices, (boolean)false));
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, counterClockwiseSquareVertices, (boolean)false));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, counterClockwiseSquareVertices, (boolean)true));
        }
        for (int i = 0; i < 1000; ++i) {
            int numberOfPoints = random.nextInt(97) + 3;
            List points = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)1.0, (int)numberOfPoints);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(points);
            }
            for (int index = 0; index < numberOfPoints; ++index) {
                Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, (List)points, (boolean)clockwiseOrdered), (String)("Iteration: " + i + ", index: " + index));
                Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, (List)points, (!clockwiseOrdered ? 1 : 0) != 0), (String)("Iteration: " + i + ", index: " + index));
            }
            int numberOfExtraPoints = random.nextInt(20);
            for (int j = 0; j < numberOfExtraPoints; ++j) {
                points.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
            }
            for (int index = 0; index < numberOfPoints; ++index) {
                Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, (List)points, (int)numberOfPoints, (boolean)clockwiseOrdered), (String)("Iteration: " + i + ", index: " + index));
                Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, (List)points, (int)numberOfPoints, (!clockwiseOrdered ? 1 : 0) != 0), (String)("Iteration: " + i + ", index: " + index));
            }
            try {
                EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)-1, (List)points, (boolean)clockwiseOrdered);
                Assertions.fail((String)("Should have thrown an " + IndexOutOfBoundsException.class.getSimpleName()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)points.size(), (List)points, (boolean)clockwiseOrdered);
                Assertions.fail((String)("Should have thrown an " + IndexOutOfBoundsException.class.getSimpleName()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)0, (List)points, (int)-1, (boolean)clockwiseOrdered);
                Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)0, (List)points, (int)(points.size() + 1), (boolean)clockwiseOrdered);
                Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)0, Collections.singletonList(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0)), (boolean)true));
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)0, Collections.singletonList(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0)), (boolean)false));
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
        points.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)0, points, (boolean)true));
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)1, points, (boolean)true));
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)0, points, (boolean)false));
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)1, points, (boolean)false));
    }

    @Test
    public void testInPlaceGiftWrapConvexHull2D() throws Exception {
        Random random = new Random(3245345L);
        EuclidGeometryPolygonToolsTest.testConvexHullAlgorithm(random, (vertices, numberOfVertices) -> EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D((List)vertices, (int)numberOfVertices));
        for (int i = 0; i < 1000; ++i) {
            int numberOfVertices2 = 100;
            List points = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfVertices2);
            ArrayList pointsCopy = new ArrayList(points);
            int actualHullSize = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D((List)points);
            int expectedHullSize = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(pointsCopy, (int)numberOfVertices2);
            Assertions.assertEquals((int)expectedHullSize, (int)actualHullSize);
            Assertions.assertEquals((Object)points, pointsCopy);
        }
    }

    @Test
    public void testInPlaceGrahamScanConvexHull2D() throws Exception {
        Random random = new Random(5641651419L);
        EuclidGeometryPolygonToolsTest.testConvexHullAlgorithm(random, (vertices, numberOfVertices) -> EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)vertices, (int)numberOfVertices));
        for (int i = 0; i < 1000; ++i) {
            int numberOfVertices2 = 100;
            List points = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfVertices2);
            ArrayList pointsCopy = new ArrayList(points);
            int actualHullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)points);
            int expectedHullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D(pointsCopy, (int)numberOfVertices2);
            Assertions.assertEquals((int)expectedHullSize, (int)actualHullSize);
            Assertions.assertEquals((Object)points, pointsCopy);
        }
    }

    @Test
    public void testCompareConvexHullAlgorithms() throws Exception {
        Random random = new Random(23454L);
        ArrayList<ConvexHullAlgorithm> algorithmsToTest = new ArrayList<ConvexHullAlgorithm>();
        algorithmsToTest.add((vertices, numberOfVertices) -> EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D((List)vertices, (int)numberOfVertices));
        algorithmsToTest.add((vertices, numberOfVertices) -> EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)vertices, (int)numberOfVertices));
        for (int i = 0; i < 1000; ++i) {
            int numberOfVertices2 = 100;
            List points = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfVertices2);
            ArrayList pointsForEachAlgo = new ArrayList();
            while (pointsForEachAlgo.size() < algorithmsToTest.size()) {
                pointsForEachAlgo.add(new ArrayList(points));
            }
            ArrayList<Integer> hullSizes = new ArrayList<Integer>();
            for (int index = 0; index < algorithmsToTest.size(); ++index) {
                hullSizes.add(((ConvexHullAlgorithm)algorithmsToTest.get(index)).process((List)pointsForEachAlgo.get(index), numberOfVertices2));
            }
            for (int algoIndex = 1; algoIndex < algorithmsToTest.size(); ++algoIndex) {
                Assertions.assertEquals((Integer)((Integer)hullSizes.get(0)), (Integer)((Integer)hullSizes.get(algoIndex)));
                for (int vertexIndex = 0; vertexIndex < (Integer)hullSizes.get(0); ++vertexIndex) {
                    Assertions.assertTrue((((List)pointsForEachAlgo.get(0)).get(vertexIndex) == ((List)pointsForEachAlgo.get(algoIndex)).get(vertexIndex) ? 1 : 0) != 0);
                }
            }
        }
    }

    private static void testConvexHullAlgorithm(Random random, ConvexHullAlgorithm algorithmToTest) throws Exception {
        int i;
        int numberOfPoints = 100;
        List points = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfPoints);
        try {
            algorithmToTest.process(points, -1);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            algorithmToTest.process(points, numberOfPoints + 1);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            int numberOfPoints2 = 100;
            int numberOfPointsToProcess = random.nextInt(numberOfPoints2 - 1) + 1;
            ArrayList listToProcess = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfPoints2);
            ArrayList original = new ArrayList(listToProcess);
            int hullSize = algorithmToTest.process(listToProcess, numberOfPointsToProcess);
            Assertions.assertEquals((int)numberOfPoints2, (int)listToProcess.size());
            Assertions.assertTrue((hullSize <= numberOfPointsToProcess ? 1 : 0) != 0);
            for (int index = numberOfPointsToProcess; index < numberOfPoints2; ++index) {
                Assertions.assertTrue((original.get(index) == listToProcess.get(index) ? 1 : 0) != 0);
            }
            ArrayList reprocessedList = new ArrayList(listToProcess);
            int reprocessedHullSize = algorithmToTest.process(reprocessedList, numberOfPointsToProcess);
            Assertions.assertEquals((int)hullSize, (int)reprocessedHullSize);
            for (int index = 0; index < numberOfPoints2; ++index) {
                Assertions.assertTrue((listToProcess.get(index) == reprocessedList.get(index) ? 1 : 0) != 0);
            }
            numberOfPointsToProcess = 1;
            listToProcess = new ArrayList(original);
            hullSize = algorithmToTest.process(listToProcess, numberOfPointsToProcess);
            Assertions.assertEquals((int)numberOfPointsToProcess, (int)hullSize);
            Assertions.assertTrue((original.get(0) == listToProcess.get(0) ? 1 : 0) != 0);
            numberOfPointsToProcess = 2;
            listToProcess = new ArrayList(original);
            hullSize = algorithmToTest.process(listToProcess, numberOfPointsToProcess);
            Assertions.assertEquals((int)numberOfPointsToProcess, (int)hullSize);
            if (EuclidGeometryPolygonTools.findMinXMaxYVertexIndex(original, (int)numberOfPointsToProcess) == 0) {
                Assertions.assertTrue((original.get(0) == listToProcess.get(0) ? 1 : 0) != 0);
                Assertions.assertTrue((original.get(1) == listToProcess.get(1) ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertTrue((original.get(1) == listToProcess.get(0) ? 1 : 0) != 0);
            Assertions.assertTrue((original.get(0) == listToProcess.get(1) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D original = EuclidCoreRandomTools.nextPoint2D((Random)random);
            ArrayList<Point2D> listToProcess = new ArrayList<Point2D>();
            for (int j = 0; j < random.nextInt(20); ++j) {
                listToProcess.add(new Point2D((Tuple2DReadOnly)original));
            }
            int hullSize = algorithmToTest.process(listToProcess, listToProcess.size());
            if (listToProcess.isEmpty()) {
                Assertions.assertEquals((int)0, (int)hullSize, (String)("Failed at iteration: " + i));
                continue;
            }
            Assertions.assertEquals((int)1, (int)hullSize, (String)("Failed at iteration: " + i));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)((EuclidGeometry)listToProcess.get(0)), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            int numberOfPoints3 = 100;
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)1.0, (int)numberOfPoints3);
            int startIndex = EuclidGeometryPolygonTools.findMinXMaxYVertexIndex((List)vertices, (int)numberOfPoints3);
            ArrayList convexHullVertices = new ArrayList();
            for (int index = 0; index < numberOfPoints3; ++index) {
                convexHullVertices.add(vertices.get(EuclidCoreTools.wrap((int)(index + startIndex), (int)numberOfPoints3)));
            }
            ArrayList copy = new ArrayList(convexHullVertices);
            algorithmToTest.process(copy, copy.size());
            for (int index = 0; index < copy.size(); ++index) {
                if (copy.get(index) == convexHullVertices.get(index)) continue;
                Assertions.fail((String)("Failed at iteration: " + i + ", vertices at index " + index + " are different, expected:\n" + convexHullVertices + "\nactual:\n" + copy));
            }
        }
        for (i = 0; i < 1000; ++i) {
            int numberOfPoints4 = 100;
            List points2 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfPoints4);
            int hullSize = algorithmToTest.process(points2, numberOfPoints4);
            for (int index = 0; index < hullSize; ++index) {
                Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPolygon2DConvexAtVertex((int)index, (List)points2, (int)hullSize, (boolean)true), (String)("Is not convex at vertex index: " + index));
            }
        }
        for (i = 0; i < 1000; ++i) {
            int numberOfPoints5 = 100;
            List processedList = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfPoints5);
            int hullSize = algorithmToTest.process(processedList, numberOfPoints5);
            ArrayList sortedList = new ArrayList(processedList);
            EuclidGeometryPolygonTools.grahamScanAngleSort(sortedList, (int)hullSize);
            for (int index = 0; index < hullSize; ++index) {
                Assertions.assertTrue((processedList.get(index) == sortedList.get(index) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            int numberOfPoints6 = 100;
            List processedList = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfPoints6);
            int hullSize = algorithmToTest.process(processedList, numberOfPoints6);
            double sumOfAngles = 0.0;
            for (int index = 0; index < hullSize; ++index) {
                Point2DReadOnly previousVertex = (Point2DReadOnly)processedList.get(EuclidCoreTools.previous((int)index, (int)hullSize));
                Point2DReadOnly vertex = (Point2DReadOnly)processedList.get(index);
                Point2DReadOnly nextVertex = (Point2DReadOnly)processedList.get(EuclidCoreTools.next((int)index, (int)hullSize));
                Vector2D previousEdge = new Vector2D();
                previousEdge.sub((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)previousVertex);
                Vector2D nextEdge = new Vector2D();
                nextEdge.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
                sumOfAngles -= previousEdge.angle((Vector2DReadOnly)nextEdge);
            }
            Assertions.assertEquals((double)(Math.PI * 2), (double)sumOfAngles, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            int numberOfPoints7 = 100;
            List processedList = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfPoints7);
            for (int numberOfDuplicates = random.nextInt(50); numberOfDuplicates > 0; --numberOfDuplicates) {
                int indexToDuplicate = random.nextInt(processedList.size());
                processedList.add(new Point2D((Tuple2DReadOnly)processedList.get(indexToDuplicate)));
            }
            Collections.shuffle(processedList);
            int hullSize = algorithmToTest.process(processedList, numberOfPoints7);
            for (int firstIndex = 0; firstIndex < hullSize; ++firstIndex) {
                Point2DReadOnly first = (Point2DReadOnly)processedList.get(firstIndex);
                for (int secondIndex = firstIndex + 1; secondIndex < hullSize; ++secondIndex) {
                    Point2DReadOnly second = (Point2DReadOnly)processedList.get(secondIndex);
                    Assertions.assertFalse((boolean)first.epsilonEquals((EuclidGeometry)second, 1.0E-7), (String)EuclidGeometryPolygonToolsTest.duplicateMessage(processedList, hullSize, firstIndex, secondIndex));
                }
            }
        }
    }

    private static String duplicateMessage(List<Point2D> processedList, int hullSize, int firstIndex, int secondIndex) {
        return "Found duplicate vertices (" + firstIndex + " and " + secondIndex + ") \n" + processedList.subList(0, hullSize);
    }

    @Test
    public void testGrahamScanAngleSort() throws Exception {
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            int index;
            int numberOfPoints = 10;
            List points = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)numberOfPoints);
            ArrayList pointsCopy = new ArrayList(points);
            int minXMaxYIndex = EuclidGeometryPolygonTools.findMinXMaxYVertexIndex((List)points, (int)points.size());
            Point2D minXMaxYVertex = (Point2D)points.get(minXMaxYIndex);
            Comparator comparator = (vertex1, vertex2) -> EuclidGeometryPolygonTools.grahamScanAngleCompare((Point2DReadOnly)minXMaxYVertex, (Point2DReadOnly)vertex1, (Point2DReadOnly)vertex2);
            Collections.sort(points, comparator);
            Assertions.assertTrue((minXMaxYVertex == points.get(0) ? 1 : 0) != 0);
            Point2D offset = new Point2D((Tuple2DReadOnly)minXMaxYVertex);
            points.forEach(v -> v.sub((Tuple2DReadOnly)offset));
            ArrayList angles = new ArrayList();
            points.forEach(v -> angles.add(EuclidCoreTools.atan2((double)v.getX(), (double)v.getY())));
            for (index = 1; index < numberOfPoints - 1; ++index) {
                Assertions.assertTrue(((Double)angles.get(index) < (Double)angles.get(index + 1) ? 1 : 0) != 0);
            }
            EuclidGeometryPolygonTools.grahamScanAngleSort(pointsCopy, (int)numberOfPoints);
            for (index = 0; index < numberOfPoints; ++index) {
                Assertions.assertTrue((points.get(index) == pointsCopy.get(index) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testComputeConvexPolygon2DArea() throws Exception {
        Random random = new Random(345345L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            Point2D average = new Point2D();
            convexPolygon2D.subList(0, hullSize).forEach(arg_0 -> ((Point2D)average).add(arg_0));
            average.scale(1.0 / (double)hullSize);
            double expectedArea = 0.0;
            for (int index = 0; index < hullSize; ++index) {
                Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(index);
                Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)index, (int)hullSize));
                expectedArea += EuclidGeometryTools.triangleArea((Point2DReadOnly)average, (Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex);
            }
            Point2D centroid = EuclidCoreRandomTools.nextPoint2D((Random)random);
            double actualArea = EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
            Point2D recomputedCentroid = new Point2D();
            for (int index = 0; index < hullSize; ++index) {
                Point2DReadOnly previousVertex = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.previous((int)index, (int)hullSize));
                Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(index);
                Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)index, (int)hullSize));
                double vertexWeight = 0.0;
                vertexWeight += EuclidGeometryTools.triangleArea((Point2DReadOnly)centroid, (Point2DReadOnly)vertex, (Point2DReadOnly)previousVertex);
                vertexWeight += EuclidGeometryTools.triangleArea((Point2DReadOnly)centroid, (Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex);
                recomputedCentroid.add((vertexWeight /= 2.0 * actualArea) * vertex.getX(), vertexWeight * vertex.getY());
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)recomputedCentroid, (EuclidGeometry)centroid, (double)1.0E-12);
            try {
                EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)-1, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
                Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)(convexPolygon2D.size() + 1), (boolean)clockwiseOrdered, (Point2DBasics)centroid);
                Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Point2D centroid = EuclidCoreRandomTools.nextPoint2D((Random)random);
        double area = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(Collections.emptyList(), (int)0, (boolean)true, (Point2DBasics)centroid);
        Assertions.assertTrue((boolean)Double.isNaN(area));
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)centroid);
        Point2D vertex = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Point2D centroid2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
        double area2 = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(Collections.singletonList(vertex), (int)1, (boolean)true, (Point2DBasics)centroid2);
        Assertions.assertTrue((area2 == 0.0 ? 1 : 0) != 0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)centroid2, (double)1.0E-12);
        Point2D vertex0 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Point2D vertex1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(vertex0);
        points.add(vertex1);
        Point2D expectedCentroid = EuclidGeometryTools.averagePoint2Ds(points);
        Point2D actualCentroid = EuclidCoreRandomTools.nextPoint2D((Random)random);
        double area3 = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(points, (int)2, (boolean)true, (Point2DBasics)actualCentroid);
        Assertions.assertTrue((area3 == 0.0 ? 1 : 0) != 0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCentroid, (EuclidGeometry)actualCentroid, (double)1.0E-12);
        vertex0 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Vector2D toVertex1 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0E-8);
        Vector2D toVertex2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0E-8);
        Point2D vertex12 = new Point2D();
        vertex12.add((Tuple2DReadOnly)vertex0, (Tuple2DReadOnly)toVertex1);
        Point2D vertex2 = new Point2D();
        vertex2.add((Tuple2DReadOnly)vertex0, (Tuple2DReadOnly)toVertex2);
        ArrayList<Point2D> points2 = new ArrayList<Point2D>();
        points2.add(vertex0);
        points2.add(vertex12);
        points2.add(vertex2);
        Point2D centroid3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
        EuclidGeometryPolygonTools.computeConvexPolygon2DArea(points2, (int)3, (boolean)true, (Point2DBasics)centroid3);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex0, (EuclidGeometry)centroid3, (double)1.0E-12);
    }

    @Test
    public void testEdgeNormal() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            for (int edgeIndex = 0; edgeIndex < hullSize; ++edgeIndex) {
                Point2DReadOnly edgeStart = (Point2DReadOnly)convexPolygon2D.get(edgeIndex);
                Point2DReadOnly edgeEnd = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize));
                Vector2D edgeNormal = new Vector2D();
                boolean success = EuclidGeometryPolygonTools.edgeNormal((int)edgeIndex, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Vector2DBasics)edgeNormal);
                Assertions.assertTrue((boolean)success);
                Assertions.assertEquals((double)1.0, (double)edgeNormal.norm(), (double)1.0E-12);
                Vector2D edgeDirection = new Vector2D();
                edgeDirection.sub((Tuple2DReadOnly)edgeEnd, (Tuple2DReadOnly)edgeStart);
                Assertions.assertEquals((double)0.0, (double)edgeDirection.dot((Tuple2DReadOnly)edgeNormal), (double)1.0E-12);
                Point2D pointInsidePolygon = new Point2D();
                pointInsidePolygon.scaleAdd(-1.0E-8, (Tuple2DReadOnly)edgeNormal, (Tuple2DReadOnly)edgeStart);
                Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)pointInsidePolygon, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (double)0.0), (String)("Iteration: " + i + ", edgeIndex: " + edgeIndex));
                Point2D pointOutsidePolygon = new Point2D();
                pointOutsidePolygon.scaleAdd(1.0E8, (Tuple2DReadOnly)edgeNormal, (Tuple2DReadOnly)edgeStart);
                Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)pointOutsidePolygon, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (double)0.0));
            }
        }
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.edgeNormal((int)0, Collections.singletonList(EuclidCoreRandomTools.nextPoint2D((Random)random)), (int)1, (boolean)true, (Vector2DBasics)new Vector2D()));
        List convexPolygon2D = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
        boolean clockwiseOrdered = random.nextBoolean();
        if (!clockwiseOrdered) {
            Collections.reverse(convexPolygon2D.subList(0, hullSize));
        }
        try {
            EuclidGeometryPolygonTools.edgeNormal((int)0, (List)convexPolygon2D, (int)-1, (boolean)clockwiseOrdered, (Vector2DBasics)new Vector2D());
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.edgeNormal((int)0, (List)convexPolygon2D, (int)(convexPolygon2D.size() + 1), (boolean)clockwiseOrdered, (Vector2DBasics)new Vector2D());
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.edgeNormal((int)-1, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Vector2DBasics)new Vector2D());
            Assertions.fail((String)("Should have thrown an " + IndexOutOfBoundsException.class.getSimpleName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.edgeNormal((int)hullSize, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Vector2DBasics)new Vector2D());
            Assertions.fail((String)("Should have thrown an " + IndexOutOfBoundsException.class.getSimpleName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIsPoint2DInsideConvexPolygon2D() throws Exception {
        Point2D outsidePoint;
        Point2D pointOnEdge;
        Point2DReadOnly vertex;
        boolean clockwiseOrdered;
        int i;
        ArrayList<Point2D> convexPolygon2D = new ArrayList<Point2D>();
        convexPolygon2D.add(new Point2D(1.0, 1.0));
        int hullSize = 1;
        Point2D query = new Point2D();
        query.set(1.0, 1.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)1.0E-10));
        query.set(0.8, 0.9);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        query.set(0.8, 1.1);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.3));
        query.set(1.0, 0.9);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        query.set(2.0, 1.0);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)1.0));
        query.set(1.0, 2.0);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)1.0));
        convexPolygon2D = new ArrayList();
        convexPolygon2D.add(new Point2D(0.0, 0.0));
        convexPolygon2D.add(new Point2D(1.0, 0.0));
        hullSize = 2;
        query = new Point2D();
        double epsilon = 1.0E-10;
        query.set(0.1, 0.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        query.set(0.1, 0.1);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(1.5, 0.0);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(1.0, 0.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        query.set(1.0, epsilon * 0.1);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        query.set(1.0, epsilon * 0.1);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(1.5, 0.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.5));
        convexPolygon2D = new ArrayList();
        convexPolygon2D.add(new Point2D(0.0, 0.0));
        convexPolygon2D.add(new Point2D(3.0, 5.0));
        convexPolygon2D.add(new Point2D(5.0, 0.0));
        hullSize = 3;
        query = new Point2D();
        epsilon = 1.0E-10;
        query.set(0.3, 0.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(0.0, 0.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(2.0, 2.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        query.set(1.0, 0.3);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(-1.0, 4.0);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(6.0, 7.0);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(10.0, 0.0);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(0.1, 0.2);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        query.set(3.5, 4.9);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)epsilon));
        query.set(3.5, -1.0);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        convexPolygon2D = new ArrayList();
        convexPolygon2D.add(new Point2D(-0.06, -0.08));
        convexPolygon2D.add(new Point2D(0.14, -0.08));
        convexPolygon2D.add(new Point2D(0.14, -0.19));
        convexPolygon2D.add(new Point2D(-0.06, -0.19));
        hullSize = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(convexPolygon2D);
        query = new Point2D();
        query.set(0.03, 0.0);
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.02));
        query.set(0.03, -0.09);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true, (double)0.0));
        Random random = new Random(324534L);
        for (i = 0; i < 1000; ++i) {
            List convexPolygon2D2 = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize2 = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D((List)convexPolygon2D2);
            boolean clockwiseOrdered2 = random.nextBoolean();
            if (!clockwiseOrdered2) {
                Collections.reverse(convexPolygon2D2.subList(0, hullSize2));
            }
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2, (Point2DBasics)centroid);
            int vertexIndex = random.nextInt(hullSize2);
            int nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize2);
            Point2DReadOnly vertex2 = (Point2DReadOnly)convexPolygon2D2.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D2.get(nextVertexIndex);
            Point2D pointOnEdge2 = new Point2D();
            pointOnEdge2.interpolate((Tuple2DReadOnly)vertex2, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            double alphaOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0);
            Point2D outsidePoint2 = new Point2D();
            outsidePoint2.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge2, alphaOutside);
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)outsidePoint2, (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)outsidePoint2, (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2, (double)0.0));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)outsidePoint2.getX(), (double)outsidePoint2.getY(), (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)outsidePoint2.getX(), (double)outsidePoint2.getY(), (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2, (double)0.0));
            double alphaInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point2D insidePoint = new Point2D();
            insidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge2, alphaInside);
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)insidePoint, (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2));
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)insidePoint, (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2, (double)0.0));
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)insidePoint.getX(), (double)insidePoint.getY(), (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2));
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)insidePoint.getX(), (double)insidePoint.getY(), (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2, (double)0.0));
        }
        for (i = 0; i < 1000; ++i) {
            double epsilon2 = random.nextDouble();
            List convexPolygon2D3 = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize3 = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D((List)convexPolygon2D3);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D3.subList(0, hullSize3));
            }
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D3, (int)hullSize3, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            int vertexIndex = random.nextInt(hullSize3);
            int nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize3);
            vertex = (Point2DReadOnly)convexPolygon2D3.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D3.get(nextVertexIndex);
            pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            double distanceOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)epsilon2);
            outsidePoint = new Point2D();
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
            orthogonal.normalize();
            orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)orthogonal);
            if (!clockwiseOrdered) {
                orthogonal.negate();
            }
            outsidePoint.scaleAdd(distanceOutside, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOnEdge);
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)outsidePoint, (List)convexPolygon2D3, (int)hullSize3, (boolean)clockwiseOrdered, (double)epsilon2));
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)outsidePoint.getX(), (double)outsidePoint.getY(), (List)convexPolygon2D3, (int)hullSize3, (boolean)clockwiseOrdered, (double)epsilon2));
            distanceOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon2, (double)(epsilon2 + 1.0));
            outsidePoint.scaleAdd(distanceOutside, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOnEdge);
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)outsidePoint, (List)convexPolygon2D3, (int)hullSize3, (boolean)clockwiseOrdered, (double)epsilon2));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)outsidePoint.getX(), (double)outsidePoint.getY(), (List)convexPolygon2D3, (int)hullSize3, (boolean)clockwiseOrdered, (double)epsilon2));
            double alphaInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point2D insidePoint = new Point2D();
            insidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, alphaInside);
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)insidePoint, (List)convexPolygon2D3, (int)hullSize3, (boolean)clockwiseOrdered, (double)0.0));
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)insidePoint.getX(), (double)insidePoint.getY(), (List)convexPolygon2D3, (int)hullSize3, (boolean)clockwiseOrdered, (double)0.0));
        }
        for (i = 0; i < 1000; ++i) {
            double epsilon3 = -0.02;
            List convexPolygon2D4 = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize4 = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D((List)convexPolygon2D4);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D4.subList(0, hullSize4));
            }
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D4, (int)hullSize4, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            int vertexIndex = random.nextInt(hullSize4);
            int nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize4);
            vertex = (Point2DReadOnly)convexPolygon2D4.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D4.get(nextVertexIndex);
            pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            double alphaOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0);
            outsidePoint = new Point2D();
            outsidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, alphaOutside);
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)outsidePoint, (List)convexPolygon2D4, (int)hullSize4, (boolean)clockwiseOrdered, (double)0.0));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)outsidePoint.getX(), (double)outsidePoint.getY(), (List)convexPolygon2D4, (int)hullSize4, (boolean)clockwiseOrdered, (double)0.0));
            double distanceInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon3, (double)0.0);
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
            orthogonal.normalize();
            orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)orthogonal);
            if (!clockwiseOrdered) {
                orthogonal.negate();
            }
            outsidePoint.scaleAdd(distanceInside, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOnEdge);
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)outsidePoint, (List)convexPolygon2D4, (int)hullSize4, (boolean)clockwiseOrdered, (double)epsilon3));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)outsidePoint.getX(), (double)outsidePoint.getY(), (List)convexPolygon2D4, (int)hullSize4, (boolean)clockwiseOrdered, (double)epsilon3));
            double distanceBetweenCentroidAndEdge = EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)centroid, (Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex);
            distanceInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-distanceBetweenCentroidAndEdge), (double)epsilon3);
            Point2D insidePoint = new Point2D();
            insidePoint.scaleAdd(distanceInside, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOnEdge);
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)insidePoint, (List)convexPolygon2D4, (int)hullSize4, (boolean)clockwiseOrdered, (double)0.0));
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((double)insidePoint.getX(), (double)insidePoint.getY(), (List)convexPolygon2D4, (int)hullSize4, (boolean)clockwiseOrdered, (double)0.0));
        }
        List convexPolygon2D5 = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize5 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D5);
        boolean clockwiseOrdered3 = random.nextBoolean();
        if (!clockwiseOrdered3) {
            Collections.reverse(convexPolygon2D5.subList(0, hullSize5));
        }
        try {
            EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)new Point2D(), (List)convexPolygon2D5, (int)-1, (boolean)clockwiseOrdered3, (double)0.0);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)new Point2D(), (List)convexPolygon2D5, (int)(convexPolygon2D5.size() + 1), (boolean)clockwiseOrdered3, (double)0.0);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSignedDistanceFromPoint2DToConvexPolygon2D() throws Exception {
        double actualDistance;
        double actualDistance2;
        double expectedDistance;
        double y;
        double x;
        ArrayList<Point2D> convexPolygon2D = new ArrayList<Point2D>();
        convexPolygon2D.add(new Point2D(0.0, 0.0));
        int hullSize = 1;
        Point2D query = new Point2D();
        query.set(2.5, 1.0);
        double distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)EuclidCoreTools.norm((double)2.5, (double)1.0), (double)distance, (double)1.0E-12);
        convexPolygon2D = new ArrayList();
        convexPolygon2D.add(new Point2D(0.0, 0.0));
        convexPolygon2D.add(new Point2D(1.0, 0.0));
        hullSize = 2;
        query = new Point2D();
        query.set(2.5, 1.0);
        distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)EuclidCoreTools.norm((double)1.5, (double)1.0), (double)distance, (double)1.0E-12);
        query.set(0.5, 1.0);
        distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)1.0, (double)distance, (double)1.0E-12);
        convexPolygon2D = new ArrayList();
        convexPolygon2D.add(new Point2D(0.0, 0.0));
        convexPolygon2D.add(new Point2D(10.0, 0.0));
        convexPolygon2D.add(new Point2D(0.0, 10.0));
        hullSize = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(convexPolygon2D);
        query = new Point2D();
        query.set(10.0, 10.0);
        distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)(5.0 * EuclidCoreTools.squareRoot((double)2.0)), (double)distance, (double)1.0E-12);
        query.set(1.2, 1.1);
        distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)-1.1, (double)distance, (double)1.0E-12);
        query.set(0.05, 9.8);
        distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)-0.05, (double)distance, (double)1.0E-12);
        query.set(9.8, 0.15);
        distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)(-0.5 * EuclidCoreTools.squareRoot((double)0.005000000000000001)), (double)distance, (double)1.0E-12);
        query.set(5.0, -0.15);
        distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)0.15, (double)distance, (double)1.0E-12);
        query.set(15.0, -0.15);
        distance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D, (int)hullSize, (boolean)true);
        Assertions.assertEquals((double)EuclidCoreTools.norm((double)5.0, (double)0.15), (double)distance, (double)1.0E-12);
        int n = 4;
        ArrayList<Point2D> clockwiseSquareVertices = new ArrayList<Point2D>();
        clockwiseSquareVertices.add(new Point2D(0.0, 1.0));
        clockwiseSquareVertices.add(new Point2D(1.0, 1.0));
        clockwiseSquareVertices.add(new Point2D(1.0, 0.0));
        clockwiseSquareVertices.add(new Point2D(0.0, 0.0));
        ArrayList counterClockwiseSquareVertices = new ArrayList(clockwiseSquareVertices);
        Collections.reverse(counterClockwiseSquareVertices);
        for (x = 0.0; x <= 1.0; x += 0.05) {
            y = 1.1;
            expectedDistance = 0.1;
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, clockwiseSquareVertices, (int)n, (boolean)true);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, counterClockwiseSquareVertices, (int)n, (boolean)false);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
        }
        for (x = 0.0; x <= 1.0; x += 0.05) {
            y = -0.1;
            expectedDistance = 0.1;
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, clockwiseSquareVertices, (int)n, (boolean)true);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, counterClockwiseSquareVertices, (int)n, (boolean)false);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
        }
        for (y = 0.0; y <= 1.0; y += 0.05) {
            x = 1.1;
            expectedDistance = 0.1;
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, clockwiseSquareVertices, (int)n, (boolean)true);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, counterClockwiseSquareVertices, (int)n, (boolean)false);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
        }
        for (y = 0.0; y <= 1.0; y += 0.05) {
            x = -0.1;
            expectedDistance = 0.1;
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, clockwiseSquareVertices, (int)n, (boolean)true);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, counterClockwiseSquareVertices, (int)n, (boolean)false);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
        }
        for (x = 0.1; x <= 0.9; x += 0.05) {
            y = 0.9;
            expectedDistance = -0.1;
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, clockwiseSquareVertices, (int)n, (boolean)true);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, counterClockwiseSquareVertices, (int)n, (boolean)false);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
        }
        for (x = 0.1; x <= 0.9; x += 0.05) {
            y = 0.1;
            expectedDistance = -0.1;
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, clockwiseSquareVertices, (int)n, (boolean)true);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
            actualDistance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)x, (double)y, counterClockwiseSquareVertices, (int)n, (boolean)false);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance2, (double)1.0E-12);
        }
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D2 = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize2 = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D((List)convexPolygon2D2);
            boolean clockwiseOrdered2 = random.nextBoolean();
            if (!clockwiseOrdered2) {
                Collections.reverse(convexPolygon2D2.subList(0, hullSize2));
            }
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2, (Point2DBasics)centroid);
            int vertexIndex = random.nextInt(hullSize2);
            int nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize2);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D2.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D2.get(nextVertexIndex);
            Point2D pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            double alphaOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0);
            Point2D outsidePoint = new Point2D();
            outsidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, alphaOutside);
            double expectedDistance2 = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)outsidePoint, (Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex);
            actualDistance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)outsidePoint, (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2);
            Assertions.assertEquals((double)expectedDistance2, (double)actualDistance, (double)1.0E-12, (String)("EdgeLength = " + vertex.distance(nextVertex)));
            double alphaInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point2D insidePoint = new Point2D();
            insidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, alphaInside);
            expectedDistance2 = Double.POSITIVE_INFINITY;
            for (int j = 0; j < hullSize2; ++j) {
                Point2DReadOnly edgeStart = (Point2DReadOnly)convexPolygon2D2.get(j);
                Point2DReadOnly edgeEnd = (Point2DReadOnly)convexPolygon2D2.get(EuclidCoreTools.next((int)j, (int)hullSize2));
                expectedDistance2 = Math.min(expectedDistance2, EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)insidePoint, (Point2DReadOnly)edgeStart, (Point2DReadOnly)edgeEnd));
            }
            expectedDistance2 = -expectedDistance2;
            actualDistance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)insidePoint, (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2);
            Assertions.assertEquals((double)expectedDistance2, (double)actualDistance, (double)1.0E-12, (String)("EdgeLength = " + vertex.distance(nextVertex)));
        }
        List convexPolygon2D3 = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize3 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D3);
        boolean clockwiseOrdered = random.nextBoolean();
        if (!clockwiseOrdered) {
            Collections.reverse(convexPolygon2D3.subList(0, hullSize3));
        }
        try {
            EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)new Point2D(), (List)convexPolygon2D3, (int)-1, (boolean)clockwiseOrdered);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException clockwiseOrdered2) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)new Point2D(), (List)convexPolygon2D3, (int)(convexPolygon2D3.size() + 1), (boolean)clockwiseOrdered);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException clockwiseOrdered2) {
            // empty catch block
        }
        double distance2 = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((double)0.0, (double)0.0, Collections.emptyList(), (int)0, (boolean)true);
        Assertions.assertTrue((boolean)Double.isNaN(distance2));
        Point2D query2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Point2D vertex = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        double expectedDistance3 = query2.distance((Point2DReadOnly)vertex);
        actualDistance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query2, Collections.singletonList(vertex), (int)1, (boolean)true);
        Assertions.assertEquals((double)expectedDistance3, (double)actualDistance, (double)1.0E-12);
        actualDistance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query2, Collections.singletonList(vertex), (int)1, (boolean)false);
        Assertions.assertEquals((double)expectedDistance3, (double)actualDistance, (double)1.0E-12);
        query2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Point2D vertex0 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Point2D vertex1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(vertex0);
        points.add(vertex1);
        expectedDistance3 = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)query2, (Point2DReadOnly)vertex0, (Point2DReadOnly)vertex1);
        actualDistance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query2, points, (int)2, (boolean)true);
        Assertions.assertEquals((double)expectedDistance3, (double)actualDistance, (double)1.0E-12);
        actualDistance = EuclidGeometryPolygonTools.signedDistanceFromPoint2DToConvexPolygon2D((Point2DReadOnly)query2, points, (int)2, (boolean)false);
        Assertions.assertEquals((double)expectedDistance3, (double)actualDistance, (double)1.0E-12);
    }

    @Test
    public void testIntersectionBetweenLine2DAndConvexPolygon2D() throws Exception {
        int vertexIndex;
        Point2D actualSecondIntersection;
        Point2D actualFirstIntersection;
        Vector2D lineDirection;
        boolean clockwiseOrdered;
        int hullSize;
        List convexPolygon2D;
        int i;
        Random random = new Random(234324L);
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int firstEdgeIndex = random.nextInt(hullSize);
            int secondEdgeIndex = EuclidCoreTools.wrap((int)(random.nextInt(hullSize - 1) + firstEdgeIndex + 1), (int)hullSize);
            Point2D expectedFirstIntersection = new Point2D();
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(firstEdgeIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)firstEdgeIndex, (int)hullSize));
            expectedFirstIntersection.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            Point2D expectedSecondIntersection = new Point2D();
            Point2DReadOnly vertex2 = (Point2DReadOnly)convexPolygon2D.get(secondEdgeIndex);
            Point2DReadOnly nextVertex2 = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)secondEdgeIndex, (int)hullSize));
            expectedSecondIntersection.interpolate((Tuple2DReadOnly)vertex2, (Tuple2DReadOnly)nextVertex2, random.nextDouble());
            Point2D pointOnLine = new Point2D();
            pointOnLine.interpolate((Tuple2DReadOnly)expectedFirstIntersection, (Tuple2DReadOnly)expectedSecondIntersection, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineDirection2 = new Vector2D();
            lineDirection2.sub((Tuple2DReadOnly)expectedSecondIntersection, (Tuple2DReadOnly)expectedFirstIntersection);
            lineDirection2.normalize();
            lineDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D actualFirstIntersection2 = new Point2D();
            Point2D actualSecondIntersection2 = new Point2D();
            int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection2, (Point2DBasics)actualSecondIntersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            if (expectedFirstIntersection.distance((Point2DReadOnly)actualFirstIntersection2) < expectedFirstIntersection.distance((Point2DReadOnly)actualSecondIntersection2)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection2, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection2, (double)1.0E-9);
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualSecondIntersection2, (double)1.0E-9);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualFirstIntersection2, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int edgeIndex = random.nextInt(hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(edgeIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize));
            Point2D pointOnLine = new Point2D();
            pointOnLine.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
            lineDirection.normalize();
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            actualFirstIntersection = new Point2D();
            actualSecondIntersection = new Point2D();
            int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
            if (vertex.distance((Point2DReadOnly)actualFirstIntersection) < vertex.distance((Point2DReadOnly)actualSecondIntersection)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualFirstIntersection, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)nextVertex, (EuclidGeometry)actualSecondIntersection, (double)1.0E-9);
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualSecondIntersection, (double)1.0E-9);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)nextVertex, (EuclidGeometry)actualFirstIntersection, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int v0Index = random.nextInt(hullSize);
            int vn1Index = EuclidCoreTools.next((int)v0Index, (int)hullSize);
            int vn2Index = EuclidCoreTools.next((int)vn1Index, (int)hullSize);
            int vp1Index = EuclidCoreTools.previous((int)v0Index, (int)hullSize);
            Point2DReadOnly v0 = (Point2DReadOnly)convexPolygon2D.get(v0Index);
            Point2DReadOnly vn1 = (Point2DReadOnly)convexPolygon2D.get(vn1Index);
            Point2DReadOnly vn2 = (Point2DReadOnly)convexPolygon2D.get(vn2Index);
            Point2DReadOnly vp1 = (Point2DReadOnly)convexPolygon2D.get(vp1Index);
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            Point2D v0Max = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)centroid, (Point2DReadOnly)v0, (Point2DReadOnly)vn1, (Point2DReadOnly)vn2);
            Vector2D extrapolationDirection = new Vector2D();
            extrapolationDirection.sub((Tuple2DReadOnly)v0, (Tuple2DReadOnly)centroid);
            if (!EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)v0Max, (Point2DReadOnly)centroid, (Vector2DReadOnly)extrapolationDirection)) {
                v0Max.scaleAdd(10.0, (Tuple2DReadOnly)extrapolationDirection, (Tuple2DReadOnly)v0);
            }
            Point2D vn1Max = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)centroid, (Point2DReadOnly)vn1, (Point2DReadOnly)v0, (Point2DReadOnly)vp1);
            extrapolationDirection.sub((Tuple2DReadOnly)vn1, (Tuple2DReadOnly)centroid);
            if (!EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)vn1Max, (Point2DReadOnly)centroid, (Vector2DReadOnly)extrapolationDirection)) {
                vn1Max.scaleAdd(10.0, (Tuple2DReadOnly)extrapolationDirection, (Tuple2DReadOnly)vn1);
            }
            Point2D firstExtrapolatedPoint = new Point2D();
            Point2D secondExtrapolatedPoint = new Point2D();
            firstExtrapolatedPoint.interpolate((Tuple2DReadOnly)v0, (Tuple2DReadOnly)v0Max, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            secondExtrapolatedPoint.interpolate((Tuple2DReadOnly)vn1, (Tuple2DReadOnly)vn1Max, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D pointOnLine = new Point2D();
            pointOnLine.interpolate((Tuple2DReadOnly)firstExtrapolatedPoint, (Tuple2DReadOnly)secondExtrapolatedPoint, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineDirection3 = new Vector2D();
            lineDirection3.sub((Tuple2DReadOnly)secondExtrapolatedPoint, (Tuple2DReadOnly)firstExtrapolatedPoint);
            lineDirection3.normalize();
            lineDirection3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D actualFirstIntersection3 = new Point2D();
            Point2D actualSecondIntersection3 = new Point2D();
            int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection3, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection3, (Point2DBasics)actualSecondIntersection3);
            Assertions.assertEquals((int)0, (int)numberOfIntersections, (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            vertexIndex = random.nextInt(hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)vertexIndex, (int)hullSize));
            Point2DReadOnly previousVertex = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.previous((int)vertexIndex, (int)hullSize));
            Vector2D previousEdgeDirection = new Vector2D();
            previousEdgeDirection.sub((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)previousVertex);
            Vector2D nextEdgeDirection = new Vector2D();
            nextEdgeDirection.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
            Vector2D lineDirection4 = new Vector2D();
            lineDirection4.interpolate((Tuple2DReadOnly)previousEdgeDirection, (Tuple2DReadOnly)nextEdgeDirection, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineDirection4.normalize();
            Point2D pointOnLine = new Point2D();
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection4, (Tuple2DReadOnly)vertex);
            lineDirection4.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D actualFirstIntersection4 = new Point2D();
            Point2D actualSecondIntersection4 = new Point2D();
            int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection4, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection4, (Point2DBasics)actualSecondIntersection4);
            Assertions.assertEquals((int)1, (int)numberOfIntersections, (String)("Iteration: " + i));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualFirstIntersection4, (double)1.0E-9);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualSecondIntersection4, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            vertexIndex = random.nextInt(hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            Point2D pointOnLine = new Point2D((Tuple2DReadOnly)centroid);
            lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)pointOnLine, (Tuple2DReadOnly)vertex);
            actualFirstIntersection = new Point2D();
            actualSecondIntersection = new Point2D();
            int nIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)2, (int)nIntersections, (String)("Iteration: " + i));
            if (vertex.distance((Point2DReadOnly)actualFirstIntersection) < vertex.distance((Point2DReadOnly)actualSecondIntersection)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualFirstIntersection, (double)1.0E-9);
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualSecondIntersection, (double)1.0E-9);
        }
        List convexPolygon2D2 = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize2 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D2);
        boolean clockwiseOrdered2 = random.nextBoolean();
        if (!clockwiseOrdered2) {
            Collections.reverse(convexPolygon2D2.subList(0, hullSize2));
        }
        try {
            EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)new Point2D(), (Vector2DReadOnly)new Vector2D(), (List)convexPolygon2D2, (int)-1, (boolean)clockwiseOrdered2, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException clockwiseOrdered3) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)new Point2D(), (Vector2DReadOnly)new Vector2D(), (List)convexPolygon2D2, (int)(convexPolygon2D2.size() + 1), (boolean)clockwiseOrdered2, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException clockwiseOrdered3) {
            // empty catch block
        }
        convexPolygon2D2 = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
        hullSize2 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D2);
        clockwiseOrdered2 = random.nextBoolean();
        if (!clockwiseOrdered2) {
            Collections.reverse(convexPolygon2D2.subList(0, hullSize2));
        }
        Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random);
        Vector2D lineDirection5 = EuclidCoreRandomTools.nextVector2D((Random)random);
        int expectedNumberOfIntersections = 0;
        int actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection5, (List)convexPolygon2D2, (int)0, (boolean)clockwiseOrdered2, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        for (int i2 = 0; i2 < 1000; ++i2) {
            Point2D vertex = EuclidCoreRandomTools.nextPoint2D((Random)random);
            List<Point2D> convexPolygon2D3 = Collections.singletonList(vertex);
            pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            lineDirection5 = EuclidCoreRandomTools.nextVector2D((Random)random);
            Point2D firstIntersection = new Point2D(Double.NaN, Double.NaN);
            Point2D secondIntersection = new Point2D(Double.NaN, Double.NaN);
            boolean clockwiseOrdered4 = random.nextBoolean();
            int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection5, convexPolygon2D3, (int)1, (boolean)clockwiseOrdered4, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
            lineDirection5.sub((Tuple2DReadOnly)pointOnLine, (Tuple2DReadOnly)vertex);
            lineDirection5.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection5, convexPolygon2D3, (int)1, (boolean)clockwiseOrdered4, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)firstIntersection, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
        }
    }

    @Test
    public void testIntersectionBetweenLineSegment2DAndConvexPolygon2D() throws Exception {
        Point2DReadOnly vertex;
        int hullSize;
        int i;
        Random random = new Random(234324L);
        ArrayList<Point2D> convexPolygon2D = new ArrayList<Point2D>();
        convexPolygon2D.add(new Point2D(-1.0, -1.0));
        convexPolygon2D.add(new Point2D(1.0, -1.0));
        convexPolygon2D.add(new Point2D(-1.0, 1.0));
        convexPolygon2D.add(new Point2D(1.0, 1.0));
        int hullSize2 = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(convexPolygon2D);
        Assertions.assertEquals((int)4, (int)hullSize2);
        boolean clockwiseOrdered = true;
        Point2D lineSegmentStart = new Point2D();
        Point2D lineSegmentEnd = new Point2D();
        Point2D expectedFirstIntersection = new Point2D();
        Point2D expectedSecondIntersection = new Point2D();
        Point2D actualFirstIntersection = new Point2D();
        Point2D actualSecondIntersection = new Point2D();
        lineSegmentStart.set(0.0, 0.0);
        lineSegmentEnd.set(2.0, 0.0);
        expectedFirstIntersection.set(1.0, 0.0);
        int expectedNumberOfIntersections = 1;
        int actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        lineSegmentStart.set(-2.0, 0.0);
        lineSegmentEnd.set(2.0, 0.0);
        expectedFirstIntersection.set(1.0, 0.0);
        expectedSecondIntersection.set(-1.0, 0.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(-0.5, 0.0);
        lineSegmentEnd.set(0.5, 0.0);
        expectedNumberOfIntersections = 0;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        lineSegmentStart.set(-3.5, 0.0);
        lineSegmentEnd.set(-1.5, 0.0);
        expectedNumberOfIntersections = 0;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        lineSegmentStart.set(-1.5, 0.0);
        lineSegmentEnd.set(0.0, 1.5);
        expectedFirstIntersection.set(-0.5, 1.0);
        expectedSecondIntersection.set(-1.0, 0.5);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(-1.0, 0.5);
        lineSegmentEnd.set(-0.5, 1.0);
        expectedFirstIntersection.set(-0.5, 1.0);
        expectedSecondIntersection.set(-1.0, 0.5);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(-1.5, 1.0);
        lineSegmentEnd.set(1.5, 1.0);
        expectedFirstIntersection.set(-1.0, 1.0);
        expectedSecondIntersection.set(1.0, 1.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(-2.5, 1.0);
        lineSegmentEnd.set(-1.5, 1.0);
        expectedNumberOfIntersections = 0;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        lineSegmentStart.set(1.0, 0.0);
        lineSegmentEnd.set(1.0, 2.0);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedSecondIntersection.set(1.0, 0.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.0, 0.0);
        lineSegmentEnd.set(1.0, 0.5);
        expectedFirstIntersection.set(1.0, 0.0);
        expectedSecondIntersection.set(1.0, 0.5);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(-0.5, 1.0);
        lineSegmentEnd.set(-1.0, 0.5);
        expectedFirstIntersection.set(-0.5, 1.0);
        expectedSecondIntersection.set(-1.0, 0.5);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(-1.5, 0.5);
        lineSegmentEnd.set(1.5, 0.5);
        expectedFirstIntersection.set(1.0, 0.5);
        expectedSecondIntersection.set(-1.0, 0.5);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(0.0, -1.5);
        lineSegmentEnd.set(1.5, -1.5);
        expectedNumberOfIntersections = 0;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        lineSegmentStart.set(0.0, 1.5);
        lineSegmentEnd.set(1.5, 1.5);
        expectedNumberOfIntersections = 0;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        lineSegmentStart.set(1.0, 1.0);
        lineSegmentEnd.set(0.5, 1.0);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedSecondIntersection.set(0.5, 1.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.0, 1.0);
        lineSegmentEnd.set(1.0, 0.5);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedSecondIntersection.set(1.0, 0.5);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(0.5, 1.0);
        lineSegmentEnd.set(1.0, 1.0);
        expectedFirstIntersection.set(0.5, 1.0);
        expectedSecondIntersection.set(1.0, 1.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.0, 0.5);
        lineSegmentEnd.set(1.0, 1.0);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedSecondIntersection.set(1.0, 0.5);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(-1.5, 1.0);
        lineSegmentEnd.set(-0.5, 1.0);
        expectedFirstIntersection.set(-0.5, 1.0);
        expectedSecondIntersection.set(-1.0, 1.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(-1.5, 1.0);
        lineSegmentEnd.set(-1.0, 1.0);
        expectedFirstIntersection.set(-1.0, 1.0);
        expectedNumberOfIntersections = 1;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        lineSegmentStart.set(-1.0, 1.0);
        lineSegmentEnd.set(-1.5, 1.0);
        expectedFirstIntersection.set(-1.0, 1.0);
        expectedNumberOfIntersections = 1;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.0, 1.0);
        lineSegmentEnd.set(1.5, 1.0);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedNumberOfIntersections = 1;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.5, 1.0);
        lineSegmentEnd.set(1.0, 1.0);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedNumberOfIntersections = 1;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.5, 1.5);
        lineSegmentEnd.set(1.0, 1.0);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedNumberOfIntersections = 1;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        lineSegmentStart.set(0.5, 1.5);
        lineSegmentEnd.set(1.0, 1.0);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedNumberOfIntersections = 1;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        lineSegmentStart.set(-1.0, -1.0);
        lineSegmentEnd.set(0.8, 1.0);
        expectedFirstIntersection.set(0.8, 1.0);
        expectedSecondIntersection.set(-1.0, -1.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.0, 1.0);
        lineSegmentEnd.set(-1.0, -1.0);
        expectedFirstIntersection.set(1.0, 1.0);
        expectedSecondIntersection.set(-1.0, -1.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.0, -0.5);
        lineSegmentEnd.set(1.0, 0.0);
        expectedFirstIntersection.set(1.0, -0.5);
        expectedSecondIntersection.set(1.0, 0.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        lineSegmentStart.set(1.0, -1.5);
        lineSegmentEnd.set(1.0, 0.5);
        expectedFirstIntersection.set(1.0, 0.5);
        expectedSecondIntersection.set(1.0, -1.0);
        expectedNumberOfIntersections = 2;
        actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, convexPolygon2D, (int)hullSize2, (boolean)clockwiseOrdered, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
        Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        for (i = 0; i < 1000; ++i) {
            List convexPolygon2D2 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D2);
            boolean clockwiseOrdered2 = random.nextBoolean();
            if (!clockwiseOrdered2) {
                Collections.reverse(convexPolygon2D2.subList(0, hullSize));
            }
            int firstEdgeIndex = random.nextInt(hullSize);
            int secondEdgeIndex = EuclidCoreTools.wrap((int)(random.nextInt(hullSize - 1) + firstEdgeIndex + 1), (int)hullSize);
            double alphaFirst = random.nextDouble();
            Point2D expectedFirstIntersection2 = new Point2D();
            Point2DReadOnly vertex2 = (Point2DReadOnly)convexPolygon2D2.get(firstEdgeIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D2.get(EuclidCoreTools.next((int)firstEdgeIndex, (int)hullSize));
            expectedFirstIntersection2.interpolate((Tuple2DReadOnly)vertex2, (Tuple2DReadOnly)nextVertex, alphaFirst);
            double alphaSecond = random.nextDouble();
            Point2D expectedSecondIntersection2 = new Point2D();
            Point2DReadOnly vertex3 = (Point2DReadOnly)convexPolygon2D2.get(secondEdgeIndex);
            Point2DReadOnly nextVertex2 = (Point2DReadOnly)convexPolygon2D2.get(EuclidCoreTools.next((int)secondEdgeIndex, (int)hullSize));
            expectedSecondIntersection2.interpolate((Tuple2DReadOnly)vertex3, (Tuple2DReadOnly)nextVertex2, alphaSecond);
            Vector2D lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)expectedSecondIntersection2, (Tuple2DReadOnly)expectedFirstIntersection2);
            lineDirection.normalize();
            Point2D actualFirstIntersection2 = new Point2D();
            Point2D actualSecondIntersection2 = new Point2D();
            Point2D lineSegmentStart2 = new Point2D();
            Point2D lineSegmentEnd2 = new Point2D();
            double alphaOutsideStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-0.01);
            double alphaOutsideEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.01, (double)10.0);
            lineSegmentStart2.interpolate((Tuple2DReadOnly)expectedFirstIntersection2, (Tuple2DReadOnly)expectedSecondIntersection2, alphaOutsideStart);
            lineSegmentEnd2.interpolate((Tuple2DReadOnly)expectedFirstIntersection2, (Tuple2DReadOnly)expectedSecondIntersection2, alphaOutsideEnd);
            int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (List)convexPolygon2D2, (int)hullSize, (boolean)clockwiseOrdered2, (Point2DBasics)actualFirstIntersection2, (Point2DBasics)actualSecondIntersection2);
            Assertions.assertEquals((int)2, (int)numberOfIntersections);
            if (expectedFirstIntersection2.distance((Point2DReadOnly)actualFirstIntersection2) < expectedFirstIntersection2.distance((Point2DReadOnly)actualSecondIntersection2)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection2, (EuclidGeometry)actualFirstIntersection2, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection2, (EuclidGeometry)actualSecondIntersection2, (double)1.0E-9);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection2, (EuclidGeometry)actualSecondIntersection2, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection2, (EuclidGeometry)actualFirstIntersection2, (double)1.0E-9);
            }
            double alphaStartInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double alphaEndInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            lineSegmentStart2.interpolate((Tuple2DReadOnly)expectedFirstIntersection2, (Tuple2DReadOnly)expectedSecondIntersection2, alphaStartInside);
            lineSegmentEnd2.interpolate((Tuple2DReadOnly)expectedFirstIntersection2, (Tuple2DReadOnly)expectedSecondIntersection2, alphaEndInside);
            numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (List)convexPolygon2D2, (int)hullSize, (boolean)clockwiseOrdered2, (Point2DBasics)actualFirstIntersection2, (Point2DBasics)actualSecondIntersection2);
            Assertions.assertEquals((int)0, (int)numberOfIntersections);
            lineSegmentStart2.interpolate((Tuple2DReadOnly)expectedFirstIntersection2, (Tuple2DReadOnly)expectedSecondIntersection2, alphaOutsideStart);
            lineSegmentEnd2.interpolate((Tuple2DReadOnly)expectedFirstIntersection2, (Tuple2DReadOnly)expectedSecondIntersection2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (List)convexPolygon2D2, (int)hullSize, (boolean)clockwiseOrdered2, (Point2DBasics)actualFirstIntersection2, (Point2DBasics)actualSecondIntersection2);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            if (actualFirstIntersection2.distance((Point2DReadOnly)expectedFirstIntersection2) < actualFirstIntersection2.distance((Point2DReadOnly)expectedSecondIntersection2)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection2, (EuclidGeometry)actualFirstIntersection2, (double)1.0E-9);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection2, (EuclidGeometry)actualFirstIntersection2, (double)1.0E-9);
            }
            lineSegmentStart2.interpolate((Tuple2DReadOnly)expectedFirstIntersection2, (Tuple2DReadOnly)expectedSecondIntersection2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd2.interpolate((Tuple2DReadOnly)expectedFirstIntersection2, (Tuple2DReadOnly)expectedSecondIntersection2, alphaOutsideEnd);
            numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2, (List)convexPolygon2D2, (int)hullSize, (boolean)clockwiseOrdered2, (Point2DBasics)actualFirstIntersection2, (Point2DBasics)actualSecondIntersection2);
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
            if (actualFirstIntersection2.distance((Point2DReadOnly)expectedFirstIntersection2) < actualFirstIntersection2.distance((Point2DReadOnly)expectedSecondIntersection2)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection2, (EuclidGeometry)actualFirstIntersection2, (double)1.0E-9);
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection2, (EuclidGeometry)actualFirstIntersection2, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            List convexPolygon2D3 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D3);
            boolean clockwiseOrdered3 = random.nextBoolean();
            if (!clockwiseOrdered3) {
                Collections.reverse(convexPolygon2D3.subList(0, hullSize));
            }
            int edgeIndex = random.nextInt(hullSize);
            vertex = (Point2DReadOnly)convexPolygon2D3.get(edgeIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D3.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize));
            Point2D pointOnLine = new Point2D();
            pointOnLine.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)vertex);
            lineDirection.normalize();
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D actualFirstIntersection3 = new Point2D();
            Point2D actualSecondIntersection3 = new Point2D();
            Point2D lineSegmentStart3 = new Point2D();
            Point2D lineSegmentEnd3 = new Point2D();
            double alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-0.01);
            double alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.01, (double)10.0);
            lineSegmentStart3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, alphaStart);
            lineSegmentEnd3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, alphaEnd);
            int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart3, (Point2DReadOnly)lineSegmentEnd3, (List)convexPolygon2D3, (int)hullSize, (boolean)clockwiseOrdered3, (Point2DBasics)actualFirstIntersection3, (Point2DBasics)actualSecondIntersection3);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
            if (vertex.distance((Point2DReadOnly)actualFirstIntersection3) < vertex.distance((Point2DReadOnly)actualSecondIntersection3)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualFirstIntersection3, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)nextVertex, (EuclidGeometry)actualSecondIntersection3, (double)1.0E-9);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualSecondIntersection3, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)nextVertex, (EuclidGeometry)actualFirstIntersection3, (double)1.0E-9);
            }
            lineSegmentStart3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart3, (Point2DReadOnly)lineSegmentEnd3, (List)convexPolygon2D3, (int)hullSize, (boolean)clockwiseOrdered3, (Point2DBasics)actualFirstIntersection3, (Point2DBasics)actualSecondIntersection3);
            Assertions.assertEquals((int)0, (int)numberOfIntersections, (String)("Iteration: " + i));
            lineSegmentStart3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            lineSegmentEnd3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart3, (Point2DReadOnly)lineSegmentEnd3, (List)convexPolygon2D3, (int)hullSize, (boolean)clockwiseOrdered3, (Point2DBasics)actualFirstIntersection3, (Point2DBasics)actualSecondIntersection3);
            Assertions.assertEquals((int)0, (int)numberOfIntersections, (String)("Iteration: " + i));
            lineSegmentStart3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            lineSegmentEnd3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart3, (Point2DReadOnly)lineSegmentEnd3, (List)convexPolygon2D3, (int)hullSize, (boolean)clockwiseOrdered3, (Point2DBasics)actualFirstIntersection3, (Point2DBasics)actualSecondIntersection3);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
            if (vertex.distance((Point2DReadOnly)actualFirstIntersection3) < vertex.distance((Point2DReadOnly)actualSecondIntersection3)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualFirstIntersection3, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentEnd3, (EuclidGeometry)actualSecondIntersection3, (double)1.0E-9);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentEnd3, (EuclidGeometry)actualFirstIntersection3, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualSecondIntersection3, (double)1.0E-9);
            }
            lineSegmentStart3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineSegmentEnd3.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart3, (Point2DReadOnly)lineSegmentEnd3, (List)convexPolygon2D3, (int)hullSize, (boolean)clockwiseOrdered3, (Point2DBasics)actualFirstIntersection3, (Point2DBasics)actualSecondIntersection3);
            Assertions.assertEquals((int)2, (int)numberOfIntersections, (String)("Iteration: " + i));
            if (nextVertex.distance((Point2DReadOnly)actualFirstIntersection3) < nextVertex.distance((Point2DReadOnly)actualSecondIntersection3)) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)nextVertex, (EuclidGeometry)actualFirstIntersection3, (double)1.0E-9);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentStart3, (EuclidGeometry)actualSecondIntersection3, (double)1.0E-9);
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)lineSegmentStart3, (EuclidGeometry)actualFirstIntersection3, (double)1.0E-9);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)nextVertex, (EuclidGeometry)actualSecondIntersection3, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            List convexPolygon2D4 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D4);
            boolean clockwiseOrdered4 = random.nextBoolean();
            if (!clockwiseOrdered4) {
                Collections.reverse(convexPolygon2D4.subList(0, hullSize));
            }
            int vertexIndex = random.nextInt(hullSize);
            vertex = (Point2DReadOnly)convexPolygon2D4.get(vertexIndex);
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D4, (int)hullSize, (boolean)clockwiseOrdered4, (Point2DBasics)centroid);
            Point2D lineSegmentStart4 = new Point2D((Tuple2DReadOnly)centroid);
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)lineSegmentStart4);
            lineSegmentDirection.scale(1.5);
            Point2D lineSegmentEnd4 = new Point2D();
            lineSegmentEnd4.add((Tuple2DReadOnly)lineSegmentStart4, (Tuple2DReadOnly)lineSegmentDirection);
            Point2D actualFirstIntersection4 = new Point2D();
            Point2D actualSecondIntersection4 = new Point2D();
            int nIntersections = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)lineSegmentStart4, (Point2DReadOnly)lineSegmentEnd4, (List)convexPolygon2D4, (int)hullSize, (boolean)clockwiseOrdered4, (Point2DBasics)actualFirstIntersection4, (Point2DBasics)actualSecondIntersection4);
            Assertions.assertEquals((int)1, (int)nIntersections, (String)("Iteration: " + i));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)actualFirstIntersection4, (double)1.0E-9);
        }
    }

    @Test
    public void testIntersectionBetweenRay2DAndConvexPolygon2D() throws Exception {
        Random random = new Random(43545L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            Point2D rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Point2D firstIntersectionWithLine = new Point2D();
            Point2D secondIntersectionWithLine = new Point2D();
            int expectedNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)firstIntersectionWithLine, (Point2DBasics)secondIntersectionWithLine);
            ArrayList<Point2D> expectedIntersections = new ArrayList<Point2D>();
            if (expectedNumberOfIntersections == 2 && EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)secondIntersectionWithLine, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection)) {
                expectedIntersections.add(secondIntersectionWithLine);
            }
            if (expectedNumberOfIntersections >= 1 && EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)firstIntersectionWithLine, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection)) {
                expectedIntersections.add(firstIntersectionWithLine);
            }
            expectedNumberOfIntersections = expectedIntersections.size();
            Point2D firstIntersectionWithRay = new Point2D();
            Point2D secondIntersectionWithRay = new Point2D();
            int actualNumberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenRay2DAndConvexPolygon2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)firstIntersectionWithRay, (Point2DBasics)secondIntersectionWithRay);
            Assertions.assertEquals((int)expectedNumberOfIntersections, (int)actualNumberOfIntersections, (String)("Iteration: " + i));
            if (expectedNumberOfIntersections == 2) {
                if (firstIntersectionWithLine.distance((Point2DReadOnly)expectedIntersections.get(0)) < firstIntersectionWithLine.distance((Point2DReadOnly)expectedIntersections.get(1))) {
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)firstIntersectionWithRay, (EuclidGeometry)((EuclidGeometry)expectedIntersections.get(0)), (double)1.0E-7);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)secondIntersectionWithRay, (EuclidGeometry)((EuclidGeometry)expectedIntersections.get(1)), (double)1.0E-7);
                } else {
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)firstIntersectionWithRay, (EuclidGeometry)((EuclidGeometry)expectedIntersections.get(1)), (double)1.0E-7);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)secondIntersectionWithRay, (EuclidGeometry)((EuclidGeometry)expectedIntersections.get(0)), (double)1.0E-7);
                }
            }
            if (expectedNumberOfIntersections != 1) continue;
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)expectedIntersections.get(0)), (EuclidGeometry)firstIntersectionWithRay, (double)1.0E-7);
        }
    }

    @Test
    public void testOrthogonalProjectionOnConvexPolygon2D() throws Exception {
        int i;
        boolean success;
        Point2D pointToProject;
        boolean clockwiseOrdered;
        int hullSize;
        List convexPolygon2D;
        int i2;
        Random random = new Random(43545L);
        for (i2 = 0; i2 < 1000; ++i2) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int edgeIndex = random.nextInt(hullSize);
            Point2DReadOnly edgeStart = (Point2DReadOnly)convexPolygon2D.get(edgeIndex);
            Point2DReadOnly edgeEnd = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize));
            Vector2D edgeNormal = new Vector2D();
            EuclidGeometryPolygonTools.edgeNormal((int)edgeIndex, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Vector2DBasics)edgeNormal);
            Point2D expectedProjection = new Point2D();
            expectedProjection.interpolate((Tuple2DReadOnly)edgeStart, (Tuple2DReadOnly)edgeEnd, random.nextDouble());
            pointToProject = new Point2D();
            pointToProject.scaleAdd(random.nextDouble(), (Tuple2DReadOnly)edgeNormal, (Tuple2DReadOnly)expectedProjection);
            Point2D actualProjection = new Point2D();
            success = EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)pointToProject, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)actualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-7);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int vertexIndex = random.nextInt(hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            Vector2D previousEdgeNormal = new Vector2D();
            Vector2D nextEdgeNormal = new Vector2D();
            Vector2D shiftDirection = new Vector2D();
            EuclidGeometryPolygonTools.edgeNormal((int)EuclidCoreTools.previous((int)vertexIndex, (int)hullSize), (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Vector2DBasics)previousEdgeNormal);
            EuclidGeometryPolygonTools.edgeNormal((int)vertexIndex, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Vector2DBasics)nextEdgeNormal);
            shiftDirection.interpolate((Tuple2DReadOnly)previousEdgeNormal, (Tuple2DReadOnly)nextEdgeNormal, random.nextDouble());
            pointToProject = new Point2D();
            pointToProject.scaleAdd(random.nextDouble(), (Tuple2DReadOnly)shiftDirection, (Tuple2DReadOnly)vertex);
            Point2D acualProjection = new Point2D();
            success = EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)pointToProject, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)acualProjection);
            Assertions.assertTrue((boolean)success);
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i2), (EuclidGeometry)vertex, (EuclidGeometry)acualProjection, (double)1.0E-7);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            int vertexIndex = random.nextInt(hullSize);
            int nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(nextVertexIndex);
            Point2D pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            Point2D pointInside = new Point2D();
            pointInside.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, random.nextDouble());
            Point2D actualProjection = new Point2D(Double.NaN, Double.NaN);
            boolean success2 = EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)pointInside, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)actualProjection);
            Assertions.assertFalse((boolean)success2);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualProjection);
        }
        ArrayList convexPolygon2D2 = new ArrayList();
        int hullSize2 = 0;
        boolean clockwiseOrdered2 = random.nextBoolean();
        Point2D point = new Point2D();
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)point, convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2, (Point2DBasics)point));
        for (i = 0; i < 1000; ++i) {
            ArrayList<Point2D> convexPolygon2D3 = new ArrayList<Point2D>();
            convexPolygon2D3.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
            hullSize = 1;
            boolean clockwiseOrdered3 = random.nextBoolean();
            Point2D query = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D projection = new Point2D();
            boolean success3 = EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D3, (int)hullSize, (boolean)clockwiseOrdered3, (Point2DBasics)projection);
            Assertions.assertTrue((boolean)success3);
            Assertions.assertEquals((Object)projection, convexPolygon2D3.get(0));
        }
        for (i = 0; i < 1000; ++i) {
            ArrayList<Point2D> convexPolygon2D4 = new ArrayList<Point2D>();
            convexPolygon2D4.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
            convexPolygon2D4.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
            hullSize = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(convexPolygon2D4);
            boolean clockwiseOrdered4 = random.nextBoolean();
            Point2D query = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D actualProjection = new Point2D();
            Point2D expectedProjection = new Point2D();
            boolean actualSuccess = EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)query, convexPolygon2D4, (int)hullSize, (boolean)clockwiseOrdered4, (Point2DBasics)actualProjection);
            boolean expectedSuccess = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)query, (Point2DReadOnly)((Point2DReadOnly)convexPolygon2D4.get(0)), (Point2DReadOnly)((Point2DReadOnly)convexPolygon2D4.get(1)), (Point2DBasics)expectedProjection);
            Assertions.assertTrue((expectedSuccess == actualSuccess ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)actualProjection, (double)1.0E-12);
        }
        List convexPolygon2D22 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
        hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D22);
        clockwiseOrdered2 = random.nextBoolean();
        if (!clockwiseOrdered2) {
            Collections.reverse(convexPolygon2D22.subList(0, hullSize));
        }
        point = new Point2D();
        try {
            EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)point, (List)convexPolygon2D22, (int)(convexPolygon2D22.size() + 1), (boolean)clockwiseOrdered2, (Point2DBasics)point);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)point, (List)convexPolygon2D22, (int)-1, (boolean)clockwiseOrdered2, (Point2DBasics)point);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLineOfSightStartEndIndex() throws Exception {
        Point2DReadOnly startVertex;
        Point2D observer;
        boolean clockwiseOrdered;
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            observer = new Point2D();
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            int vertexIndex = random.nextInt(hullSize);
            int nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(nextVertexIndex);
            Point2D pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            observer.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)observer, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (double)0.0));
            int lineOfSightStartIndex = EuclidGeometryPolygonTools.lineOfSightStartIndex((Point2DReadOnly)observer, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered);
            int lineOfSightEndIndex = EuclidGeometryPolygonTools.lineOfSightEndIndex((Point2DReadOnly)observer, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered);
            Assertions.assertNotEquals((int)-1, (int)lineOfSightStartIndex);
            Assertions.assertNotEquals((int)-1, (int)lineOfSightEndIndex);
            startVertex = (Point2DReadOnly)convexPolygon2D.get(lineOfSightStartIndex);
            Vector2D startDirection = new Vector2D();
            startDirection.sub((Tuple2DReadOnly)startVertex, (Tuple2DReadOnly)observer);
            Assertions.assertEquals((int)1, (int)EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)observer, (Vector2DReadOnly)startDirection, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D()));
            Point2DReadOnly endVertex = (Point2DReadOnly)convexPolygon2D.get(lineOfSightEndIndex);
            Vector2D endDirection = new Vector2D();
            endDirection.sub((Tuple2DReadOnly)endVertex, (Tuple2DReadOnly)observer);
            Assertions.assertEquals((int)1, (int)EuclidGeometryPolygonTools.intersectionBetweenLine2DAndConvexPolygon2D((Point2DReadOnly)observer, (Vector2DReadOnly)endDirection, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D()));
            HashSet<Integer> lineOfSightIndices = new HashSet<Integer>();
            lineOfSightIndices.add(lineOfSightStartIndex);
            lineOfSightIndices.add(lineOfSightEndIndex);
            int j = EuclidCoreTools.next((int)lineOfSightStartIndex, (int)hullSize);
            while (j != lineOfSightEndIndex) {
                lineOfSightIndices.add(j);
                j = EuclidCoreTools.next((int)j, (int)hullSize);
            }
            Integer currentIndex = 0;
            while (currentIndex < hullSize) {
                Point2DReadOnly vertex2 = (Point2DReadOnly)convexPolygon2D.get(currentIndex);
                Vector2D fromObserverToVertex = new Vector2D();
                fromObserverToVertex.sub((Tuple2DReadOnly)vertex2, (Tuple2DReadOnly)observer);
                Vector2D deltaAwayFromVertex = new Vector2D();
                deltaAwayFromVertex.setAndNormalize((Tuple2DReadOnly)fromObserverToVertex);
                deltaAwayFromVertex.scale(-0.001);
                Point2D rightBeforeVertex = new Point2D();
                rightBeforeVertex.add((Tuple2DReadOnly)fromObserverToVertex, (Tuple2DReadOnly)observer);
                rightBeforeVertex.add((Tuple2DReadOnly)deltaAwayFromVertex);
                int expected = lineOfSightIndices.contains(currentIndex) ? 0 : 1;
                int actual = EuclidGeometryPolygonTools.intersectionBetweenLineSegment2DAndConvexPolygon2D((Point2DReadOnly)observer, (Point2DReadOnly)rightBeforeVertex, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
                Assertions.assertEquals((int)expected, (int)actual);
                Integer n = currentIndex;
                Integer n2 = currentIndex = Integer.valueOf(currentIndex + 1);
            }
        }
        ArrayList<Point2D> convexPolygon2D = new ArrayList<Point2D>();
        int hullSize = 0;
        Point2D observer2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        clockwiseOrdered = true;
        Assertions.assertEquals((int)-1, (int)EuclidGeometryPolygonTools.lineOfSightStartIndex((Point2DReadOnly)observer2, convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered));
        Assertions.assertEquals((int)-1, (int)EuclidGeometryPolygonTools.lineOfSightEndIndex((Point2DReadOnly)observer2, convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered));
        convexPolygon2D = new ArrayList();
        convexPolygon2D.add(new Point2D(1.0, 1.0));
        hullSize = 1;
        observer2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        clockwiseOrdered = true;
        Assertions.assertEquals((int)0, (int)EuclidGeometryPolygonTools.lineOfSightStartIndex((Point2DReadOnly)observer2, convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered));
        Assertions.assertEquals((int)0, (int)EuclidGeometryPolygonTools.lineOfSightEndIndex((Point2DReadOnly)observer2, convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered));
        for (int i = 0; i < 1000; ++i) {
            ArrayList<Point2D> convexPolygon2D2 = new ArrayList<Point2D>();
            convexPolygon2D2.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
            convexPolygon2D2.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
            int hullSize2 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D(convexPolygon2D2);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D2.subList(0, hullSize2));
            }
            observer = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            int startIndex = EuclidGeometryPolygonTools.lineOfSightStartIndex((Point2DReadOnly)observer, convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered);
            int endIndex = EuclidGeometryPolygonTools.lineOfSightEndIndex((Point2DReadOnly)observer, convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered);
            startVertex = (Point2D)convexPolygon2D2.get(startIndex);
            Point2D endVertex = (Point2D)convexPolygon2D2.get(endIndex);
            if (clockwiseOrdered) {
                Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)endVertex, (Point2DReadOnly)observer, (Point2DReadOnly)startVertex));
                Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)startVertex, (Point2DReadOnly)observer, (Point2DReadOnly)endVertex));
                continue;
            }
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)endVertex, (Point2DReadOnly)observer, (Point2DReadOnly)startVertex));
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)startVertex, (Point2DReadOnly)observer, (Point2DReadOnly)endVertex));
        }
        List convexPolygon2D2 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
        hullSize = 2;
        boolean clockwiseOrdered2 = random.nextBoolean();
        if (!clockwiseOrdered2) {
            Collections.reverse(convexPolygon2D2.subList(0, hullSize));
        }
        Point2D observer3 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        try {
            EuclidGeometryPolygonTools.lineOfSightStartIndex((Point2DReadOnly)observer3, (List)convexPolygon2D2, (int)(convexPolygon2D2.size() + 1), (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.lineOfSightStartIndex((Point2DReadOnly)observer3, (List)convexPolygon2D2, (int)-1, (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.lineOfSightEndIndex((Point2DReadOnly)observer3, (List)convexPolygon2D2, (int)(convexPolygon2D2.size() + 1), (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.lineOfSightEndIndex((Point2DReadOnly)observer3, (List)convexPolygon2D2, (int)-1, (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testClosestPointToNonInterectingRay2D() throws Exception {
        Vector2D rayDirection;
        Point2D rayOrigin;
        List convexPolygon2D;
        int i;
        ArrayList<Point2D> convexPolygon2D2 = new ArrayList<Point2D>();
        convexPolygon2D2.add(new Point2D(-1.0, 0.0));
        convexPolygon2D2.add(new Point2D(0.0, 1.0));
        convexPolygon2D2.add(new Point2D(2.0, 0.0));
        convexPolygon2D2.add(new Point2D(1.0, -1.0));
        int hullSize = 4;
        Point2D rayOrigin2 = new Point2D();
        Vector2D rayDirection2 = new Vector2D();
        Point2D expected = new Point2D();
        Point2D actual = new Point2D();
        rayOrigin2.set(5.0, -3.0);
        rayDirection2.set(0.0, 1.0);
        expected.set(2.0, 0.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(1.0, 1.0);
        rayDirection2.set(0.5, 0.5);
        expected.set(0.8, 0.6);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(1.0, 1.0);
        rayDirection2.set(-0.5, 0.1);
        expected.set(0.0, 1.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(-0.75, 0.75);
        rayDirection2.set(0.0, 0.1);
        expected.set(-0.5, 0.5);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(-0.75, 0.75);
        rayDirection2.set(0.3, 0.3);
        expected.set(-0.5, 0.5);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(-0.75, 0.75);
        rayDirection2.set(-0.3, -0.3);
        expected.set(-0.5, 0.5);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(-0.75, 0.75);
        rayDirection2.set(0.3, 0.31);
        expected.set(-0.5, 0.5);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(-0.75, 0.75);
        rayDirection2.set(0.3, 0.29);
        expected.set(0.0, 1.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(1.75, -0.75);
        rayDirection2.set(1.0, 1.0);
        expected.set(1.5, -0.5);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(1.75, -0.75);
        rayDirection2.set(-0.3, -0.3);
        expected.set(1.5, -0.5);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(1.0, -1.2);
        rayDirection2.set(-2.0, 1.0);
        expected.set(1.0, -1.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(1.0, -1.2);
        rayDirection2.set(2.0, -1.0);
        expected.set(1.0, -1.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        rayOrigin2.set(-0.1, -0.7);
        rayDirection2.set(-2.0, 1.0);
        expected.set(0.0, -0.5);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        convexPolygon2D2 = new ArrayList();
        Point2D vertex = new Point2D(1.0, -1.0);
        convexPolygon2D2.add(vertex);
        int hullSize2 = 1;
        Point2D rayOrigin3 = new Point2D();
        Vector2D rayDirection3 = new Vector2D();
        Point2D expected2 = vertex;
        Point2D actual2 = new Point2D();
        rayOrigin3.set(5.0, -3.0);
        rayDirection3.set(0.0, 1.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection3, convexPolygon2D2, (int)hullSize2, (boolean)true, (Point2DBasics)actual2));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual2, (double)1.0E-12);
        rayOrigin3.set(0.0, 0.0);
        rayDirection3.set(1.0, 0.0);
        Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection3, convexPolygon2D2, (int)hullSize2, (boolean)true, (Point2DBasics)actual2));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual2, (double)1.0E-12);
        convexPolygon2D2 = new ArrayList();
        hullSize = 0;
        rayOrigin = new Point2D();
        rayDirection2 = new Vector2D();
        Point2D actual3 = new Point2D();
        Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection2, convexPolygon2D2, (int)hullSize, (boolean)true, (Point2DBasics)actual3));
        Random random = new Random(324234L);
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize3 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize3));
            }
            rayOrigin = new Point2D();
            rayDirection = new Vector2D();
            int edgeIndex = random.nextInt(hullSize3);
            Point2D pointOnEdge = new Point2D();
            Vector2D edgeNormal = new Vector2D();
            Vector2D edgeDirection = new Vector2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)convexPolygon2D.get(edgeIndex), (Tuple2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize3)), random.nextDouble());
            EuclidGeometryPolygonTools.edgeNormal((int)edgeIndex, (List)convexPolygon2D, (int)hullSize3, (boolean)clockwiseOrdered, (Vector2DBasics)edgeNormal);
            edgeDirection.sub((Tuple2DReadOnly)convexPolygon2D.get(edgeIndex), (Tuple2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize3)));
            edgeDirection.normalize();
            if (random.nextBoolean()) {
                edgeDirection.negate();
            }
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)edgeNormal, (Tuple2DReadOnly)pointOnEdge);
            rayDirection.interpolate((Tuple2DReadOnly)edgeDirection, (Tuple2DReadOnly)edgeNormal, random.nextDouble());
            int closestVertexIndexToRay = EuclidGeometryPolygonTools.closestVertexIndexToRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize3, (boolean)clockwiseOrdered);
            Point2DReadOnly closestVertexToRay = (Point2DReadOnly)convexPolygon2D.get(closestVertexIndexToRay);
            Point2D rayOriginProjected = new Point2D();
            EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)rayOrigin, (List)convexPolygon2D, (int)hullSize3, (boolean)clockwiseOrdered, (Point2DBasics)rayOriginProjected);
            double distanceVertexToRay = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)closestVertexToRay, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
            double distancePojectionToRay = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)rayOriginProjected, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
            Point2D expectedClosestPoint = new Point2D();
            if (distanceVertexToRay < distancePojectionToRay) {
                expectedClosestPoint.set((Tuple2DReadOnly)closestVertexToRay);
            } else {
                expectedClosestPoint.set(rayOriginProjected);
            }
            Point2D actualClosestPoint = new Point2D();
            boolean success = EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize3, (boolean)clockwiseOrdered, (Point2DBasics)actualClosestPoint);
            Assertions.assertTrue((boolean)success);
            if (!expectedClosestPoint.epsilonEquals((EuclidGeometry)actualClosestPoint, 1.0E-12)) {
                double distanceActual;
                double distanceExpected;
                int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenRay2DAndConvexPolygon2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize3, (boolean)clockwiseOrdered, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
                if (numberOfIntersections > 0) {
                    System.err.println("Intersecting ray, test is bad");
                }
                if ((distanceExpected = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)expectedClosestPoint, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection)) > (distanceActual = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)actualClosestPoint, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection))) {
                    System.err.println("Test is bad");
                }
            }
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize4 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize4));
            }
            rayOrigin = new Point2D();
            rayDirection = new Vector2D();
            int v0Index = random.nextInt(hullSize4);
            int vn1Index = EuclidCoreTools.next((int)v0Index, (int)hullSize4);
            int vn2Index = EuclidCoreTools.next((int)vn1Index, (int)hullSize4);
            int vp1Index = EuclidCoreTools.previous((int)v0Index, (int)hullSize4);
            Point2DReadOnly v0 = (Point2DReadOnly)convexPolygon2D.get(v0Index);
            Point2DReadOnly vn1 = (Point2DReadOnly)convexPolygon2D.get(vn1Index);
            Point2DReadOnly vn2 = (Point2DReadOnly)convexPolygon2D.get(vn2Index);
            Point2DReadOnly vp1 = (Point2DReadOnly)convexPolygon2D.get(vp1Index);
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize4, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            Point2D v0Max = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)centroid, (Point2DReadOnly)v0, (Point2DReadOnly)vn1, (Point2DReadOnly)vn2);
            Vector2D extrapolationDirection = new Vector2D();
            extrapolationDirection.sub((Tuple2DReadOnly)v0, (Tuple2DReadOnly)centroid);
            if (!EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)v0Max, (Point2DReadOnly)centroid, (Vector2DReadOnly)extrapolationDirection)) {
                v0Max.scaleAdd(10.0, (Tuple2DReadOnly)extrapolationDirection, (Tuple2DReadOnly)v0);
            }
            Point2D vn1Max = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)centroid, (Point2DReadOnly)vn1, (Point2DReadOnly)v0, (Point2DReadOnly)vp1);
            extrapolationDirection.sub((Tuple2DReadOnly)vn1, (Tuple2DReadOnly)centroid);
            if (!EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)vn1Max, (Point2DReadOnly)centroid, (Vector2DReadOnly)extrapolationDirection)) {
                vn1Max.scaleAdd(10.0, (Tuple2DReadOnly)extrapolationDirection, (Tuple2DReadOnly)vn1);
            }
            Point2D firstExtrapolatedPoint = new Point2D();
            Point2D secondExtrapolatedPoint = new Point2D();
            firstExtrapolatedPoint.interpolate((Tuple2DReadOnly)v0, (Tuple2DReadOnly)v0Max, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            secondExtrapolatedPoint.interpolate((Tuple2DReadOnly)vn1, (Tuple2DReadOnly)vn1Max, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D pointOnLine = new Point2D((Tuple2DReadOnly)firstExtrapolatedPoint);
            Vector2D lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)secondExtrapolatedPoint, (Tuple2DReadOnly)firstExtrapolatedPoint);
            lineDirection.normalize();
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            rayDirection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection);
            int closestVertexIndexToRay = EuclidGeometryPolygonTools.closestVertexIndexToRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize4, (boolean)clockwiseOrdered);
            Point2DReadOnly closestVertexToRay = (Point2DReadOnly)convexPolygon2D.get(closestVertexIndexToRay);
            Point2D rayOriginProjected = new Point2D();
            EuclidGeometryPolygonTools.orthogonalProjectionOnConvexPolygon2D((Point2DReadOnly)rayOrigin, (List)convexPolygon2D, (int)hullSize4, (boolean)clockwiseOrdered, (Point2DBasics)rayOriginProjected);
            double distanceVertexToRay = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)closestVertexToRay, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
            double distancePojectionToRay = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)rayOriginProjected, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
            Point2D expectedClosestPoint = new Point2D();
            if (distanceVertexToRay < distancePojectionToRay) {
                expectedClosestPoint.set((Tuple2DReadOnly)closestVertexToRay);
            } else {
                expectedClosestPoint.set(rayOriginProjected);
            }
            Point2D actualClosestPoint = new Point2D();
            boolean success = EuclidGeometryPolygonTools.closestPointToNonInterectingRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize4, (boolean)clockwiseOrdered, (Point2DBasics)actualClosestPoint);
            Assertions.assertTrue((boolean)success);
            if (!expectedClosestPoint.epsilonEquals((EuclidGeometry)actualClosestPoint, 1.0E-12)) {
                double distanceActual;
                double distanceExpected;
                int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenRay2DAndConvexPolygon2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize4, (boolean)clockwiseOrdered, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
                if (numberOfIntersections > 0) {
                    System.err.println("Intersecting ray, test is bad");
                }
                if ((distanceExpected = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)expectedClosestPoint, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection)) > (distanceActual = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)actualClosestPoint, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection))) {
                    System.err.println("Test is bad");
                }
            }
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
        }
    }

    @Test
    public void testClosestVertexIndexToLine2D() throws Exception {
        Point2D vertex1 = new Point2D(0.0, 0.0);
        Point2D vertex2 = new Point2D(10.0, 0.0);
        Point2D vertex3 = new Point2D(0.0, 10.0);
        ArrayList<Point2D> convexPolygon2D = new ArrayList<Point2D>();
        convexPolygon2D.add(vertex1);
        convexPolygon2D.add(vertex2);
        convexPolygon2D.add(vertex3);
        int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D(convexPolygon2D);
        Point2D firstPointOnLine = new Point2D();
        Point2D secondPointOnLine = new Point2D();
        firstPointOnLine.set(-1.0, 1.0);
        secondPointOnLine.set(1.0, -1.0);
        Point2D closestVertex = (Point2D)convexPolygon2D.get(EuclidGeometryPolygonTools.closestVertexIndexToLine2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, convexPolygon2D, (int)hullSize));
        Assertions.assertTrue((vertex1 == closestVertex ? 1 : 0) != 0);
        firstPointOnLine.set(9.0, 0.0);
        secondPointOnLine.set(0.0, 1.0);
        closestVertex = (Point2D)convexPolygon2D.get(EuclidGeometryPolygonTools.closestVertexIndexToLine2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, convexPolygon2D, (int)hullSize));
        Assertions.assertTrue((vertex2 == closestVertex ? 1 : 0) != 0);
        firstPointOnLine.set(11.0, 0.0);
        secondPointOnLine.set(0.0, 12.0);
        closestVertex = (Point2D)convexPolygon2D.get(EuclidGeometryPolygonTools.closestVertexIndexToLine2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, convexPolygon2D, (int)hullSize));
        Assertions.assertTrue((vertex2 == closestVertex ? 1 : 0) != 0);
        firstPointOnLine.set(12.0, 0.0);
        secondPointOnLine.set(0.0, 11.0);
        closestVertex = (Point2D)convexPolygon2D.get(EuclidGeometryPolygonTools.closestVertexIndexToLine2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, convexPolygon2D, (int)hullSize));
        Assertions.assertTrue((vertex3 == closestVertex ? 1 : 0) != 0);
        firstPointOnLine.set(-1.0, 13.0);
        secondPointOnLine.set(1.0, 14.0);
        closestVertex = (Point2D)convexPolygon2D.get(EuclidGeometryPolygonTools.closestVertexIndexToLine2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine, convexPolygon2D, (int)hullSize));
        Assertions.assertTrue((vertex3 == closestVertex ? 1 : 0) != 0);
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D2 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize2 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D2);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D2.subList(0, hullSize2));
            }
            Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            closestVertex = null;
            double minDistance = Double.POSITIVE_INFINITY;
            for (Point2DReadOnly vertex : convexPolygon2D2.subList(0, hullSize2)) {
                double distance = EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)vertex, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                closestVertex = vertex;
            }
            int actualIndex = EuclidGeometryPolygonTools.closestVertexIndexToLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D2, (int)hullSize2);
            Assertions.assertTrue((closestVertex == convexPolygon2D2.get(actualIndex) ? 1 : 0) != 0);
        }
        List convexPolygon2D3 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize3 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D3);
        boolean clockwiseOrdered = random.nextBoolean();
        if (!clockwiseOrdered) {
            Collections.reverse(convexPolygon2D3.subList(0, hullSize3));
        }
        Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
        try {
            EuclidGeometryPolygonTools.closestVertexIndexToLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D3, (int)(convexPolygon2D3.size() + 1));
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.closestVertexIndexToLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D3, (int)-1);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testClosestVertexIndexToRay2D() throws Exception {
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            Point2D rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            Point2DReadOnly closestVertex = null;
            double minDistance = Double.POSITIVE_INFINITY;
            for (Point2DReadOnly vertex : convexPolygon2D.subList(0, hullSize)) {
                double distance = EuclidGeometryTools.distanceFromPoint2DToRay2D((Point2DReadOnly)vertex, (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                closestVertex = vertex;
            }
            int actualIndex = EuclidGeometryPolygonTools.closestVertexIndexToRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered);
            Assertions.assertTrue((closestVertex == convexPolygon2D.get(actualIndex) ? 1 : 0) != 0);
        }
        List convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
        boolean clockwiseOrdered = random.nextBoolean();
        if (!clockwiseOrdered) {
            Collections.reverse(convexPolygon2D.subList(0, hullSize));
        }
        Point2D rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Vector2D rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
        try {
            EuclidGeometryPolygonTools.closestVertexIndexToRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)(convexPolygon2D.size() + 1), (boolean)clockwiseOrdered);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.closestVertexIndexToRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)-1, (boolean)clockwiseOrdered);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testClosestVertexIndexToPoint2D() throws Exception {
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            Point2D query = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2DReadOnly closestVertex = (Point2DReadOnly)convexPolygon2D.get(0);
            for (Point2DReadOnly vertex : convexPolygon2D.subList(0, hullSize)) {
                if (!(query.distance(vertex) < query.distance(closestVertex))) continue;
                closestVertex = vertex;
            }
            int closestVertexIndex = EuclidGeometryPolygonTools.closestVertexIndexToPoint2D((Point2DReadOnly)query, (List)convexPolygon2D, (int)hullSize);
            Assertions.assertTrue((closestVertex == convexPolygon2D.get(closestVertexIndex) ? 1 : 0) != 0);
        }
        List convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
        boolean clockwiseOrdered = random.nextBoolean();
        if (!clockwiseOrdered) {
            Collections.reverse(convexPolygon2D.subList(0, hullSize));
        }
        try {
            EuclidGeometryPolygonTools.closestVertexIndexToPoint2D((Point2DReadOnly)new Point2D(), (List)convexPolygon2D, (int)(convexPolygon2D.size() + 1));
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.closestVertexIndexToPoint2D((Point2DReadOnly)new Point2D(), (List)convexPolygon2D, (int)-1);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testClosestEdgeIndexToPoint2D() throws Exception {
        Point2D pointOnEdge;
        Point2DReadOnly nextVertex;
        Point2DReadOnly vertex;
        int nextVertexIndex;
        int vertexIndex;
        Point2D centroid;
        boolean clockwiseOrdered;
        int hullSize;
        List convexPolygon2D;
        int i;
        Random random = new Random(324234L);
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            vertexIndex = random.nextInt(hullSize);
            nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize);
            vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            nextVertex = (Point2DReadOnly)convexPolygon2D.get(nextVertexIndex);
            pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            double alphaOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0);
            Point2D outsidePoint = new Point2D();
            outsidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, alphaOutside);
            int closestVertexIndex = EuclidGeometryPolygonTools.closestVertexIndexToPoint2D((Point2DReadOnly)outsidePoint, (List)convexPolygon2D, (int)hullSize);
            int closestEdgeIndex = EuclidGeometryPolygonTools.closestEdgeIndexToPoint2D((Point2DReadOnly)outsidePoint, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered);
            boolean isEdgeAdjacentToClosestVertex = closestEdgeIndex == closestVertexIndex || closestEdgeIndex == EuclidCoreTools.previous((int)closestVertexIndex, (int)hullSize);
            Assertions.assertTrue((boolean)isEdgeAdjacentToClosestVertex);
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.canObserverSeeEdge((int)closestEdgeIndex, (Point2DReadOnly)outsidePoint, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered));
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            vertexIndex = random.nextInt(hullSize);
            nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize);
            vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            nextVertex = (Point2DReadOnly)convexPolygon2D.get(nextVertexIndex);
            pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            double alphaInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point2D insidePoint = new Point2D();
            insidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, alphaInside);
            int expectedIndex = -1;
            double minDistance = Double.POSITIVE_INFINITY;
            for (int edgeIndex = 0; edgeIndex < hullSize; ++edgeIndex) {
                double distance = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((Point2DReadOnly)insidePoint, (Point2DReadOnly)((Point2DReadOnly)convexPolygon2D.get(edgeIndex)), (Point2DReadOnly)((Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize))));
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                expectedIndex = edgeIndex;
            }
            int actualIndex = EuclidGeometryPolygonTools.closestEdgeIndexToPoint2D((Point2DReadOnly)insidePoint, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered);
            Assertions.assertEquals((int)expectedIndex, (int)actualIndex);
        }
        List convexPolygon2D2 = new ArrayList<Point2D>();
        int hullSize2 = 0;
        boolean clockwiseOrdered2 = true;
        Assertions.assertEquals((int)-1, (int)EuclidGeometryPolygonTools.closestEdgeIndexToPoint2D((Point2DReadOnly)new Point2D(), convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2));
        convexPolygon2D2 = new ArrayList();
        convexPolygon2D2.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0));
        hullSize2 = 1;
        clockwiseOrdered2 = true;
        Assertions.assertEquals((int)-1, (int)EuclidGeometryPolygonTools.closestEdgeIndexToPoint2D((Point2DReadOnly)new Point2D(), convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2));
        convexPolygon2D2 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
        hullSize2 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D(convexPolygon2D2);
        clockwiseOrdered2 = random.nextBoolean();
        if (!clockwiseOrdered2) {
            Collections.reverse(convexPolygon2D2.subList(0, hullSize2));
        }
        try {
            EuclidGeometryPolygonTools.closestEdgeIndexToPoint2D((Point2DReadOnly)new Point2D(), convexPolygon2D2, (int)(convexPolygon2D2.size() + 1), (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.closestEdgeIndexToPoint2D((Point2DReadOnly)new Point2D(), convexPolygon2D2, (int)-1, (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNextEdgeIndexIntersectingWithLine2D() throws Exception {
        Vector2D lineDirection;
        int thirdEdgeIndex;
        Vector2D lineDirection2;
        Point2D pointOnLine;
        Point2DReadOnly edgeEnd;
        Point2DReadOnly edgeStart;
        Point2DReadOnly edgeEnd2;
        Point2DReadOnly edgeStart2;
        boolean clockwiseOrdered;
        int hullSize;
        ArrayList<Point2D> convexPolygon2D;
        int i;
        Random random = new Random(324234L);
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int firstEdgeIndex = random.nextInt(hullSize);
            int secondEdgeIndex = EuclidCoreTools.wrap((int)(random.nextInt(hullSize - 1) + firstEdgeIndex + 1), (int)hullSize);
            Point2D pointOnFirstEdge = new Point2D();
            edgeStart2 = (Point2DReadOnly)convexPolygon2D.get(firstEdgeIndex);
            edgeEnd2 = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)firstEdgeIndex, (int)hullSize));
            pointOnFirstEdge.interpolate((Tuple2DReadOnly)edgeStart2, (Tuple2DReadOnly)edgeEnd2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.05, (double)0.95));
            Point2D pointOnSecondEdge = new Point2D();
            edgeStart = (Point2DReadOnly)convexPolygon2D.get(secondEdgeIndex);
            edgeEnd = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)secondEdgeIndex, (int)hullSize));
            pointOnSecondEdge.interpolate((Tuple2DReadOnly)edgeStart, (Tuple2DReadOnly)edgeEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.05, (double)0.95));
            pointOnLine = new Point2D((Tuple2DReadOnly)pointOnFirstEdge);
            lineDirection2 = new Vector2D();
            lineDirection2.sub((Tuple2DReadOnly)pointOnSecondEdge, (Tuple2DReadOnly)pointOnFirstEdge);
            lineDirection2.normalize();
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLine);
            if (random.nextBoolean()) {
                lineDirection2.negate();
            }
            lineDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            int actualFirstEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, convexPolygon2D, (int)hullSize);
            int actualSecondEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)actualFirstEdgeIndex, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, convexPolygon2D, (int)hullSize);
            if (firstEdgeIndex < secondEdgeIndex) {
                Assertions.assertEquals((int)firstEdgeIndex, (int)actualFirstEdgeIndex);
                Assertions.assertEquals((int)secondEdgeIndex, (int)actualSecondEdgeIndex);
            } else {
                Assertions.assertEquals((int)secondEdgeIndex, (int)actualFirstEdgeIndex);
                Assertions.assertEquals((int)firstEdgeIndex, (int)actualSecondEdgeIndex);
            }
            thirdEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)actualSecondEdgeIndex, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, convexPolygon2D, (int)hullSize);
            Assertions.assertEquals((int)actualFirstEdgeIndex, (int)thirdEdgeIndex);
            Assertions.assertEquals((int)-2, (int)EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-2, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, convexPolygon2D, (int)hullSize));
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int vertexIndex = random.nextInt(hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            Vector2D nextEdgeDirection = new Vector2D();
            edgeStart2 = vertex;
            edgeEnd2 = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)vertexIndex, (int)hullSize));
            nextEdgeDirection.sub((Tuple2DReadOnly)edgeEnd2, (Tuple2DReadOnly)edgeStart2);
            nextEdgeDirection.normalize();
            Vector2D previousEdgeDirection = new Vector2D();
            edgeStart = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.previous((int)vertexIndex, (int)hullSize));
            edgeEnd = vertex;
            previousEdgeDirection.sub((Tuple2DReadOnly)edgeEnd, (Tuple2DReadOnly)edgeStart);
            previousEdgeDirection.normalize();
            pointOnLine = new Point2D((Tuple2DReadOnly)vertex);
            lineDirection2 = new Vector2D();
            lineDirection2.interpolate((Tuple2DReadOnly)nextEdgeDirection, (Tuple2DReadOnly)previousEdgeDirection, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.05, (double)0.95));
            lineDirection2.normalize();
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLine);
            if (random.nextBoolean()) {
                lineDirection2.negate();
            }
            lineDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            int firstEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, convexPolygon2D, (int)hullSize);
            int secondEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)firstEdgeIndex, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, convexPolygon2D, (int)hullSize);
            if (EuclidCoreTools.previous((int)vertexIndex, (int)hullSize) < vertexIndex) {
                Assertions.assertEquals((int)firstEdgeIndex, (int)EuclidCoreTools.previous((int)vertexIndex, (int)hullSize));
                Assertions.assertEquals((int)secondEdgeIndex, (int)vertexIndex);
            } else {
                Assertions.assertEquals((int)firstEdgeIndex, (int)vertexIndex);
                Assertions.assertEquals((int)secondEdgeIndex, (int)EuclidCoreTools.previous((int)vertexIndex, (int)hullSize));
            }
            thirdEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)secondEdgeIndex, (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection2, convexPolygon2D, (int)hullSize);
            Assertions.assertEquals((int)thirdEdgeIndex, (int)firstEdgeIndex);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int edgeIndex = random.nextInt(hullSize);
            Point2DReadOnly edgeStart3 = (Point2DReadOnly)convexPolygon2D.get(edgeIndex);
            Point2DReadOnly edgeEnd3 = (Point2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize));
            Point2D pointOnLine2 = new Point2D((Tuple2DReadOnly)edgeStart3);
            lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)edgeEnd3, (Tuple2DReadOnly)edgeStart3);
            lineDirection.normalize();
            pointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine2);
            if (random.nextBoolean()) {
                lineDirection.negate();
            }
            lineDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            int firstEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection, convexPolygon2D, (int)hullSize);
            int secondEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)firstEdgeIndex, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection, convexPolygon2D, (int)hullSize);
            int thirdEdgeIndex2 = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)secondEdgeIndex, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection, convexPolygon2D, (int)hullSize);
            int nextEdgeIndex = EuclidCoreTools.next((int)edgeIndex, (int)hullSize);
            int previousEdgeIndex = EuclidCoreTools.previous((int)edgeIndex, (int)hullSize);
            int[] expectedIndices = new int[]{firstEdgeIndex, secondEdgeIndex, thirdEdgeIndex2};
            int[] acutalIndices = new int[]{previousEdgeIndex, edgeIndex, nextEdgeIndex};
            Arrays.sort(acutalIndices);
            Arrays.sort(expectedIndices);
            Assertions.assertArrayEquals((int[])expectedIndices, (int[])acutalIndices);
            int fourthEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)thirdEdgeIndex2, (Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection, convexPolygon2D, (int)hullSize);
            Assertions.assertEquals((int)firstEdgeIndex, (int)fourthEdgeIndex);
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            int v0Index = random.nextInt(hullSize);
            int vn1Index = EuclidCoreTools.next((int)v0Index, (int)hullSize);
            int vn2Index = EuclidCoreTools.next((int)vn1Index, (int)hullSize);
            int vp1Index = EuclidCoreTools.previous((int)v0Index, (int)hullSize);
            Point2DReadOnly v0 = (Point2DReadOnly)convexPolygon2D.get(v0Index);
            Point2DReadOnly vn1 = (Point2DReadOnly)convexPolygon2D.get(vn1Index);
            Point2DReadOnly vn2 = (Point2DReadOnly)convexPolygon2D.get(vn2Index);
            Point2DReadOnly vp1 = (Point2DReadOnly)convexPolygon2D.get(vp1Index);
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea(convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            Point2D v0Max = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)centroid, (Point2DReadOnly)v0, (Point2DReadOnly)vn1, (Point2DReadOnly)vn2);
            Vector2D extrapolationDirection = new Vector2D();
            extrapolationDirection.sub((Tuple2DReadOnly)v0, (Tuple2DReadOnly)centroid);
            if (!EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)v0Max, (Point2DReadOnly)centroid, (Vector2DReadOnly)extrapolationDirection)) {
                v0Max.scaleAdd(10.0, (Tuple2DReadOnly)extrapolationDirection, (Tuple2DReadOnly)v0);
            }
            Point2D vn1Max = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((Point2DReadOnly)centroid, (Point2DReadOnly)vn1, (Point2DReadOnly)v0, (Point2DReadOnly)vp1);
            extrapolationDirection.sub((Tuple2DReadOnly)vn1, (Tuple2DReadOnly)centroid);
            if (!EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)vn1Max, (Point2DReadOnly)centroid, (Vector2DReadOnly)extrapolationDirection)) {
                vn1Max.scaleAdd(10.0, (Tuple2DReadOnly)extrapolationDirection, (Tuple2DReadOnly)vn1);
            }
            Point2D firstExtrapolatedPoint = new Point2D();
            Point2D secondExtrapolatedPoint = new Point2D();
            firstExtrapolatedPoint.interpolate((Tuple2DReadOnly)v0, (Tuple2DReadOnly)v0Max, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            secondExtrapolatedPoint.interpolate((Tuple2DReadOnly)vn1, (Tuple2DReadOnly)vn1Max, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D pointOnLine3 = new Point2D();
            pointOnLine3.interpolate((Tuple2DReadOnly)firstExtrapolatedPoint, (Tuple2DReadOnly)secondExtrapolatedPoint, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineDirection3 = new Vector2D();
            lineDirection3.sub((Tuple2DReadOnly)secondExtrapolatedPoint, (Tuple2DReadOnly)firstExtrapolatedPoint);
            lineDirection3.normalize();
            lineDirection3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Assertions.assertEquals((int)-2, (int)EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine3, (Vector2DReadOnly)lineDirection3, convexPolygon2D, (int)hullSize));
        }
        Point2D vertex = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        convexPolygon2D = new ArrayList<Point2D>();
        convexPolygon2D.add(vertex);
        hullSize = 1;
        Point2D pointOnLine4 = new Point2D((Tuple2DReadOnly)vertex);
        Vector2D lineDirection4 = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
        Assertions.assertEquals((int)-2, (int)EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine4, (Vector2DReadOnly)lineDirection4, convexPolygon2D, (int)hullSize));
        for (int i2 = 0; i2 < 1000; ++i2) {
            Point2D vertex1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D vertex2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            ArrayList<Point2D> convexPolygon2D2 = new ArrayList<Point2D>();
            convexPolygon2D2.add(vertex1);
            convexPolygon2D2.add(vertex2);
            int hullSize2 = 2;
            Point2D pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex1, (Tuple2DReadOnly)vertex2, random.nextDouble());
            Point2D pointOutsideEdge = new Point2D();
            pointOutsideEdge.interpolate((Tuple2DReadOnly)vertex1, (Tuple2DReadOnly)vertex2, 1.0 + random.nextDouble());
            Point2D pointOnLine5 = new Point2D();
            lineDirection = new Vector2D();
            lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            pointOnLine5.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnEdge);
            int firstEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine5, (Vector2DReadOnly)lineDirection, convexPolygon2D2, (int)hullSize2);
            int secondEdgeIndex = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)firstEdgeIndex, (Point2DReadOnly)pointOnLine5, (Vector2DReadOnly)lineDirection, convexPolygon2D2, (int)hullSize2);
            Assertions.assertEquals((int)0, (int)firstEdgeIndex);
            Assertions.assertEquals((int)1, (int)secondEdgeIndex);
            int thirdEdgeIndex3 = EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)secondEdgeIndex, (Point2DReadOnly)pointOnLine5, (Vector2DReadOnly)lineDirection, convexPolygon2D2, (int)hullSize2);
            Assertions.assertEquals((int)firstEdgeIndex, (int)thirdEdgeIndex3);
            lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-10.0, (double)10.0);
            pointOnLine5.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOutsideEdge);
            Assertions.assertEquals((int)-2, (int)EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine5, (Vector2DReadOnly)lineDirection, convexPolygon2D2, (int)hullSize2));
        }
        List convexPolygon2D3 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize3 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D3);
        boolean clockwiseOrdered2 = random.nextBoolean();
        if (!clockwiseOrdered2) {
            Collections.reverse(convexPolygon2D3.subList(0, hullSize3));
        }
        pointOnLine4 = new Point2D();
        lineDirection = new Vector2D();
        try {
            EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine4, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D3, (int)(convexPolygon2D3.size() + 1));
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-1, (Point2DReadOnly)pointOnLine4, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D3, (int)-1);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)-3, (Point2DReadOnly)pointOnLine4, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D3, (int)hullSize3);
            Assertions.fail((String)("Should have thrown an " + IndexOutOfBoundsException.class.getSimpleName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.nextEdgeIndexIntersectingWithLine2D((int)hullSize3, (Point2DReadOnly)pointOnLine4, (Vector2DReadOnly)lineDirection, (List)convexPolygon2D3, (int)hullSize3);
            Assertions.fail((String)("Should have thrown an " + IndexOutOfBoundsException.class.getSimpleName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testCanObserverSeeEdge() throws Exception {
        int edgeIndex;
        boolean clockwiseOrdered;
        int hullSize;
        List convexPolygon2D;
        int i;
        Random random = new Random(324234L);
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            Point2D pointInside = new Point2D();
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            int vertexIndex = random.nextInt(hullSize);
            int nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(nextVertexIndex);
            Point2D pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            pointInside.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, random.nextDouble());
            for (edgeIndex = 0; edgeIndex < hullSize; ++edgeIndex) {
                Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.canObserverSeeEdge((int)edgeIndex, (Point2DReadOnly)pointInside, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered));
            }
        }
        for (i = 0; i < 1000; ++i) {
            convexPolygon2D = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
            hullSize = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D);
            clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            Point2D observer = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            edgeIndex = random.nextInt(hullSize);
            Point2D rayOrigin = new Point2D();
            rayOrigin.interpolate((Tuple2DReadOnly)convexPolygon2D.get(edgeIndex), (Tuple2DReadOnly)convexPolygon2D.get(EuclidCoreTools.next((int)edgeIndex, (int)hullSize)), 0.5);
            Vector2D rayDirection = new Vector2D();
            rayDirection.sub((Tuple2DReadOnly)observer, (Tuple2DReadOnly)rayOrigin);
            rayDirection.normalize();
            rayOrigin.scaleAdd(0.001, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            int numberOfIntersections = EuclidGeometryPolygonTools.intersectionBetweenRay2DAndConvexPolygon2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
            if (EuclidGeometryPolygonTools.canObserverSeeEdge((int)edgeIndex, (Point2DReadOnly)observer, (List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered)) {
                Assertions.assertEquals((int)0, (int)numberOfIntersections);
                continue;
            }
            Assertions.assertEquals((int)1, (int)numberOfIntersections);
        }
        List convexPolygon2D2 = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)10.0, (double)10.0, (int)100);
        int hullSize2 = EuclidGeometryPolygonTools.inPlaceGrahamScanConvexHull2D((List)convexPolygon2D2);
        boolean clockwiseOrdered2 = random.nextBoolean();
        if (!clockwiseOrdered2) {
            Collections.reverse(convexPolygon2D2.subList(0, hullSize2));
        }
        Point2D observer = new Point2D();
        try {
            EuclidGeometryPolygonTools.canObserverSeeEdge((int)0, (Point2DReadOnly)observer, (List)convexPolygon2D2, (int)(convexPolygon2D2.size() + 1), (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.canObserverSeeEdge((int)0, (Point2DReadOnly)observer, (List)convexPolygon2D2, (int)-1, (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.canObserverSeeEdge((int)-1, (Point2DReadOnly)observer, (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IndexOutOfBoundsException.class.getSimpleName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            EuclidGeometryPolygonTools.canObserverSeeEdge((int)hullSize2, (Point2DReadOnly)observer, (List)convexPolygon2D2, (int)hullSize2, (boolean)clockwiseOrdered2);
            Assertions.fail((String)("Should have thrown an " + IndexOutOfBoundsException.class.getSimpleName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testMoveElementToEnd() throws Exception {
        Random random = new Random(35L);
        for (int i = 0; i < 1000; ++i) {
            int j;
            int numberOfPoints = 100;
            ArrayList<Integer> points = new ArrayList<Integer>();
            for (int j2 = 0; j2 < numberOfPoints; ++j2) {
                points.add(j2);
            }
            ArrayList pointsCopy = new ArrayList(points);
            int listSize = random.nextInt(numberOfPoints) + 1;
            int removeIndex = random.nextInt(listSize);
            Integer removedElement = (Integer)pointsCopy.remove(removeIndex);
            EuclidGeometryPolygonTools.moveElementToEnd(points, (int)removeIndex, (int)listSize);
            Assertions.assertTrue((points.get(listSize - 1) == removedElement ? 1 : 0) != 0);
            for (j = removeIndex; j < listSize - 1; ++j) {
                Assertions.assertTrue((points.get(j) == pointsCopy.get(j) ? 1 : 0) != 0);
            }
            for (j = listSize; j < numberOfPoints; ++j) {
                Assertions.assertTrue((points.get(j) == pointsCopy.get(j - 1) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testFindMinXMaxYVertexIndex() throws Exception {
        int numberOfPoints;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            numberOfPoints = 100;
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            double minX = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
            double minXMaxY = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
            for (int j = 0; j < numberOfPoints; ++j) {
                double y;
                double x;
                if (random.nextDouble() < 0.15) {
                    x = EuclidCoreRandomTools.nextDouble((Random)random, (double)minX, (double)(minX + 10.0));
                    y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                } else {
                    x = minX;
                    y = EuclidCoreRandomTools.nextDouble((Random)random, (double)(minXMaxY - 10.0), (double)minXMaxY);
                }
                points.add(new Point2D(x, y));
            }
            int expectedMinXMaxYIndex = random.nextInt(numberOfPoints);
            points.set(expectedMinXMaxYIndex, new Point2D(minX, minXMaxY));
            int actualMinXMaxYIndex = EuclidGeometryPolygonTools.findMinXMaxYVertexIndex(points, (int)numberOfPoints);
            Assertions.assertEquals((int)expectedMinXMaxYIndex, (int)actualMinXMaxYIndex);
        }
        for (i = 0; i < 1000; ++i) {
            numberOfPoints = 100;
            int listSize = numberOfPoints + random.nextInt(100);
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            double minX = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
            double minXMaxY = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
            for (int j = 0; j < listSize; ++j) {
                double y;
                double x;
                if (random.nextDouble() < 0.15) {
                    x = EuclidCoreRandomTools.nextDouble((Random)random, (double)minX, (double)(minX + 10.0));
                    y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                } else {
                    x = minX;
                    y = EuclidCoreRandomTools.nextDouble((Random)random, (double)(minXMaxY - 10.0), (double)minXMaxY);
                }
                points.add(new Point2D(x, y));
            }
            int expectedMinXMaxYIndex = random.nextInt(numberOfPoints);
            points.set(expectedMinXMaxYIndex, new Point2D(minX, minXMaxY));
            int actualMinXMaxYIndex = EuclidGeometryPolygonTools.findMinXMaxYVertexIndex(points, (int)numberOfPoints);
            Assertions.assertEquals((int)expectedMinXMaxYIndex, (int)actualMinXMaxYIndex);
        }
    }

    @Test
    public void testFindVertexIndex() throws Exception {
        int index;
        int bestIndex;
        Bound yBound;
        Bound xBound;
        boolean isXPriority;
        Vertex2DSupplier supplier;
        int i;
        Random random = new Random(23524L);
        for (i = 0; i < 1000; ++i) {
            supplier = EuclidGeometryRandomTools.nextVertex2DSupplier((Random)random, (int)200);
            isXPriority = true;
            xBound = Bound.MAX;
            yBound = random.nextBoolean() ? Bound.MIN : Bound.MAX;
            bestIndex = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)supplier, (boolean)isXPriority, (Bound)xBound, (Bound)yBound);
            for (index = 0; index < supplier.getNumberOfVertices(); ++index) {
                Assertions.assertTrue((supplier.getVertex(index).getX() <= supplier.getVertex(bestIndex).getX() ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            supplier = EuclidGeometryRandomTools.nextVertex2DSupplier((Random)random, (int)200);
            isXPriority = true;
            xBound = Bound.MIN;
            yBound = random.nextBoolean() ? Bound.MIN : Bound.MAX;
            bestIndex = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)supplier, (boolean)isXPriority, (Bound)xBound, (Bound)yBound);
            for (index = 0; index < supplier.getNumberOfVertices(); ++index) {
                Assertions.assertTrue((supplier.getVertex(index).getX() >= supplier.getVertex(bestIndex).getX() ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            supplier = EuclidGeometryRandomTools.nextVertex2DSupplier((Random)random, (int)200);
            isXPriority = false;
            xBound = random.nextBoolean() ? Bound.MIN : Bound.MAX;
            yBound = Bound.MAX;
            bestIndex = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)supplier, (boolean)isXPriority, (Bound)xBound, (Bound)yBound);
            for (index = 0; index < supplier.getNumberOfVertices(); ++index) {
                Assertions.assertTrue((supplier.getVertex(index).getY() <= supplier.getVertex(bestIndex).getY() ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            supplier = EuclidGeometryRandomTools.nextVertex2DSupplier((Random)random, (int)200);
            isXPriority = false;
            xBound = random.nextBoolean() ? Bound.MIN : Bound.MAX;
            yBound = Bound.MIN;
            bestIndex = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)supplier, (boolean)isXPriority, (Bound)xBound, (Bound)yBound);
            for (index = 0; index < supplier.getNumberOfVertices(); ++index) {
                Assertions.assertTrue((supplier.getVertex(index).getY() >= supplier.getVertex(bestIndex).getY() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testIsConvexPolygonConcyclic() {
        int numberOfVertices;
        int i;
        Random random = new Random(4365L);
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(20);
            List concyclicPoints = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)1.0, (int)numberOfVertices);
            if (random.nextBoolean()) {
                Collections.reverse(concyclicPoints);
            }
            if (concyclicPoints.isEmpty()) {
                Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isConvexPolygon2DConcyclic((List)concyclicPoints, (int)numberOfVertices, (double)1.0E-9), (String)("Iteration " + i));
                continue;
            }
            Assertions.assertTrue((boolean)EuclidGeometryPolygonTools.isConvexPolygon2DConcyclic((List)concyclicPoints, (int)numberOfVertices, (double)1.0E-9), (String)("Iteration " + i));
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(16) + 4;
            Point2D circumcenter = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            List notConcyclicPoints = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (Point2DReadOnly)circumcenter, (double)1.0, (int)numberOfVertices);
            if (random.nextBoolean()) {
                Collections.reverse(notConcyclicPoints);
            }
            Point2D vertexUnmodified = new Point2D((Tuple2DReadOnly)notConcyclicPoints.get(random.nextInt(numberOfVertices)));
            Point2D vertex = (Point2D)notConcyclicPoints.get(random.nextInt(numberOfVertices));
            UnitVector2D directionAway = new UnitVector2D();
            directionAway.sub((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)circumcenter);
            double distanceOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0E-9, (double)1.0);
            vertex.scaleAdd(distanceOutside, (Tuple2DReadOnly)directionAway, (Tuple2DReadOnly)vertex);
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isConvexPolygon2DConcyclic((List)notConcyclicPoints, (int)numberOfVertices, (double)1.0E-9), (String)("Iteration " + i));
            vertex.set(vertexUnmodified);
            double radius = vertex.distance((Point2DReadOnly)circumcenter);
            double distanceInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0E-9, (double)radius);
            vertex.scaleAdd(-distanceInside, (Tuple2DReadOnly)directionAway, (Tuple2DReadOnly)vertex);
            Assertions.assertFalse((boolean)EuclidGeometryPolygonTools.isConvexPolygon2DConcyclic((List)notConcyclicPoints, (int)numberOfVertices, (double)1.0E-9), (String)("Iteration " + i));
        }
    }

    private static interface ConvexHullAlgorithm {
        public int process(List<? extends Point2DReadOnly> var1, int var2);
    }
}

