/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class Axis2DTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testOrdinals() {
        Assertions.assertEquals((int)Axis2D.X.ordinal(), (int)0);
        Assertions.assertEquals((int)Axis2D.Y.ordinal(), (int)1);
    }

    @Test
    public void testDot() {
        Random random = new Random(3249783L);
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 2; ++j) {
                Axis2D axis = Axis2D.values[j];
                Vector2D axisVector = new Vector2D((Tuple2DReadOnly)axis);
                Vector2D otherVector = EuclidCoreRandomTools.nextVector2D((Random)random);
                Assertions.assertEquals((double)axisVector.dot((Tuple2DReadOnly)otherVector), (double)axis.dot((Tuple2DReadOnly)otherVector));
            }
        }
    }

    @Test
    public void testExtract() {
        Random random = new Random(436566L);
        for (int i = 0; i < 1000; ++i) {
            Point2D point2D = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Assertions.assertEquals((double)point2D.getX(), (double)Axis2D.X.extract((Tuple2DReadOnly)point2D));
            Assertions.assertEquals((double)point2D.getY(), (double)Axis2D.Y.extract((Tuple2DReadOnly)point2D));
            for (int j = 0; j < 2; ++j) {
                Assertions.assertEquals((double)point2D.getElement(j), (double)Axis2D.values[j].extract((Tuple2DReadOnly)point2D));
            }
        }
    }

    @Test
    public void testInsert() {
        Random random = new Random(436566L);
        for (int i = 0; i < 1000; ++i) {
            Point2D original = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D actual = new Point2D((Tuple2DReadOnly)original);
            Point2D expected = new Point2D((Tuple2DReadOnly)original);
            double newValue = random.nextDouble();
            for (int j = 0; j < 2; ++j) {
                Axis2D.values[j].insert((Tuple2DBasics)actual, newValue);
                expected.setElement(j, newValue);
                Assertions.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testVectorValues() {
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector2D(1.0, 0.0), (EuclidGeometry)Axis2D.X, (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector2D(0.0, 1.0), (EuclidGeometry)Axis2D.Y, (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector2D(-1.0, 0.0), (EuclidGeometry)Axis2D.X.negated(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector2D(0.0, -1.0), (EuclidGeometry)Axis2D.Y.negated(), (double)0.0);
    }

    @Test
    public void testOther() {
        Assertions.assertEquals((Object)Axis2D.X.other(), (Object)Axis2D.Y);
        Assertions.assertEquals((Object)Axis2D.Y.other(), (Object)Axis2D.X);
    }
}

