/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.exceptions.NotAMatrix2DException;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Tuple2DBasicsTest;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class Point2DBasicsTest<T extends Point2DBasics>
extends Tuple2DBasicsTest<T> {
    @Test
    public void testDistance() {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(expectedDistance);
            Point2DBasics p1 = (Point2DBasics)this.createRandomTuple(random);
            Point2DBasics p2 = (Point2DBasics)this.createTuple(p1.getX() + translation.getX(), p1.getY() + translation.getY());
            double actualDistance = p1.distance((Point2DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceSquared() {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            double expectedDistanceSquared = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(EuclidCoreTools.squareRoot((double)expectedDistanceSquared));
            Point2DBasics p1 = (Point2DBasics)this.createRandomTuple(random);
            Point2DBasics p2 = (Point2DBasics)this.createTuple(p1.getX() + translation.getX(), p1.getY() + translation.getY());
            double actualDistanceSquared = p1.distanceSquared((Point2DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistanceSquared, (double)actualDistanceSquared, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceXY() {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(expectedDistance);
            Point2DBasics p1 = (Point2DBasics)this.createRandomTuple(random);
            Point3D p2 = new Point3D(p1.getX() + translation.getX(), p1.getY() + translation.getY(), random.nextDouble());
            double actualDistance = p1.distanceXY((Point3DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceXYSquared() {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            double expectedDistanceSquared = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(EuclidCoreTools.squareRoot((double)expectedDistanceSquared));
            Point2DBasics p1 = (Point2DBasics)this.createRandomTuple(random);
            Point3D p2 = new Point3D(p1.getX() + translation.getX(), p1.getY() + translation.getY(), random.nextDouble());
            double actualDistance = p1.distanceXYSquared((Point3DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistanceSquared, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceFromOrigin() throws Exception {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(expectedDistance);
            Point2DBasics p = (Point2DBasics)this.createTuple(translation.getX(), translation.getY());
            double actualDistance = p.distanceFromOrigin();
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceFromOriginSquared() throws Exception {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            double expectedDistanceSquared = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(EuclidCoreTools.squareRoot((double)expectedDistanceSquared));
            Point2DBasics p = (Point2DBasics)this.createTuple(translation.getX(), translation.getY());
            double actualDistance = p.distanceFromOriginSquared();
            Assertions.assertEquals((double)expectedDistanceSquared, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            Point2DBasics original = (Point2DBasics)this.createRandomTuple(random);
            Point2DBasics actual = (Point2DBasics)this.createEmptyTuple();
            Point2DBasics expected = (Point2DBasics)this.createEmptyTuple();
            RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
            rigidBodyTransform.getRotation().setToYawOrientation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            rigidBodyTransform.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((Tuple2DReadOnly)original);
            rigidBodyTransform.transform(expected);
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            rigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            try {
                actual.applyTransform((Transform)rigidBodyTransform);
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException or NotAnOrientation2DException.");
            }
            catch (NotAMatrix2DException | NotAnOrientation2DException throwable) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException or NotAnOrientation2DException.");
            }
            try {
                actual.applyTransform((Transform)rigidBodyTransform, true);
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException or NotAnOrientation2DException.");
            }
            catch (NotAMatrix2DException | NotAnOrientation2DException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException or NotAnOrientation2DException.");
            }
            actual.applyTransform((Transform)rigidBodyTransform, false);
        }
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            Point2DBasics original = (Point2DBasics)this.createRandomTuple(random);
            Point2DBasics actual = (Point2DBasics)this.createEmptyTuple();
            Point2DBasics expected = (Point2DBasics)this.createEmptyTuple();
            RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
            rigidBodyTransform.getRotation().setToYawOrientation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            rigidBodyTransform.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((Tuple2DReadOnly)original);
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform);
            actual.applyInverseTransform((Transform)rigidBodyTransform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform, false);
            actual.applyInverseTransform((Transform)rigidBodyTransform, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform, true);
            actual.applyInverseTransform((Transform)rigidBodyTransform, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            rigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            try {
                actual.applyInverseTransform((Transform)rigidBodyTransform);
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException or NotAnOrientation2DException.");
            }
            catch (NotAMatrix2DException | NotAnOrientation2DException throwable) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException or NotAnOrientation2DException.");
            }
            try {
                actual.applyInverseTransform((Transform)rigidBodyTransform, true);
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException or NotAnOrientation2DException.");
            }
            catch (NotAMatrix2DException | NotAnOrientation2DException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException or NotAnOrientation2DException.");
            }
            actual.applyInverseTransform((Transform)rigidBodyTransform, false);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Point2D pointB;
            Point2D pointA = EuclidCoreRandomTools.nextPoint2D((Random)random);
            if (pointA.epsilonEquals((EuclidGeometry)(pointB = EuclidCoreRandomTools.nextPoint2D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, EuclidCoreTools.squareRoot((double)3.0) * this.getEpsilon()));
            } else if (EuclidCoreTools.norm((double)(pointA.getX() - pointB.getX()), (double)(pointA.getY() - pointB.getY())) <= this.getEpsilon()) {
                Assertions.assertTrue((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, this.getEpsilon()));
            } else {
                Assertions.assertFalse((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, this.getEpsilon()));
            }
            pointA = EuclidCoreRandomTools.nextPoint2D((Random)random);
            pointB = new Point2D((Tuple2DReadOnly)pointA);
            Assertions.assertTrue((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, 0.0));
            pointB.set(pointA.getX() + 0.9 * this.getEpsilon(), pointA.getY());
            Assertions.assertTrue((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, this.getEpsilon()));
            pointB.set(pointA.getX() + 1.1 * this.getEpsilon(), pointA.getY());
            Assertions.assertFalse((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, this.getEpsilon()));
            pointB.set(pointA.getX(), pointA.getY() + 0.9 * this.getEpsilon());
            Assertions.assertTrue((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, this.getEpsilon()));
            pointB.set(pointA.getX(), pointA.getY() + 1.1 * this.getEpsilon());
            Assertions.assertFalse((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, this.getEpsilon()));
        }
    }
}

