/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.TransformTest;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public abstract class RigidBodyTransformBasicsTest<T extends RigidBodyTransformBasics>
extends TransformTest<T> {
    @Override
    public abstract T createRandomTransform(Random var1);

    @Override
    public abstract T createRandomTransform2D(Random var1);

    public abstract T copy(T var1);

    public abstract T identity();

    public abstract double getEpsilon();

    @Test
    public void testMultiply() throws Exception {
        T t2;
        T t1;
        int i;
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            T transform = this.createRandomTransform(random);
            T inverse = this.copy(transform);
            inverse.invert();
            Assertions.assertTrue((boolean)transform.hasRotation());
            Assertions.assertTrue((boolean)transform.hasTranslation());
            transform.multiply(inverse);
            Assertions.assertFalse((boolean)transform.hasRotation());
            Assertions.assertFalse((boolean)transform.hasTranslation());
            Assertions.assertTrue((boolean)transform.epsilonEquals(this.identity(), this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            this.checkMultiplyAgainstEJML(t1, t2);
        }
        for (i = 0; i < 1000; ++i) {
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            this.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply(t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t1.setRotationToZero();
            this.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertFalse((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply(t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            this.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply(t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            this.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertFalse((boolean)t1.hasTranslation());
            t1.multiply(t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2.setRotationToZero();
            this.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertFalse((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply(t2);
            Assertions.assertFalse((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2.setTranslationToZero();
            this.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertFalse((boolean)t1.hasTranslation());
            t1.multiply(t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertFalse((boolean)t1.hasTranslation());
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.getRotation().set((Orientation3DReadOnly)t1.getRotation());
            t2.invertRotation();
            this.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply(t2);
            Assertions.assertFalse((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)t1.getTranslation());
            negateTranslation.negate();
            t1.inverseTransform((Vector3DBasics)negateTranslation);
            t2.getTranslation().set((Tuple3DReadOnly)negateTranslation);
            this.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply(t2);
            Assertions.assertTrue((boolean)t1.hasRotation());
            Assertions.assertFalse((boolean)t1.hasTranslation());
        }
    }

    @Test
    public void testResetRotation() throws Exception {
        Random random = new Random(42353L);
        T original = this.createRandomTransform(random);
        T transform = this.copy(original);
        Assertions.assertTrue((boolean)transform.hasRotation());
        transform.setRotationToZero();
        Assertions.assertFalse((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.getTranslation().equals((EuclidGeometry)original.getTranslation()));
        Assertions.assertTrue((boolean)transform.getRotation().equals((EuclidGeometry)this.identity().getRotation()));
    }

    @Test
    public void testResetTranslation() throws Exception {
        Random random = new Random(42353L);
        T original = this.createRandomTransform(random);
        T transform = this.copy(original);
        Assertions.assertTrue((boolean)transform.hasTranslation());
        transform.setTranslationToZero();
        Assertions.assertFalse((boolean)transform.hasTranslation());
        Assertions.assertTrue((transform.getTranslationX() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getTranslationY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getTranslationZ() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)transform.getRotation().equals((EuclidGeometry)original.getRotation()));
    }

    @Test
    public void testNormalizeRotationPart() throws Exception {
        int j;
        Random random = new Random(42353L);
        T original = this.createRandomTransform(random);
        T transform = this.copy(original);
        double corruptionFactor = 0.1;
        RotationMatrix rotationPart = new RotationMatrix();
        original.getRotation().get((CommonMatrix3DBasics)rotationPart);
        double m00 = rotationPart.getM00() + corruptionFactor * random.nextDouble();
        double m01 = rotationPart.getM01() + corruptionFactor * random.nextDouble();
        double m02 = rotationPart.getM02() + corruptionFactor * random.nextDouble();
        double m10 = rotationPart.getM10() + corruptionFactor * random.nextDouble();
        double m11 = rotationPart.getM11() + corruptionFactor * random.nextDouble();
        double m12 = rotationPart.getM12() + corruptionFactor * random.nextDouble();
        double m20 = rotationPart.getM20() + corruptionFactor * random.nextDouble();
        double m21 = rotationPart.getM21() + corruptionFactor * random.nextDouble();
        double m22 = rotationPart.getM22() + corruptionFactor * random.nextDouble();
        transform.getRotation().setRotationMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        transform.normalizeRotationPart();
        Matrix3D rotation = new Matrix3D();
        Vector3D vector1 = new Vector3D();
        Vector3D vector2 = new Vector3D();
        rotation.set((Orientation3DReadOnly)transform.getRotation());
        for (j = 0; j < 3; ++j) {
            rotation.getRow(j, (Tuple3DBasics)vector1);
            Assertions.assertEquals((double)1.0, (double)vector1.norm(), (double)this.getEpsilon());
            rotation.getColumn(j, (Tuple3DBasics)vector1);
            Assertions.assertEquals((double)1.0, (double)vector1.norm(), (double)this.getEpsilon());
        }
        for (j = 0; j < 3; ++j) {
            rotation.getRow(j, (Tuple3DBasics)vector1);
            rotation.getRow((j + 1) % 3, (Tuple3DBasics)vector2);
            Assertions.assertEquals((double)0.0, (double)vector1.dot((Tuple3DReadOnly)vector2), (double)this.getEpsilon());
            rotation.getColumn(j, (Tuple3DBasics)vector1);
            rotation.getColumn((j + 1) % 3, (Tuple3DBasics)vector2);
            Assertions.assertEquals((double)0.0, (double)vector1.dot((Tuple3DReadOnly)vector2), (double)this.getEpsilon());
        }
        corruptionFactor = 9.0E-13;
        m00 = 1.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m01 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m02 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m10 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m11 = 1.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m12 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m20 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m21 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m22 = 1.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        transform.getRotation().setRotationMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        Assertions.assertFalse((boolean)transform.hasRotation());
        transform.getTranslation().set(0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)transform.getRotation().equals((EuclidGeometry)this.identity().getRotation()));
        Assertions.assertTrue((boolean)transform.epsilonEquals(this.identity(), corruptionFactor));
        transform.normalizeRotationPart();
        Assertions.assertTrue((boolean)transform.getRotation().epsilonEquals((EuclidGeometry)this.identity().getRotation(), this.getEpsilon()));
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(2342L);
        T transform = this.createRandomTransform(random);
        Assertions.assertTrue((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.hasTranslation());
        Assertions.assertFalse((boolean)transform.equals(this.identity()));
        transform.setToZero();
        Assertions.assertFalse((boolean)transform.hasRotation());
        Assertions.assertFalse((boolean)transform.hasTranslation());
        Assertions.assertTrue((boolean)transform.equals(this.identity()));
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(2342L);
        T transform = this.createRandomTransform(random);
        Assertions.assertTrue((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.hasTranslation());
        Assertions.assertFalse((boolean)transform.containsNaN());
        transform.setToNaN();
        Assertions.assertTrue((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.hasTranslation());
        RotationMatrix rotationMatrix = new RotationMatrix();
        transform.getRotation().get((CommonMatrix3DBasics)rotationMatrix);
        double x = transform.getTranslationX();
        double y = transform.getTranslationY();
        double z = transform.getTranslationZ();
        double m00 = rotationMatrix.getM00();
        double m01 = rotationMatrix.getM01();
        double m02 = rotationMatrix.getM02();
        double m10 = rotationMatrix.getM10();
        double m11 = rotationMatrix.getM11();
        double m12 = rotationMatrix.getM12();
        double m20 = rotationMatrix.getM20();
        double m21 = rotationMatrix.getM21();
        double m22 = rotationMatrix.getM22();
        Assertions.assertEquals((double)m00, (double)Double.NaN);
        Assertions.assertEquals((double)m01, (double)Double.NaN);
        Assertions.assertEquals((double)m02, (double)Double.NaN);
        Assertions.assertEquals((double)m10, (double)Double.NaN);
        Assertions.assertEquals((double)m11, (double)Double.NaN);
        Assertions.assertEquals((double)m12, (double)Double.NaN);
        Assertions.assertEquals((double)m20, (double)Double.NaN);
        Assertions.assertEquals((double)m21, (double)Double.NaN);
        Assertions.assertEquals((double)m22, (double)Double.NaN);
        Assertions.assertEquals((double)x, (double)Double.NaN);
        Assertions.assertEquals((double)y, (double)Double.NaN);
        Assertions.assertEquals((double)z, (double)Double.NaN);
    }

    @Test
    public void testContainsNaN() throws Exception {
        Random random = new Random(143234L);
        T transform = this.createRandomTransform(random);
        transform.getRotation().setRotationMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        transform.getTranslation().set(0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getRotation().setRotationMatrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        transform.getTranslation().setX(Double.NaN);
        transform.getTranslation().setY(0.0);
        transform.getTranslation().setZ(0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getTranslation().setX(0.0);
        transform.getTranslation().setY(Double.NaN);
        transform.getTranslation().setZ(0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.getTranslation().setX(0.0);
        transform.getTranslation().setY(0.0);
        transform.getTranslation().setZ(Double.NaN);
        Assertions.assertTrue((boolean)transform.containsNaN());
    }

    @Test
    public void testAppendOrientation() throws Exception {
        Random random = new Random(46575L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            T orientationTransform = this.createRandomTransform(random);
            orientationTransform.getRotation().set((Orientation3DReadOnly)orientation);
            orientationTransform.getTranslation().set(0.0, 0.0, 0.0);
            T expected = this.copy(original);
            expected.multiply(orientationTransform);
            T actual = this.copy(original);
            actual.appendOrientation((Orientation3DReadOnly)orientation);
            Assertions.assertTrue((boolean)expected.epsilonEquals(actual, this.getEpsilon()));
            Assertions.assertTrue((boolean)expected.equals(actual));
        }
    }

    @Test
    public void testAppendYawPitchRoll() throws Exception {
        RotationMatrix expectedRotation;
        T original;
        int i;
        Random random = new Random(35454L);
        T expected = this.createRandomTransform(random);
        T actual = this.createRandomTransform(random);
        for (i = 0; i < 1000; ++i) {
            RotationMatrix expectedRotation2 = new RotationMatrix();
            T original2 = this.createRandomTransform(random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation2.set((Orientation3DReadOnly)original2.getRotation());
            expectedRotation2.appendYawRotation(yaw);
            expected.set((RotationMatrixReadOnly)expectedRotation2, (Tuple3DReadOnly)original2.getTranslation());
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set(original2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)expected.geometricallyEquals(actual, this.getEpsilon()));
            original2.setToZero();
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set(original2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.appendYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original2 = this.createRandomTransform(random);
            yaw = 0.0;
            actual.set(original2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original2.getRotation().setToYawOrientation(-yaw);
            actual.set(original2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendYawRotation(yaw);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            expectedRotation = new RotationMatrix((Orientation3DReadOnly)original.getRotation());
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.appendPitchRotation(pitch);
            expected.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)expected.geometricallyEquals(actual, this.getEpsilon()));
            original.setToZero();
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set(original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.appendPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = this.createRandomTransform(random);
            pitch = 0.0;
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToPitchOrientation(-pitch);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendPitchRotation(pitch);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            expectedRotation = new RotationMatrix((Orientation3DReadOnly)original.getRotation());
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.appendRollRotation(roll);
            expected.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)expected.geometricallyEquals(actual, this.getEpsilon()));
            original.setToZero();
            roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set(original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.appendRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = this.createRandomTransform(random);
            roll = 0.0;
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToRollOrientation(-roll);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendRollRotation(roll);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
    }

    @Test
    public void testPrependTranslation() throws Exception {
        T translationTransform;
        T original;
        int i;
        Random random = new Random(35454L);
        T expected = this.createRandomTransform(random);
        T actual = this.createRandomTransform(random);
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            translationTransform = this.identity();
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double z = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            translationTransform.getTranslation().set(x, y, z);
            expected.set(original);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            expected.preMultiply(translationTransform);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation(x, y, z);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)expected.equals(actual));
            original.setToZero();
            actual.set(original);
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.prependTranslation(x, y, z);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = this.createRandomTransform(random);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = this.createRandomTransform(random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)original.getTranslation());
            negateTranslation.negate();
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation(negateTranslation.getX(), negateTranslation.getY(), negateTranslation.getZ());
            Assertions.assertFalse((boolean)actual.hasTranslation());
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            translationTransform = this.identity();
            Point3D translation = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
            translationTransform.getTranslation().set((Tuple3DReadOnly)translation);
            expected.set(original);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            expected.preMultiply(translationTransform);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation((Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)expected.equals(actual));
            original.setToZero();
            actual.set(original);
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.prependTranslation((Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = this.createRandomTransform(random);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = this.createRandomTransform(random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)original.getTranslation());
            negateTranslation.negate();
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation((Tuple3DReadOnly)negateTranslation);
            Assertions.assertFalse((boolean)actual.hasTranslation());
        }
    }

    @Test
    public void testPrependOrientation() throws Exception {
        Random random = new Random(3456L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            T orientationTransform = this.identity();
            orientationTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)orientation);
            T expected = this.identity();
            expected.set(original);
            expected.preMultiply(orientationTransform);
            T actual = this.identity();
            actual.set(original);
            actual.prependOrientation((Orientation3DReadOnly)orientation);
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPrependYawPitchRoll() throws Exception {
        T original;
        int i;
        Random random = new Random(35454L);
        T expected = this.createRandomTransform(random);
        T actual = this.createRandomTransform(random);
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            T yawTransform = this.identity();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            yawTransform.getRotation().setToYawOrientation(yaw);
            expected.set(original);
            Assertions.assertTrue((boolean)expected.hasRotation());
            expected.preMultiply(yawTransform);
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)expected.epsilonEquals(actual, this.getEpsilon()));
            original.setToZero();
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set(original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.prependYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = this.createRandomTransform(random);
            yaw = 0.0;
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToYawOrientation(-yaw);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependYawRotation(yaw);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            T pitchTransform = this.identity();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            pitchTransform.getRotation().setToPitchOrientation(pitch);
            expected.set(original);
            expected.preMultiply(pitchTransform);
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)expected.epsilonEquals(actual, this.getEpsilon()));
            original.setToZero();
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set(original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.prependPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = this.createRandomTransform(random);
            pitch = 0.0;
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToPitchOrientation(-pitch);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependPitchRotation(pitch);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            T rollTransform = this.identity();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rollTransform.getRotation().setToRollOrientation(roll);
            expected.set(original);
            Assertions.assertTrue((boolean)expected.hasRotation());
            expected.preMultiply(rollTransform);
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)expected.epsilonEquals(actual, this.getEpsilon()));
            original.setToZero();
            roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set(original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.prependRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = this.createRandomTransform(random);
            roll = 0.0;
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToRollOrientation(-roll);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependRollRotation(roll);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
    }

    @Test
    public void testSetRotationAndZeroTranslation() throws Exception {
        Random random = new Random(2342L);
        RotationMatrix expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RotationMatrix actualRotation = new RotationMatrix();
        T actualTransform = this.createRandomTransform(random);
        AxisAngle axisAngle = new AxisAngle((Orientation3DReadOnly)expectedRotation);
        actualTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)axisAngle);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        actualRotation.set((Orientation3DReadOnly)actualTransform.getRotation());
        Assertions.assertTrue((boolean)actualRotation.epsilonEquals((EuclidGeometry)expectedRotation, this.getEpsilon()));
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 0.0));
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        actualTransform = this.createRandomTransform(random);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        expectedRotation.get((DMatrix)denseMatrix);
        actualTransform.setRotationAndZeroTranslation((RotationMatrixReadOnly)new RotationMatrix((DMatrix)denseMatrix));
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        actualRotation.set((Orientation3DReadOnly)actualTransform.getRotation());
        Assertions.assertTrue((boolean)actualRotation.epsilonEquals((EuclidGeometry)expectedRotation, this.getEpsilon()));
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationAndZeroTranslation((RotationMatrixReadOnly)new RotationMatrix());
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        actualTransform = this.createRandomTransform(random);
        Quaternion quaternion = new Quaternion((Orientation3DReadOnly)expectedRotation);
        actualTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)quaternion);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        actualRotation.set((Orientation3DReadOnly)actualTransform.getRotation());
        Assertions.assertTrue((boolean)actualRotation.epsilonEquals((EuclidGeometry)expectedRotation, this.getEpsilon()));
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)new Quaternion());
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        actualTransform = this.createRandomTransform(random);
        actualTransform.setRotationAndZeroTranslation((RotationMatrixReadOnly)expectedRotation);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        actualRotation.set((Orientation3DReadOnly)actualTransform.getRotation());
        Assertions.assertTrue((boolean)actualRotation.epsilonEquals((EuclidGeometry)expectedRotation, this.getEpsilon()));
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationAndZeroTranslation((RotationMatrixReadOnly)new RotationMatrix());
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
        T actualTransform2 = this.createRandomTransform(random);
        actualTransform2.setRotationAndZeroTranslation((Vector3DReadOnly)rotationVector);
        expectedRotation.setRotationVector((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)actualTransform2.hasRotation());
        Assertions.assertFalse((boolean)actualTransform2.hasTranslation());
        actualRotation.set((Orientation3DReadOnly)actualTransform2.getRotation());
        Assertions.assertTrue((boolean)actualRotation.epsilonEquals((EuclidGeometry)expectedRotation, this.getEpsilon()));
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform2.getTranslation());
        actualTransform2.getRotation().setRotationVector((Vector3DReadOnly)new Vector3D());
        Assertions.assertFalse((boolean)actualTransform2.hasRotation());
    }

    @Test
    public void testMultiplyWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform(multipliedWithRigidBody);
            expected.set(original);
            expected.multiply(multipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiply((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            multipliedWith.set(actual);
            multipliedWith.invert();
            actual.multiply((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testMultiplyWithAffineTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            AffineTransform multipliedWith = new AffineTransform(multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set(original);
            expected.multiply(multipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiply((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
            multipliedWithRigidBody.set(actual);
            multipliedWithRigidBody.invert();
            actual.multiply((AffineTransformReadOnly)new AffineTransform(multipliedWithRigidBody));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testMultiplyInvertThis() throws Exception {
        int i;
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWith = this.createRandomTransform(random);
            expected.set(original);
            expected.invert();
            expected.multiply(multipliedWith);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            actual.multiplyInvertThis(this.copy(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T t1 = this.createRandomTransform(random);
            T t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            expected.setAndInvert(t1);
            expected.multiply(t2);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2 = this.createRandomTransform(random);
            expected.setAndInvert(t1);
            expected.multiply(t2);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            expected.setAndInvert(t1);
            expected.multiply(t2);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            expected.setAndInvert(t1);
            expected.multiply(t2);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            expected.setAndInvert(t1);
            expected.multiply(t2);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            expected.setAndInvert(t1);
            expected.multiply(t2);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.getRotation().set((Orientation3DReadOnly)t1.getRotation());
            expected.setAndInvert(t1);
            expected.multiply(t2);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.getTranslation().set((Tuple3DReadOnly)t1.getTranslation());
            expected.setAndInvert(t1);
            expected.multiply(t2);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
        }
    }

    @Test
    public void testMultiplyInvertOther() throws Exception {
        int i;
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWith = this.createRandomTransform(random);
            T inverseOfMultipliedWith = this.copy(multipliedWith);
            inverseOfMultipliedWith.invert();
            expected.set(original);
            expected.multiply(inverseOfMultipliedWith);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            actual.multiplyInvertOther(this.copy(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            T expected = this.createRandomTransform(random);
            T actual = this.identity();
            T t1 = this.createRandomTransform(random);
            T t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            T t2Inverse = this.identity();
            t2Inverse.setAndInvert(t2);
            expected.set(t1);
            expected.multiply(t2Inverse);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2 = this.createRandomTransform(random);
            t2Inverse.setAndInvert(t2);
            expected.set(t1);
            expected.multiply(t2Inverse);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            t2Inverse.setAndInvert(t2);
            expected.set(t1);
            expected.multiply(t2Inverse);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            t2Inverse.setAndInvert(t2);
            expected.set(t1);
            expected.multiply(t2Inverse);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            t2Inverse.setAndInvert(t2);
            expected.set(t1);
            expected.multiply(t2Inverse);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            t2Inverse.setAndInvert(t2);
            expected.set(t1);
            expected.multiply(t2Inverse);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.getRotation().set((Orientation3DReadOnly)t1.getRotation());
            t2Inverse.setAndInvert(t2);
            expected.set(t1);
            expected.multiply(t2Inverse);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)t1.getTranslation());
            t1.inverseTransform((Vector3DBasics)negateTranslation);
            t2.transform((Vector3DBasics)negateTranslation);
            t2.getTranslation().set((Tuple3DReadOnly)negateTranslation);
            t2Inverse.setAndInvert(t2);
            expected.set(t1);
            expected.multiply(t2Inverse);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testMultiplyInvertThisWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform(multipliedWithRigidBody);
            expected.set(original);
            expected.invert();
            expected.multiply(multipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)new QuaternionBasedTransform(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testMultiplyInvertOtherWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            T inverseOfMultipliedWithRigidBody = this.copy(multipliedWithRigidBody);
            inverseOfMultipliedWithRigidBody.invert();
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform(multipliedWithRigidBody);
            expected.set(original);
            expected.multiply(inverseOfMultipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)new QuaternionBasedTransform(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testMultiplyInvertThisWithAffineTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            AffineTransform multipliedWith = new AffineTransform(multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set(original);
            expected.invert();
            expected.multiply(multipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
            actual.multiplyInvertThis((AffineTransformReadOnly)new AffineTransform(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testMultiplyInvertOtherWithAffineTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            T inverseOfMultipliedWithRigidBody = this.copy(multipliedWithRigidBody);
            inverseOfMultipliedWithRigidBody.invert();
            AffineTransform multipliedWith = new AffineTransform(multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set(original);
            expected.multiply(inverseOfMultipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
            actual.multiplyInvertOther((AffineTransformReadOnly)new AffineTransform(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPreMultiply() throws Exception {
        int i;
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            T transform = this.createRandomTransform(random);
            T inverse = this.copy(transform);
            inverse.invert();
            Assertions.assertTrue((boolean)transform.hasRotation());
            Assertions.assertTrue((boolean)transform.hasTranslation());
            transform.preMultiply(inverse);
            Assertions.assertFalse((boolean)transform.hasRotation());
            Assertions.assertFalse((boolean)transform.hasTranslation());
            Assertions.assertTrue((boolean)transform.epsilonEquals(this.identity(), this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T t1 = this.createRandomTransform(random);
            T t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            expected.set(t2);
            expected.multiply(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2 = this.createRandomTransform(random);
            expected.set(t2);
            expected.multiply(t1);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            expected.set(t2);
            expected.multiply(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            expected.set(t2);
            expected.multiply(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiply(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            expected.set(t2);
            expected.multiply(t1);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            expected.set(t2);
            expected.multiply(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiply(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t1.getRotation().set((Orientation3DReadOnly)t2.getRotation());
            t1.invertRotation();
            expected.set(t2);
            expected.multiply(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)t2.getTranslation());
            negateTranslation.negate();
            t2.inverseTransform((Vector3DBasics)negateTranslation);
            t1.getTranslation().set((Tuple3DReadOnly)negateTranslation);
            expected.set(t2);
            expected.multiply(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.equals(expected));
        }
    }

    @Test
    public void testPreMultiplyWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform(multipliedWithRigidBody);
            expected.set(original);
            expected.preMultiply(multipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            multipliedWith.set(actual);
            multipliedWith.invert();
            actual.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPreMultiplyWithAffineTransform() throws Exception {
        Random random = new Random(462416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            AffineTransform multipliedWith = new AffineTransform(multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set(original);
            expected.preMultiply(multipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
            multipliedWithRigidBody.set(actual);
            multipliedWithRigidBody.invert();
            actual.preMultiply((AffineTransformReadOnly)new AffineTransform(multipliedWithRigidBody));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPreMultiplyInvertThis() throws Exception {
        int i;
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWith = this.createRandomTransform(random);
            expected.set(original);
            expected.invert();
            expected.preMultiply(multipliedWith);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            actual.preMultiplyInvertThis(this.copy(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            T expected = this.identity();
            T actual = this.identity();
            T t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            T t2 = this.createRandomTransform(random);
            expected.set(t2);
            expected.multiplyInvertOther(t1);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            expected.set(t2);
            expected.multiplyInvertOther(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            expected.set(t2);
            expected.multiplyInvertOther(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            expected.set(t2);
            expected.multiplyInvertOther(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            expected.set(t2);
            expected.multiplyInvertOther(t1);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            expected.set(t2);
            expected.multiplyInvertOther(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t1.getRotation().set((Orientation3DReadOnly)t2.getRotation());
            expected.set(t2);
            expected.multiplyInvertOther(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)t2.getTranslation());
            t2.inverseTransform((Vector3DBasics)negateTranslation);
            t1.transform((Vector3DBasics)negateTranslation);
            t1.getTranslation().set((Tuple3DReadOnly)negateTranslation);
            expected.set(t2);
            expected.multiplyInvertOther(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPreMultiplyInvertOther() throws Exception {
        int i;
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWith = this.createRandomTransform(random);
            T inverseOfMultipliedWith = this.copy(multipliedWith);
            inverseOfMultipliedWith.invert();
            expected.set(original);
            expected.preMultiply(inverseOfMultipliedWith);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            actual.preMultiplyInvertOther(this.copy(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            T expected = this.identity();
            T actual = this.identity();
            T t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            T t2 = this.createRandomTransform(random);
            expected.set(t2);
            expected.multiplyInvertThis(t1);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            expected.set(t2);
            expected.multiplyInvertThis(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            expected.set(t2);
            expected.multiplyInvertThis(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            expected.set(t2);
            expected.multiplyInvertThis(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t1.setRotationToZero();
            t2 = this.createRandomTransform(random);
            t2.setRotationToZero();
            expected.set(t2);
            expected.multiplyInvertThis(t1);
            actual.set(t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t1.setTranslationToZero();
            t2 = this.createRandomTransform(random);
            t2.setTranslationToZero();
            expected.set(t2);
            expected.multiplyInvertThis(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t1.getRotation().set((Orientation3DReadOnly)t2.getRotation());
            expected.set(t2);
            expected.multiplyInvertThis(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            t1 = this.createRandomTransform(random);
            t2 = this.createRandomTransform(random);
            t1.getTranslation().set((Tuple3DReadOnly)t2.getTranslation());
            expected.set(t2);
            expected.multiplyInvertThis(t1);
            actual.set(t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther(t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPreMultiplyInvertThisWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform(multipliedWithRigidBody);
            expected.set(original);
            expected.invert();
            expected.preMultiply(multipliedWithRigidBody);
            actual.set(original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)new QuaternionBasedTransform(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPreMultiplyInvertOtherWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            T inverseOfMultipliedWithRigidBody = this.copy(multipliedWithRigidBody);
            inverseOfMultipliedWithRigidBody.invert();
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform(multipliedWithRigidBody);
            expected.set(original);
            expected.preMultiply(inverseOfMultipliedWithRigidBody);
            actual.set(original);
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)new QuaternionBasedTransform(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.epsilonEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPreMultiplyInvertThisWithAffineTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            AffineTransform multipliedWith = new AffineTransform(multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set(original);
            expected.invert();
            expected.preMultiply(multipliedWithRigidBody);
            actual.set(original);
            actual.preMultiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
            actual.preMultiplyInvertThis((AffineTransformReadOnly)new AffineTransform(actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
        }
    }

    @Test
    public void testPreMultiplyInvertOtherWithAffineTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            T original = this.createRandomTransform(random);
            T expected = this.createRandomTransform(random);
            T actual = this.createRandomTransform(random);
            T multipliedWithRigidBody = this.createRandomTransform(random);
            T inverseOfMultipliedWithRigidBody = this.copy(multipliedWithRigidBody);
            inverseOfMultipliedWithRigidBody.invert();
            AffineTransform multipliedWith = new AffineTransform(multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set(original);
            expected.preMultiply(inverseOfMultipliedWithRigidBody);
            actual.set(original);
            actual.preMultiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.geometricallyEquals(expected, this.getEpsilon()));
        }
    }

    private void checkMultiplyAgainstEJML(T t1, T t2) {
        T actual_t3 = this.copy(t1);
        actual_t3.multiply(t2);
        DMatrixRMaj m1 = CommonOps_DDRM.identity((int)4);
        DMatrixRMaj m2 = CommonOps_DDRM.identity((int)4);
        DMatrixRMaj m3 = new DMatrixRMaj(4, 4);
        Matrix3D r1 = new Matrix3D();
        t1.getRotation().get((CommonMatrix3DBasics)r1);
        r1.get((DMatrix)m1);
        t1.getTranslation().get(0, 3, (DMatrix)m1);
        Matrix3D r2 = new Matrix3D();
        t2.getRotation().get((CommonMatrix3DBasics)r2);
        r2.get((DMatrix)m2);
        t2.getTranslation().get(0, 3, (DMatrix)m2);
        CommonOps_DDRM.mult((DMatrix1Row)m1, (DMatrix1Row)m2, (DMatrix1Row)m3);
        T expected_t3 = this.identity();
        expected_t3.getRotation().setRotationMatrix(m3.get(0, 0), m3.get(0, 1), m3.get(0, 2), m3.get(1, 0), m3.get(1, 1), m3.get(1, 2), m3.get(2, 0), m3.get(2, 1), m3.get(2, 2));
        expected_t3.getTranslation().set(0, 3, (DMatrix)m3);
        EuclidCoreTestTools.assertGeometricallyEquals(expected_t3, actual_t3, (double)this.getEpsilon());
    }
}

