/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class RotationMatrixToolsTest {
    private static final double EPS = 1.0E-12;

    @Test
    public void testApplyYawRotation() throws Exception {
        Vector3D actualTuple;
        Vector3D expectedTuple;
        Point3D tupleOriginal;
        double yaw;
        RotationMatrix rotationMatrix;
        int i;
        Random random = new Random(435345L);
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = new RotationMatrix();
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rotationMatrix.setToYawOrientation(yaw);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            expectedTuple = new Vector3D();
            actualTuple = new Vector3D();
            rotationMatrix.transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expectedTuple);
            RotationMatrixTools.applyYawRotation((double)yaw, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)1.0E-12);
            actualTuple.set((Tuple3DReadOnly)tupleOriginal);
            RotationMatrixTools.applyYawRotation((double)yaw, (Tuple3DReadOnly)actualTuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = new RotationMatrix();
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rotationMatrix.setToYawOrientation(yaw);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            expectedTuple = new Vector2D();
            actualTuple = new Vector2D();
            rotationMatrix.transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expectedTuple);
            RotationMatrixTools.applyYawRotation((double)yaw, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)1.0E-12);
            actualTuple.set((Tuple2DReadOnly)tupleOriginal);
            RotationMatrixTools.applyYawRotation((double)yaw, (Tuple2DReadOnly)actualTuple, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)1.0E-12);
        }
    }

    @Test
    public void testApplyPitchRotation() throws Exception {
        Random random = new Random(435345L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = new RotationMatrix();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rotationMatrix.setToPitchOrientation(pitch);
            Point3D tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D expectedTuple = new Vector3D();
            Vector3D actualTuple = new Vector3D();
            rotationMatrix.transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expectedTuple);
            RotationMatrixTools.applyPitchRotation((double)pitch, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)1.0E-12);
            actualTuple.set((Tuple3DReadOnly)tupleOriginal);
            RotationMatrixTools.applyPitchRotation((double)pitch, (Tuple3DReadOnly)actualTuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)1.0E-12);
        }
    }

    @Test
    public void testApplyRollRotation() throws Exception {
        Random random = new Random(435345L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = new RotationMatrix();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rotationMatrix.setToRollOrientation(roll);
            Point3D tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D expectedTuple = new Vector3D();
            Vector3D actualTuple = new Vector3D();
            rotationMatrix.transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expectedTuple);
            RotationMatrixTools.applyRollRotation((double)roll, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)1.0E-12);
            actualTuple.set((Tuple3DReadOnly)tupleOriginal);
            RotationMatrixTools.applyRollRotation((double)roll, (Tuple3DReadOnly)actualTuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)1.0E-12);
        }
    }

    @Test
    public void testInterpolate() throws Exception {
        RotationMatrix r1;
        Random random = new Random(74232L);
        for (int i = 0; i < 1000; ++i) {
            r1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix r2 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)r1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)r2);
            double alpha = random.nextDouble();
            Quaternion qInterpolated = new Quaternion();
            qInterpolated.interpolate((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, alpha);
            RotationMatrix expectedMatrix = new RotationMatrix((Orientation3DReadOnly)qInterpolated);
            RotationMatrix actualMatrix = new RotationMatrix();
            RotationMatrixTools.interpolate((RotationMatrixReadOnly)r1, (RotationMatrixReadOnly)r2, (double)alpha, (RotationMatrixBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        double errorAverage = 0.0;
        for (int i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), Math.PI);
            RotationMatrix diff = new RotationMatrix((Orientation3DReadOnly)axisAngle);
            RotationMatrix r12 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix r2 = new RotationMatrix();
            r2.set(r12);
            r2.multiply((RotationMatrixReadOnly)diff);
            double alpha = random.nextDouble();
            axisAngle.scaleAngle(alpha);
            diff.set((Orientation3DReadOnly)axisAngle);
            RotationMatrix expectedMatrix = new RotationMatrix();
            expectedMatrix.set(r12);
            expectedMatrix.multiply((RotationMatrixReadOnly)diff);
            RotationMatrix actualMatrix = new RotationMatrix();
            RotationMatrixTools.interpolate((RotationMatrixReadOnly)r12, (RotationMatrixReadOnly)r2, (double)alpha, (RotationMatrixBasics)actualMatrix);
            if (!expectedMatrix.epsilonEquals((EuclidGeometry)actualMatrix, 1.0E-12)) {
                axisAngle.scaleAngle(-1.0);
                diff.set((Orientation3DReadOnly)axisAngle);
                expectedMatrix.set(r12);
                expectedMatrix.multiply((RotationMatrixReadOnly)diff);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            }
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    errorAverage += Math.abs(expectedMatrix.getElement(row, column) - actualMatrix.getElement(row, column));
                }
            }
        }
        Assertions.assertTrue(((errorAverage /= 9000.0) < 5.0E-5 ? 1 : 0) != 0);
        for (int i = 0; i < 1000; ++i) {
            r1 = new RotationMatrix();
            RotationMatrix r2 = new RotationMatrix();
            RotationMatrix result = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrixTools.interpolate((RotationMatrixReadOnly)r1, (RotationMatrixReadOnly)r2, (double)random.nextDouble(), (RotationMatrixBasics)result);
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)result, (double)1.0E-12);
        }
    }

    @Test
    public void testDistance() throws Exception {
        RotationMatrix converted;
        RotationMatrix rotationMatrix;
        double expectedDistance;
        RotationMatrix m2;
        AxisAngle axisAngle;
        RotationMatrix m1;
        int i;
        Random random = new Random(45345L);
        for (i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix m22 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)m1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)m22);
            double actualDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m22);
            double expectedDistance2 = Math.abs(EuclidCoreTools.trimAngleMinusPiToPi((double)q1.distance((Orientation3DReadOnly)q2)));
            Assertions.assertEquals((double)expectedDistance2, (double)actualDistance, (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m1), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            m2 = new RotationMatrix();
            m2.set((Orientation3DReadOnly)axisAngle);
            m2.preMultiply((RotationMatrixReadOnly)m1);
            double actualDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m2);
            expectedDistance = Math.abs(axisAngle.getAngle());
            EuclidCoreTestTools.assertAngleEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m1), (double)1.0E-12);
            m2.set((Orientation3DReadOnly)axisAngle);
            m2.preMultiplyTransposeThis((RotationMatrixReadOnly)m1);
            actualDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m2);
            EuclidCoreTestTools.assertAngleEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m1), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            axisAngle.setAngle(Math.PI);
            m2 = new RotationMatrix();
            m2.set((Orientation3DReadOnly)axisAngle);
            m2.preMultiply((RotationMatrixReadOnly)m1);
            double actualDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m2);
            expectedDistance = Math.abs(axisAngle.getAngle());
            EuclidCoreTestTools.assertAngleEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)RotationMatrixTools.distance((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m1), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            converted = new RotationMatrix((Orientation3DReadOnly)quaternion);
            double actualDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (QuaternionReadOnly)quaternion);
            expectedDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)converted);
            Assertions.assertEquals((double)actualDistance, (double)expectedDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            converted = new RotationMatrix((Orientation3DReadOnly)axisAngle);
            double actualDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (AxisAngleReadOnly)axisAngle);
            expectedDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)converted);
            Assertions.assertEquals((double)actualDistance, (double)expectedDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            YawPitchRoll yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            converted = new RotationMatrix((Orientation3DReadOnly)yawPitchRoll);
            double actualDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (YawPitchRollReadOnly)yawPitchRoll);
            expectedDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)converted);
            Assertions.assertEquals((double)actualDistance, (double)expectedDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            double withQuaternionResult = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)orientation));
            double withRotationMatrixResult = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation));
            double notCastedResult = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (Orientation3DReadOnly)orientation);
            if (Math.abs(notCastedResult) <= Math.PI) {
                Assertions.assertEquals((double)notCastedResult, (double)withRotationMatrixResult, (double)1.0E-12);
                continue;
            }
            Assertions.assertEquals((double)notCastedResult, (double)withQuaternionResult, (double)1.0E-12);
        }
    }

    @Test
    public void testAngle() throws Exception {
        Random random = new Random(242334L);
        for (int i = 0; i < 1000; ++i) {
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            RotationMatrix rotationMatrix = new RotationMatrix((Orientation3DReadOnly)quaternion);
            double expected = quaternion.angle();
            double actual = RotationMatrixTools.angle((RotationMatrixReadOnly)rotationMatrix);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiply() throws Exception {
        RotationMatrix m2;
        RotationMatrix m1;
        boolean inverse2;
        boolean inverse1;
        RotationMatrix actual;
        Matrix3D expected;
        Orientation3DBasics orientation2;
        Orientation3DBasics orientation1;
        int j;
        int i;
        Random random = new Random(2345L);
        for (i = 0; i < 10000; ++i) {
            for (j = 0; j < 4; ++j) {
                orientation1 = EuclidCoreRandomTools.nextOrientation3D((Random)random);
                orientation2 = EuclidCoreRandomTools.nextOrientation3D((Random)random);
                expected = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random);
                actual = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                inverse1 = (j & 1) != 0;
                inverse2 = (j & 2) != 0;
                m1 = new RotationMatrix((Orientation3DReadOnly)orientation1);
                m2 = new RotationMatrix((Orientation3DReadOnly)orientation2);
                if (inverse1 && inverse2) {
                    Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse1 && !inverse2) {
                    Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse2) {
                    Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else {
                    Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                }
                RotationMatrixTools.multiply((Orientation3DReadOnly)orientation1, (boolean)inverse1, (Orientation3DReadOnly)orientation2, (boolean)inverse2, (CommonMatrix3DBasics)actual);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
                orientation1.setToZero();
                m1 = new RotationMatrix((Orientation3DReadOnly)orientation1);
                m2 = new RotationMatrix((Orientation3DReadOnly)orientation2);
                if (inverse1 && inverse2) {
                    Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse1 && !inverse2) {
                    Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse2) {
                    Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else {
                    Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                }
                RotationMatrixTools.multiply((Orientation3DReadOnly)orientation1, (boolean)inverse1, (Orientation3DReadOnly)orientation2, (boolean)inverse2, (CommonMatrix3DBasics)actual);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
                orientation1 = EuclidCoreRandomTools.nextOrientation3D((Random)random);
                orientation2.setToZero();
                m1 = new RotationMatrix((Orientation3DReadOnly)orientation1);
                m2 = new RotationMatrix((Orientation3DReadOnly)orientation2);
                if (inverse1 && inverse2) {
                    Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse1 && !inverse2) {
                    Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse2) {
                    Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else {
                    Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                }
                RotationMatrixTools.multiply((Orientation3DReadOnly)orientation1, (boolean)inverse1, (Orientation3DReadOnly)orientation2, (boolean)inverse2, (CommonMatrix3DBasics)actual);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
                orientation1.setToZero();
                RotationMatrixTools.multiply((Orientation3DReadOnly)orientation1, (boolean)inverse1, (Orientation3DReadOnly)orientation2, (boolean)inverse2, (CommonMatrix3DBasics)actual);
                EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actual, (double)1.0E-12);
            }
        }
        for (i = 0; i < 10000; ++i) {
            for (j = 0; j < 4; ++j) {
                orientation1 = EuclidCoreRandomTools.nextOrientation3D((Random)random);
                orientation2 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                expected = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random);
                actual = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                inverse1 = (j & 1) != 0;
                inverse2 = (j & 2) != 0;
                m1 = new RotationMatrix((Orientation3DReadOnly)orientation1);
                m2 = new RotationMatrix((RotationMatrixReadOnly)orientation2);
                if (inverse1 && inverse2) {
                    Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse1 && !inverse2) {
                    Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse2) {
                    Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else {
                    Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                }
                RotationMatrixTools.multiply((Orientation3DReadOnly)orientation1, (boolean)inverse1, (RotationMatrixReadOnly)orientation2, (boolean)inverse2, (CommonMatrix3DBasics)actual);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
                orientation1.setToZero();
                m1 = new RotationMatrix((Orientation3DReadOnly)orientation1);
                m2 = new RotationMatrix((RotationMatrixReadOnly)orientation2);
                if (inverse1 && inverse2) {
                    Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse1 && !inverse2) {
                    Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse2) {
                    Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else {
                    Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                }
                RotationMatrixTools.multiply((Orientation3DReadOnly)orientation1, (boolean)inverse1, (RotationMatrixReadOnly)orientation2, (boolean)inverse2, (CommonMatrix3DBasics)actual);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
                orientation1 = EuclidCoreRandomTools.nextOrientation3D((Random)random);
                orientation2.setToZero();
                m1 = new RotationMatrix((Orientation3DReadOnly)orientation1);
                m2 = new RotationMatrix((RotationMatrixReadOnly)orientation2);
                if (inverse1 && inverse2) {
                    Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse1 && !inverse2) {
                    Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else if (inverse2) {
                    Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                } else {
                    Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
                }
                RotationMatrixTools.multiply((Orientation3DReadOnly)orientation1, (boolean)inverse1, (RotationMatrixReadOnly)orientation2, (boolean)inverse2, (CommonMatrix3DBasics)actual);
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
                orientation1.setToZero();
                RotationMatrixTools.multiply((Orientation3DReadOnly)orientation1, (boolean)inverse1, (RotationMatrixReadOnly)orientation2, (boolean)inverse2, (CommonMatrix3DBasics)actual);
                EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actual, (double)1.0E-12);
            }
        }
    }

    @Test
    public void testPrependYawRotation() throws Exception {
        Random random = new Random(234L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix actual = new RotationMatrix();
            RotationMatrix expected = new RotationMatrix();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            RotationMatrix yawMatrix = new RotationMatrix();
            RotationMatrixConversion.computeYawMatrix((double)yaw, (CommonMatrix3DBasics)yawMatrix);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)yawMatrix, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            RotationMatrixTools.prependYawRotation((double)yaw, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            original.setToZero();
            RotationMatrixTools.prependYawRotation((double)yaw, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawMatrix, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendYawRotation() throws Exception {
        Random random = new Random(234L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix actual = new RotationMatrix();
            RotationMatrix expected = new RotationMatrix();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            RotationMatrix yawMatrix = new RotationMatrix();
            RotationMatrixConversion.computeYawMatrix((double)yaw, (CommonMatrix3DBasics)yawMatrix);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)original, (RotationMatrixReadOnly)yawMatrix, (CommonMatrix3DBasics)expected);
            RotationMatrixTools.appendYawRotation((Matrix3DReadOnly)original, (double)yaw, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            original.setToZero();
            RotationMatrixTools.appendYawRotation((Matrix3DReadOnly)original, (double)yaw, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawMatrix, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependPitchRotation() throws Exception {
        Random random = new Random(234L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix actual = new RotationMatrix();
            RotationMatrix expected = new RotationMatrix();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            RotationMatrix yawMatrix = new RotationMatrix();
            RotationMatrixConversion.computePitchMatrix((double)yaw, (CommonMatrix3DBasics)yawMatrix);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)yawMatrix, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            RotationMatrixTools.prependPitchRotation((double)yaw, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            original.setToZero();
            RotationMatrixTools.prependPitchRotation((double)yaw, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawMatrix, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendPitchRotation() throws Exception {
        Random random = new Random(234L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix actual = new RotationMatrix();
            RotationMatrix expected = new RotationMatrix();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            RotationMatrix yawMatrix = new RotationMatrix();
            RotationMatrixConversion.computePitchMatrix((double)yaw, (CommonMatrix3DBasics)yawMatrix);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)original, (RotationMatrixReadOnly)yawMatrix, (CommonMatrix3DBasics)expected);
            RotationMatrixTools.appendPitchRotation((Matrix3DReadOnly)original, (double)yaw, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            original.setToZero();
            RotationMatrixTools.appendPitchRotation((Matrix3DReadOnly)original, (double)yaw, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawMatrix, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependRollRotation() throws Exception {
        Random random = new Random(234L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix actual = new RotationMatrix();
            RotationMatrix expected = new RotationMatrix();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            RotationMatrix yawMatrix = new RotationMatrix();
            RotationMatrixConversion.computeRollMatrix((double)yaw, (CommonMatrix3DBasics)yawMatrix);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)yawMatrix, (RotationMatrixReadOnly)original, (CommonMatrix3DBasics)expected);
            RotationMatrixTools.prependRollRotation((double)yaw, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            original.setToZero();
            RotationMatrixTools.prependRollRotation((double)yaw, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawMatrix, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendRollRotation() throws Exception {
        Random random = new Random(234L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix actual = new RotationMatrix();
            RotationMatrix expected = new RotationMatrix();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            RotationMatrix yawMatrix = new RotationMatrix();
            RotationMatrixConversion.computeRollMatrix((double)yaw, (CommonMatrix3DBasics)yawMatrix);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)original, (RotationMatrixReadOnly)yawMatrix, (CommonMatrix3DBasics)expected);
            RotationMatrixTools.appendRollRotation((Matrix3DReadOnly)original, (double)yaw, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            original.setToZero();
            RotationMatrixTools.appendRollRotation((Matrix3DReadOnly)original, (double)yaw, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)yawMatrix, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }
}

