/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.EuclidShapeCollisionTools;
import us.ihmc.euclid.shape.collision.gjk.GilbertJohnsonKeerthiCollisionDetector;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.HalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.Vertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeFactories;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Capsule3D;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.PointShape3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

class GilbertJohnsonKeerthiCollisionDetectorTest {
    private static final boolean VERBOSE = false;
    private static final int ITERATIONS = 5000;
    private static final double EPSILON = 1.0E-10;

    GilbertJohnsonKeerthiCollisionDetectorTest() {
    }

    @Test
    void testReusingSupportDirection() {
        int newNumberOfIterations;
        EuclidShape3DCollisionResult actualResult;
        Vector3D initialSupportDirection;
        int originalNumberOfIterations;
        EuclidShape3DCollisionResult expectedResult;
        Shape3DBasics shapeB;
        Shape3DBasics shapeA;
        int i;
        Random random = new Random(789034505L);
        GilbertJohnsonKeerthiCollisionDetector detector = new GilbertJohnsonKeerthiCollisionDetector();
        double distanceEpsilon = 1.0E-4;
        double pointTangentialEpsilon = 0.01;
        int totalIterationsWithoutHint = 0;
        int totalIterationsWithHint = 0;
        for (i = 0; i < 5000; ++i) {
            shapeA = EuclidShapeRandomTools.nextConvexShape3D((Random)random);
            expectedResult = detector.evaluateCollision((Shape3DReadOnly)shapeA, (Shape3DReadOnly)(shapeB = EuclidShapeRandomTools.nextConvexShape3D((Random)random)));
            if (expectedResult.areShapesColliding()) {
                --i;
                continue;
            }
            originalNumberOfIterations = detector.getNumberOfIterations();
            initialSupportDirection = new Vector3D((Tuple3DReadOnly)detector.getSupportDirection());
            detector.setInitialSupportDirection((Vector3DReadOnly)initialSupportDirection);
            actualResult = detector.evaluateCollision((Shape3DReadOnly)shapeA, (Shape3DReadOnly)shapeB);
            newNumberOfIterations = detector.getNumberOfIterations();
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)distanceEpsilon, (double)pointTangentialEpsilon, (double)0.0);
            totalIterationsWithoutHint += originalNumberOfIterations;
            totalIterationsWithHint += newNumberOfIterations;
        }
        Assertions.assertTrue((totalIterationsWithHint < totalIterationsWithoutHint / 3 ? 1 : 0) != 0);
        totalIterationsWithoutHint = 0;
        totalIterationsWithHint = 0;
        for (i = 0; i < 5000; ++i) {
            shapeA = EuclidShapeRandomTools.nextConvexShape3D((Random)random);
            shapeB = EuclidShapeRandomTools.nextConvexShape3D((Random)random);
            if (shapeA instanceof PointShape3DReadOnly && shapeB instanceof PointShape3DReadOnly) {
                --i;
                continue;
            }
            expectedResult = detector.evaluateCollision((Shape3DReadOnly)shapeA, (Shape3DReadOnly)shapeB);
            while (!expectedResult.areShapesColliding()) {
                Vector3D centroidSeparation = new Vector3D();
                centroidSeparation.sub((Tuple3DReadOnly)shapeB.getCentroid(), (Tuple3DReadOnly)shapeA.getCentroid());
                centroidSeparation.scale(0.5);
                shapeA.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)centroidSeparation));
                expectedResult = detector.evaluateCollision((Shape3DReadOnly)shapeA, (Shape3DReadOnly)shapeB);
            }
            originalNumberOfIterations = detector.getNumberOfIterations();
            initialSupportDirection = new Vector3D((Tuple3DReadOnly)detector.getSupportDirection());
            detector.setInitialSupportDirection((Vector3DReadOnly)initialSupportDirection);
            actualResult = detector.evaluateCollision((Shape3DReadOnly)shapeA, (Shape3DReadOnly)shapeB);
            newNumberOfIterations = detector.getNumberOfIterations();
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)distanceEpsilon, (double)pointTangentialEpsilon, (double)0.0);
            totalIterationsWithoutHint += originalNumberOfIterations;
            totalIterationsWithHint += newNumberOfIterations;
        }
        Assertions.assertTrue((totalIterationsWithHint < totalIterationsWithoutHint ? 1 : 0) != 0);
    }

    @Test
    void testSimpleCollisionWithNonCollidingCubeAndTetrahedron() {
        Random random = new Random(34534L);
        ConvexPolytope3D cube = EuclidPolytopeFactories.newCube((double)1.0);
        for (int i = 0; i < 5000; ++i) {
            Point3D tetrahedronClosest = new Point3D(0.5, 0.0, 0.0);
            Point3D tetrahedronFarthest0 = new Point3D(1.0, 1.0, 0.0);
            Point3D tetrahedronFarthest1 = new Point3D(1.0, 0.0, 1.0);
            Point3D tetrahedronFarthest2 = new Point3D(1.0, -1.0, 0.0);
            Vector3D translation = new Vector3D();
            translation.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            translation.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5));
            translation.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5));
            Arrays.asList(tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2).forEach(p -> p.add((Tuple3DReadOnly)translation));
            ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2}));
            double distance = Double.POSITIVE_INFINITY;
            for (Vertex3D tetraVertex : tetrahedron.getVertices()) {
                Assertions.assertFalse((boolean)cube.isPointInside((Point3DReadOnly)tetraVertex));
                for (Face3D cubeFace : cube.getFaces()) {
                    distance = Math.min(distance, cubeFace.distance((Point3DReadOnly)tetraVertex));
                }
            }
            for (Vertex3D cubeVertex : cube.getVertices()) {
                Assertions.assertFalse((boolean)tetrahedron.isPointInside((Point3DReadOnly)cubeVertex));
                for (Face3D tetraFace : tetrahedron.getFaces()) {
                    distance = Math.min(distance, tetraFace.distance((Point3DReadOnly)cubeVertex));
                }
            }
            Assertions.assertEquals((double)translation.getX(), (double)distance, (double)1.0E-10);
            GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)cube, (ConvexPolytope3DReadOnly)tetrahedron, false, (Point3DReadOnly)new Point3D(0.5, tetrahedronClosest.getY(), tetrahedronClosest.getZ()), (Point3DReadOnly)tetrahedronClosest);
        }
    }

    @Test
    void testSimpleCollisionWithCollidingCubeAndTetrahedron() {
        Random random = new Random(34534L);
        ConvexPolytope3D cube = EuclidPolytopeFactories.newCube((double)1.0);
        for (int i = 0; i < 5000; ++i) {
            Point3D tetrahedronClosest = new Point3D(0.5, 0.0, 0.0);
            Point3D tetrahedronFarthest0 = new Point3D(1.0, 1.0, 0.0);
            Point3D tetrahedronFarthest1 = new Point3D(1.0, 0.0, 1.0);
            Point3D tetrahedronFarthest2 = new Point3D(1.0, -1.0, 0.0);
            Vector3D translation = new Vector3D();
            translation.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)-0.5, (double)0.0));
            translation.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5));
            translation.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5));
            Arrays.asList(tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2).forEach(p -> p.add((Tuple3DReadOnly)translation));
            ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{tetrahedronClosest, tetrahedronFarthest0, tetrahedronFarthest1, tetrahedronFarthest2}));
            GilbertJohnsonKeerthiCollisionDetector collisionDetector = new GilbertJohnsonKeerthiCollisionDetector();
            Assertions.assertTrue((boolean)collisionDetector.evaluateCollision((Shape3DReadOnly)cube, (Shape3DReadOnly)tetrahedron).areShapesColliding());
            Assertions.assertTrue((boolean)collisionDetector.evaluateCollision((Shape3DReadOnly)tetrahedron, (Shape3DReadOnly)cube).areShapesColliding());
            GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)cube, (ConvexPolytope3DReadOnly)tetrahedron, true, null, null);
        }
    }

    @Test
    void testNonCollidingConvexPolytope3DWithTetrahedron() throws Exception {
        Random random = new Random(45345L);
        for (int i = 0; i < 5000; ++i) {
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), false, null, null);
            } else {
                Face3D face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
                HalfEdge3D edge2 = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
                Point3D pointOnConvexPolytope3D = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination());
                Point3D pointOnTetrahedron = new Point3D((Tuple3DReadOnly)pointOnConvexPolytope3D);
                pointOnTetrahedron.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)face.getNormal(), (Tuple3DReadOnly)pointOnTetrahedron);
                ConvexPolytope3D tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointOnTetrahedron, (Vector3DReadOnly)face.getNormal(), 1.0);
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, false, (Point3DReadOnly)pointOnConvexPolytope3D, (Point3DReadOnly)pointOnTetrahedron);
            }
            if (convexPolytope3D.isEmpty()) {
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), false, null, null);
            } else {
                Face3D firstFace = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
                HalfEdge3D closestEdge = (HalfEdge3D)firstFace.getEdge(random.nextInt(firstFace.getNumberOfEdges()));
                Vector3D towardOutside = new Vector3D();
                if (closestEdge.getTwin() != null) {
                    Face3D secondFace = (Face3D)((HalfEdge3D)closestEdge.getTwin()).getFace();
                    towardOutside.interpolate((Tuple3DReadOnly)firstFace.getNormal(), (Tuple3DReadOnly)secondFace.getNormal(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                } else {
                    Vector3D faceNormal = new Vector3D((Tuple3DReadOnly)firstFace.getNormal());
                    towardOutside.cross((Tuple3DReadOnly)faceNormal, (Tuple3DReadOnly)closestEdge.getDirection(false));
                    if (random.nextBoolean()) {
                        faceNormal.negate();
                    }
                    towardOutside.interpolate((Tuple3DReadOnly)faceNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                }
                towardOutside.normalize();
                Point3D pointOnConvexPolytope3D = new Point3D();
                pointOnConvexPolytope3D.interpolate((Tuple3DReadOnly)closestEdge.getOrigin(), (Tuple3DReadOnly)closestEdge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                Point3D pointOnTetrahedron = new Point3D();
                pointOnTetrahedron.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnConvexPolytope3D);
                ConvexPolytope3D tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointOnTetrahedron, (Vector3DReadOnly)towardOutside, 1.0);
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, false, (Point3DReadOnly)pointOnConvexPolytope3D, (Point3DReadOnly)pointOnTetrahedron);
            }
            if (convexPolytope3D.isEmpty()) {
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), false, null, null);
                continue;
            }
            Vertex3D pointOnConvexPolytope3D = (Vertex3D)convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
            Vector3D towardOutside = new Vector3D();
            pointOnConvexPolytope3D.getAssociatedEdges().stream().forEach(edge -> towardOutside.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)((Face3D)edge.getFace()).getNormal(), (Tuple3DReadOnly)towardOutside));
            towardOutside.normalize();
            Point3D pointOnTetrahedron = new Point3D();
            pointOnTetrahedron.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnConvexPolytope3D);
            ConvexPolytope3D tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointOnTetrahedron, (Vector3DReadOnly)towardOutside, 1.0);
            GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, false, (Point3DReadOnly)pointOnConvexPolytope3D, (Point3DReadOnly)pointOnTetrahedron);
        }
    }

    @Test
    void testVertexCollidingConvexPolytope3DWithTetrahedron() throws Exception {
        Random random = new Random(45345L);
        for (int i = 0; i < 5000; ++i) {
            Point3D pointInside;
            Point3D pointOnFace;
            Face3D face;
            LineSegment3D secondTetraSegment;
            LineSegment3D firstTetraSegment;
            Vector3D secondOrthogonalToEdge;
            Vector3D firstOrthogonalToEdge;
            Vector3DBasics edgeDirection;
            HalfEdge3D edge;
            ConvexPolytope3D tetrahedron;
            ConvexPolytope3D convexPolytope3D = EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random);
            if (convexPolytope3D.isEmpty()) {
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), false, null, null);
            } else {
                if (convexPolytope3D.getNumberOfVertices() == 1) {
                    tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)convexPolytope3D.getVertex(0));
                    Assertions.assertTrue((boolean)tetrahedron.isPointInside((Point3DReadOnly)convexPolytope3D.getVertex(0)));
                } else if (convexPolytope3D.getNumberOfVertices() == 2) {
                    edge = (HalfEdge3D)convexPolytope3D.getHalfEdge(0);
                    edgeDirection = edge.getDirection(true);
                    firstOrthogonalToEdge = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)edgeDirection, (boolean)true);
                    secondOrthogonalToEdge = new Vector3D();
                    secondOrthogonalToEdge.cross((Tuple3DReadOnly)firstOrthogonalToEdge, (Tuple3DReadOnly)edgeDirection);
                    firstTetraSegment = new LineSegment3D();
                    firstTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                    firstTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                    firstTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                    secondTetraSegment = new LineSegment3D();
                    secondTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                    secondTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                    firstOrthogonalToEdge.negate();
                    secondTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                    tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{firstTetraSegment.getFirstEndpoint(), firstTetraSegment.getSecondEndpoint(), secondTetraSegment.getFirstEndpoint(), secondTetraSegment.getSecondEndpoint()}));
                } else if (convexPolytope3D.getNumberOfFaces() == 1) {
                    face = (Face3D)convexPolytope3D.getFace(0);
                    pointOnFace = EuclidShapeRandomTools.nextPoint3DOnFace3D((Random)random, (Face3DReadOnly)face);
                    tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)pointOnFace);
                } else {
                    face = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
                    HalfEdge3D edge2 = (HalfEdge3D)face.getEdge(random.nextInt(face.getNumberOfEdges()));
                    pointInside = EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)convexPolytope3D.getCentroid(), (Point3DReadOnly)face.getCentroid(), (Point3DReadOnly)edge2.getOrigin(), (Point3DReadOnly)edge2.getDestination());
                    tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointInside, (Vector3DReadOnly)face.getNormal(), 1.0);
                }
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, true, null, null);
            }
            if (convexPolytope3D.isEmpty()) {
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), false, null, null);
            } else {
                if (convexPolytope3D.getNumberOfVertices() == 1) {
                    tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)convexPolytope3D.getVertex(0));
                    Assertions.assertTrue((boolean)tetrahedron.isPointInside((Point3DReadOnly)convexPolytope3D.getVertex(0)));
                } else if (convexPolytope3D.getNumberOfVertices() == 2) {
                    edge = (HalfEdge3D)convexPolytope3D.getHalfEdge(0);
                    edgeDirection = edge.getDirection(true);
                    firstOrthogonalToEdge = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)edgeDirection, (boolean)true);
                    secondOrthogonalToEdge = new Vector3D();
                    secondOrthogonalToEdge.cross((Tuple3DReadOnly)firstOrthogonalToEdge, (Tuple3DReadOnly)edgeDirection);
                    firstTetraSegment = new LineSegment3D();
                    firstTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                    firstTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                    firstTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                    secondTetraSegment = new LineSegment3D();
                    secondTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                    secondTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                    firstOrthogonalToEdge.negate();
                    secondTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                    tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{firstTetraSegment.getFirstEndpoint(), firstTetraSegment.getSecondEndpoint(), secondTetraSegment.getFirstEndpoint(), secondTetraSegment.getSecondEndpoint()}));
                } else if (convexPolytope3D.getNumberOfFaces() == 1) {
                    face = (Face3D)convexPolytope3D.getFace(0);
                    pointOnFace = EuclidShapeRandomTools.nextPoint3DOnFace3D((Random)random, (Face3DReadOnly)face);
                    tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)pointOnFace);
                } else {
                    Face3D firstFace = (Face3D)convexPolytope3D.getFace(random.nextInt(convexPolytope3D.getNumberOfFaces()));
                    HalfEdge3D closestEdge = (HalfEdge3D)firstFace.getEdge(random.nextInt(firstFace.getNumberOfEdges()));
                    Point3D pointOnEdge = new Point3D();
                    pointOnEdge.interpolate((Tuple3DReadOnly)closestEdge.getOrigin(), (Tuple3DReadOnly)closestEdge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
                    Vector3D towardInside = new Vector3D();
                    towardInside.sub((Tuple3DReadOnly)convexPolytope3D.getCentroid(), (Tuple3DReadOnly)pointOnEdge);
                    towardInside.normalize();
                    Point3D pointInside2 = new Point3D();
                    double distanceInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.001);
                    pointInside2.scaleAdd(distanceInside, (Tuple3DReadOnly)towardInside, (Tuple3DReadOnly)pointOnEdge);
                    tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointInside2, (Vector3DReadOnly)towardInside, 1.0);
                }
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, true, null, null);
            }
            if (convexPolytope3D.isEmpty()) {
                GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random), false, null, null);
                continue;
            }
            if (convexPolytope3D.getNumberOfVertices() == 1) {
                tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)convexPolytope3D.getVertex(0));
                Assertions.assertTrue((boolean)tetrahedron.isPointInside((Point3DReadOnly)convexPolytope3D.getVertex(0)));
            } else if (convexPolytope3D.getNumberOfVertices() == 2) {
                edge = (HalfEdge3D)convexPolytope3D.getHalfEdge(0);
                edgeDirection = edge.getDirection(true);
                firstOrthogonalToEdge = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)edgeDirection, (boolean)true);
                secondOrthogonalToEdge = new Vector3D();
                secondOrthogonalToEdge.cross((Tuple3DReadOnly)firstOrthogonalToEdge, (Tuple3DReadOnly)edgeDirection);
                firstTetraSegment = new LineSegment3D();
                firstTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                firstTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)edgeDirection, (Tuple3DReadOnly)edge.midpoint());
                firstTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                secondTetraSegment = new LineSegment3D();
                secondTetraSegment.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                secondTetraSegment.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0), (Tuple3DReadOnly)secondOrthogonalToEdge, (Tuple3DReadOnly)edge.midpoint());
                firstOrthogonalToEdge.negate();
                secondTetraSegment.translate((Tuple3DReadOnly)firstOrthogonalToEdge);
                tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{firstTetraSegment.getFirstEndpoint(), firstTetraSegment.getSecondEndpoint(), secondTetraSegment.getFirstEndpoint(), secondTetraSegment.getSecondEndpoint()}));
            } else if (convexPolytope3D.getNumberOfFaces() == 1) {
                face = (Face3D)convexPolytope3D.getFace(0);
                pointOnFace = EuclidShapeRandomTools.nextPoint3DOnFace3D((Random)random, (Face3DReadOnly)face);
                tetrahedron = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)pointOnFace);
            } else {
                Vertex3D closestVertex = (Vertex3D)convexPolytope3D.getVertex(random.nextInt(convexPolytope3D.getNumberOfVertices()));
                Vector3D towardInside = new Vector3D();
                towardInside.sub((Tuple3DReadOnly)convexPolytope3D.getCentroid(), (Tuple3DReadOnly)closestVertex);
                pointInside = new Point3D();
                double distanceInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.001);
                pointInside.scaleAdd(distanceInside, (Tuple3DReadOnly)towardInside, (Tuple3DReadOnly)closestVertex);
                tetrahedron = GilbertJohnsonKeerthiCollisionDetectorTest.newTetrahedron(random, (Point3DReadOnly)pointInside, (Vector3DReadOnly)towardInside, 1.0);
            }
            GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)convexPolytope3D, (ConvexPolytope3DReadOnly)tetrahedron, true, null, null);
        }
    }

    @Test
    void testEdgeCollidingWithIcosahedronAndTetrahedron() throws Exception {
        Random random = new Random(54675476L);
        for (int i = 0; i < 5000; ++i) {
            ConvexPolytope3D icosahedron = EuclidShapeRandomTools.nextIcosahedronBasedConvexPolytope3D((Random)random);
            HalfEdge3D edge = (HalfEdge3D)icosahedron.getHalfEdge(random.nextInt(icosahedron.getNumberOfEdges()));
            Point3D pointOnEdge = new Point3D();
            pointOnEdge.interpolate((Tuple3DReadOnly)edge.getOrigin(), (Tuple3DReadOnly)edge.getDestination(), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Vector3D towardInside = new Vector3D();
            towardInside.sub((Tuple3DReadOnly)icosahedron.getCentroid(), (Tuple3DReadOnly)pointOnEdge);
            towardInside.normalize();
            Vector3D towardOutside = new Vector3D();
            towardOutside.setAndNegate((Tuple3DReadOnly)towardInside);
            Vector3D orthogonalToEdge = new Vector3D();
            orthogonalToEdge.cross((Tuple3DReadOnly)edge.getDirection(true), (Tuple3DReadOnly)towardOutside);
            orthogonalToEdge.normalize();
            LineSegment3D firstTetrahedronEdge = new LineSegment3D();
            firstTetrahedronEdge.getFirstEndpoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)orthogonalToEdge, (Tuple3DReadOnly)pointOnEdge);
            firstTetrahedronEdge.getSecondEndpoint().scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple3DReadOnly)orthogonalToEdge, (Tuple3DReadOnly)pointOnEdge);
            towardInside.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.001));
            firstTetrahedronEdge.translate((Tuple3DReadOnly)towardInside);
            LineSegment3D secondTetrahedronEdge = new LineSegment3D((LineSegment3DReadOnly)edge);
            secondTetrahedronEdge.translate((Tuple3DReadOnly)towardOutside);
            ConvexPolytope3D tetrahedron = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{firstTetrahedronEdge.getFirstEndpoint(), firstTetrahedronEdge.getSecondEndpoint(), secondTetrahedronEdge.getFirstEndpoint(), secondTetrahedronEdge.getSecondEndpoint()}));
            GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)icosahedron, (ConvexPolytope3DReadOnly)tetrahedron, true, null, null);
        }
    }

    @Test
    void testCollidingLineSegmentAndTriangle() throws Exception {
        Random random = new Random(34534L);
        for (int i = 0; i < 5000; ++i) {
            Point3D triangleA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D triangleB = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D triangleC = EuclidCoreRandomTools.nextPoint3D((Random)random);
            ConvexPolytope3D triangle = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{triangleA, triangleB, triangleC}));
            Point3D pointOnTriangle = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)triangleA, (Point3DReadOnly)triangleB, (Point3DReadOnly)triangleC);
            Vector3D orthogonalToNormal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)((Face3D)triangle.getFace(0)).getNormal(), (boolean)true);
            Vector3D direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)((Face3D)triangle.getFace(0)).getNormal(), (Tuple3DReadOnly)orthogonalToNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            direction.normalize();
            Point3D segmentStart = new Point3D();
            segmentStart.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)pointOnTriangle);
            Point3D segmentEnd = new Point3D();
            segmentEnd.scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)pointOnTriangle);
            ConvexPolytope3D lineSegment = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{segmentStart, segmentEnd}));
            GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)triangle, (ConvexPolytope3DReadOnly)lineSegment, true, null, null);
        }
    }

    @Test
    void testCollidingTriangles() throws Exception {
        Random random = new Random(34534L);
        for (int i = 0; i < 5000; ++i) {
            Point3D firstTriangleA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D firstTriangleB = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D firstTriangleC = EuclidCoreRandomTools.nextPoint3D((Random)random);
            ConvexPolytope3D firstTriangle = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{firstTriangleA, firstTriangleB, firstTriangleC}));
            Point3D pointOnTriangle = EuclidGeometryRandomTools.nextPoint3DInTriangle((Random)random, (Point3DReadOnly)firstTriangleA, (Point3DReadOnly)firstTriangleB, (Point3DReadOnly)firstTriangleC);
            Vector3D orthogonalToNormal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)((Face3D)firstTriangle.getFace(0)).getNormal(), (boolean)true);
            Vector3D direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)((Face3D)firstTriangle.getFace(0)).getNormal(), (Tuple3DReadOnly)orthogonalToNormal, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            direction.normalize();
            Point3D secondTriangleA = new Point3D();
            Point3D secondTriangleBase = new Point3D();
            secondTriangleA.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)pointOnTriangle);
            secondTriangleBase.scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)pointOnTriangle);
            Vector3D secondTriangleBaseDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)direction, (boolean)true);
            Point3D secondTriangleB = new Point3D();
            Point3D secondTriangleC = new Point3D();
            secondTriangleB.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)secondTriangleBaseDirection, (Tuple3DReadOnly)secondTriangleBase);
            secondTriangleC.scaleAdd(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)secondTriangleBaseDirection, (Tuple3DReadOnly)secondTriangleBase);
            ConvexPolytope3D secondTriangle = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{secondTriangleA, secondTriangleB, secondTriangleC}));
            GilbertJohnsonKeerthiCollisionDetectorTest.performAssertionsTwoCombinations("Iteration: " + i, (ConvexPolytope3DReadOnly)firstTriangle, (ConvexPolytope3DReadOnly)secondTriangle, true, null, null);
        }
    }

    public static ConvexPolytope3D newTetrahedron(Random random, Point3DReadOnly topVertex, Vector3DReadOnly topToBaseCentroid, double baseSize) {
        Point3D baseCentroid = new Point3D();
        baseCentroid.add((Tuple3DReadOnly)topVertex, (Tuple3DReadOnly)topToBaseCentroid);
        Point3D base0 = new Point3D(baseSize * EuclidCoreTools.cos((double)0.0), baseSize * EuclidCoreTools.sin((double)0.0), 0.0);
        Point3D base1 = new Point3D(baseSize * EuclidCoreTools.cos((double)1.0471975511965976), baseSize * EuclidCoreTools.sin((double)1.0471975511965976), 0.0);
        Point3D base2 = new Point3D(baseSize * EuclidCoreTools.cos((double)2.0943951023931953), baseSize * EuclidCoreTools.sin((double)2.0943951023931953), 0.0);
        AxisAngle rotation = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)topToBaseCentroid);
        rotation.transform((Tuple3DBasics)base0);
        rotation.transform((Tuple3DBasics)base1);
        rotation.transform((Tuple3DBasics)base2);
        base0.add((Tuple3DReadOnly)baseCentroid);
        base1.add((Tuple3DReadOnly)baseCentroid);
        base2.add((Tuple3DReadOnly)baseCentroid);
        ArrayList<Point3DReadOnly> vertices = new ArrayList<Point3DReadOnly>(Arrays.asList(topVertex, base0, base1, base2));
        Collections.shuffle(vertices, random);
        return new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier(vertices));
    }

    public static void performAssertionsTwoCombinations(String messagePrefix, ConvexPolytope3DReadOnly polytopeA, ConvexPolytope3DReadOnly polytopeB, boolean expectedCollisionTestResult, Point3DReadOnly expectedPointOnA, Point3DReadOnly expectedPointOnB) {
        GilbertJohnsonKeerthiCollisionDetectorTest.performAssertions(messagePrefix, polytopeA, polytopeB, expectedCollisionTestResult, expectedPointOnA, expectedPointOnB);
        GilbertJohnsonKeerthiCollisionDetectorTest.performAssertions(messagePrefix, polytopeB, polytopeA, expectedCollisionTestResult, expectedPointOnB, expectedPointOnA);
    }

    public static void performAssertions(String messagePrefix, ConvexPolytope3DReadOnly polytopeA, ConvexPolytope3DReadOnly polytopeB, boolean expectedCollisionTestResult, Point3DReadOnly expectedPointOnA, Point3DReadOnly expectedPointOnB) {
        GilbertJohnsonKeerthiCollisionDetector collisionDetector = new GilbertJohnsonKeerthiCollisionDetector();
        EuclidShape3DCollisionResult result = collisionDetector.evaluateCollision((Shape3DReadOnly)polytopeA, (Shape3DReadOnly)polytopeB);
        boolean actualCollisionTestResult = result.areShapesColliding();
        Assertions.assertEquals((Object)expectedCollisionTestResult, (Object)actualCollisionTestResult, (String)(messagePrefix + ", GJK distance: " + result.getSignedDistance()));
        boolean isOnePolytopeEmpty = polytopeA.isEmpty() || polytopeB.isEmpty();
        Assertions.assertTrue((polytopeA == result.getShapeA() ? 1 : 0) != 0);
        Assertions.assertTrue((polytopeB == result.getShapeB() ? 1 : 0) != 0);
        if (isOnePolytopeEmpty) {
            Assertions.assertNull((Object)collisionDetector.getSimplex(), (String)messagePrefix);
        } else {
            Assertions.assertNotNull((Object)collisionDetector.getSimplex().getVertices(), (String)messagePrefix);
        }
        if (isOnePolytopeEmpty) {
            Assertions.assertFalse((boolean)result.areShapesColliding());
            Assertions.assertTrue((boolean)Double.isNaN(result.getSignedDistance()));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((String)messagePrefix, (Tuple3DReadOnly)result.getPointOnA());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((String)messagePrefix, (Tuple3DReadOnly)result.getPointOnB());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((String)messagePrefix, (Tuple3DReadOnly)result.getNormalOnA());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((String)messagePrefix, (Tuple3DReadOnly)result.getNormalOnB());
        } else if (actualCollisionTestResult) {
            Assertions.assertTrue((boolean)Double.isNaN(result.getSignedDistance()));
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((String)messagePrefix, (Tuple3DReadOnly)result.getPointOnA());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((String)messagePrefix, (Tuple3DReadOnly)result.getPointOnB());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((String)messagePrefix, (Tuple3DReadOnly)result.getNormalOnA());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((String)messagePrefix, (Tuple3DReadOnly)result.getNormalOnB());
        } else {
            Point3D actualPointOnA = result.getPointOnA();
            Point3D actualPointOnB = result.getPointOnB();
            EuclidCoreTestTools.assertEquals((String)messagePrefix, (EuclidGeometry)expectedPointOnA, (EuclidGeometry)actualPointOnA, (double)2.0E-9);
            EuclidCoreTestTools.assertEquals((String)messagePrefix, (EuclidGeometry)expectedPointOnB, (EuclidGeometry)actualPointOnB, (double)2.0E-9);
        }
    }

    @Test
    void testSphere3DToSphere3D() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-9;
        double positionMaxEpsilon = 1.0E-6;
        double distanceMeanEpsilon = 1.0E-13;
        double positionMeanEpsilon = 1.2E-8;
        AnalyticalShapeCollisionDetection<Sphere3D, Sphere3D> function = new AnalyticalShapeCollisionDetection<Sphere3D, Sphere3D>(() -> {
            Sphere3D sphereA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D sphereB = EuclidShapeRandomTools.nextSphere3D((Random)random);
            sphereB.getPosition().add((Tuple3DReadOnly)sphereA.getPosition(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)5.0) * (sphereA.getRadius() + sphereB.getRadius()))));
            return new Pair<Sphere3D, Sphere3D>(sphereA, sphereB);
        }, EuclidShapeCollisionTools::evaluateSphere3DSphere3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testPointShape3DBox3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-13;
        double positionMaxEpsilon = 1.0E-13;
        double distanceMeanEpsilon = 1.0E-15;
        double positionMeanEpsilon = 1.0E-15;
        AnalyticalShapeCollisionDetection<PointShape3D, Box3D> function = new AnalyticalShapeCollisionDetection<PointShape3D, Box3D>(() -> {
            Vector3D normal;
            Point3D closestPointOnSurface;
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Box3D shapeB = EuclidShapeRandomTools.nextBox3D((Random)random);
            boolean colliding = shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA, (Point3DBasics)(closestPointOnSurface = new Point3D()), (Vector3DBasics)(normal = new Vector3D()));
            if (colliding) {
                shapeA.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            }
            return new Pair<PointShape3D, Box3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DBox3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testSphere3DBox3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-6;
        double positionMaxEpsilon = 5.0E-5;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-7;
        AnalyticalShapeCollisionDetection<Sphere3D, Box3D> function = new AnalyticalShapeCollisionDetection<Sphere3D, Box3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Box3D shapeB = EuclidShapeRandomTools.nextBox3D((Random)random);
            Point3D closestPointOnSurface = new Point3D();
            Vector3D normal = new Vector3D();
            shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA.getPosition(), (Point3DBasics)closestPointOnSurface, (Vector3DBasics)normal);
            shapeA.getPosition().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0) + shapeA.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            return new Pair<Sphere3D, Box3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DBox3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testPointShape3DCapsule3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-6;
        double positionMaxEpsilon = 5.0E-5;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 5.0E-8;
        AnalyticalShapeCollisionDetection<PointShape3D, Capsule3D> function = new AnalyticalShapeCollisionDetection<PointShape3D, Capsule3D>(() -> {
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Capsule3D shapeB = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Point3D closestPointOnSurface = new Point3D();
            Vector3D normal = new Vector3D();
            shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA, (Point3DBasics)closestPointOnSurface, (Vector3DBasics)normal);
            shapeA.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            return new Pair<PointShape3D, Capsule3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DCapsule3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testCapsule3DCapsule3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-7;
        double positionMaxEpsilon = 1.0E-5;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-6;
        AnalyticalShapeCollisionDetection<Capsule3D, Capsule3D> function = new AnalyticalShapeCollisionDetection<Capsule3D, Capsule3D>(() -> {
            Capsule3D shapeA = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D shapeB = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            return new Pair<Capsule3D, Capsule3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateCapsule3DCapsule3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testSphere3DCapsule3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-7;
        double positionMaxEpsilon = 5.0E-5;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-7;
        AnalyticalShapeCollisionDetection<Sphere3D, Capsule3D> function = new AnalyticalShapeCollisionDetection<Sphere3D, Capsule3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Capsule3D shapeB = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Point3D closestPointOnSurface = new Point3D();
            Vector3D normal = new Vector3D();
            shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA.getPosition(), (Point3DBasics)closestPointOnSurface, (Vector3DBasics)normal);
            shapeA.getPosition().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0) + shapeA.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            return new Pair<Sphere3D, Capsule3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DCapsule3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testPointShape3DCylinder3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-6;
        double positionMaxEpsilon = 1.0E-5;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-7;
        AnalyticalShapeCollisionDetection<PointShape3D, Cylinder3D> function = new AnalyticalShapeCollisionDetection<PointShape3D, Cylinder3D>(() -> {
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Cylinder3D shapeB = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Point3D closestPointOnSurface = new Point3D();
            Vector3D normal = new Vector3D();
            shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA, (Point3DBasics)closestPointOnSurface, (Vector3DBasics)normal);
            shapeA.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            return new Pair<PointShape3D, Cylinder3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DCylinder3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testSphere3DCylinder3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 5.0E-4;
        double positionMaxEpsilon = 0.0102;
        double distanceMeanEpsilon = 2.0E-8;
        double positionMeanEpsilon = 2.0E-5;
        AnalyticalShapeCollisionDetection<Sphere3D, Cylinder3D> function = new AnalyticalShapeCollisionDetection<Sphere3D, Cylinder3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Cylinder3D shapeB = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Point3D closestPointOnSurface = new Point3D();
            Vector3D normal = new Vector3D();
            shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA.getPosition(), (Point3DBasics)closestPointOnSurface, (Vector3DBasics)normal);
            shapeA.getPosition().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0) + shapeA.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            return new Pair<Sphere3D, Cylinder3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DCylinder3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testPointShape3DEllipsoid3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-7;
        double positionMaxEpsilon = 1.0E-4;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-7;
        AnalyticalShapeCollisionDetection<PointShape3D, Ellipsoid3D> function = new AnalyticalShapeCollisionDetection<PointShape3D, Ellipsoid3D>(() -> {
            Vector3D normal;
            Point3D closestPointOnSurface;
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Ellipsoid3D shapeB = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            boolean colliding = shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA, (Point3DBasics)(closestPointOnSurface = new Point3D()), (Vector3DBasics)(normal = new Vector3D()));
            if (colliding) {
                shapeA.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            }
            return new Pair<PointShape3D, Ellipsoid3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DEllipsoid3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testSphere3DEllipsoid3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-7;
        double positionMaxEpsilon = 1.0E-4;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-7;
        AnalyticalShapeCollisionDetection<Sphere3D, Ellipsoid3D> function = new AnalyticalShapeCollisionDetection<Sphere3D, Ellipsoid3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Ellipsoid3D shapeB = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Point3D closestPointOnSurface = new Point3D();
            Vector3D normal = new Vector3D();
            shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA.getPosition(), (Point3DBasics)closestPointOnSurface, (Vector3DBasics)normal);
            shapeA.getPosition().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0) + shapeA.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            return new Pair<Sphere3D, Ellipsoid3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DEllipsoid3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testPointShape3DRamp3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-14;
        double positionMaxEpsilon = 1.0E-13;
        double distanceMeanEpsilon = 1.0E-15;
        double positionMeanEpsilon = 1.0E-15;
        AnalyticalShapeCollisionDetection<PointShape3D, Ramp3D> function = new AnalyticalShapeCollisionDetection<PointShape3D, Ramp3D>(() -> {
            Vector3D normal;
            Point3D closestPointOnSurface;
            PointShape3D shapeA = EuclidShapeRandomTools.nextPointShape3D((Random)random);
            Ramp3D shapeB = EuclidShapeRandomTools.nextRamp3D((Random)random);
            boolean colliding = shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA, (Point3DBasics)(closestPointOnSurface = new Point3D()), (Vector3DBasics)(normal = new Vector3D()));
            if (colliding) {
                shapeA.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            }
            return new Pair<PointShape3D, Ramp3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluatePointShape3DRamp3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testSphere3DRamp3DCollisionTest() throws Exception {
        Random random = new Random(13741L);
        double distanceMaxEpsilon = 1.0E-6;
        double positionMaxEpsilon = 1.0E-4;
        double distanceMeanEpsilon = 1.0E-10;
        double positionMeanEpsilon = 1.0E-7;
        AnalyticalShapeCollisionDetection<Sphere3D, Ramp3D> function = new AnalyticalShapeCollisionDetection<Sphere3D, Ramp3D>(() -> {
            Sphere3D shapeA = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Ramp3D shapeB = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D closestPointOnSurface = new Point3D();
            Vector3D normal = new Vector3D();
            shapeB.evaluatePoint3DCollision((Point3DReadOnly)shapeA.getPosition(), (Point3DBasics)closestPointOnSurface, (Vector3DBasics)normal);
            shapeA.getPosition().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)4.0) + shapeA.getRadius(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)closestPointOnSurface);
            return new Pair<Sphere3D, Ramp3D>(shapeA, shapeB);
        }, EuclidShapeCollisionTools::evaluateSphere3DRamp3DCollision);
        GilbertJohnsonKeerthiCollisionDetectorTest.assertAgainstAnalyticalFunction(random, function, distanceMaxEpsilon, positionMaxEpsilon, distanceMeanEpsilon, positionMeanEpsilon);
    }

    @Test
    void testShapeTransformOptimization() {
        Random random = new Random(34686L);
        double distanceEpsilon = 1.0E-4;
        double pointTangentialEpsilon = 0.01;
        for (int i = 0; i < 50000; ++i) {
            Shape3DBasics shapeA = EuclidShapeRandomTools.nextConvexShape3D((Random)random);
            Shape3DBasics shapeB = EuclidShapeRandomTools.nextConvexShape3D((Random)random);
            GilbertJohnsonKeerthiCollisionDetector detector = new GilbertJohnsonKeerthiCollisionDetector();
            EuclidShape3DCollisionResult expectedResult = detector.evaluateCollision((SupportingVertexHolder)shapeA, (SupportingVertexHolder)shapeB);
            expectedResult.setShapeA((Shape3DReadOnly)shapeA);
            expectedResult.setShapeB((Shape3DReadOnly)shapeB);
            EuclidShape3DCollisionResult actualResult = detector.evaluateCollision((Shape3DReadOnly)shapeA, (Shape3DReadOnly)shapeB);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)distanceEpsilon, (double)pointTangentialEpsilon, (double)0.0);
        }
    }

    private static <A extends Shape3DReadOnly, B extends Shape3DReadOnly> void assertAgainstAnalyticalFunction(Random random, AnalyticalShapeCollisionDetection<A, B> function, double distanceMaxEpsilon, double positionMaxEpsilon, double distanceMeanEpsilon, double positionMeanEpsilon) {
        boolean verbose = false;
        double meanDistanceError = 0.0;
        double meanPositionError = 0.0;
        double maxDistanceError = 0.0;
        double maxPositionError = 0.0;
        int numberOfNonCollidingSamples = 0;
        for (int i = 0; i < 5000; ++i) {
            String iterationPrefix = "Iteration #" + i;
            Pair shapes = function.shapeSupplier.get();
            Shape3DReadOnly shapeA = (Shape3DReadOnly)shapes.a;
            Shape3DReadOnly shapeB = (Shape3DReadOnly)shapes.b;
            EuclidShape3DCollisionResult expectedResult = function.collisionFunction.apply(shapeA, shapeB);
            EuclidShape3DCollisionResult gjkResult = new EuclidShape3DCollisionResult();
            GilbertJohnsonKeerthiCollisionDetector gjkDetector = new GilbertJohnsonKeerthiCollisionDetector();
            if (random.nextBoolean()) {
                gjkDetector.evaluateCollision(shapeA, shapeB, (EuclidShape3DCollisionResultBasics)gjkResult);
            } else {
                gjkDetector.evaluateCollision(shapeB, shapeA, (EuclidShape3DCollisionResultBasics)gjkResult);
                gjkResult.swapShapes();
            }
            double distanceError = Math.abs(expectedResult.getSignedDistance() - gjkResult.getSignedDistance());
            if (verbose && i % 5000 == 0) {
                System.out.println(iterationPrefix + ", Number of its: " + gjkDetector.getNumberOfIterations() + " Analytical: " + expectedResult.getSignedDistance() + ", GJK: " + gjkResult.getSignedDistance() + ", diff: " + distanceError);
            }
            Assertions.assertEquals((Object)expectedResult.areShapesColliding(), (Object)gjkResult.areShapesColliding(), (String)(iterationPrefix + " Analytical: " + expectedResult.getSignedDistance() + ", GJK: " + gjkResult.getSignedDistance() + ", diff: " + distanceError));
            if (gjkResult.areShapesColliding()) {
                Assertions.assertTrue((boolean)gjkResult.containsNaN(), (String)iterationPrefix);
                Assertions.assertTrue((boolean)gjkResult.getPointOnA().containsNaN(), (String)iterationPrefix);
                Assertions.assertTrue((boolean)gjkResult.getPointOnB().containsNaN(), (String)iterationPrefix);
                Assertions.assertTrue((boolean)Double.isNaN(gjkResult.getSignedDistance()), (String)iterationPrefix);
            } else {
                double positionErrorOnA = expectedResult.getPointOnA().distance((Point3DReadOnly)gjkResult.getPointOnA());
                double positionErrorOnB = expectedResult.getPointOnB().distance((Point3DReadOnly)gjkResult.getPointOnB());
                Assertions.assertEquals((double)expectedResult.getSignedDistance(), (double)gjkResult.getSignedDistance(), (double)distanceMaxEpsilon, (String)(iterationPrefix + ", difference: " + distanceError));
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)iterationPrefix, (Point3DReadOnly)expectedResult.getPointOnA(), (Point3DReadOnly)gjkResult.getPointOnA(), (double)positionMaxEpsilon);
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)iterationPrefix, (Point3DReadOnly)expectedResult.getPointOnB(), (Point3DReadOnly)gjkResult.getPointOnB(), (double)positionMaxEpsilon);
                ++numberOfNonCollidingSamples;
                meanDistanceError += distanceError;
                meanPositionError += positionErrorOnA;
                meanPositionError += positionErrorOnB;
                maxDistanceError = Math.max(maxDistanceError, distanceError);
                maxPositionError = EuclidCoreTools.max((double)maxPositionError, (double)positionErrorOnA, (double)positionErrorOnB);
            }
            Assertions.assertTrue((boolean)gjkResult.getNormalOnA().containsNaN(), (String)iterationPrefix);
            Assertions.assertTrue((boolean)gjkResult.getNormalOnB().containsNaN(), (String)iterationPrefix);
        }
        meanDistanceError /= (double)numberOfNonCollidingSamples;
        meanPositionError /= 2.0 * (double)numberOfNonCollidingSamples;
        if (verbose) {
            System.out.println("Number of iterations: 5000, number of non-colliding samples: " + numberOfNonCollidingSamples);
            System.out.println("Max error for the distance: " + maxDistanceError + ", position: " + maxPositionError);
            System.out.println("Average error for the distance: " + meanDistanceError + ", position: " + meanPositionError);
        }
        Assertions.assertTrue((meanDistanceError < distanceMeanEpsilon ? 1 : 0) != 0, (String)("mean distance error: " + meanDistanceError + " expected less than: " + distanceMeanEpsilon));
        Assertions.assertTrue((meanPositionError < positionMeanEpsilon ? 1 : 0) != 0, (String)("mean position error: " + meanPositionError + " expected less than: " + positionMeanEpsilon));
    }

    static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }

    static class Pair<A, B> {
        final A a;
        final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    static class AnalyticalShapeCollisionDetection<A extends Shape3DReadOnly, B extends Shape3DReadOnly> {
        final Supplier<Pair<A, B>> shapeSupplier;
        final BiFunction<A, B, EuclidShape3DCollisionResult> collisionFunction;

        public AnalyticalShapeCollisionDetection(Supplier<Pair<A, B>> shapeSupplier, TriConsumer<A, B, EuclidShape3DCollisionResult> collisionFunction) {
            this(shapeSupplier, AnalyticalShapeCollisionDetection.toBiFunction(collisionFunction));
        }

        public AnalyticalShapeCollisionDetection(Supplier<Pair<A, B>> shapeSupplier, BiFunction<A, B, EuclidShape3DCollisionResult> collisionFunction) {
            this.shapeSupplier = shapeSupplier;
            this.collisionFunction = collisionFunction;
        }

        private static <A extends Shape3DReadOnly, B extends Shape3DReadOnly> BiFunction<A, B, EuclidShape3DCollisionResult> toBiFunction(TriConsumer<A, B, EuclidShape3DCollisionResult> triConsumer) {
            return (t, u) -> {
                EuclidShape3DCollisionResult result = new EuclidShape3DCollisionResult();
                triConsumer.accept(t, u, result);
                return result;
            };
        }
    }
}

