/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public abstract class FrameTuple2DReadOnlyTest<F extends FrameTuple2DReadOnly> {
    public static final double EPSILON = 1.0E-15;

    public F createEmptyFrameTuple() {
        return this.createFrameTuple(ReferenceFrame.getWorldFrame(), 0.0, 0.0);
    }

    public final F createEmptyFrameTuple(ReferenceFrame referenceFrame) {
        return this.createFrameTuple(referenceFrame, 0.0, 0.0);
    }

    public F createRandomFrameTuple(Random random) {
        return this.createFrameTuple(ReferenceFrame.getWorldFrame(), random.nextDouble(), random.nextDouble());
    }

    public final F createRandomFrameTuple(Random random, ReferenceFrame referenceFrame) {
        return this.createFrameTuple(referenceFrame, random.nextDouble(), random.nextDouble());
    }

    public final F createFrameTuple(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple) {
        return this.createFrameTuple(referenceFrame, tuple.getX(), tuple.getY());
    }

    public final F createFrameTuple(F frameTuple) {
        return this.createFrameTuple(frameTuple.getReferenceFrame(), (Tuple2DReadOnly)frameTuple);
    }

    public F createFrameTuple(double x, double y) {
        return this.createFrameTuple(ReferenceFrame.getWorldFrame(), x, y);
    }

    public abstract F createFrameTuple(ReferenceFrame var1, double var2, double var4);

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = 0.0;
        ReferenceFrame frame1 = ReferenceFrame.getWorldFrame();
        ReferenceFrame frame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double x = random.nextDouble();
        double y = random.nextDouble();
        F tuple1 = this.createFrameTuple(frame1, x, y);
        F tuple2 = this.createFrameTuple(frame1, x, y);
        F tuple3 = this.createFrameTuple(frame2, x, y);
        F tuple4 = this.createFrameTuple(frame2, x, y);
        Assertions.assertTrue((boolean)tuple1.epsilonEquals(tuple2, epsilon));
        Assertions.assertFalse((boolean)tuple1.epsilonEquals(tuple3, epsilon));
        Assertions.assertFalse((boolean)tuple3.epsilonEquals(tuple2, epsilon));
        Assertions.assertTrue((boolean)tuple3.epsilonEquals(tuple4, epsilon));
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame frame1 = ReferenceFrame.getWorldFrame();
        ReferenceFrame frame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double x = random.nextDouble();
        double y = random.nextDouble();
        F tuple1 = this.createFrameTuple(frame1, x, y);
        F tuple2 = this.createFrameTuple(frame1, x, y);
        F tuple3 = this.createFrameTuple(frame2, x, y);
        F tuple4 = this.createFrameTuple(frame2, x, y);
        Assertions.assertTrue((boolean)tuple1.equals(tuple2));
        Assertions.assertFalse((boolean)tuple1.equals(tuple3));
        Assertions.assertFalse((boolean)tuple3.equals(tuple2));
        Assertions.assertTrue((boolean)tuple3.equals(tuple4));
        F tuple2AsObject = tuple2;
        F tuple3AsObject = tuple3;
        F tuple4AsObject = tuple4;
        Assertions.assertTrue((boolean)tuple1.equals(tuple2AsObject));
        Assertions.assertFalse((boolean)tuple1.equals(tuple3AsObject));
        Assertions.assertFalse((boolean)tuple3.equals(tuple2AsObject));
        Assertions.assertTrue((boolean)tuple3.equals(tuple4AsObject));
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameTuple2DReadOnly.class, Tuple2DReadOnly.class, true);
    }
}

