/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.ConvexPolygon2DBasicsTest;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public class ConvexPolygon2DTest
extends ConvexPolygon2DBasicsTest<ConvexPolygon2D> {
    @Override
    public ConvexPolygon2D createEmptyConvexPolygon2D() {
        return new ConvexPolygon2D();
    }

    @Override
    public ConvexPolygon2D createRandomConvexPolygon2D(Random random) {
        return EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)2.0, (int)50);
    }

    @Override
    public ConvexPolygon2D createConvexPolygon2D(Vertex2DSupplier supplier) {
        return new ConvexPolygon2D(supplier);
    }

    @Test
    public void testIssue17() throws Exception {
        ConvexPolygon2D polygon;
        Point2D pointB;
        Point2D pointA;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            pointB = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            polygon = new ConvexPolygon2D();
            polygon.addVertex((Point2DReadOnly)pointA);
            polygon.addVertex((Point2DReadOnly)pointA);
            polygon.addVertex((Point2DReadOnly)pointB);
            polygon.addVertex((Point2DReadOnly)pointB);
            Assertions.assertFalse((boolean)pointA.epsilonEquals((EuclidGeometry)pointB, 1.0E-7));
            polygon.update();
            Assertions.assertEquals((int)2, (int)polygon.getNumberOfVertices());
            if (polygon.getVertex(0).equals((EuclidGeometry)pointA)) {
                Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointB);
                continue;
            }
            Assertions.assertEquals((Object)polygon.getVertex(0), (Object)pointB);
            Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointA);
        }
        for (i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            pointB = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            polygon = new ConvexPolygon2D();
            polygon.addVertex((Point2DReadOnly)pointA);
            polygon.addVertex((Point2DReadOnly)pointB);
            polygon.addVertex((Point2DReadOnly)pointA);
            polygon.addVertex((Point2DReadOnly)pointB);
            Assertions.assertFalse((boolean)pointA.epsilonEquals((EuclidGeometry)pointB, 1.0E-7));
            polygon.update();
            Assertions.assertEquals((int)2, (int)polygon.getNumberOfVertices());
            if (polygon.getVertex(0).equals((EuclidGeometry)pointA)) {
                Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointB);
                continue;
            }
            Assertions.assertEquals((Object)polygon.getVertex(0), (Object)pointB);
            Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointA);
        }
    }

    @Test
    public void testConstructors() {
        ConvexPolygon2D defaultConstructor = new ConvexPolygon2D();
        Assertions.assertEquals((double)0.0, (double)defaultConstructor.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be zero");
        Assertions.assertTrue((boolean)defaultConstructor.isUpToDate());
        int numberOfVertices = 4;
        ArrayList<Point2D> verticesList = new ArrayList<Point2D>();
        verticesList.add(new Point2D(0.0, 0.0));
        verticesList.add(new Point2D(0.0, 1.0));
        verticesList.add(new Point2D(1.0, 0.0));
        verticesList.add(new Point2D(1.0, 1.0));
        ConvexPolygon2D listInt = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(verticesList, (int)numberOfVertices));
        Assertions.assertEquals((double)4.0, (double)listInt.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be 4");
        ConvexPolygon2D list = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(verticesList));
        Assertions.assertEquals((double)4.0, (double)list.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be 4");
        double[][] verticesArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
        ConvexPolygon2D doubleInt = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray, (int)numberOfVertices));
        Assertions.assertEquals((double)4.0, (double)doubleInt.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be four");
        Assertions.assertTrue((boolean)doubleInt.isUpToDate());
        ConvexPolygon2D doubles = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesArray));
        Assertions.assertEquals((double)4.0, (double)doubles.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be four");
        Assertions.assertTrue((boolean)doubles.isUpToDate());
        ConvexPolygon2D polygon = new ConvexPolygon2D((Vertex2DSupplier)doubles);
        Assertions.assertEquals((double)4.0, (double)polygon.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be four");
        Assertions.assertTrue((boolean)polygon.isUpToDate());
        ConvexPolygon2D polygonPolygon = new ConvexPolygon2D((Vertex2DSupplier)doubleInt, (Vertex2DSupplier)doubles);
        Assertions.assertEquals((double)4.0, (double)polygonPolygon.getNumberOfVertices(), (double)1.0E-10, (String)"Number of vertices should be four");
        Assertions.assertTrue((boolean)polygonPolygon.isUpToDate());
    }
}

