/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.yawPitchRoll;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRollReadOnlyTest;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public abstract class YawPitchRollBasicsTest<T extends YawPitchRollBasics>
extends YawPitchRollReadOnlyTest<T> {
    @Test
    public void testComponentSetters() {
        YawPitchRollBasics ypr;
        int i;
        Random random = new Random(5464L);
        for (i = 0; i < 1000; ++i) {
            ypr = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            Assertions.assertTrue((ypr.getYaw() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == 0.0 ? 1 : 0) != 0);
            double expectedYaw = random.nextDouble();
            ypr.setYaw(expectedYaw);
            Assertions.assertTrue((ypr.getYaw() == expectedYaw ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            Assertions.assertTrue((ypr.getYaw() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == 0.0 ? 1 : 0) != 0);
            double expectedPitch = random.nextDouble();
            ypr.setPitch(expectedPitch);
            Assertions.assertTrue((ypr.getYaw() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == expectedPitch ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            Assertions.assertTrue((ypr.getYaw() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == 0.0 ? 1 : 0) != 0);
            double expectedRoll = random.nextDouble();
            ypr.setRoll(expectedRoll);
            Assertions.assertTrue((ypr.getYaw() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == expectedRoll ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetToZero() {
        YawPitchRollBasics ypr = (YawPitchRollBasics)this.createYawPitchRoll(Double.NaN, Double.NaN, Double.NaN);
        Assertions.assertTrue((boolean)Double.isNaN(ypr.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(ypr.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(ypr.getRoll()));
        ypr.setToZero();
        Assertions.assertTrue((ypr.getYaw() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((ypr.getPitch() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((ypr.getRoll() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetToNaN() {
        YawPitchRollBasics ypr = (YawPitchRollBasics)this.createYawPitchRoll(0.0, 0.0, 0.0);
        Assertions.assertTrue((ypr.getYaw() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((ypr.getPitch() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((ypr.getRoll() == 0.0 ? 1 : 0) != 0);
        ypr.setToNaN();
        Assertions.assertTrue((boolean)Double.isNaN(ypr.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(ypr.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(ypr.getRoll()));
    }

    @Test
    public void testNegate() {
        Random random = new Random(5646541L);
        for (int i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random);
            YawPitchRollBasics expectedYPR = (YawPitchRollBasics)this.createYawPitchRoll(-yaw, -pitch, -roll);
            YawPitchRollBasics actualYPR = (YawPitchRollBasics)this.createYawPitchRoll(yaw, pitch, roll);
            actualYPR.negate();
            Assertions.assertTrue((boolean)expectedYPR.equals((YawPitchRollReadOnly)actualYPR));
        }
    }

    @Test
    public void testAbsolute() {
        Random random = new Random(5646541L);
        for (int i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random);
            YawPitchRollBasics expectedYPR = (YawPitchRollBasics)this.createYawPitchRoll(Math.abs(yaw), Math.abs(pitch), Math.abs(roll));
            YawPitchRollBasics actualYPR = (YawPitchRollBasics)this.createYawPitchRoll(yaw, pitch, roll);
            actualYPR.absolute();
            Assertions.assertTrue((boolean)expectedYPR.equals((YawPitchRollReadOnly)actualYPR));
        }
    }

    @Test
    public void testInvert() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRollBasics ypr = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            YawPitchRollBasics inverseYPR = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            inverseYPR.set((YawPitchRollReadOnly)ypr);
            inverseYPR.invert();
            RotationMatrix rotationMatrix = new RotationMatrix((Orientation3DReadOnly)ypr);
            RotationMatrix inverseRotationMatrix = new RotationMatrix((Orientation3DReadOnly)inverseYPR);
            RotationMatrix identityExpected = new RotationMatrix();
            identityExpected.set(rotationMatrix);
            identityExpected.multiply((RotationMatrixReadOnly)inverseRotationMatrix);
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)identityExpected, (double)this.getEpsilon());
            YawPitchRollBasics zeroExpected = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            YawPitchRollTools.multiply((Orientation3DReadOnly)ypr, (boolean)false, (Orientation3DReadOnly)inverseYPR, (boolean)false, (YawPitchRollBasics)zeroExpected);
            EuclidCoreTestTools.assertAngleEquals((double)0.0, (double)zeroExpected.getYaw(), (double)this.getEpsilon());
            EuclidCoreTestTools.assertAngleEquals((double)0.0, (double)zeroExpected.getPitch(), (double)this.getEpsilon());
            EuclidCoreTestTools.assertAngleEquals((double)0.0, (double)zeroExpected.getRoll(), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetWithDoubles() {
        Random random = new Random(5646541L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRollBasics expectedYPR = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            YawPitchRollBasics actualYPR = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            actualYPR.set(expectedYPR.getYaw(), expectedYPR.getPitch(), expectedYPR.getRoll());
            Assertions.assertTrue((boolean)expectedYPR.equals((YawPitchRollReadOnly)actualYPR));
        }
    }

    @Test
    public void testSet() {
        Object[] axisAngleArray;
        int i;
        YawPitchRollBasics actualYPR = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
        YawPitchRollBasics expectedYPR = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
        Random random = new Random(64654L);
        for (i = 0; i < 1000; ++i) {
            expectedYPR = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            actualYPR.set((YawPitchRollReadOnly)expectedYPR);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)actualYPR, (YawPitchRollReadOnly)expectedYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedYPR = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            actualYPR.set((YawPitchRollReadOnly)expectedYPR);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)actualYPR, (YawPitchRollReadOnly)expectedYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedYPR = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            double[] axisAngleArray2 = new double[]{expectedYPR.getYaw(), expectedYPR.getPitch(), expectedYPR.getRoll()};
            actualYPR.set(axisAngleArray2);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYPR, (YawPitchRollReadOnly)actualYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedYPR = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            int startIndex = random.nextInt(10);
            axisAngleArray = new double[4 + startIndex + random.nextInt(10)];
            expectedYPR.get(startIndex, axisAngleArray);
            actualYPR.set(startIndex, axisAngleArray);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYPR, (YawPitchRollReadOnly)actualYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedYPR = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            float[] axisAngleArray3 = new float[]{expectedYPR.getYaw32(), expectedYPR.getPitch32(), expectedYPR.getRoll32()};
            actualYPR.set(axisAngleArray3);
            Assertions.assertTrue((expectedYPR.getYaw32() == actualYPR.getYaw32() ? 1 : 0) != 0);
            Assertions.assertTrue((expectedYPR.getPitch32() == actualYPR.getPitch32() ? 1 : 0) != 0);
            Assertions.assertTrue((expectedYPR.getRoll32() == actualYPR.getRoll32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            expectedYPR = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            int startIndex = random.nextInt(10);
            axisAngleArray = new float[4 + startIndex + random.nextInt(10)];
            expectedYPR.get(startIndex, (float[])axisAngleArray);
            actualYPR.set(startIndex, (float[])axisAngleArray);
            Assertions.assertTrue((expectedYPR.getYaw32() == actualYPR.getYaw32() ? 1 : 0) != 0);
            Assertions.assertTrue((expectedYPR.getPitch32() == actualYPR.getPitch32() ? 1 : 0) != 0);
            Assertions.assertTrue((expectedYPR.getRoll32() == actualYPR.getRoll32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualYPR.set((Orientation3DReadOnly)quaternion);
            YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (YawPitchRollBasics)expectedYPR);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYPR, (YawPitchRollReadOnly)actualYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualYPR.set((Orientation3DReadOnly)matrix);
            YawPitchRollConversion.convertMatrixToYawPitchRoll((RotationMatrixReadOnly)matrix, (YawPitchRollBasics)expectedYPR);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYPR, (YawPitchRollReadOnly)actualYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            actualYPR.setRotationVector((Vector3DReadOnly)rotationVector);
            YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (YawPitchRollBasics)expectedYPR);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYPR, (YawPitchRollReadOnly)actualYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualYPR.set((Orientation3DReadOnly)axisAngle);
            YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (YawPitchRollBasics)expectedYPR);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYPR, (YawPitchRollReadOnly)actualYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.5707963267948966);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actualYPR.setYawPitchRoll(yaw, pitch, roll);
            expectedYPR.set(yaw, pitch, roll);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYPR, (YawPitchRollReadOnly)actualYPR, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            actualYPR = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            for (int index = 0; index < 3; ++index) {
                double expectedValue = random.nextDouble();
                actualYPR.setElement(index, expectedValue);
                double actualValue = actualYPR.getElement(index);
                Assertions.assertEquals((double)expectedValue, (double)actualValue, (double)this.getEpsilon());
            }
        }
    }

    @Test
    public void testAppend() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngle orientation;
            switch (random.nextInt(5)) {
                case 0: {
                    orientation = EuclidCoreRandomTools.nextAxisAngle((Random)random);
                    break;
                }
                case 1: {
                    orientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
                    break;
                }
                case 2: {
                    orientation = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
                    break;
                }
                default: {
                    orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                }
            }
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            actual.set((YawPitchRollReadOnly)original);
            actual.append((Orientation3DReadOnly)orientation);
            q.set((Orientation3DReadOnly)original);
            q.append((Orientation3DReadOnly)orientation);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendInvertOther() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngle orientation;
            switch (random.nextInt(5)) {
                case 0: {
                    orientation = EuclidCoreRandomTools.nextAxisAngle((Random)random);
                    break;
                }
                case 1: {
                    orientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
                    break;
                }
                case 2: {
                    orientation = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
                    break;
                }
                default: {
                    orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                }
            }
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            actual.set((YawPitchRollReadOnly)original);
            actual.appendInvertOther((Orientation3DReadOnly)orientation);
            q.set((Orientation3DReadOnly)original);
            q.appendInvertOther((Orientation3DReadOnly)orientation);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendYawRotation() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)original);
            actual.appendYawRotation(yaw);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            q.appendYawRotation(yaw);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendPitchRotation() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)original);
            actual.appendPitchRotation(pitch);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            q.appendPitchRotation(pitch);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendRollRotation() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)original);
            actual.appendRollRotation(roll);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            q.appendRollRotation(roll);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrepend() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngle orientation;
            switch (random.nextInt(5)) {
                case 0: {
                    orientation = EuclidCoreRandomTools.nextAxisAngle((Random)random);
                    break;
                }
                case 1: {
                    orientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
                    break;
                }
                case 2: {
                    orientation = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
                    break;
                }
                default: {
                    orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                }
            }
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            actual.set((YawPitchRollReadOnly)original);
            actual.prepend((Orientation3DReadOnly)orientation);
            q.set((Orientation3DReadOnly)original);
            q.prepend((Orientation3DReadOnly)orientation);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependInvertOther() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngle orientation;
            switch (random.nextInt(5)) {
                case 0: {
                    orientation = EuclidCoreRandomTools.nextAxisAngle((Random)random);
                    break;
                }
                case 1: {
                    orientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
                    break;
                }
                case 2: {
                    orientation = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
                    break;
                }
                default: {
                    orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                }
            }
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createEmptyYawPitchRoll();
            actual.set((YawPitchRollReadOnly)original);
            actual.prependInvertOther((Orientation3DReadOnly)orientation);
            q.set((Orientation3DReadOnly)original);
            q.prependInvertOther((Orientation3DReadOnly)orientation);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependYawRotation() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)original);
            actual.prependYawRotation(yaw);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            q.prependYawRotation(yaw);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependPitchRotation() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)original);
            actual.prependPitchRotation(pitch);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            q.prependPitchRotation(pitch);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependRollRotation() {
        Random random = new Random(4353L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRollBasics original = (YawPitchRollBasics)this.createRandomYawPitchRoll(random);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            YawPitchRollBasics actual = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)original);
            actual.prependRollRotation(roll);
            Quaternion q = new Quaternion((Orientation3DReadOnly)original);
            q.prependRollRotation(roll);
            YawPitchRollBasics expected = (YawPitchRollBasics)this.createYawPitchRoll((Orientation3DReadOnly)q);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }
}

