/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Tuple4DBasicsTest;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public abstract class Vector4DBasicsTest<T extends Vector4DBasics>
extends Tuple4DBasicsTest<T> {
    @Override
    public void testSetDoubles() {
        Random random = new Random(621541L);
        Vector4DBasics vector = (Vector4DBasics)this.createEmptyTuple();
        for (int i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y = random.nextDouble();
            double z = random.nextDouble();
            double s = random.nextDouble();
            vector.set(x, y, z, s);
            Assertions.assertEquals((double)vector.getX(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)vector.getY(), (double)y, (double)this.getEpsilon());
            Assertions.assertEquals((double)vector.getZ(), (double)z, (double)this.getEpsilon());
            Assertions.assertEquals((double)vector.getS(), (double)s, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            Vector4DBasics tuple = (Vector4DBasics)this.createEmptyTuple();
            tuple.setX(random.nextDouble());
            tuple.setY(random.nextDouble());
            tuple.setZ(random.nextDouble());
            tuple.setS(random.nextDouble());
            tuple.setToZero();
            Assertions.assertTrue((tuple.getX() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getS() == 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTuple3DSetters() throws Exception {
        int index;
        Vector4DBasics tuple;
        int i;
        Random random = new Random(4325234L);
        for (i = 0; i < 1000; ++i) {
            tuple = (Vector4DBasics)this.createEmptyTuple();
            Point3D point3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            tuple.set((Point3DReadOnly)point3D);
            for (index = 0; index < 3; ++index) {
                Assertions.assertEquals((double)tuple.getElement(index), (double)point3D.getElement(index), (double)this.getEpsilon());
            }
            Assertions.assertTrue((tuple.getS() == 1.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            tuple = (Vector4DBasics)this.createEmptyTuple();
            Vector3D vector3D = EuclidCoreRandomTools.nextVector3D((Random)random);
            tuple.set((Vector3DReadOnly)vector3D);
            for (index = 0; index < 3; ++index) {
                Assertions.assertEquals((double)tuple.getElement(index), (double)vector3D.getElement(index), (double)this.getEpsilon());
            }
            Assertions.assertTrue((tuple.getS() == 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSettersForIndividualComponents() throws Exception {
        double x;
        int i;
        Random random = new Random(621541L);
        Vector4DBasics vector = (Vector4DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble();
            vector.setX(x);
            Assertions.assertEquals((double)vector.getX(), (double)x, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            double y = random.nextDouble();
            vector.setY(y);
            Assertions.assertEquals((double)vector.getY(), (double)y, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            double z = random.nextDouble();
            vector.setZ(z);
            Assertions.assertEquals((double)vector.getZ(), (double)z, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            double s = random.nextDouble();
            vector.setS(s);
            Assertions.assertEquals((double)vector.getS(), (double)s, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            try {
                vector.setElement(-1, random.nextDouble());
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException s) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            try {
                vector.setElement(4, random.nextDouble());
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            x = random.nextDouble();
            double y = random.nextDouble();
            double z = random.nextDouble();
            double s = random.nextDouble();
            vector.setElement(0, x);
            vector.setElement(1, y);
            vector.setElement(2, z);
            vector.setElement(3, s);
            Assertions.assertEquals((double)vector.getX(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)vector.getY(), (double)y, (double)this.getEpsilon());
            Assertions.assertEquals((double)vector.getZ(), (double)z, (double)this.getEpsilon());
            Assertions.assertEquals((double)vector.getS(), (double)s, (double)this.getEpsilon());
        }
    }

    @Test
    public void testClip() throws Exception {
        double max;
        double min;
        double max2;
        int i;
        Random random = new Random(621541L);
        Vector4DBasics tuple1 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple2 = (Vector4DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            max2 = random.nextDouble();
            tuple1.setX(max2 + random.nextDouble());
            tuple1.setY(max2 + random.nextDouble());
            tuple1.setZ(max2 + random.nextDouble());
            tuple1.setS(max2 + random.nextDouble());
            tuple1.clipToMax(max2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)max2, (double)this.getEpsilon());
            max2 = random.nextDouble();
            tuple1.setX(max2 - random.nextDouble());
            tuple1.setY(max2 - random.nextDouble());
            tuple1.setZ(max2 - random.nextDouble());
            tuple1.setS(max2 - random.nextDouble());
            tuple1.set((Tuple4DReadOnly)tuple2);
            tuple1.clipToMax(max2);
            Assertions.assertTrue((boolean)tuple1.equals((Tuple4DReadOnly)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            max2 = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple1.setS(random.nextDouble());
            tuple2.setX(max2 + random.nextDouble());
            tuple2.setY(max2 + random.nextDouble());
            tuple2.setZ(max2 + random.nextDouble());
            tuple2.setS(max2 + random.nextDouble());
            tuple1.setAndClipToMax(max2, (Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)max2, (double)this.getEpsilon());
            max2 = random.nextDouble();
            tuple2.setX(max2 - random.nextDouble());
            tuple2.setY(max2 - random.nextDouble());
            tuple2.setZ(max2 - random.nextDouble());
            tuple2.setS(max2 - random.nextDouble());
            tuple1.setAndClipToMax(max2, (Tuple4DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((Tuple4DReadOnly)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            tuple1.setX(min - random.nextDouble());
            tuple1.setY(min - random.nextDouble());
            tuple1.setZ(min - random.nextDouble());
            tuple1.setS(min - random.nextDouble());
            tuple1.clipToMin(min);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble();
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple2.setZ(min + random.nextDouble());
            tuple2.setS(min + random.nextDouble());
            tuple1.set((Tuple4DReadOnly)tuple2);
            tuple1.clipToMin(min);
            Assertions.assertTrue((boolean)tuple1.equals((Tuple4DReadOnly)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple1.setS(random.nextDouble());
            tuple2.setX(min - random.nextDouble());
            tuple2.setY(min - random.nextDouble());
            tuple2.setZ(min - random.nextDouble());
            tuple2.setS(min - random.nextDouble());
            tuple1.setAndClipToMin(min, (Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble();
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple2.setZ(min + random.nextDouble());
            tuple2.setS(min + random.nextDouble());
            tuple1.setAndClipToMin(min, (Tuple4DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((Tuple4DReadOnly)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(min - random.nextDouble());
            tuple1.setY(min - random.nextDouble());
            tuple1.setZ(min - random.nextDouble());
            tuple1.setS(min - random.nextDouble());
            tuple1.clipToMinMax(min, max);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(max + random.nextDouble());
            tuple1.setY(max + random.nextDouble());
            tuple1.setZ(max + random.nextDouble());
            tuple1.setS(max + random.nextDouble());
            tuple1.clipToMinMax(min, max);
            Assertions.assertEquals((double)tuple1.getX(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)max, (double)this.getEpsilon());
            min = random.nextDouble() - 1.0;
            max = random.nextDouble() + 1.0;
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple2.setZ(min + random.nextDouble());
            tuple2.setS(min + random.nextDouble());
            tuple1.set((Tuple4DReadOnly)tuple2);
            tuple1.clipToMinMax(min, max);
            Assertions.assertTrue((boolean)tuple1.equals((Tuple4DReadOnly)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple1.setS(random.nextDouble());
            tuple2.setX(min - random.nextDouble());
            tuple2.setY(min - random.nextDouble());
            tuple2.setZ(min - random.nextDouble());
            tuple2.setS(min - random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple1.setS(random.nextDouble());
            tuple2.setX(max + random.nextDouble());
            tuple2.setY(max + random.nextDouble());
            tuple2.setZ(max + random.nextDouble());
            tuple2.setS(max + random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)max, (double)this.getEpsilon());
            min = random.nextDouble() - 1.0;
            max = random.nextDouble() + 1.0;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple1.setS(random.nextDouble());
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple2.setZ(min + random.nextDouble());
            tuple2.setS(min + random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple4DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((Tuple4DReadOnly)tuple2));
        }
    }

    @Test
    public void testAdd() throws Exception {
        double s;
        double z;
        double y;
        double x;
        double sOld;
        double zOld;
        double yOld;
        double xOld;
        int i;
        Random random = new Random(621541L);
        Vector4DBasics tuple1 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple2 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple3 = (Vector4DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            sOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            s = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.setS(sOld);
            tuple1.addX(x);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            tuple1.addY(y);
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + y), (double)this.getEpsilon());
            tuple1.addZ(z);
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld + z), (double)this.getEpsilon());
            tuple1.addS(s);
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld + s), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            sOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            s = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.setS(sOld);
            tuple1.add(x, y, z, s);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + y), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld + z), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld + s), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            sOld = random.nextDouble();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple2.setS(random.nextDouble());
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.setS(sOld);
            tuple1.add((Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + tuple2.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld + tuple2.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld + tuple2.getS()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple1.setZ(random.nextDouble());
            tuple1.setS(random.nextDouble());
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple2.setS(random.nextDouble());
            tuple3.setX(random.nextDouble());
            tuple3.setY(random.nextDouble());
            tuple3.setZ(random.nextDouble());
            tuple3.setS(random.nextDouble());
            tuple1.add((Tuple4DReadOnly)tuple2, (Tuple4DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() + tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() + tuple3.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(tuple2.getS() + tuple3.getS()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSub() throws Exception {
        double s;
        double z;
        double y;
        double x;
        double sOld;
        double zOld;
        double yOld;
        double xOld;
        int i;
        Random random = new Random(621541L);
        Vector4DBasics tuple1 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple2 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple3 = (Vector4DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            sOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            s = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.setS(sOld);
            tuple1.subX(x);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            tuple1.subY(y);
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - y), (double)this.getEpsilon());
            tuple1.subZ(z);
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld - z), (double)this.getEpsilon());
            tuple1.subS(s);
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld - s), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            sOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            s = random.nextDouble();
            tuple1.set(xOld, yOld, zOld, sOld);
            tuple1.sub(x, y, z, s);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - y), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld - z), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld - s), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            sOld = random.nextDouble();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple2.setS(random.nextDouble());
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.setS(sOld);
            tuple1.sub((Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - tuple2.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld - tuple2.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld - tuple2.getS()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.sub((Tuple4DReadOnly)tuple2, (Tuple4DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() - tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() - tuple3.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(tuple2.getS() - tuple3.getS()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testScale() throws Exception {
        double sOld;
        double zOld;
        double yOld;
        double xOld;
        double scale;
        double sOld2;
        double zOld2;
        double yOld2;
        double xOld2;
        int i;
        Random random = new Random(621541L);
        Vector4DBasics tuple1 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple2 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple3 = (Vector4DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld2 = random.nextDouble();
            yOld2 = random.nextDouble();
            zOld2 = random.nextDouble();
            sOld2 = random.nextDouble();
            double scale2 = random.nextDouble();
            tuple1.set(xOld2, yOld2, zOld2, sOld2);
            tuple1.scale(scale2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld2 * scale2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld2 * scale2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld2 * scale2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld2 * scale2), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld2 = random.nextDouble();
            yOld2 = random.nextDouble();
            zOld2 = random.nextDouble();
            sOld2 = random.nextDouble();
            double scaleX = random.nextDouble();
            double scaleY = random.nextDouble();
            double scaleZ = random.nextDouble();
            double scaleS = random.nextDouble();
            tuple1.set(xOld2, yOld2, zOld2, sOld2);
            tuple1.scale(scaleX, scaleY, scaleZ, scaleS);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld2 * scaleX), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld2 * scaleY), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld2 * scaleZ), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld2 * scaleS), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.setAndScale(scale, (Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(tuple2.getS() * scale), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            sOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.setS(sOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple2.setS(random.nextDouble());
            tuple1.scaleAdd(scale, (Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld * scale + tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld * scale + tuple2.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld * scale + tuple2.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld * scale + tuple2.getS()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.scaleAdd(scale, (Tuple4DReadOnly)tuple2, (Tuple4DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale + tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale + tuple3.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(tuple2.getS() * scale + tuple3.getS()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set((Tuple4DReadOnly)tuple1);
            tuple1.scaleAdd(scale, (Tuple4DReadOnly)tuple2, (Tuple4DReadOnly)tuple1);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale + tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale + tuple3.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(tuple2.getS() * scale + tuple3.getS()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            zOld = random.nextDouble();
            sOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.setS(sOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple2.setS(random.nextDouble());
            tuple1.scaleSub(scale, (Tuple4DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld * scale - tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld * scale - tuple2.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(zOld * scale - tuple2.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(sOld * scale - tuple2.getS()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.scaleSub(scale, (Tuple4DReadOnly)tuple2, (Tuple4DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale - tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale - tuple3.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(tuple2.getS() * scale - tuple3.getS()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set((Tuple4DReadOnly)tuple1);
            tuple1.scaleSub(scale, (Tuple4DReadOnly)tuple2, (Tuple4DReadOnly)tuple1);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale - tuple3.getY()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)(tuple2.getZ() * scale - tuple3.getZ()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)(tuple2.getS() * scale - tuple3.getS()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testInterpolate() throws Exception {
        double alpha;
        int i;
        Random random = new Random(621541L);
        Vector4DBasics tuple1 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple2 = (Vector4DBasics)this.createEmptyTuple();
        Vector4DBasics tuple3 = (Vector4DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            alpha = random.nextDouble();
            double xOld = random.nextDouble();
            double yOld = random.nextDouble();
            double zOld = random.nextDouble();
            double sOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.setZ(zOld);
            tuple1.setS(sOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple2.setZ(random.nextDouble());
            tuple2.setS(random.nextDouble());
            tuple1.interpolate((Tuple4DReadOnly)tuple2, alpha);
            Assertions.assertEquals((double)tuple1.getX(), (double)EuclidCoreTools.interpolate((double)xOld, (double)tuple2.getX(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)EuclidCoreTools.interpolate((double)yOld, (double)tuple2.getY(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)EuclidCoreTools.interpolate((double)zOld, (double)tuple2.getZ(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)EuclidCoreTools.interpolate((double)sOld, (double)tuple2.getS(), (double)alpha), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            alpha = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple3.set(random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
            tuple1.interpolate((Tuple4DReadOnly)tuple2, (Tuple4DReadOnly)tuple3, alpha);
            Assertions.assertEquals((double)tuple1.getX(), (double)EuclidCoreTools.interpolate((double)tuple2.getX(), (double)tuple3.getX(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)EuclidCoreTools.interpolate((double)tuple2.getY(), (double)tuple3.getY(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getZ(), (double)EuclidCoreTools.interpolate((double)tuple2.getZ(), (double)tuple3.getZ(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getS(), (double)EuclidCoreTools.interpolate((double)tuple2.getS(), (double)tuple3.getS(), (double)alpha), (double)this.getEpsilon());
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        Vector4DBasics actual;
        Vector4DBasics expected;
        Vector4DBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (Vector4DBasics)this.createRandomTuple(random);
            expected = (Vector4DBasics)this.createEmptyTuple();
            actual = (Vector4DBasics)this.createEmptyTuple();
            expected.set((Tuple4DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple4DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (Vector4DBasics)this.createRandomTuple(random);
            expected = (Vector4DBasics)this.createEmptyTuple();
            actual = (Vector4DBasics)this.createEmptyTuple();
            expected.set((Tuple4DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple4DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = (Vector4DBasics)this.createRandomTuple(random);
            expected = (Vector4DBasics)this.createEmptyTuple();
            actual = (Vector4DBasics)this.createEmptyTuple();
            expected.set((Tuple4DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple4DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)(10.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        Vector4DBasics actual;
        Vector4DBasics expected;
        Vector4DBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (Vector4DBasics)this.createRandomTuple(random);
            expected = (Vector4DBasics)this.createEmptyTuple();
            actual = (Vector4DBasics)this.createEmptyTuple();
            expected.set((Tuple4DReadOnly)original);
            actual.set((Tuple4DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (Vector4DBasics)this.createRandomTuple(random);
            expected = (Vector4DBasics)this.createEmptyTuple();
            actual = (Vector4DBasics)this.createEmptyTuple();
            expected.set((Tuple4DReadOnly)original);
            actual.set((Tuple4DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextNonSingularAffineTransform((Random)random);
            original = (Vector4DBasics)this.createRandomTuple(random);
            expected = (Vector4DBasics)this.createEmptyTuple();
            actual = (Vector4DBasics)this.createEmptyTuple();
            expected.set((Tuple4DReadOnly)original);
            actual.set((Tuple4DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)(10.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            Vector4D vectorB;
            Vector4D vectorA = EuclidCoreRandomTools.nextVector4D((Random)random);
            if (vectorA.epsilonEquals((Tuple4DReadOnly)(vectorB = EuclidCoreRandomTools.nextVector4D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, EuclidCoreTools.squareRoot((double)3.0) * this.getEpsilon()));
            } else {
                Vector4D diff = new Vector4D();
                diff.sub((Tuple4DReadOnly)vectorA, (Tuple4DReadOnly)vectorB);
                if (diff.norm() <= this.getEpsilon()) {
                    Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
                } else {
                    Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
                }
            }
            vectorA = EuclidCoreRandomTools.nextVector4D((Random)random);
            vectorB = new Vector4D((Tuple4DReadOnly)vectorA);
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, 0.0));
            vectorB.set(vectorA.getX() + 0.9 * this.getEpsilon(), vectorA.getY(), vectorA.getZ(), vectorA.getS());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX() + 1.1 * this.getEpsilon(), vectorA.getY(), vectorA.getZ(), vectorA.getS());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY() + 0.9 * this.getEpsilon(), vectorA.getZ(), vectorA.getS());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY() + 1.1 * this.getEpsilon(), vectorA.getZ(), vectorA.getS());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY(), vectorA.getZ() + 0.9 * this.getEpsilon(), vectorA.getS());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY(), vectorA.getZ() + 1.1 * this.getEpsilon(), vectorA.getS());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY(), vectorA.getZ(), vectorA.getS() + 0.9 * this.getEpsilon());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY(), vectorA.getZ(), vectorA.getS() + 1.1 * this.getEpsilon());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector4DReadOnly)vectorB, this.getEpsilon()));
        }
    }
}

