/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Point3DBasicsTest;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Point3D32Test
extends Point3DBasicsTest<Point3D32> {
    private static final double EPS = 1.0E-10;

    @Test
    public void testPoint3D32() {
        Point3D32 point;
        int i;
        Random random = new Random(621541L);
        Point3D32 point2 = new Point3D32();
        Assertions.assertTrue((0.0 == point2.getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == point2.getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == point2.getZ() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            float newZ;
            float newY;
            float newX = random.nextFloat();
            Assertions.assertTrue((newX == (point = new Point3D32(newX, newY = random.nextFloat(), newZ = random.nextFloat())).getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((newY == point.getY32() ? 1 : 0) != 0);
            Assertions.assertTrue((newZ == point.getZ32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D32 point3;
            float[] randomPoint32Array = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat()};
            Assertions.assertTrue((randomPoint32Array[0] == (point3 = new Point3D32(randomPoint32Array)).getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((randomPoint32Array[1] == point3.getY32() ? 1 : 0) != 0);
            Assertions.assertTrue((randomPoint32Array[2] == point3.getZ32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D32 point22 = EuclidCoreRandomTools.nextPoint3D32((Random)random);
            point = new Point3D32((Tuple3DReadOnly)point22);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)point, (Tuple3DReadOnly)point22, (double)1.0E-10);
        }
    }

    @Override
    public void testSetters() throws Exception {
        int i;
        super.testSetters();
        Random random = new Random(621541L);
        Point3D32 tuple1 = this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            tuple1.setX(x);
            Assertions.assertEquals((double)tuple1.getX32(), (double)x, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float y = random.nextFloat();
            tuple1.setY(y);
            Assertions.assertEquals((double)tuple1.getY32(), (double)y, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float z = random.nextFloat();
            tuple1.setZ(z);
            Assertions.assertEquals((double)tuple1.getZ32(), (double)z, (double)this.getEpsilon());
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Point3D32 tuple1 = this.createRandomTuple(random);
        int newHashCode = tuple1.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple1.hashCode());
        int previousHashCode = tuple1.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple1.setElement(i % 3, (double)random.nextFloat());
            newHashCode = tuple1.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Point3D32 pointB;
            Point3D32 pointA = EuclidCoreRandomTools.nextPoint3D32((Random)random);
            if (pointA.geometricallyEquals((Point3DReadOnly)(pointB = EuclidCoreRandomTools.nextPoint3D32((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)pointA.geometricallyEquals(pointB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)pointA.geometricallyEquals(pointB, this.getEpsilon()));
        }
    }

    @Override
    public Point3D32 createEmptyTuple() {
        return new Point3D32();
    }

    @Override
    public Point3D32 createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextPoint3D32((Random)random);
    }

    @Override
    public Point3D32 createTuple(double x, double y, double z) {
        return new Point3D32((float)x, (float)y, (float)z);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-6;
    }
}

