/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidFrameToolsTest {
    private static final Class<Point3DReadOnly> P3_RO = Point3DReadOnly.class;
    private static final Class<Point3DBasics> P3_BA = Point3DBasics.class;
    private static final Class<Point2DReadOnly> P2_RO = Point2DReadOnly.class;
    private static final Class<Point2DBasics> P2_BA = Point2DBasics.class;
    private static final Class<?> D = Double.TYPE;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testAPIIsComplete() {
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("orthogonalProjectionOnLine3D", new Class[]{P3_RO, D, D, D, D, D, D, P3_BA}));
        signaturesToIgnore.add(new MethodSignature("orthogonalProjectionOnLine2D", new Class[]{P2_RO, D, D, D, D, P2_BA}));
        signaturesToIgnore.add(new MethodSignature("orthogonalProjectionOnLineSegment2D", new Class[]{P2_RO, D, D, D, D, P2_BA}));
        signaturesToIgnore.add(new MethodSignature("orthogonalProjectionOnLineSegment3D", new Class[]{P3_RO, D, D, D, D, D, D, P3_BA}));
        signaturesToIgnore.add(new MethodSignature("intersectionBetweenLine3DAndBoundingBox3D", new Class[]{D, D, D, D, D, D, D, D, D, D, D, D, P3_BA, P3_BA}));
        signaturesToIgnore.add(new MethodSignature("intersectionBetweenLine3DAndCylinder3D", new Class[]{D, D, D, D, D, D, D, D, D, D, D, D, D, D, P3_BA, P3_BA}));
        signaturesToIgnore.add(new MethodSignature("intersectionBetweenLine3DAndEllipsoid3D", new Class[]{D, D, D, D, D, D, D, D, D, P3_BA, P3_BA}));
        signaturesToIgnore.add(new MethodSignature("closestPoint2DsBetweenTwoLineSegment2Ds", new Class[]{D, D, D, D, D, D, D, D, P2_BA, P2_BA}));
        signaturesToIgnore.add(new MethodSignature("closestPoint3DsBetweenTwoLineSegment3Ds", new Class[]{D, D, D, D, D, D, D, D, D, D, D, D, P3_BA, P3_BA}));
        signaturesToIgnore.add(new MethodSignature("axisAngleFromZUpToVector3D", new Class[]{Vector3DReadOnly.class, AxisAngleBasics.class}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(EuclidFrameTools.class, EuclidGeometryTools.class, false, 2, methodFilter);
    }

    @Test
    public void testReferenceFrameChecked() throws Throwable {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertStaticMethodsCheckReferenceFrame(EuclidFrameTools.class, 10);
    }

    @Test
    public void testConservedFunctionality() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertStaticMethodsPreserveFunctionality(EuclidFrameTools.class, EuclidGeometryTools.class, 10);
    }

    @Test
    public void testAveragePoint2Ds() throws Exception {
        int size;
        int i;
        Random random = new Random(3245436L);
        for (i = 0; i < 1000; ++i) {
            size = random.nextInt(50) + 2;
            for (int index = 0; index < size; ++index) {
                ArrayList<FramePoint2D> points = new ArrayList<FramePoint2D>(size);
                ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                while (points.size() < size) {
                    ReferenceFrame referenceFrame = points.size() == index ? frameA : frameB;
                    points.add(EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)referenceFrame));
                }
                try {
                    EuclidFrameTools.averagePoint2Ds(points);
                    Assertions.fail((String)("Should have thrown a " + ReferenceFrameMismatchException.class.getSimpleName()));
                    continue;
                }
                catch (ReferenceFrameMismatchException referenceFrameMismatchException) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            size = random.nextInt(50);
            ArrayList<FramePoint2D> points = new ArrayList<FramePoint2D>(size);
            ReferenceFrame referenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            while (points.size() < size) {
                points.add(EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)referenceFrame));
            }
            FramePoint2D actual = EuclidFrameTools.averagePoint2Ds(points);
            Point2D expected = EuclidGeometryTools.averagePoint2Ds(points);
            if (size != 0) {
                Assertions.assertEquals((Object)referenceFrame, (Object)actual.getReferenceFrame());
            }
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAveragePoint3Ds() throws Exception {
        int i;
        Random random = new Random(3245436L);
        for (i = 0; i < 1000; ++i) {
            int size = random.nextInt(50) + 2;
            for (int index = 0; index < size; ++index) {
                ArrayList<FramePoint3D> points = new ArrayList<FramePoint3D>();
                ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                while (points.size() < size) {
                    ReferenceFrame referenceFrame = points.size() == index ? frameA : frameB;
                    points.add(EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)referenceFrame));
                }
                try {
                    EuclidFrameTools.averagePoint3Ds(points);
                    Assertions.fail((String)("Should have thrown a " + ReferenceFrameMismatchException.class.getSimpleName()));
                    continue;
                }
                catch (ReferenceFrameMismatchException referenceFrameMismatchException) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            ArrayList<FramePoint3D> points = new ArrayList<FramePoint3D>();
            int size = random.nextInt(50);
            ReferenceFrame referenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            while (points.size() < size) {
                points.add(EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)referenceFrame));
            }
            FramePoint3D actual = EuclidFrameTools.averagePoint3Ds(points);
            Point3D expected = EuclidGeometryTools.averagePoint3Ds(points);
            if (size != 0) {
                Assertions.assertEquals((Object)referenceFrame, (Object)actual.getReferenceFrame());
            }
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
    }
}

