/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameTuple3DBasicsTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class FramePoint3DTest
extends FrameTuple3DBasicsTest<FramePoint3D> {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Override
    public Tuple3DBasics createRandomFramelessTuple(Random random) {
        return EuclidCoreRandomTools.nextPoint3D((Random)random);
    }

    @Override
    public FramePoint3D createFrameTuple(ReferenceFrame referenceFrame, double x, double y, double z) {
        return new FramePoint3D(referenceFrame, x, y, z);
    }

    @Test
    public void testConstructors() throws Exception {
        FramePoint3D framePoint3D;
        Point3D randomTuple;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        FramePoint3D framePoint3D2 = new FramePoint3D();
        Assertions.assertTrue((framePoint3D2.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)framePoint3D2);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint3D framePoint3D3 = new FramePoint3D(randomFrame);
            Assertions.assertTrue((framePoint3D3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)framePoint3D3);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            framePoint3D = new FramePoint3D(randomFrame, (randomTuple = EuclidCoreRandomTools.nextPoint3D((Random)random)).getX(), randomTuple.getY(), randomTuple.getZ());
            Assertions.assertTrue((framePoint3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomTuple, (Tuple3DReadOnly)framePoint3D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidCoreRandomTools.nextPoint3D((Random)random);
            double[] array = new double[3];
            randomTuple.get(array);
            FramePoint3D framePoint3D4 = new FramePoint3D(randomFrame, array);
            Assertions.assertTrue((framePoint3D4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomTuple, (Tuple3DReadOnly)framePoint3D4, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            framePoint3D = new FramePoint3D(randomFrame, (Tuple3DReadOnly)(randomTuple = EuclidCoreRandomTools.nextPoint3D((Random)random)));
            Assertions.assertTrue((framePoint3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomTuple, (Tuple3DReadOnly)framePoint3D, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D randomTuple2D;
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            framePoint3D = new FramePoint3D(randomFrame, (Tuple2DReadOnly)(randomTuple2D = EuclidCoreRandomTools.nextPoint2D((Random)random)));
            Assertions.assertTrue((framePoint3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)randomTuple2D, (Tuple2DReadOnly)new Point2D((Tuple3DReadOnly)framePoint3D), (double)1.0E-15);
            Assertions.assertTrue((framePoint3D.getZ() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint2D randomFrameTuple2D = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)randomFrame);
            framePoint3D = new FramePoint3D((FrameTuple2DReadOnly)randomFrameTuple2D);
            Assertions.assertTrue((framePoint3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)randomFrameTuple2D, (Tuple2DReadOnly)new Point2D((Tuple3DReadOnly)framePoint3D), (double)1.0E-15);
            Assertions.assertTrue((framePoint3D.getZ() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)randomFrame);
            framePoint3D = new FramePoint3D((FrameTuple3DReadOnly)randomTuple);
            Assertions.assertTrue((framePoint3D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomTuple, (Tuple3DReadOnly)framePoint3D, (double)1.0E-15);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)randomTuple, (FrameTuple3DReadOnly)framePoint3D, (double)1.0E-15);
        }
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        FramePoint3D source;
        ReferenceFrame destinationFrame;
        ReferenceFrame sourceFrame;
        int i;
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFramePoint3D, 10);
        Random random = new Random(544354L);
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            source = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)sourceFrame);
            FramePoint3D actual = (FramePoint3D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple3DReadOnly)source);
            FramePoint3D expected = new FramePoint3D((FrameTuple3DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            source = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)sourceFrame);
            double z = EuclidCoreRandomTools.nextDouble((Random)random);
            FramePoint3D actual = (FramePoint3D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple2DReadOnly)source, z);
            FramePoint3D expected = new FramePoint3D();
            expected.setIncludingFrame((FrameTuple2DReadOnly)source, z);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Point3D expectedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random);
            FramePoint3D framePoint = new FramePoint3D(initialFrame, (Tuple3DReadOnly)expectedPoint);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expectedPoint.applyTransform((Transform)transform);
            framePoint.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == framePoint.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedPoint, (Tuple3DReadOnly)framePoint, (double)1.0000000000000002E-14);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                framePoint.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSetFromReferenceFrame() throws Exception {
        Random random = new Random(6572L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FramePoint3D expected = (FramePoint3D)this.createEmptyFrameTuple(anotherFrame);
            expected.changeFrame(initialFrame);
            FramePoint3D actual = (FramePoint3D)this.createRandomFrameTuple(random, initialFrame);
            actual.setFromReferenceFrame(anotherFrame);
            Assertions.assertTrue((initialFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            FramePoint3D framePoint1 = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame);
            FramePoint3D framePoint2 = new FramePoint3D(worldFrame);
            double epsilon = random.nextDouble();
            Vector3D difference = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            framePoint2.add((FrameTuple3DReadOnly)framePoint1, (Tuple3DReadOnly)difference);
            Assertions.assertTrue((boolean)framePoint1.geometricallyEquals(framePoint2, epsilon));
            difference = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            framePoint2.add((FrameTuple3DReadOnly)framePoint1, (Tuple3DReadOnly)difference);
            Assertions.assertFalse((boolean)framePoint1.geometricallyEquals(framePoint2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (int)100);
        FramePoint3D tuple = new FramePoint3D();
        tuple.setX(random.nextDouble());
        tuple.setY(random.nextDouble());
        tuple.setZ(random.nextDouble());
        tuple.setReferenceFrame(frames[random.nextInt(frames.length)]);
        int newHashCode = tuple.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple.hashCode());
        int previousHashCode = tuple.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple.setElement(i % 3, random.nextDouble());
            newHashCode = tuple.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
            ReferenceFrame oldFrame = tuple.getReferenceFrame();
            ReferenceFrame newFrame = frames[random.nextInt(frames.length)];
            tuple.setReferenceFrame(newFrame);
            newHashCode = tuple.hashCode();
            if (oldFrame != newFrame) {
                Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            }
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Point3D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Point3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Point3D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FramePoint3D.class, Point3D.class, true, 1, methodFilter);
    }

    @Override
    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFramePoint3D, 10);
    }
}

