/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.orientation.interfaces;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

public abstract class Orientation3DBasicsTest {
    public abstract Orientation3DBasics createEmptyOrientation3DBasics();

    private Orientation3DBasics createRandomOrientation3DBasics(Random random) {
        Orientation3DBasics rand = this.createEmptyOrientation3DBasics();
        rand.set((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        return rand;
    }

    public abstract double getEpsilon();

    @Test
    public void testInvert() throws Exception {
        Random random = new Random(258097L);
        for (int i = 0; i < 1000; ++i) {
            Orientation3DBasics orientation = this.createRandomOrientation3DBasics(random);
            Orientation3DBasics inverse = this.createEmptyOrientation3DBasics();
            inverse.set((Orientation3DReadOnly)orientation);
            inverse.invert();
            Vector3D vectorOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D vectorTransformed = new Vector3D();
            Orientation3DBasics neutral = this.createEmptyOrientation3DBasics();
            neutral.set((Orientation3DReadOnly)orientation);
            neutral.append((Orientation3DReadOnly)inverse);
            neutral.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)vectorTransformed);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vectorOriginal, (Tuple3DReadOnly)vectorTransformed, (double)this.getEpsilon());
            neutral.set((Orientation3DReadOnly)orientation);
            neutral.prepend((Orientation3DReadOnly)inverse);
            neutral.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)vectorTransformed);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vectorOriginal, (Tuple3DReadOnly)vectorTransformed, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetRotationMatrix() throws Exception {
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        double m02;
        double m01;
        double m00;
        Orientation3DBasics orientation;
        RotationMatrix rotationMatrix;
        int i;
        Random random = new Random(43543L);
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            m00 = rotationMatrix.getM00();
            m01 = rotationMatrix.getM01();
            m02 = rotationMatrix.getM02();
            m10 = rotationMatrix.getM10();
            m11 = rotationMatrix.getM11();
            m12 = rotationMatrix.getM12();
            m20 = rotationMatrix.getM20();
            m21 = rotationMatrix.getM21();
            m22 = rotationMatrix.getM22();
            orientation.setRotationMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            Vector3D vectorOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D expected = new Vector3D();
            Vector3D actual = new Vector3D();
            rotationMatrix.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)expected);
            orientation.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            m00 = rotationMatrix.getM00();
            m01 = rotationMatrix.getM01();
            m02 = rotationMatrix.getM02();
            m10 = rotationMatrix.getM10();
            m11 = rotationMatrix.getM11();
            m12 = rotationMatrix.getM12();
            m20 = rotationMatrix.getM20();
            m21 = rotationMatrix.getM21();
            m22 = rotationMatrix.getM22();
            orientation.setRotationMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            double yprEpsilon = 10.0 * this.getEpsilon();
            Assertions.assertEquals((double)rotationMatrix.getYaw(), (double)orientation.getYaw(), (double)yprEpsilon);
            Assertions.assertEquals((double)rotationMatrix.getPitch(), (double)orientation.getPitch(), (double)yprEpsilon);
            Assertions.assertEquals((double)rotationMatrix.getRoll(), (double)orientation.getRoll(), (double)yprEpsilon);
        }
    }

    @Test
    public void testSetAxisAngle() throws Exception {
        double angle;
        double z;
        double y;
        double x;
        Orientation3DBasics orientation;
        AxisAngle axisAngle;
        int i;
        Random random = new Random(43543L);
        for (i = 0; i < 1000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            x = axisAngle.getX();
            y = axisAngle.getY();
            z = axisAngle.getZ();
            angle = axisAngle.getAngle();
            orientation.setAxisAngle(x, y, z, angle);
            Vector3D vectorOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D expected = new Vector3D();
            Vector3D actual = new Vector3D();
            axisAngle.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)expected);
            orientation.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            x = axisAngle.getX();
            y = axisAngle.getY();
            z = axisAngle.getZ();
            angle = axisAngle.getAngle();
            orientation.setAxisAngle(x, y, z, angle);
            double yprEpsilon = 10.0 * this.getEpsilon();
            Assertions.assertEquals((double)axisAngle.getYaw(), (double)orientation.getYaw(), (double)yprEpsilon);
            Assertions.assertEquals((double)axisAngle.getPitch(), (double)orientation.getPitch(), (double)yprEpsilon);
            Assertions.assertEquals((double)axisAngle.getRoll(), (double)orientation.getRoll(), (double)yprEpsilon);
        }
    }

    @Test
    public void testSetQuaternion() throws Exception {
        double s;
        double z;
        double y;
        double x;
        Orientation3DBasics orientation;
        Quaternion quaternion;
        int i;
        Random random = new Random(43543L);
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            x = quaternion.getX();
            y = quaternion.getY();
            z = quaternion.getZ();
            s = quaternion.getS();
            orientation.setQuaternion(x, y, z, s);
            Vector3D vectorOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D expected = new Vector3D();
            Vector3D actual = new Vector3D();
            quaternion.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)expected);
            orientation.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            x = quaternion.getX();
            y = quaternion.getY();
            z = quaternion.getZ();
            s = quaternion.getS();
            orientation.setQuaternion(x, y, z, s);
            double yprEpsilon = 10.0 * this.getEpsilon();
            Assertions.assertEquals((double)quaternion.getYaw(), (double)orientation.getYaw(), (double)yprEpsilon);
            Assertions.assertEquals((double)quaternion.getPitch(), (double)orientation.getPitch(), (double)yprEpsilon);
            Assertions.assertEquals((double)quaternion.getRoll(), (double)orientation.getRoll(), (double)yprEpsilon);
        }
    }

    @Test
    public void testSetRotationVector() throws Exception {
        double z;
        double y;
        double x;
        Orientation3DBasics orientation;
        Vector3D rotationVector;
        int i;
        Random random = new Random(43543L);
        for (i = 0; i < 1000; ++i) {
            rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            x = rotationVector.getX();
            y = rotationVector.getY();
            z = rotationVector.getZ();
            orientation.setRotationVector(x, y, z);
            Vector3D vectorOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D expected = new Vector3D();
            Vector3D actual = new Vector3D();
            new Quaternion((Vector3DReadOnly)rotationVector).transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)expected);
            orientation.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            x = rotationVector.getX();
            y = rotationVector.getY();
            z = rotationVector.getZ();
            orientation.setRotationVector(x, y, z);
            double yprEpsilon = 10.0 * this.getEpsilon();
            Assertions.assertEquals((double)new RotationMatrix((Vector3DReadOnly)rotationVector).getYaw(), (double)orientation.getYaw(), (double)yprEpsilon);
            Assertions.assertEquals((double)new Quaternion((Vector3DReadOnly)rotationVector).getPitch(), (double)orientation.getPitch(), (double)yprEpsilon);
            Assertions.assertEquals((double)new AxisAngle((Vector3DReadOnly)rotationVector).getRoll(), (double)orientation.getRoll(), (double)yprEpsilon);
        }
        for (i = 0; i < 1000; ++i) {
            rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            orientation.setRotationVector((Vector3DReadOnly)rotationVector);
            double yprEpsilon = 10.0 * this.getEpsilon();
            Assertions.assertEquals((double)new RotationMatrix((Vector3DReadOnly)rotationVector).getYaw(), (double)orientation.getYaw(), (double)yprEpsilon);
            Assertions.assertEquals((double)new Quaternion((Vector3DReadOnly)rotationVector).getPitch(), (double)orientation.getPitch(), (double)yprEpsilon);
            Assertions.assertEquals((double)new AxisAngle((Vector3DReadOnly)rotationVector).getRoll(), (double)orientation.getRoll(), (double)yprEpsilon);
        }
    }

    @Test
    public void testSetYawPitchRoll() throws Exception {
        double roll;
        double pitch;
        double yaw;
        Orientation3DBasics orientation;
        YawPitchRoll yawPitchRoll;
        int i;
        Random random = new Random(43543L);
        for (i = 0; i < 1000; ++i) {
            yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            yaw = yawPitchRoll.getYaw();
            pitch = yawPitchRoll.getPitch();
            roll = yawPitchRoll.getRoll();
            orientation.setYawPitchRoll(yaw, pitch, roll);
            Vector3D vectorOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D expected = new Vector3D();
            Vector3D actual = new Vector3D();
            RotationMatrixTools.applyRollRotation((double)roll, (Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)expected);
            RotationMatrixTools.applyPitchRotation((double)pitch, (Tuple3DReadOnly)expected, (Tuple3DBasics)expected);
            RotationMatrixTools.applyYawRotation((double)yaw, (Tuple3DReadOnly)expected, (Tuple3DBasics)expected);
            orientation.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            orientation = this.createEmptyOrientation3DBasics();
            yaw = yawPitchRoll.getYaw();
            pitch = yawPitchRoll.getPitch();
            roll = yawPitchRoll.getRoll();
            orientation.setYawPitchRoll(yaw, pitch, roll);
            double yprEpsilon = 10.0 * this.getEpsilon();
            Assertions.assertEquals((double)yawPitchRoll.getYaw(), (double)orientation.getYaw(), (double)yprEpsilon);
            Assertions.assertEquals((double)yawPitchRoll.getPitch(), (double)orientation.getPitch(), (double)yprEpsilon);
            Assertions.assertEquals((double)yawPitchRoll.getRoll(), (double)orientation.getRoll(), (double)yprEpsilon);
        }
    }

    @Test
    public void testSetEuler() throws Exception {
        double rotZ;
        double rotY;
        double rotX;
        Orientation3DBasics orientation;
        Vector3D eulerAngles;
        int i;
        Random random = new Random(43543L);
        for (i = 0; i < 1000; ++i) {
            eulerAngles = new Vector3D();
            EuclidCoreRandomTools.nextYawPitchRoll((Random)random).getEuler((Tuple3DBasics)eulerAngles);
            orientation = this.createEmptyOrientation3DBasics();
            rotX = eulerAngles.getX();
            rotY = eulerAngles.getY();
            rotZ = eulerAngles.getZ();
            orientation.setEuler(rotX, rotY, rotZ);
            Vector3D vectorOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D expected = new Vector3D();
            Vector3D actual = new Vector3D();
            RotationMatrixTools.applyRollRotation((double)rotX, (Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)expected);
            RotationMatrixTools.applyPitchRotation((double)rotY, (Tuple3DReadOnly)expected, (Tuple3DBasics)expected);
            RotationMatrixTools.applyYawRotation((double)rotZ, (Tuple3DReadOnly)expected, (Tuple3DBasics)expected);
            orientation.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            eulerAngles = new Vector3D();
            EuclidCoreRandomTools.nextYawPitchRoll((Random)random).getEuler((Tuple3DBasics)eulerAngles);
            orientation = this.createEmptyOrientation3DBasics();
            rotX = eulerAngles.getX();
            rotY = eulerAngles.getY();
            rotZ = eulerAngles.getZ();
            orientation.setEuler(rotX, rotY, rotZ);
            double yprEpsilon = 10.0 * this.getEpsilon();
            Assertions.assertEquals((double)rotZ, (double)orientation.getYaw(), (double)yprEpsilon);
            Assertions.assertEquals((double)rotY, (double)orientation.getPitch(), (double)yprEpsilon);
            Assertions.assertEquals((double)rotX, (double)orientation.getRoll(), (double)yprEpsilon);
        }
        for (i = 0; i < 1000; ++i) {
            eulerAngles = new Vector3D();
            EuclidCoreRandomTools.nextYawPitchRoll((Random)random).getEuler((Tuple3DBasics)eulerAngles);
            orientation = this.createEmptyOrientation3DBasics();
            orientation.setEuler((Vector3DReadOnly)eulerAngles);
            double yprEpsilon = 10.0 * this.getEpsilon();
            Assertions.assertEquals((double)eulerAngles.getZ(), (double)orientation.getYaw(), (double)yprEpsilon);
            Assertions.assertEquals((double)eulerAngles.getY(), (double)orientation.getPitch(), (double)yprEpsilon);
            Assertions.assertEquals((double)eulerAngles.getX(), (double)orientation.getRoll(), (double)yprEpsilon);
        }
    }

    @Test
    public void testSetAndInvert() throws Exception {
        Random random = new Random(258097L);
        for (int i = 0; i < 1000; ++i) {
            Orientation3DBasics orientation = this.createRandomOrientation3DBasics(random);
            Orientation3DBasics inverse = this.createEmptyOrientation3DBasics();
            inverse.setAndInvert((Orientation3DReadOnly)orientation);
            Vector3D vectorOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D vectorTransformed = new Vector3D();
            Orientation3DBasics neutral = this.createEmptyOrientation3DBasics();
            neutral.set((Orientation3DReadOnly)orientation);
            neutral.append((Orientation3DReadOnly)inverse);
            neutral.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)vectorTransformed);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vectorOriginal, (Tuple3DReadOnly)vectorTransformed, (double)this.getEpsilon());
            neutral.set((Orientation3DReadOnly)orientation);
            neutral.prepend((Orientation3DReadOnly)inverse);
            neutral.transform((Tuple3DReadOnly)vectorOriginal, (Tuple3DBasics)vectorTransformed);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vectorOriginal, (Tuple3DReadOnly)vectorTransformed, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppend() throws Exception {
        Quaternion actual;
        Quaternion appended;
        Orientation3DBasics actualOrientation;
        Quaternion expected;
        int i;
        Random random = new Random(54L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.multiply((QuaternionReadOnly)appended);
            actualOrientation.append((Orientation3DReadOnly)appended);
            actual = new Quaternion();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expected.multiply((AxisAngleReadOnly)appended);
            actualOrientation.append((Orientation3DReadOnly)appended);
            actual = new AxisAngle();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.multiply((RotationMatrixReadOnly)appended);
            actualOrientation.append((Orientation3DReadOnly)appended);
            actual = new RotationMatrix();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendInvertThis() throws Exception {
        Quaternion actual;
        Quaternion appended;
        Orientation3DBasics actualOrientation;
        Quaternion expected;
        int i;
        Random random = new Random(54L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.multiplyConjugateThis((QuaternionReadOnly)appended);
            actualOrientation.appendInvertThis((Orientation3DReadOnly)appended);
            actual = new Quaternion();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expected.multiplyInvertThis((AxisAngleReadOnly)appended);
            actualOrientation.appendInvertThis((Orientation3DReadOnly)appended);
            actual = new AxisAngle();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.multiplyTransposeThis((RotationMatrixReadOnly)appended);
            actualOrientation.appendInvertThis((Orientation3DReadOnly)appended);
            actual = new RotationMatrix();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendInvertOther() throws Exception {
        Quaternion actual;
        Quaternion appended;
        Orientation3DBasics actualOrientation;
        Quaternion expected;
        int i;
        Random random = new Random(54L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.multiplyConjugateOther((QuaternionReadOnly)appended);
            actualOrientation.appendInvertOther((Orientation3DReadOnly)appended);
            actual = new Quaternion();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expected.multiplyInvertOther((AxisAngleReadOnly)appended);
            actualOrientation.appendInvertOther((Orientation3DReadOnly)appended);
            actual = new AxisAngle();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.multiplyTransposeOther((RotationMatrixReadOnly)appended);
            actualOrientation.appendInvertOther((Orientation3DReadOnly)appended);
            actual = new RotationMatrix();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendInvertBoth() throws Exception {
        Quaternion actual;
        Quaternion appended;
        Orientation3DBasics actualOrientation;
        Quaternion expected;
        int i;
        Random random = new Random(54L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.multiplyConjugateBoth((QuaternionReadOnly)appended);
            actualOrientation.appendInvertBoth((Orientation3DReadOnly)appended);
            actual = new Quaternion();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expected.multiplyInvertBoth((AxisAngleReadOnly)appended);
            actualOrientation.appendInvertBoth((Orientation3DReadOnly)appended);
            actual = new AxisAngle();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            appended = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.multiplyTransposeBoth((RotationMatrixReadOnly)appended);
            actualOrientation.appendInvertBoth((Orientation3DReadOnly)appended);
            actual = new RotationMatrix();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrepend() throws Exception {
        Quaternion actual;
        Quaternion prepended;
        Orientation3DBasics actualOrientation;
        Quaternion expected;
        int i;
        Random random = new Random(54L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.preMultiply((QuaternionReadOnly)prepended);
            actualOrientation.prepend((Orientation3DReadOnly)prepended);
            actual = new Quaternion();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expected.preMultiply((AxisAngleReadOnly)prepended);
            actualOrientation.prepend((Orientation3DReadOnly)prepended);
            actual = new AxisAngle();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.preMultiply((RotationMatrixReadOnly)prepended);
            actualOrientation.prepend((Orientation3DReadOnly)prepended);
            actual = new RotationMatrix();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependInvertThis() throws Exception {
        Quaternion actual;
        Quaternion prepended;
        Orientation3DBasics actualOrientation;
        Quaternion expected;
        int i;
        Random random = new Random(54L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.preMultiplyConjugateThis((QuaternionReadOnly)prepended);
            actualOrientation.prependInvertThis((Orientation3DReadOnly)prepended);
            actual = new Quaternion();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expected.preMultiplyInvertThis((AxisAngleReadOnly)prepended);
            actualOrientation.prependInvertThis((Orientation3DReadOnly)prepended);
            actual = new AxisAngle();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.preMultiplyTransposeThis((RotationMatrixReadOnly)prepended);
            actualOrientation.prependInvertThis((Orientation3DReadOnly)prepended);
            actual = new RotationMatrix();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependInvertOther() throws Exception {
        Quaternion actual;
        Quaternion prepended;
        Orientation3DBasics actualOrientation;
        Quaternion expected;
        int i;
        Random random = new Random(54L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.preMultiplyConjugateOther((QuaternionReadOnly)prepended);
            actualOrientation.prependInvertOther((Orientation3DReadOnly)prepended);
            actual = new Quaternion();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expected.preMultiplyInvertOther((AxisAngleReadOnly)prepended);
            actualOrientation.prependInvertOther((Orientation3DReadOnly)prepended);
            actual = new AxisAngle();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.preMultiplyTransposeOther((RotationMatrixReadOnly)prepended);
            actualOrientation.prependInvertOther((Orientation3DReadOnly)prepended);
            actual = new RotationMatrix();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependInvertBoth() throws Exception {
        Quaternion actual;
        Quaternion prepended;
        Orientation3DBasics actualOrientation;
        Quaternion expected;
        int i;
        Random random = new Random(54L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextQuaternion((Random)random);
            expected.preMultiplyConjugateBoth((QuaternionReadOnly)prepended);
            actualOrientation.prependInvertBoth((Orientation3DReadOnly)prepended);
            actual = new Quaternion();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expected.preMultiplyInvertBoth((AxisAngleReadOnly)prepended);
            actualOrientation.prependInvertBoth((Orientation3DReadOnly)prepended);
            actual = new AxisAngle();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualOrientation = this.createEmptyOrientation3DBasics();
            actualOrientation.set((Orientation3DReadOnly)expected);
            prepended = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected.preMultiplyTransposeBoth((RotationMatrixReadOnly)prepended);
            actualOrientation.prependInvertBoth((Orientation3DReadOnly)prepended);
            actual = new RotationMatrix();
            actual.set((Orientation3DReadOnly)actualOrientation);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
    }
}

