/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.orientation;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;

public class Orientation2DTest {
    @Test
    public void testGeometricallyEquals() {
        int i;
        Random random = new Random(19732L);
        double epsilon = 1.0E-7;
        Orientation2D firstOrientation = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        Orientation2D secondOrientation = new Orientation2D((Orientation2DReadOnly)firstOrientation);
        Assertions.assertTrue((boolean)firstOrientation.geometricallyEquals(secondOrientation, epsilon));
        Assertions.assertTrue((boolean)secondOrientation.geometricallyEquals(firstOrientation, epsilon));
        Assertions.assertTrue((boolean)firstOrientation.geometricallyEquals(firstOrientation, epsilon));
        Assertions.assertTrue((boolean)secondOrientation.geometricallyEquals(secondOrientation, epsilon));
        for (i = 0; i < 1000; ++i) {
            firstOrientation = EuclidCoreRandomTools.nextOrientation2D((Random)random);
            secondOrientation = new Orientation2D((Orientation2DReadOnly)firstOrientation);
            secondOrientation.setYaw(firstOrientation.getYaw() + 0.99 * epsilon);
            Assertions.assertTrue((boolean)firstOrientation.geometricallyEquals(secondOrientation, epsilon));
            secondOrientation.setYaw(firstOrientation.getYaw() - 0.99 * epsilon);
            Assertions.assertTrue((boolean)firstOrientation.geometricallyEquals(secondOrientation, epsilon));
            secondOrientation.setYaw(firstOrientation.getYaw() + 1.01 * epsilon);
            Assertions.assertFalse((boolean)firstOrientation.geometricallyEquals(secondOrientation, epsilon));
            secondOrientation.setYaw(firstOrientation.getYaw() - 1.01 * epsilon);
            Assertions.assertFalse((boolean)firstOrientation.geometricallyEquals(secondOrientation, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstOrientation = EuclidCoreRandomTools.nextOrientation2D((Random)random);
            secondOrientation = EuclidCoreRandomTools.nextOrientation2D((Random)random);
            epsilon = Math.PI;
            Assertions.assertTrue((boolean)firstOrientation.geometricallyEquals(secondOrientation, epsilon));
            epsilon = Math.PI + Math.PI * random.nextDouble();
            Assertions.assertTrue((boolean)firstOrientation.geometricallyEquals(secondOrientation, epsilon));
        }
    }
}

