/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion32;
import us.ihmc.euclid.tuple4D.QuaternionBasicsTest;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class Quaternion32Test
extends QuaternionBasicsTest<Quaternion32> {
    public static final float EPS = 1.0E-6f;

    @Test
    public void testQuaternion32() {
        int i;
        Random random = new Random(613615L);
        Quaternion32 quaternion = new Quaternion32();
        Quaternion32 expected = new Quaternion32();
        expected.setToZero();
        EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternion, (QuaternionReadOnly)expected, (double)1.0E-6f);
        for (i = 0; i < 1000; ++i) {
            Quaternion32 quaternionCopy;
            quaternion = quaternionCopy = EuclidCoreRandomTools.nextQuaternion32((Random)random);
            Quaternion32 quaternion2 = new Quaternion32((Orientation3DReadOnly)quaternion);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternion, (QuaternionReadOnly)quaternion2, (double)1.0E-6f);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternion, (QuaternionReadOnly)quaternionCopy, (double)1.0E-6f);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion32((Random)random);
            float[] quaternionArray = new float[]{expected.getX32(), expected.getY32(), expected.getZ32(), expected.getS32()};
            quaternion = new Quaternion32(quaternionArray);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)quaternion, (double)1.0E-6f);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrixCopy;
            RotationMatrix rotationMatrix = rotationMatrixCopy = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            quaternion = new Quaternion32((Orientation3DReadOnly)rotationMatrix);
            QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)expected);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternion, (QuaternionReadOnly)expected, (double)1.0E-6f);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrix, (Matrix3DReadOnly)rotationMatrixCopy, (double)1.0E-6f);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVectorCopy;
            Vector3D rotationVector = rotationVectorCopy = EuclidCoreRandomTools.nextRotationVector((Random)random);
            quaternion = new Quaternion32((Vector3DReadOnly)rotationVector);
            QuaternionConversion.convertRotationVectorToQuaternion((Vector3DReadOnly)rotationVector, (QuaternionBasics)expected);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternion, (QuaternionReadOnly)expected, (double)1.0E-6f);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)rotationVector, (Vector3DReadOnly)rotationVectorCopy, (double)1.0E-6f);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextQuaternion32((Random)random);
            quaternion = new Quaternion32(expected.getX32(), expected.getY32(), expected.getZ32(), expected.getS32());
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternion, (QuaternionReadOnly)expected, (double)1.0E-6f);
        }
        for (i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            quaternion = new Quaternion32(yaw, pitch, roll);
            QuaternionConversion.convertYawPitchRollToQuaternion((double)yaw, (double)pitch, (double)roll, (QuaternionBasics)expected);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternion, (QuaternionReadOnly)expected, (double)1.0E-6f);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Quaternion32 q = EuclidCoreRandomTools.nextQuaternion32((Random)random);
        int newHashCode = q.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)q.hashCode());
        int previousHashCode = q.hashCode();
        for (int i = 0; i < 1000; ++i) {
            float qx = q.getX32();
            float qy = q.getY32();
            float qz = q.getZ32();
            float qs = q.getS32();
            switch (random.nextInt(4)) {
                case 0: {
                    qx = random.nextFloat();
                    break;
                }
                case 1: {
                    qy = random.nextFloat();
                    break;
                }
                case 2: {
                    qz = random.nextFloat();
                    break;
                }
                case 3: {
                    qs = random.nextFloat();
                }
            }
            q.setUnsafe((double)qx, (double)qy, (double)qz, (double)qs);
            newHashCode = q.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    public Quaternion32 createEmptyTuple() {
        return new Quaternion32();
    }

    @Override
    public Quaternion32 createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextQuaternion32((Random)random);
    }

    @Override
    public Quaternion32 createTuple(double x, double y, double z, double s) {
        Quaternion32 quaternion = new Quaternion32();
        quaternion.setUnsafe(x, y, z, s);
        return quaternion;
    }

    @Override
    public double getEpsilon() {
        return 1.0E-6;
    }
}

