/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.LinearTransform3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.TransformTest;
import us.ihmc.euclid.transform.interfaces.AffineTransformBasics;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class AffineTransformTest
extends TransformTest<AffineTransform> {
    private static final double EPS = 1.0E-10;

    @Test
    public void testConstructors() throws Exception {
        int column;
        int row;
        Random random = new Random(3435L);
        AffineTransform transform = new AffineTransform();
        for (int row2 = 0; row2 < 4; ++row2) {
            for (int column2 = 0; column2 < 4; ++column2) {
                if (row2 == column2) {
                    Assertions.assertTrue((transform.getElement(row2, column2) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row2, column2) == 0.0 ? 1 : 0) != 0);
            }
        }
        AffineTransform expected = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        AffineTransform actual = new AffineTransform((AffineTransformReadOnly)expected);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 4; ++column) {
                Assertions.assertTrue((expected.getElement(row, column) == actual.getElement(row, column) ? 1 : 0) != 0);
            }
        }
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new AffineTransform((RigidBodyTransformReadOnly)expected);
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 4; ++column) {
                Assertions.assertTrue((expected.getElement(row, column) == actual.getElement(row, column) ? 1 : 0) != 0);
            }
        }
        Matrix3D rotationPart = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
        Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        AffineTransform transform2 = new AffineTransform((Matrix3DReadOnly)rotationPart, (Tuple3DReadOnly)translation);
        for (int row3 = 0; row3 < 3; ++row3) {
            for (int column3 = 0; column3 < 3; ++column3) {
                Assertions.assertTrue((rotationPart.getElement(row3, column3) == transform2.getElement(row3, column3) ? 1 : 0) != 0);
            }
            Assertions.assertTrue((translation.getElement(row3) == transform2.getElement(row3, 3) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        int column;
        int row;
        Random random = new Random(2342L);
        AffineTransform transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 4; ++column) {
                if (row == column) {
                    Assertions.assertFalse((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertFalse((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
        transform.setToZero();
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 4; ++column) {
                if (row == 3 && column == 3) {
                    Assertions.assertTrue((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        int column;
        int row;
        Random random = new Random(2342L);
        AffineTransform transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 4; ++column) {
                Assertions.assertFalse((boolean)Double.isNaN(transform.getElement(row, column)));
            }
        }
        transform.setToNaN();
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 4; ++column) {
                Assertions.assertTrue((boolean)Double.isNaN(transform.getElement(row, column)));
            }
        }
    }

    @Test
    public void testContainsNaN() throws Exception {
        AffineTransform transform = new AffineTransform();
        Assertions.assertFalse((boolean)transform.containsNaN());
        transform.getLinearTransform().setToNaN();
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setIdentity();
        Assertions.assertFalse((boolean)transform.containsNaN());
        transform.getTranslation().setToNaN();
        Assertions.assertTrue((boolean)transform.containsNaN());
    }

    @Test
    public void testLinearTransformToIdentity() throws Exception {
        Random random = new Random(42353L);
        AffineTransform original = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        AffineTransform transform = new AffineTransform((AffineTransformReadOnly)original);
        transform.setLinearTransformToIdentity();
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                if (column == 3) {
                    Assertions.assertTrue((transform.getElement(row, column) == original.getElement(row, column) ? 1 : 0) != 0);
                    continue;
                }
                if (row == column) {
                    Assertions.assertTrue((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testResetScale() throws Exception {
        Random random = new Random(42353L);
        RotationMatrix rotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        AffineTransform transform = new AffineTransform(rotation, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
        double scaleX = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
        double scaleY = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
        double scaleZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotation, (Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)transform.getRotationView()), (double)1.0E-10);
        transform.getLinearTransform().scaleColumns(scaleX, scaleY, scaleZ);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotation, (Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)transform.getRotationView()), (double)1.0E-10);
        transform.resetScale();
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotation, (Matrix3DReadOnly)transform.getLinearTransform(), (double)1.0E-10);
    }

    @Test
    public void testResetTranslation() throws Exception {
        Random random = new Random(42353L);
        AffineTransform original = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        AffineTransform transform = new AffineTransform((AffineTransformReadOnly)original);
        transform.setTranslationToZero();
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                if (column < 3) {
                    Assertions.assertTrue((transform.getElement(row, column) == original.getElement(row, column) ? 1 : 0) != 0);
                    continue;
                }
                if (row == column) {
                    Assertions.assertTrue((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testSetIdentity() throws Exception {
        int column;
        int row;
        Random random = new Random(2342L);
        AffineTransform transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 4; ++column) {
                if (row == column) {
                    Assertions.assertFalse((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertFalse((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
        transform.setIdentity();
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 4; ++column) {
                if (row == column) {
                    Assertions.assertTrue((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testSet() throws Exception {
        int row;
        Random random = new Random(34534L);
        AffineTransform expected = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        AffineTransform actual = new AffineTransform();
        actual.setIdentity();
        double m00 = expected.getM00();
        double m01 = expected.getM01();
        double m02 = expected.getM02();
        double m03 = expected.getM03();
        double m10 = expected.getM10();
        double m11 = expected.getM11();
        double m12 = expected.getM12();
        double m13 = expected.getM13();
        double m20 = expected.getM20();
        double m21 = expected.getM21();
        double m22 = expected.getM22();
        double m23 = expected.getM23();
        actual.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        actual.setIdentity();
        actual.set(expected);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        RigidBodyTransform rigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual.setIdentity();
        actual.set((RigidBodyTransformReadOnly)rigidBodyTransform);
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertTrue((rigidBodyTransform.getElement(row, column) == actual.getElement(row, column) ? 1 : 0) != 0);
            }
        }
        actual.setIdentity();
        DMatrixRMaj denseMatrix = new DMatrixRMaj(4, 4);
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                denseMatrix.set(row, column, expected.getElement(row, column));
            }
        }
        actual.set((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        actual.setIdentity();
        int startRow = random.nextInt(10);
        int startColumn = random.nextInt(10);
        DMatrixRMaj denseMatrix2 = new DMatrixRMaj(4 + startRow, 4 + startColumn);
        for (int row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                denseMatrix2.set(row2 + startRow, column + startColumn, expected.getElement(row2, column));
            }
        }
        actual.set((DMatrix)denseMatrix2, startRow, startColumn);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        actual.setIdentity();
        double[] transformArray = new double[16];
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row + column] = expected.getElement(row, column);
            }
        }
        actual.set(transformArray);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual.set((RotationMatrixReadOnly)rotationMatrix, (Tuple3DReadOnly)translation);
        for (int row3 = 0; row3 < 3; ++row3) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((rotationMatrix.getElement(row3, column) == actual.getElement(row3, column) ? 1 : 0) != 0);
            }
            Assertions.assertTrue((translation.getElement(row3) == actual.getElement(row3, 3) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetLinearTransform() throws Exception {
        AffineTransform transform;
        Matrix3D expected;
        int i;
        Random random = new Random(42523L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)10.0);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            transform.setLinearTransform((Matrix3DReadOnly)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)transform.getLinearTransform(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)3, (int)3, (double)10.0);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            transform.setLinearTransform((DMatrix)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)new Matrix3D((DMatrix)expected), (Matrix3DReadOnly)transform.getLinearTransform(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            transform.setLinearTransform((RotationMatrixReadOnly)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)transform.getLinearTransform(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            transform.setLinearTransform((Orientation3DReadOnly)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)expected), (Matrix3DReadOnly)transform.getLinearTransform(), (double)1.0E-10);
        }
    }

    @Test
    public void testSetTranslation() throws Exception {
        Random random = new Random(42523L);
        AffineTransform transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random, (double)10.0);
        transform.setTranslationX(expected.getX());
        transform.setTranslationY(expected.getY());
        transform.setTranslationZ(expected.getZ());
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)transform.getTranslation(), (double)1.0E-10);
        transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random, (double)10.0);
        transform.setTranslation(expected.getX(), expected.getY(), expected.getZ());
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)transform.getTranslation(), (double)1.0E-10);
        transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random, (double)10.0);
        transform.setTranslation((Tuple3DReadOnly)expected);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)transform.getTranslation(), (double)1.0E-10);
    }

    @Test
    public void testAppendTranslation() throws Exception {
        AffineTransform translationTransform;
        AffineTransform original;
        int i;
        Random random = new Random(35454L);
        AffineTransform expected = new AffineTransform();
        AffineTransform actual = new AffineTransform();
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            translationTransform = new AffineTransform();
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double z = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            translationTransform.setTranslation(x, y, z);
            expected.set(original);
            expected.multiply((AffineTransformReadOnly)translationTransform);
            actual.set(original);
            actual.appendTranslation(x, y, z);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            translationTransform = new AffineTransform();
            Point3D translation = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
            translationTransform.setTranslation((Tuple3DReadOnly)translation);
            expected.set(original);
            expected.multiply((AffineTransformReadOnly)translationTransform);
            actual.set(original);
            actual.appendTranslation((Tuple3DReadOnly)translation);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testAppendOrientation() throws Exception {
        Random random = new Random(3456L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            AffineTransform orientationTransform = new AffineTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)new Vector3D());
            AffineTransform expected = new AffineTransform();
            expected.set(original);
            expected.multiply((AffineTransformReadOnly)orientationTransform);
            AffineTransform actual = new AffineTransform();
            actual.set(original);
            actual.appendOrientation((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testAppendYawPitchRoll() throws Exception {
        Matrix3D expectedRotation;
        AffineTransform original;
        int i;
        Random random = new Random(35454L);
        AffineTransform expected = new AffineTransform();
        AffineTransform actual = new AffineTransform();
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            expectedRotation = new Matrix3D((Matrix3DReadOnly)original.getLinearTransform());
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.multiply((Matrix3DReadOnly)new RotationMatrix(yaw, 0.0, 0.0));
            expected.set((Matrix3DReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            actual.set(original);
            actual.appendYawRotation(yaw);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            expectedRotation = new Matrix3D((Matrix3DReadOnly)original.getLinearTransform());
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.multiply((Matrix3DReadOnly)new RotationMatrix(0.0, pitch, 0.0));
            expected.set((Matrix3DReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            actual.set(original);
            actual.appendPitchRotation(pitch);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            expectedRotation = new Matrix3D((Matrix3DReadOnly)original.getLinearTransform());
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.multiply((Matrix3DReadOnly)new RotationMatrix(0.0, 0.0, roll));
            expected.set((Matrix3DReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            actual.set(original);
            actual.appendRollRotation(roll);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPrependTranslation() throws Exception {
        AffineTransform translationTransform;
        AffineTransform original;
        int i;
        Random random = new Random(35454L);
        AffineTransform expected = new AffineTransform();
        AffineTransform actual = new AffineTransform();
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            translationTransform = new AffineTransform();
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double z = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            translationTransform.setTranslation(x, y, z);
            expected.set(original);
            expected.preMultiply((AffineTransformReadOnly)translationTransform);
            actual.set(original);
            actual.prependTranslation(x, y, z);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            translationTransform = new AffineTransform();
            Point3D translation = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
            translationTransform.setTranslation((Tuple3DReadOnly)translation);
            expected.set(original);
            expected.preMultiply((AffineTransformReadOnly)translationTransform);
            actual.set(original);
            actual.prependTranslation((Tuple3DReadOnly)translation);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPrependOrientation() throws Exception {
        Random random = new Random(3456L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            AffineTransform orientationTransform = new AffineTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)new Vector3D());
            AffineTransform expected = new AffineTransform();
            expected.set(original);
            expected.preMultiply((AffineTransformReadOnly)orientationTransform);
            AffineTransform actual = new AffineTransform();
            actual.set(original);
            actual.prependOrientation((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPrependYawPitchRoll() throws Exception {
        AffineTransform original;
        int i;
        Random random = new Random(35454L);
        AffineTransform expected = new AffineTransform();
        AffineTransform actual = new AffineTransform();
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            AffineTransform yawTransform = new AffineTransform();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            yawTransform.getLinearTransform().setToYawMatrix(yaw);
            expected.set(original);
            expected.preMultiply((AffineTransformReadOnly)yawTransform);
            actual.set(original);
            actual.prependYawRotation(yaw);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            AffineTransform pitchTransform = new AffineTransform();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            pitchTransform.getLinearTransform().setToPitchMatrix(pitch);
            expected.set(original);
            expected.preMultiply((AffineTransformReadOnly)pitchTransform);
            actual.set(original);
            actual.prependPitchRotation(pitch);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = this.createRandomTransform(random);
            AffineTransform rollTransform = new AffineTransform();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rollTransform.getLinearTransform().setToRollMatrix(roll);
            expected.set(original);
            expected.preMultiply((AffineTransformReadOnly)rollTransform);
            actual.set(original);
            actual.prependRollRotation(roll);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiply() throws Exception {
        AffineTransform t2;
        AffineTransform t1;
        int i;
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            AffineTransform transform = EuclidCoreRandomTools.nextNonSingularAffineTransform((Random)random);
            AffineTransform inverse = new AffineTransform((AffineTransformReadOnly)transform);
            inverse.invert();
            Assertions.assertTrue((boolean)transform.hasLinearTransform());
            Assertions.assertTrue((boolean)transform.hasTranslation());
            transform.multiply((AffineTransformReadOnly)inverse);
            Assertions.assertFalse((boolean)transform.hasLinearTransform());
            Assertions.assertFalse((boolean)transform.hasTranslation());
            for (int row = 0; row < 4; ++row) {
                for (int column = 0; column < 4; ++column) {
                    if (row == column) {
                        Assertions.assertEquals((double)transform.getElement(row, column), (double)1.0, (double)1.0E-10);
                        continue;
                    }
                    Assertions.assertEquals((double)transform.getElement(row, column), (double)0.0, (double)1.0E-10);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            t1 = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            t2 = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
        }
        for (i = 0; i < 1000; ++i) {
            t1 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new AffineTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply((AffineTransformReadOnly)t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = new AffineTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertFalse((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply((AffineTransformReadOnly)t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)new Vector3D());
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply((AffineTransformReadOnly)t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertFalse((boolean)t1.hasTranslation());
            t1.multiply((AffineTransformReadOnly)t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = new AffineTransform(new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new AffineTransform(new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertFalse((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply((AffineTransformReadOnly)t2);
            Assertions.assertFalse((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)new Vector3D());
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertFalse((boolean)t1.hasTranslation());
            t1.multiply((AffineTransformReadOnly)t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertFalse((boolean)t1.hasTranslation());
            t1 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2.setLinearTransform((Matrix3DReadOnly)t1.getLinearTransform());
            t2.getLinearTransform().invert();
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply((AffineTransformReadOnly)t2);
            Assertions.assertFalse((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new AffineTransform((Matrix3DReadOnly)EuclidCoreRandomTools.nextLinearTransform3D((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)t1.getTranslation());
            negateTranslation.negate();
            t1.inverseTransform((Vector3DBasics)negateTranslation);
            t2.setTranslation((Tuple3DReadOnly)negateTranslation);
            AffineTransformTest.checkMultiplyAgainstEJML(t1, t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertTrue((boolean)t1.hasTranslation());
            t1.multiply((AffineTransformReadOnly)t2);
            Assertions.assertTrue((boolean)t1.hasLinearTransform());
            Assertions.assertFalse((boolean)t1.hasTranslation());
        }
    }

    private static void checkMultiplyAgainstEJML(AffineTransform t1, AffineTransform t2) {
        AffineTransform t3 = new AffineTransform((AffineTransformReadOnly)t1);
        t3.multiply((AffineTransformReadOnly)t2);
        DMatrixRMaj m1 = new DMatrixRMaj(4, 4);
        DMatrixRMaj m2 = new DMatrixRMaj(4, 4);
        DMatrixRMaj m3 = new DMatrixRMaj(4, 4);
        t1.get((DMatrix)m1);
        t2.get((DMatrix)m2);
        CommonOps_DDRM.mult((DMatrix1Row)m1, (DMatrix1Row)m2, (DMatrix1Row)m3);
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertEquals((double)m3.get(row, column), (double)t3.getElement(row, column), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testMultiplyWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransformTest.checkMultiplyAgainstEJML(original, multipliedWith);
        }
    }

    private static void checkMultiplyAgainstEJML(AffineTransform t1, RigidBodyTransform t2) {
        AffineTransform t3 = new AffineTransform((AffineTransformReadOnly)t1);
        t3.multiply((RigidBodyTransformReadOnly)t2);
        DMatrixRMaj m1 = new DMatrixRMaj(4, 4);
        DMatrixRMaj m2 = new DMatrixRMaj(4, 4);
        DMatrixRMaj m3 = new DMatrixRMaj(4, 4);
        t1.get((DMatrix)m1);
        t2.get((DMatrix)m2);
        CommonOps_DDRM.mult((DMatrix1Row)m1, (DMatrix1Row)m2, (DMatrix1Row)m3);
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertEquals((double)m3.get(row, column), (double)t3.getElement(row, column), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testMultiplyWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            AffineTransformTest.checkMultiplyAgainstEJML(original, multipliedWith);
        }
    }

    private static void checkMultiplyAgainstEJML(AffineTransform t1, QuaternionBasedTransform t2) {
        AffineTransform t3 = new AffineTransform((AffineTransformReadOnly)t1);
        t3.multiply((RigidBodyTransformReadOnly)t2);
        DMatrixRMaj m1 = new DMatrixRMaj(4, 4);
        DMatrixRMaj m2 = new DMatrixRMaj(4, 4);
        DMatrixRMaj m3 = new DMatrixRMaj(4, 4);
        t1.get((DMatrix)m1);
        new RigidBodyTransform((RigidBodyTransformReadOnly)t2).get((DMatrix)m2);
        CommonOps_DDRM.mult((DMatrix1Row)m1, (DMatrix1Row)m2, (DMatrix1Row)m3);
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertEquals((double)m3.get(row, column), (double)t3.getElement(row, column), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testMultiplyInvertThis() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            AffineTransform multipliedWith = this.createRandomTransform(random);
            expected.set(original);
            expected.invert();
            expected.multiply((AffineTransformReadOnly)multipliedWith);
            actual.set(original);
            actual.multiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertOther() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            AffineTransform multipliedWith = this.createRandomTransform(random);
            AffineTransform inverseOfMultipliedWith = new AffineTransform((AffineTransformReadOnly)multipliedWith);
            inverseOfMultipliedWith.invert();
            expected.set(original);
            expected.multiply((AffineTransformReadOnly)inverseOfMultipliedWith);
            actual.set(original);
            actual.multiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertThisWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform affineMultipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWith);
            expected.set(original);
            expected.multiplyInvertThis((AffineTransformReadOnly)affineMultipliedWith);
            actual.set(original);
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((String)("Iteration " + i), (AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertOtherWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform affineMultipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWith);
            expected.set(original);
            expected.multiplyInvertOther((AffineTransformReadOnly)affineMultipliedWith);
            actual.set(original);
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertThisWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            AffineTransform affineMultipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWith);
            expected.set(original);
            expected.multiplyInvertThis((AffineTransformReadOnly)affineMultipliedWith);
            actual.set(original);
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertOtherWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            AffineTransform affineMultipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWith);
            expected.set(original);
            expected.multiplyInvertOther((AffineTransformReadOnly)affineMultipliedWith);
            actual.set(original);
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiply() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            AffineTransform multipliedWith = this.createRandomTransform(random);
            expected.set(multipliedWith);
            expected.multiply((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiply((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyWithRigidBodyTransform() throws Exception {
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.set((RigidBodyTransformReadOnly)multipliedWith);
            expected.multiply((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expected.set((RigidBodyTransformReadOnly)multipliedWith);
            expected.multiply((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertThis() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            AffineTransform multipliedWith = this.createRandomTransform(random);
            expected.set(multipliedWith);
            expected.multiplyInvertOther((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertOther() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            AffineTransform multipliedWith = this.createRandomTransform(random);
            expected.set(multipliedWith);
            expected.invert();
            expected.multiply((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertThisWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.set((RigidBodyTransformReadOnly)multipliedWith);
            expected.multiplyInvertOther((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertOtherWithRigidBodyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.set((RigidBodyTransformReadOnly)multipliedWith);
            expected.invert();
            expected.multiply((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertThisWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expected.set((RigidBodyTransformReadOnly)multipliedWith);
            expected.multiplyInvertOther((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testPreMultiplyInvertOtherWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            AffineTransform original = this.createRandomTransform(random);
            AffineTransform expected = this.createRandomTransform(random);
            AffineTransform actual = this.createRandomTransform(random);
            QuaternionBasedTransform multipliedWith = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            expected.set((RigidBodyTransformReadOnly)multipliedWith);
            expected.invert();
            expected.multiply((AffineTransformReadOnly)original);
            actual.set(original);
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformWithTuple() throws Exception {
        int i;
        Random random = new Random(432L);
        AffineTransform transform = this.createRandomTransform(random);
        DMatrixRMaj matrix = new DMatrixRMaj(4, 4);
        transform.get((DMatrix)matrix);
        DMatrixRMaj ejmlPoint = new DMatrixRMaj(4, 1);
        DMatrixRMaj ejmlTransformedPoint = new DMatrixRMaj(4, 1);
        Point3D point = EuclidCoreRandomTools.nextPoint3D((Random)random);
        point.get((DMatrix)ejmlPoint);
        ejmlPoint.set(3, 0, 1.0);
        transform.transform((Point3DBasics)point);
        CommonOps_DDRM.mult((DMatrix1Row)matrix, (DMatrix1Row)ejmlPoint, (DMatrix1Row)ejmlTransformedPoint);
        for (int i2 = 0; i2 < 3; ++i2) {
            Assertions.assertEquals((double)ejmlTransformedPoint.get(i2, 0), (double)point.getElement(i2), (double)1.0E-10);
        }
        ejmlPoint = new DMatrixRMaj(4, 1);
        ejmlTransformedPoint = new DMatrixRMaj(4, 1);
        point = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D pointTransformed = new Point3D();
        point.get((DMatrix)ejmlPoint);
        ejmlPoint.set(3, 0, 1.0);
        transform.transform((Point3DReadOnly)point, (Point3DBasics)pointTransformed);
        CommonOps_DDRM.mult((DMatrix1Row)matrix, (DMatrix1Row)ejmlPoint, (DMatrix1Row)ejmlTransformedPoint);
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((double)ejmlTransformedPoint.get(i, 0), (double)pointTransformed.getElement(i), (double)1.0E-10);
        }
        DMatrixRMaj ejmlVector = new DMatrixRMaj(4, 1);
        DMatrixRMaj ejmlTransformedVector = new DMatrixRMaj(4, 1);
        Vector3D vector = EuclidCoreRandomTools.nextVector3D((Random)random);
        vector.get((DMatrix)ejmlVector);
        transform.transform((Vector3DBasics)vector);
        CommonOps_DDRM.mult((DMatrix1Row)matrix, (DMatrix1Row)ejmlVector, (DMatrix1Row)ejmlTransformedVector);
        for (int i3 = 0; i3 < 3; ++i3) {
            Assertions.assertEquals((double)ejmlTransformedVector.get(i3, 0), (double)vector.getElement(i3), (double)1.0E-10);
        }
        ejmlVector = new DMatrixRMaj(4, 1);
        ejmlTransformedVector = new DMatrixRMaj(4, 1);
        vector = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D vectorTransformed = new Vector3D();
        vector.get((DMatrix)ejmlVector);
        transform.transform((Vector3DReadOnly)vector, (Vector3DBasics)vectorTransformed);
        CommonOps_DDRM.mult((DMatrix1Row)matrix, (DMatrix1Row)ejmlVector, (DMatrix1Row)ejmlTransformedVector);
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((double)ejmlTransformedVector.get(i, 0), (double)vectorTransformed.getElement(i), (double)1.0E-10);
        }
    }

    @Test
    public void testTransformWithQuaternion() throws Exception {
        Random random = new Random(34534L);
        AffineTransform transform = this.createRandomTransform(random);
        Quaternion quaternionOriginal = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion quaternionExpected = new Quaternion();
        Quaternion quaternionActual = new Quaternion();
        quaternionExpected.set(transform.getLinearTransform().getAsQuaternion());
        quaternionExpected.multiply((QuaternionReadOnly)quaternionOriginal);
        transform.transform((Orientation3DReadOnly)quaternionOriginal, (Orientation3DBasics)quaternionActual);
        EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternionExpected, (QuaternionReadOnly)quaternionActual, (double)1.0E-10);
        quaternionActual.set(quaternionOriginal);
        transform.transform((Orientation3DBasics)quaternionActual);
        EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)quaternionExpected, (QuaternionReadOnly)quaternionActual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithVector4D() throws Exception {
        Random random = new Random(5634L);
        AffineTransform transform = this.createRandomTransform(random);
        Vector4D vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
        Vector4D vectorExpected = new Vector4D();
        Vector4D vectorActual = new Vector4D();
        Vector3D vector3D = new Vector3D(vectorOriginal.getX(), vectorOriginal.getY(), vectorOriginal.getZ());
        transform.transform((Vector3DBasics)vector3D);
        vectorExpected.set((Vector3DReadOnly)vector3D);
        vectorExpected.setS(vectorOriginal.getS());
        vectorExpected.addX(vectorExpected.getS() * transform.getM03());
        vectorExpected.addY(vectorExpected.getS() * transform.getM13());
        vectorExpected.addZ(vectorExpected.getS() * transform.getM23());
        transform.transform((Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        vectorActual.set(vectorOriginal);
        transform.transform((Vector4DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        DMatrixRMaj transformDenseMatrix = new DMatrixRMaj(4, 4);
        transform.get((DMatrix)transformDenseMatrix);
        DMatrixRMaj vectorOriginalDenseMatrix = new DMatrixRMaj(4, 1);
        vectorOriginal.get((DMatrix)vectorOriginalDenseMatrix);
        DMatrixRMaj vectorTransformedDenseMatrix = new DMatrixRMaj(4, 1);
        CommonOps_DDRM.mult((DMatrix1Row)transformDenseMatrix, (DMatrix1Row)vectorOriginalDenseMatrix, (DMatrix1Row)vectorTransformedDenseMatrix);
        vectorExpected.set((DMatrix)vectorTransformedDenseMatrix);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithTuple2D() throws Exception {
        Random random = new Random(4353L);
        AffineTransform transfom2D = new AffineTransform();
        transfom2D.getLinearTransform().setToYawMatrix(Math.PI * 2 * random.nextDouble() - Math.PI);
        transfom2D.setTranslation((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        transfom2D.appendScale(random.nextDouble(), random.nextDouble(), 1.0);
        Point2D pointOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
        Point2D pointExpected = new Point2D();
        Point2D pointActual = new Point2D();
        Point3D point = new Point3D(pointOriginal.getX(), pointOriginal.getY(), 0.0);
        transfom2D.transform((Point3DBasics)point);
        pointExpected.set(point.getX(), point.getY());
        pointActual.set(pointOriginal);
        transfom2D.transform((Point2DBasics)pointActual);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)pointExpected, (Tuple2DReadOnly)pointActual, (double)1.0E-10);
        pointOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
        pointExpected = new Point2D();
        pointActual = new Point2D();
        point = new Point3D(pointOriginal.getX(), pointOriginal.getY(), 0.0);
        transfom2D.transform((Point3DBasics)point);
        pointExpected.set(point.getX(), point.getY());
        pointActual.set(pointOriginal);
        transfom2D.transform((Point2DBasics)pointActual, true);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)pointExpected, (Tuple2DReadOnly)pointActual, (double)1.0E-10);
        pointOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
        pointExpected = new Point2D();
        pointActual = new Point2D();
        point = new Point3D(pointOriginal.getX(), pointOriginal.getY(), 0.0);
        transfom2D.transform((Point3DBasics)point);
        pointExpected.set(point.getX(), point.getY());
        transfom2D.transform((Point2DReadOnly)pointOriginal, (Point2DBasics)pointActual);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)pointExpected, (Tuple2DReadOnly)pointActual, (double)1.0E-10);
        pointOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
        pointExpected = new Point2D();
        pointActual = new Point2D();
        point = new Point3D(pointOriginal.getX(), pointOriginal.getY(), 0.0);
        transfom2D.transform((Point3DBasics)point);
        pointExpected.set(point.getX(), point.getY());
        transfom2D.transform((Point2DReadOnly)pointOriginal, (Point2DBasics)pointActual, true);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)pointExpected, (Tuple2DReadOnly)pointActual, (double)1.0E-10);
        Vector2D vectorOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
        Vector2D vectorExpected = new Vector2D();
        Vector2D vectorActual = new Vector2D();
        Vector3D vector = new Vector3D(vectorOriginal.getX(), vectorOriginal.getY(), 0.0);
        transfom2D.transform((Vector3DBasics)vector);
        vectorExpected.set(vector.getX(), vector.getY());
        vectorActual.set(vectorOriginal);
        transfom2D.transform((Vector2DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)vectorExpected, (Tuple2DReadOnly)vectorActual, (double)1.0E-10);
        vectorOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
        vectorExpected = new Vector2D();
        vectorActual = new Vector2D();
        vector = new Vector3D(vectorOriginal.getX(), vectorOriginal.getY(), 0.0);
        transfom2D.transform((Vector3DBasics)vector);
        vectorExpected.set(vector.getX(), vector.getY());
        transfom2D.transform((Vector2DReadOnly)vectorOriginal, (Vector2DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)vectorExpected, (Tuple2DReadOnly)vectorActual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithMatrix3D() throws Exception {
        Random random = new Random(4534L);
        AffineTransform transform = this.createRandomTransform(random);
        Matrix3D matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        Matrix3D m = new Matrix3D((Matrix3DReadOnly)transform.getLinearTransform());
        matrixExpected.set(matrixOriginal);
        matrixExpected.preMultiply((Matrix3DReadOnly)m);
        matrixExpected.multiplyInvertOther((Matrix3DReadOnly)m);
        transform.transform((Matrix3DReadOnly)matrixOriginal, (Matrix3DBasics)matrixActual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        matrixActual.set(matrixOriginal);
        transform.transform((Matrix3DBasics)matrixActual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithRotationMatrix() throws Exception {
        Random random = new Random(2342L);
        AffineTransform transform = this.createRandomTransform(random);
        RotationMatrix original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RotationMatrix expected = new RotationMatrix();
        RotationMatrix actual = new RotationMatrix();
        transform.getLinearTransform().getAsQuaternion().transform((RotationMatrixReadOnly)original, (RotationMatrixBasics)expected);
        actual.set(original);
        transform.transform((RotationMatrixBasics)actual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithOtherRigidBodyTransform() throws Exception {
        Random random = new Random(23423L);
        AffineTransform transform = this.createRandomTransform(random);
        RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expected = new RigidBodyTransform();
        RigidBodyTransform actual = new RigidBodyTransform();
        expected.set((AffineTransformReadOnly)transform);
        expected.multiply((RigidBodyTransformReadOnly)original);
        transform.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)expected, (RigidBodyTransform)actual, (double)1.0E-10);
        actual.set(original);
        transform.transform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)expected, (RigidBodyTransform)actual, (double)1.0E-10);
        RigidBodyTransform inverse = new RigidBodyTransform();
        inverse.set((AffineTransformReadOnly)transform);
        inverse.invert();
        inverse.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)expected);
        transform.inverseTransform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)expected, (RigidBodyTransform)actual, (double)1.0E-10);
        actual.set(original);
        transform.inverseTransform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)expected, (RigidBodyTransform)actual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(23423L);
        AffineTransform transform = this.createRandomTransform(random);
        RigidBodyTransform originalRigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expectedRigidBodyTransform = new RigidBodyTransform();
        QuaternionBasedTransform original = new QuaternionBasedTransform((RigidBodyTransformReadOnly)originalRigidBodyTransform);
        QuaternionBasedTransform expected = new QuaternionBasedTransform();
        QuaternionBasedTransform actual = new QuaternionBasedTransform();
        transform.transform((RigidBodyTransformReadOnly)originalRigidBodyTransform, (RigidBodyTransformBasics)expectedRigidBodyTransform);
        expected.set((RigidBodyTransformReadOnly)expectedRigidBodyTransform);
        transform.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertQuaternionBasedTransformGeometricallyEquals((QuaternionBasedTransform)expected, (QuaternionBasedTransform)actual, (double)1.0E-10);
        actual.set(original);
        transform.transform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertQuaternionBasedTransformGeometricallyEquals((QuaternionBasedTransform)expected, (QuaternionBasedTransform)actual, (double)1.0E-10);
        RigidBodyTransform inverse = new RigidBodyTransform();
        inverse.set((AffineTransformReadOnly)transform);
        inverse.invert();
        inverse.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)expected);
        transform.inverseTransform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertQuaternionBasedTransformGeometricallyEquals((QuaternionBasedTransform)expected, (QuaternionBasedTransform)actual, (double)1.0E-10);
        actual.set(original);
        transform.inverseTransform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertQuaternionBasedTransformGeometricallyEquals((QuaternionBasedTransform)expected, (QuaternionBasedTransform)actual, (double)1.0E-10);
    }

    @Test
    public void testTransformWithAffineTransform() throws Exception {
        Random random = new Random(23423L);
        AffineTransform transform = this.createRandomTransform(random);
        AffineTransform original = this.createRandomTransform(random);
        AffineTransform expected = new AffineTransform();
        AffineTransform actual = new AffineTransform();
        expected.set(original);
        expected.preMultiply((AffineTransformReadOnly)transform);
        transform.transform((AffineTransformReadOnly)original, (AffineTransformBasics)actual);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        actual.set(original);
        transform.transform((AffineTransformBasics)actual);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        expected.set(original);
        expected.preMultiplyInvertOther((AffineTransformReadOnly)transform);
        transform.inverseTransform((AffineTransformReadOnly)original, (AffineTransformBasics)actual);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
        actual.set(original);
        transform.inverseTransform((AffineTransformBasics)actual);
        EuclidCoreTestTools.assertAffineTransformEquals((AffineTransformReadOnly)expected, (AffineTransformReadOnly)actual, (double)1.0E-10);
    }

    @Test
    public void testGet() throws Exception {
        int row;
        Random random = new Random(2342L);
        AffineTransform transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        DMatrixRMaj denseMatrix = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)4, (int)4);
        transform.get((DMatrix)denseMatrix);
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertTrue((denseMatrix.get(row, column) == transform.getElement(row, column) ? 1 : 0) != 0);
            }
        }
        transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        int startRow = random.nextInt(10);
        int startColumn = random.nextInt(10);
        DMatrixRMaj denseMatrix2 = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)(4 + startRow), (int)(4 + startColumn));
        transform.get(startRow, startColumn, (DMatrix)denseMatrix2);
        for (int row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertTrue((denseMatrix2.get(row2 + startRow, column + startColumn) == transform.getElement(row2, column) ? 1 : 0) != 0);
            }
        }
        transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        double[] transformArray = new double[16];
        transform.get(transformArray);
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertTrue((transformArray[4 * row + column] == transform.getElement(row, column) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetElement() throws Exception {
        Random random = new Random(5464L);
        AffineTransform transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        LinearTransform3D rotationScaleMatrix = transform.getLinearTransform();
        Vector3DBasics translation = transform.getTranslation();
        Assertions.assertTrue((rotationScaleMatrix.getM00() == transform.getM00() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM01() == transform.getM01() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM02() == transform.getM02() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM10() == transform.getM10() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM11() == transform.getM11() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM12() == transform.getM12() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM20() == transform.getM20() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM21() == transform.getM21() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM22() == transform.getM22() ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM00() == transform.getElement(0, 0) ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM01() == transform.getElement(0, 1) ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM02() == transform.getElement(0, 2) ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM10() == transform.getElement(1, 0) ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM11() == transform.getElement(1, 1) ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM12() == transform.getElement(1, 2) ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM20() == transform.getElement(2, 0) ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM21() == transform.getElement(2, 1) ? 1 : 0) != 0);
        Assertions.assertTrue((rotationScaleMatrix.getM22() == transform.getElement(2, 2) ? 1 : 0) != 0);
        Assertions.assertTrue((translation.getElement(0) == transform.getM03() ? 1 : 0) != 0);
        Assertions.assertTrue((translation.getElement(1) == transform.getM13() ? 1 : 0) != 0);
        Assertions.assertTrue((translation.getElement(2) == transform.getM23() ? 1 : 0) != 0);
        Assertions.assertTrue((translation.getElement(0) == transform.getElement(0, 3) ? 1 : 0) != 0);
        Assertions.assertTrue((translation.getElement(1) == transform.getElement(1, 3) ? 1 : 0) != 0);
        Assertions.assertTrue((translation.getElement(2) == transform.getElement(2, 3) ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getM30() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getM31() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getM32() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getM33() == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(3, 0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(3, 1) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(3, 2) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(3, 3) == 1.0 ? 1 : 0) != 0);
        try {
            transform.getElement(0, 4);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            transform.getElement(1, 4);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            transform.getElement(2, 4);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            transform.getElement(3, 4);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            transform.getElement(4, 0);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(2354L);
        AffineTransform t1 = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        AffineTransform t2 = new AffineTransform();
        Assertions.assertFalse((boolean)t1.equals((AffineTransformReadOnly)t2));
        Assertions.assertFalse((boolean)t1.equals(null));
        Assertions.assertFalse((boolean)t1.equals((Object)new double[4]));
        t2.set(t1);
        Assertions.assertTrue((boolean)t1.equals((AffineTransformReadOnly)t2));
        AffineTransform t2AsObject = t2;
        Assertions.assertTrue((boolean)t1.equals((Object)t2AsObject));
        double smallestEpsilon = 1.0E-15;
        double[] coeffs = new double[16];
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 4; ++column) {
                t2.set(t1);
                Assertions.assertTrue((boolean)t1.equals((AffineTransformReadOnly)t2));
                t1.get(coeffs);
                int n = 3 * row + column;
                coeffs[n] = coeffs[n] + smallestEpsilon;
                t2.set(coeffs);
                Assertions.assertFalse((boolean)t1.equals((AffineTransformReadOnly)t2));
                t2.set(t1);
                Assertions.assertTrue((boolean)t1.equals((AffineTransformReadOnly)t2));
                t1.get(coeffs);
                int n2 = 3 * row + column;
                coeffs[n2] = coeffs[n2] - smallestEpsilon;
                t2.set(coeffs);
                Assertions.assertFalse((boolean)t1.equals((AffineTransformReadOnly)t2));
            }
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(2354L);
        AffineTransform t = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        double m00 = t.getM00();
        double m01 = t.getM01();
        double m02 = t.getM02();
        double m10 = t.getM10();
        double m11 = t.getM11();
        double m12 = t.getM12();
        double m20 = t.getM20();
        double m21 = t.getM21();
        double m22 = t.getM22();
        double tx = t.getM03();
        double ty = t.getM13();
        double tz = t.getM23();
        double small = 9.99E-11;
        double big = 1.001E-10;
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00 + small, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01 + small, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02 + small, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10 + small, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11 + small, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12 + small, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20 + small, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21 + small, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22 + small, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx + small, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty + small, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz + small), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00 - small, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01 - small, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02 - small, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10 - small, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11 - small, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12 - small, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20 - small, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21 - small, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22 - small, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx - small, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty - small, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz - small), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00 + big, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01 + big, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02 + big, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10 + big, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11 + big, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12 + big, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20 + big, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21 + big, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22 + big, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx + big, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty + big, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz + big), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00 - big, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01 - big, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02 - big, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10 - big, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11 - big, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12 - big, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20 - big, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21 - big, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22 - big, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx - big, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty - big, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.epsilonEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz - big), 1.0E-10));
    }

    private static AffineTransform createTransform(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, double tx, double ty, double tz) {
        return new AffineTransform((Matrix3DReadOnly)new Matrix3D(m00, m01, m02, m10, m11, m12, m20, m21, m22), (Tuple3DReadOnly)new Vector3D(tx, ty, tz));
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(2354L);
        AffineTransform t = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        double m00 = t.getM00();
        double m01 = t.getM01();
        double m02 = t.getM02();
        double m10 = t.getM10();
        double m11 = t.getM11();
        double m12 = t.getM12();
        double m20 = t.getM20();
        double m21 = t.getM21();
        double m22 = t.getM22();
        double tx = t.getM03();
        double ty = t.getM13();
        double tz = t.getM23();
        double small = 9.99E-11;
        double big = 1.001E-10;
        Vector3D d = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)small);
        double small_dx = d.getX();
        double small_dy = d.getY();
        double small_dz = d.getZ();
        d = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)big);
        double big_dx = d.getX();
        double big_dy = d.getY();
        double big_dz = d.getZ();
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00 + small, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01 + small, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02 + small, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10 + small, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11 + small, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12 + small, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20 + small, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21 + small, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22 + small, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx + small_dx, ty + small_dy, tz + small_dz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00 - small, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01 - small, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02 - small, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10 - small, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11 - small, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12 - small, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20 - small, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21 - small, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22 - small, tx, ty, tz), 1.0E-10));
        Assertions.assertTrue((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx - small_dx, ty - small_dy, tz - small_dz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00 + big, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01 + big, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02 + big, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10 + big, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11 + big, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12 + big, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20 + big, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21 + big, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22 + big, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx + big_dx, ty + big_dy, tz + big_dz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00 - big, m01, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01 - big, m02, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02 - big, m10, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10 - big, m11, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11 - big, m12, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12 - big, m20, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20 - big, m21, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21 - big, m22, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22 - big, tx, ty, tz), 1.0E-10));
        Assertions.assertFalse((boolean)t.geometricallyEquals(AffineTransformTest.createTransform(m00, m01, m02, m10, m11, m12, m20, m21, m22, tx - big_dx, ty - big_dy, tz - big_dz), 1.0E-10));
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(12345L);
        AffineTransform affine = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        int newHashCode = affine.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)affine.hashCode());
        int previousHashCode = affine.hashCode();
        for (int i = 0; i < 1000; ++i) {
            affine = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            newHashCode = affine.hashCode();
            Assertions.assertNotEquals((int)previousHashCode, (int)newHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Test
    public void testToString() throws Exception {
        AffineTransform affB;
        AffineTransform affA;
        int i;
        Random random = new Random(12345L);
        for (i = 0; i < 1000; ++i) {
            affA = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            affB = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            Assertions.assertNotEquals((Object)affA.toString(), (Object)affB.toString());
        }
        for (i = 0; i < 1000; ++i) {
            affA = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            affB = new AffineTransform((AffineTransformReadOnly)affA);
            Assertions.assertEquals((Object)affA.toString(), (Object)affB.toString());
        }
    }

    @Override
    public AffineTransform createRandomTransform(Random random) {
        AffineTransform next = EuclidCoreRandomTools.nextNonSingularAffineTransform((Random)random);
        if (random.nextBoolean()) {
            next.getTranslation().setToZero();
        }
        if (random.nextBoolean()) {
            next.getLinearTransform().setIdentity();
        } else if (random.nextBoolean()) {
            next.getLinearTransform().resetScale();
        }
        return next;
    }

    @Override
    public AffineTransform createRandomTransform2D(Random random) {
        AffineTransform transfom2D = new AffineTransform();
        transfom2D.getLinearTransform().setToYawMatrix(Math.PI * 2 * random.nextDouble() - Math.PI);
        transfom2D.setTranslation((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        transfom2D.appendScale(random.nextDouble(), random.nextDouble(), 1.0);
        return transfom2D;
    }
}

