/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class YawPitchRollToolsTest {
    public static final double EPSILON = 1.0E-12;

    @Test
    public void testIsZero() {
        Random random = new Random(342L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            double roll = 0.0;
            double pitch = 0.0;
            double yaw = 0.0;
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
        }
    }

    @Test
    public void testIsOrientation2D() {
        Random random = new Random(342L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            double roll = 0.0;
            double pitch = 0.0;
            double yaw = 0.0;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = Double.NaN;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0);
            roll = 0.0;
            pitch = 0.0;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            roll = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            roll = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
        }
    }

    @Test
    public void testDistance() throws Exception {
        Random random = new Random(5321L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll firstYPR = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll secondYPR = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            Quaternion firstQ = new Quaternion((Orientation3DReadOnly)firstYPR);
            Quaternion secondQ = new Quaternion((Orientation3DReadOnly)secondYPR);
            Assertions.assertEquals((double)firstQ.distance((QuaternionReadOnly)secondQ), (double)YawPitchRollTools.distance((YawPitchRollReadOnly)firstYPR, (YawPitchRollReadOnly)secondYPR), (double)1.0E-12);
            Assertions.assertEquals((double)firstQ.distance((QuaternionReadOnly)secondQ), (double)YawPitchRollTools.distance((double)firstYPR.getYaw(), (double)firstYPR.getPitch(), (double)firstYPR.getRoll(), (double)secondYPR.getYaw(), (double)secondYPR.getPitch(), (double)secondYPR.getRoll()), (double)1.0E-12);
        }
    }

    @Test
    public void testTransform() throws Exception {
        Point3D expected;
        Point3D actual;
        Point3D tupleOriginal;
        YawPitchRoll ypr;
        int i;
        Random random = new Random(24546654L);
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.addTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).addTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.addTransform((YawPitchRollReadOnly)ypr, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).addTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)false);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testTransform$0(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setPitch(0.0);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testTransform$1(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setRoll(0.0);
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)false);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testTransform$2(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setPitch(0.0);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testTransform$3(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setRoll(0.0);
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testInverseTransform() throws Exception {
        Point3D expected;
        Point3D actual;
        Point3D tupleOriginal;
        YawPitchRoll ypr;
        int i;
        Random random = new Random(24546654L);
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)false);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testInverseTransform$4(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setPitch(0.0);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testInverseTransform$5(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setRoll(0.0);
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)false);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testInverseTransform$6(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setPitch(0.0);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testInverseTransform$7(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setRoll(0.0);
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiply() throws Exception {
        Random random = new Random(5303298L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll ypr1 = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            AxisAngle aa1 = new AxisAngle((Orientation3DReadOnly)ypr1);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)ypr1);
            RotationMatrix r1 = new RotationMatrix((Orientation3DReadOnly)ypr1);
            YawPitchRoll ypr2 = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            AxisAngle aa2 = new AxisAngle((Orientation3DReadOnly)ypr2);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)ypr2);
            RotationMatrix r2 = new RotationMatrix((Orientation3DReadOnly)ypr2);
            for (int invertByte = 0; invertByte < 4; invertByte = (int)((byte)(invertByte + 1))) {
                boolean invert1 = (invertByte & 1) != 0;
                boolean invert2 = (invertByte & 2) != 0;
                Quaternion qExpected = new Quaternion();
                if (invert1) {
                    qExpected.setAndInvert((Orientation3DReadOnly)q1);
                } else {
                    qExpected.set(q1);
                }
                if (invert2) {
                    qExpected.multiplyConjugateOther((QuaternionReadOnly)q2);
                } else {
                    qExpected.multiply((QuaternionReadOnly)q2);
                }
                YawPitchRoll yprExpected = new YawPitchRoll((Orientation3DReadOnly)qExpected);
                YawPitchRoll yprActual = new YawPitchRoll();
                YawPitchRollTools.multiply((Orientation3DReadOnly)ypr1, (boolean)invert1, (Orientation3DReadOnly)ypr2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yprExpected, (YawPitchRollReadOnly)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)aa1, (boolean)invert1, (Orientation3DReadOnly)ypr2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yprExpected, (YawPitchRollReadOnly)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)q1, (boolean)invert1, (Orientation3DReadOnly)ypr2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yprExpected, (YawPitchRollReadOnly)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)r1, (boolean)invert1, (Orientation3DReadOnly)ypr2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yprExpected, (YawPitchRollReadOnly)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)ypr1, (boolean)invert1, (Orientation3DReadOnly)aa2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yprExpected, (YawPitchRollReadOnly)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)ypr1, (boolean)invert1, (Orientation3DReadOnly)q2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yprExpected, (YawPitchRollReadOnly)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)ypr1, (boolean)invert1, (Orientation3DReadOnly)r2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yprExpected, (YawPitchRollReadOnly)yprActual, (double)1.0E-12);
            }
        }
    }

    @Test
    public void testPrependYawRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.prependYawRotation(yaw);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.prependYawRotation((YawPitchRollReadOnly)original, (double)yaw, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendYawRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.appendYawRotation(yaw);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.appendYawRotation((YawPitchRollReadOnly)original, (double)yaw, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependPitchRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.prependPitchRotation(pitch);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.prependPitchRotation((YawPitchRollReadOnly)original, (double)pitch, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendPitchRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.appendPitchRotation(pitch);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.appendPitchRotation((YawPitchRollReadOnly)original, (double)pitch, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependRollRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.prependRollRotation(roll);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.prependRollRotation((YawPitchRollReadOnly)original, (double)roll, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendRollRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.appendRollRotation(roll);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.appendRollRotation((YawPitchRollReadOnly)original, (double)roll, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-12);
        }
    }

    private static /* synthetic */ void lambda$testInverseTransform$7(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testInverseTransform$6(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testInverseTransform$5(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testInverseTransform$4(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testTransform$3(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testTransform$2(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testTransform$1(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testTransform$0(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }
}

