/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidShapeToolsTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testSupportingVertexCapsule3D() {
        Random random = new Random(89737893L);
        for (int i = 0; i < 1000; ++i) {
            double capsule3DLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            double capsule3DRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            Point3D capsule3DPosition = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D capsule3DAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D supportDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D expected = new Point3D();
            EuclidShapeTools.supportingVertexCapsule3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)capsule3DPosition, (Vector3DReadOnly)capsule3DAxis, (double)capsule3DLength, (double)capsule3DRadius, (Point3DBasics)expected);
            capsule3DAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            supportDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            Point3D actual = new Point3D();
            EuclidShapeTools.supportingVertexCapsule3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)capsule3DPosition, (Vector3DReadOnly)capsule3DAxis, (double)capsule3DLength, (double)capsule3DRadius, (Point3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testSupportingVertexCylinder3D() {
        Random random = new Random(89737893L);
        for (int i = 0; i < 1000; ++i) {
            double cylinder3DLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            double cylinder3DRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            Point3D cylinder3DPosition = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D cylinder3DAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D supportDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D expected = new Point3D();
            EuclidShapeTools.supportingVertexCylinder3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)cylinder3DPosition, (Vector3DReadOnly)cylinder3DAxis, (double)cylinder3DLength, (double)cylinder3DRadius, (Point3DBasics)expected);
            cylinder3DAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            supportDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            Point3D actual = new Point3D();
            EuclidShapeTools.supportingVertexCylinder3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)cylinder3DPosition, (Vector3DReadOnly)cylinder3DAxis, (double)cylinder3DLength, (double)cylinder3DRadius, (Point3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testSupportingVertexCircle3D() {
        Random random = new Random(89737893L);
        for (int i = 0; i < 1000; ++i) {
            double circle3DRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            Point3D circle3DPosition = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D circle3DAxis = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D axisOrthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)circle3DAxis, (boolean)true);
            Point3D expected = new Point3D();
            expected.scaleAdd(circle3DRadius, (Tuple3DReadOnly)axisOrthogonal, (Tuple3DReadOnly)circle3DPosition);
            Vector3D supportDirection = new Vector3D();
            supportDirection.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0), (Tuple3DReadOnly)axisOrthogonal);
            supportDirection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)circle3DAxis, (Tuple3DReadOnly)supportDirection);
            Point3D actual = new Point3D();
            EuclidShapeTools.supportingVertexCircle3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)circle3DPosition, (Vector3DReadOnly)circle3DAxis, (double)circle3DRadius, (Point3DBasics)actual);
            Assertions.assertEquals((double)circle3DRadius, (double)actual.distance((Point3DReadOnly)circle3DPosition), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testInnerSupportingVertexTorus3D() {
        Random random = new Random(78934L);
        for (int i = 0; i < 1000; ++i) {
            double torus3DRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            double torus3DTubeRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)torus3DRadius);
            Point3D torus3DPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D torus3DAxis = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3D supportingVertex = new Point3D();
            Vector3D supportDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            EuclidShapeTools.innerSupportingVertexTorus3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)torus3DPosition, (Vector3DReadOnly)torus3DAxis, (double)torus3DRadius, (double)torus3DTubeRadius, (Point3DBasics)supportingVertex);
            double signedDistance = EuclidShapeTools.signedDistanceBetweenPoint3DAndTorus3D((Point3DReadOnly)supportingVertex, (Point3DReadOnly)torus3DPosition, (Vector3DReadOnly)torus3DAxis, (double)torus3DRadius, (double)torus3DTubeRadius);
            Assertions.assertEquals((double)0.0, (double)signedDistance, (double)1.0E-12, (String)("Iteration " + i));
            Vector3D normal = new Vector3D();
            Point3D closestPoint = new Point3D();
            EuclidShapeTools.evaluatePoint3DTorus3DCollision((Point3DReadOnly)supportingVertex, (Point3DReadOnly)torus3DPosition, (Vector3DReadOnly)torus3DAxis, (double)torus3DRadius, (double)torus3DTubeRadius, (Point3DBasics)closestPoint, (Vector3DBasics)normal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)closestPoint, (Tuple3DReadOnly)supportingVertex, (double)1.0E-12);
            Vector3D towardsAxis = new Vector3D();
            towardsAxis.sub((Tuple3DReadOnly)torus3DPosition, (Tuple3DReadOnly)closestPoint);
            torus3DAxis.normalize();
            double dot = towardsAxis.dot((Vector3DReadOnly)torus3DAxis);
            towardsAxis.scaleAdd(-dot, (Tuple3DReadOnly)torus3DAxis, (Tuple3DReadOnly)towardsAxis);
            Assertions.assertTrue((normal.dot((Vector3DReadOnly)towardsAxis) > 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSignedDistanceBetweenPoint3DAndTorus3D() {
        Random random = new Random(9638966L);
        for (int i = 0; i < 1000; ++i) {
            double torus3DRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            double torus3DTubeRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)torus3DRadius);
            Point3D torus3DPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D torus3DAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D query = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            double expected = EuclidShapeTools.signedDistanceBetweenPoint3DAndTorus3D((Point3DReadOnly)query, (Point3DReadOnly)torus3DPosition, (Vector3DReadOnly)torus3DAxis, (double)torus3DRadius, (double)torus3DTubeRadius);
            torus3DAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            double actual = EuclidShapeTools.signedDistanceBetweenPoint3DAndTorus3D((Point3DReadOnly)query, (Point3DReadOnly)torus3DPosition, (Vector3DReadOnly)torus3DAxis, (double)torus3DRadius, (double)torus3DTubeRadius);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testEvaluatePoint3DTorus3DCollision() {
        Random random = new Random(9638966L);
        for (int i = 0; i < 1000; ++i) {
            double torus3DRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0);
            double torus3DTubeRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)torus3DRadius);
            Point3D torus3DPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D torus3DAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D query = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D expectedClosestPointOnSurface = new Point3D();
            Vector3D expectedNormal = new Vector3D();
            double expectedSignedDistance = EuclidShapeTools.evaluatePoint3DTorus3DCollision((Point3DReadOnly)query, (Point3DReadOnly)torus3DPosition, (Vector3DReadOnly)torus3DAxis, (double)torus3DRadius, (double)torus3DTubeRadius, (Point3DBasics)expectedClosestPointOnSurface, (Vector3DBasics)expectedNormal);
            torus3DAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
            Point3D actualClosestPointOnSurface = new Point3D();
            Vector3D actualNormal = new Vector3D();
            double actualSignedDistance = EuclidShapeTools.evaluatePoint3DTorus3DCollision((Point3DReadOnly)query, (Point3DReadOnly)torus3DPosition, (Vector3DReadOnly)torus3DAxis, (double)torus3DRadius, (double)torus3DTubeRadius, (Point3DBasics)actualClosestPointOnSurface, (Vector3DBasics)actualNormal);
            Assertions.assertEquals((double)expectedSignedDistance, (double)actualSignedDistance, (double)1.0E-12, (String)("Iteration " + i));
            EuclidCoreTestTools.assertTuple3DEquals((String)("Iteration " + i), (Tuple3DReadOnly)expectedClosestPointOnSurface, (Tuple3DReadOnly)actualClosestPointOnSurface, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((String)("Iteration " + i), (Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeRamp3DCentroid() {
        Random random = new Random(365435L);
        for (int i = 0; i < 1000; ++i) {
            Ramp3D ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D actualCentroid = new Point3D();
            EuclidShapeTools.computeRamp3DCentroid((Shape3DPoseReadOnly)ramp3D.getPose(), (Vector3DReadOnly)ramp3D.getSize(), (Point3DBasics)actualCentroid);
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])ramp3D.getVertices()));
            Point3D expectedCentroid = convexPolytope3D.getCentroid();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedCentroid, (Tuple3DReadOnly)actualCentroid, (double)1.0E-12);
        }
    }

    @Test
    public void testIsFirstValueMinimum() {
        boolean actualResult;
        boolean isLesser;
        int mask;
        int k;
        boolean isMinimumValue;
        int currentByte;
        int j;
        int numberOfCombinations;
        double[] values;
        double possibleMin;
        int i;
        Random random = new Random(65467547L);
        for (i = 0; i < 1000; ++i) {
            possibleMin = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            values = new double[4];
            numberOfCombinations = (int)Math.pow(2.0, values.length);
            for (j = 0; j < numberOfCombinations; ++j) {
                currentByte = 0;
                isMinimumValue = j == 0;
                for (k = 0; k < values.length; ++k) {
                    values[k] = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
                    mask = (int)Math.pow(2.0, currentByte);
                    isLesser = (j & mask) != 0;
                    values[k] = possibleMin + (isLesser ? -values[k] : values[k]);
                    ++currentByte;
                }
                actualResult = EuclidShapeTools.isFirstValueMinimum((double)possibleMin, (double)values[0], (double)values[1], (double)values[2], (double)values[3]);
                Assertions.assertEquals((Object)isMinimumValue, (Object)actualResult);
            }
        }
        for (i = 0; i < 1000; ++i) {
            possibleMin = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            values = new double[3];
            numberOfCombinations = (int)Math.pow(2.0, values.length);
            for (j = 0; j < numberOfCombinations; ++j) {
                currentByte = 0;
                isMinimumValue = j == 0;
                for (k = 0; k < values.length; ++k) {
                    values[k] = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
                    mask = (int)Math.pow(2.0, currentByte);
                    isLesser = (j & mask) != 0;
                    values[k] = possibleMin + (isLesser ? -values[k] : values[k]);
                    ++currentByte;
                }
                actualResult = EuclidShapeTools.isFirstValueMinimum((double)possibleMin, (double)values[0], (double)values[1], (double)values[2]);
                Assertions.assertEquals((Object)isMinimumValue, (Object)actualResult);
            }
        }
        for (i = 0; i < 1000; ++i) {
            possibleMin = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            values = new double[2];
            numberOfCombinations = (int)Math.pow(2.0, values.length);
            for (j = 0; j < numberOfCombinations; ++j) {
                currentByte = 0;
                isMinimumValue = j == 0;
                for (k = 0; k < values.length; ++k) {
                    values[k] = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
                    mask = (int)Math.pow(2.0, currentByte);
                    isLesser = (j & mask) != 0;
                    values[k] = possibleMin + (isLesser ? -values[k] : values[k]);
                    ++currentByte;
                }
                actualResult = EuclidShapeTools.isFirstValueMinimum((double)possibleMin, (double)values[0], (double)values[1]);
                Assertions.assertEquals((Object)isMinimumValue, (Object)actualResult);
            }
        }
    }

    @Test
    public void testIsFirstValueMaximum() {
        boolean actualResult;
        boolean isGreater;
        int mask;
        int k;
        boolean isMinimumValue;
        int currentByte;
        int j;
        int numberOfCombinations;
        double[] values;
        double possibleMax;
        int i;
        Random random = new Random(65467547L);
        for (i = 0; i < 1000; ++i) {
            possibleMax = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            values = new double[4];
            numberOfCombinations = (int)Math.pow(2.0, values.length);
            for (j = 0; j < numberOfCombinations; ++j) {
                currentByte = 0;
                isMinimumValue = j == 0;
                for (k = 0; k < values.length; ++k) {
                    values[k] = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
                    mask = (int)Math.pow(2.0, currentByte);
                    isGreater = (j & mask) != 0;
                    values[k] = possibleMax + (isGreater ? values[k] : -values[k]);
                    ++currentByte;
                }
                actualResult = EuclidShapeTools.isFirstValueMaximum((double)possibleMax, (double)values[0], (double)values[1], (double)values[2], (double)values[3]);
                Assertions.assertEquals((Object)isMinimumValue, (Object)actualResult);
            }
        }
        for (i = 0; i < 1000; ++i) {
            possibleMax = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            values = new double[3];
            numberOfCombinations = (int)Math.pow(2.0, values.length);
            for (j = 0; j < numberOfCombinations; ++j) {
                currentByte = 0;
                isMinimumValue = j == 0;
                for (k = 0; k < values.length; ++k) {
                    values[k] = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
                    mask = (int)Math.pow(2.0, currentByte);
                    isGreater = (j & mask) != 0;
                    values[k] = possibleMax + (isGreater ? values[k] : -values[k]);
                    ++currentByte;
                }
                actualResult = EuclidShapeTools.isFirstValueMaximum((double)possibleMax, (double)values[0], (double)values[1], (double)values[2]);
                Assertions.assertEquals((Object)isMinimumValue, (Object)actualResult);
            }
        }
        for (i = 0; i < 1000; ++i) {
            possibleMax = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            values = new double[2];
            numberOfCombinations = (int)Math.pow(2.0, values.length);
            for (j = 0; j < numberOfCombinations; ++j) {
                currentByte = 0;
                isMinimumValue = j == 0;
                for (k = 0; k < values.length; ++k) {
                    values[k] = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
                    mask = (int)Math.pow(2.0, currentByte);
                    isGreater = (j & mask) != 0;
                    values[k] = possibleMax + (isGreater ? values[k] : -values[k]);
                    ++currentByte;
                }
                actualResult = EuclidShapeTools.isFirstValueMaximum((double)possibleMax, (double)values[0], (double)values[1]);
                Assertions.assertEquals((Object)isMinimumValue, (Object)actualResult);
            }
        }
    }

    @Test
    public void testGeometricallyEduals() {
        Point3D pointB;
        Point3D pointA;
        Vector3D tangent;
        Vector3D deNormalizedNormal;
        Vector3D normal;
        double tangentialEpsilon;
        double normalEpsilon;
        int i;
        Random random = new Random(5474L);
        for (i = 0; i < 1000; ++i) {
            normalEpsilon = random.nextDouble();
            tangentialEpsilon = Double.POSITIVE_INFINITY;
            normal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            deNormalizedNormal = new Vector3D();
            deNormalizedNormal.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0), (Tuple3DReadOnly)normal);
            tangent = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true);
            pointA = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            pointB = new Point3D();
            pointB.scaleAdd(random.nextDouble() * normalEpsilon, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointA);
            pointB.scaleAdd(random.nextDouble() * 100.0, (Tuple3DReadOnly)tangent, (Tuple3DReadOnly)pointB);
            Assertions.assertTrue((boolean)EuclidShapeTools.geometricallyEquals((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Vector3DReadOnly)deNormalizedNormal, (double)normalEpsilon, (double)tangentialEpsilon), (String)("Iteration " + i));
            pointB.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * normalEpsilon, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointA);
            pointB.scaleAdd(random.nextDouble() * 100.0, (Tuple3DReadOnly)tangent, (Tuple3DReadOnly)pointB);
            Assertions.assertFalse((boolean)EuclidShapeTools.geometricallyEquals((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Vector3DReadOnly)deNormalizedNormal, (double)normalEpsilon, (double)tangentialEpsilon), (String)("Iteration " + i));
        }
        for (i = 0; i < 1000; ++i) {
            normalEpsilon = Double.POSITIVE_INFINITY;
            tangentialEpsilon = random.nextDouble();
            normal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            deNormalizedNormal = new Vector3D();
            deNormalizedNormal.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0), (Tuple3DReadOnly)normal);
            tangent = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true);
            pointA = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            pointB = new Point3D();
            pointB.scaleAdd(random.nextDouble() * 100.0, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointA);
            pointB.scaleAdd(random.nextDouble() * tangentialEpsilon, (Tuple3DReadOnly)tangent, (Tuple3DReadOnly)pointB);
            Assertions.assertTrue((boolean)EuclidShapeTools.geometricallyEquals((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Vector3DReadOnly)deNormalizedNormal, (double)normalEpsilon, (double)tangentialEpsilon), (String)("Iteration " + i));
            pointB.scaleAdd(random.nextDouble() * 100.0, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointA);
            pointB.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * tangentialEpsilon, (Tuple3DReadOnly)tangent, (Tuple3DReadOnly)pointB);
            Assertions.assertFalse((boolean)EuclidShapeTools.geometricallyEquals((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Vector3DReadOnly)deNormalizedNormal, (double)normalEpsilon, (double)tangentialEpsilon), (String)("Iteration " + i));
        }
        for (i = 0; i < 1000; ++i) {
            normalEpsilon = random.nextDouble();
            tangentialEpsilon = random.nextDouble();
            normal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            deNormalizedNormal = new Vector3D();
            deNormalizedNormal.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0), (Tuple3DReadOnly)normal);
            tangent = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true);
            pointA = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            pointB = new Point3D();
            pointB.scaleAdd(random.nextDouble() * normalEpsilon, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointA);
            pointB.scaleAdd(random.nextDouble() * tangentialEpsilon, (Tuple3DReadOnly)tangent, (Tuple3DReadOnly)pointB);
            Assertions.assertTrue((boolean)EuclidShapeTools.geometricallyEquals((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Vector3DReadOnly)deNormalizedNormal, (double)normalEpsilon, (double)tangentialEpsilon), (String)("Iteration " + i));
            pointB.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * normalEpsilon, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointA);
            pointB.scaleAdd(random.nextDouble() * tangentialEpsilon, (Tuple3DReadOnly)tangent, (Tuple3DReadOnly)pointB);
            Assertions.assertFalse((boolean)EuclidShapeTools.geometricallyEquals((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Vector3DReadOnly)deNormalizedNormal, (double)normalEpsilon, (double)tangentialEpsilon), (String)("Iteration " + i));
            pointB.scaleAdd(random.nextDouble() * normalEpsilon, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointA);
            pointB.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * tangentialEpsilon, (Tuple3DReadOnly)tangent, (Tuple3DReadOnly)pointB);
            Assertions.assertFalse((boolean)EuclidShapeTools.geometricallyEquals((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Vector3DReadOnly)deNormalizedNormal, (double)normalEpsilon, (double)tangentialEpsilon), (String)("Iteration " + i));
            pointB.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * normalEpsilon, (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointA);
            pointB.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * tangentialEpsilon, (Tuple3DReadOnly)tangent, (Tuple3DReadOnly)pointB);
            Assertions.assertFalse((boolean)EuclidShapeTools.geometricallyEquals((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Vector3DReadOnly)deNormalizedNormal, (double)normalEpsilon, (double)tangentialEpsilon), (String)("Iteration " + i));
        }
    }
}

