/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.Torus3D;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Torus3DTest {
    private static final double EPSILON = 1.0E-9;

    @Test
    void testConstructors() throws Exception {
        double tubeRadius;
        double radius;
        int i;
        Random random = new Random(34563L);
        Torus3D torus3D = new Torus3D();
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)torus3D.getPosition());
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)Axis3D.Z, (Tuple3DReadOnly)torus3D.getAxis(), (double)1.0E-9);
        Assertions.assertEquals((double)1.0, (double)torus3D.getRadius());
        Assertions.assertEquals((double)0.1, (double)torus3D.getTubeRadius());
        for (i = 0; i < 1000; ++i) {
            radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            tubeRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Torus3D torus3D2 = new Torus3D(radius, tubeRadius);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)torus3D2.getPosition());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)Axis3D.Z, (Tuple3DReadOnly)torus3D2.getAxis(), (double)1.0E-9);
            Assertions.assertEquals((double)radius, (double)torus3D2.getRadius());
            Assertions.assertEquals((double)tubeRadius, (double)torus3D2.getTubeRadius());
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Torus3D(-0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Torus3D(1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            tubeRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D axis = EuclidCoreRandomTools.nextVector3D((Random)random);
            Torus3D torus3D3 = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
            axis.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)position, (Tuple3DReadOnly)torus3D3.getPosition(), (double)1.0E-9);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)axis, (Tuple3DReadOnly)torus3D3.getAxis(), (double)1.0E-9);
            Assertions.assertEquals((double)radius, (double)torus3D3.getRadius());
            Assertions.assertEquals((double)tubeRadius, (double)torus3D3.getTubeRadius());
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Torus3D((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Torus3D((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            Torus3D original = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Torus3D copy = new Torus3D((Torus3DReadOnly)original);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)original, (Torus3DReadOnly)copy, (double)1.0E-9);
        }
    }

    @Test
    void testSetToNaN() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Torus3D torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Assertions.assertFalse((boolean)torus3D.containsNaN());
            Assertions.assertFalse((boolean)torus3D.getPosition().containsNaN());
            Assertions.assertFalse((boolean)torus3D.getAxis().containsNaN());
            Assertions.assertFalse((boolean)Double.isNaN(torus3D.getRadius()));
            Assertions.assertFalse((boolean)Double.isNaN(torus3D.getTubeRadius()));
            torus3D.setToNaN();
            Assertions.assertTrue((boolean)torus3D.containsNaN());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)torus3D.getPosition());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)torus3D.getAxis());
            Assertions.assertTrue((boolean)Double.isNaN(torus3D.getRadius()));
            Assertions.assertTrue((boolean)Double.isNaN(torus3D.getTubeRadius()));
        }
    }

    @Test
    void testSetToZero() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Torus3D torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((Tuple3DReadOnly)torus3D.getPosition(), 1.0E-9));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((Tuple3DReadOnly)torus3D.getAxis(), 1.0E-9));
            Assertions.assertNotEquals((double)0.0, (double)torus3D.getRadius());
            Assertions.assertNotEquals((double)0.0, (double)torus3D.getTubeRadius());
            torus3D.setToZero();
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)torus3D.getPosition());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)Axis3D.Z, (Tuple3DReadOnly)torus3D.getAxis(), (double)1.0E-9);
            Assertions.assertEquals((double)0.0, (double)torus3D.getRadius());
            Assertions.assertEquals((double)0.0, (double)torus3D.getTubeRadius());
        }
    }

    @Test
    void testSetters() throws Exception {
        Torus3D actual;
        Torus3D expected;
        int i;
        Random random = new Random(5467457L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextTorus3D((Random)random);
            actual = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-9));
            actual.set(expected);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)expected, (Torus3DReadOnly)actual, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextTorus3D((Random)random);
            actual = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-9));
            actual.set((Torus3DReadOnly)expected);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)expected, (Torus3DReadOnly)actual, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextTorus3D((Random)random);
            actual = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-9));
            actual.set((Point3DReadOnly)expected.getPosition(), (Vector3DReadOnly)expected.getAxis(), expected.getRadius(), expected.getTubeRadius());
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)expected, (Torus3DReadOnly)actual, (double)1.0E-9);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Torus3D().set((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Torus3D().set((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, 1.0, -0.1));
    }

    @Test
    void testSetRadii() throws Exception {
        Random random = new Random(43905783L);
        for (int i = 0; i < 1000; ++i) {
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double tubeRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            Torus3D torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Assertions.assertNotEquals((double)radius, (double)torus3D.getRadius());
            Assertions.assertNotEquals((double)tubeRadius, (double)torus3D.getTubeRadius());
            torus3D.setRadii(radius, tubeRadius);
            Assertions.assertEquals((double)radius, (double)torus3D.getRadius());
            Assertions.assertEquals((double)tubeRadius, (double)torus3D.getTubeRadius());
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Torus3D().setRadii(-0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Torus3D().setRadii(1.0, -0.1));
    }

    @Test
    void testIsPointInside() throws Exception {
        double distanceFromTubeAxis;
        Vector3D orthogonalToTubeAxis;
        Vector3D tubeAxis;
        Point3D pointOnTubeCenter;
        Vector3D orthogonalToAxis;
        Torus3D torus3D;
        int i;
        Random random = new Random(17970997L);
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = random.nextDouble() * torus3D.getTubeRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            Assertions.assertTrue((boolean)torus3D.isPointInside((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)torus3D.getTubeRadius(), (double)torus3D.getRadius());
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            Assertions.assertFalse((boolean)torus3D.isPointInside((Point3DReadOnly)pointOutside));
        }
    }

    @Test
    void testEvaluatePoint3DCollision() throws Exception {
        double distanceFromTubeAxis;
        Vector3D orthogonalToTubeAxis;
        Vector3D tubeAxis;
        Point3D pointOnTubeCenter;
        Vector3D orthogonalToAxis;
        Torus3D torus3D;
        int i;
        Random random = new Random(16980501L);
        Point3D actualClosestPoint = new Point3D();
        Vector3D actualNormal = new Vector3D();
        Point3D expectedClosestPoint = new Point3D();
        Vector3D expectedNormal = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Point3D pointOnAxis = new Point3D();
            pointOnAxis.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)torus3D.getAxis(), (Tuple3DReadOnly)torus3D.getPosition());
            Assertions.assertFalse((boolean)torus3D.evaluatePoint3DCollision((Point3DReadOnly)pointOnAxis, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            Assertions.assertFalse((boolean)actualClosestPoint.containsNaN());
            Assertions.assertFalse((boolean)actualNormal.containsNaN());
            torus3D.evaluatePoint3DCollision((Point3DReadOnly)actualClosestPoint, (Point3DBasics)expectedClosestPoint, (Vector3DBasics)expectedNormal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-9);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            Assertions.assertTrue((boolean)torus3D.evaluatePoint3DCollision((Point3DReadOnly)pointOnTubeCenter, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            Assertions.assertFalse((boolean)actualClosestPoint.containsNaN());
            Assertions.assertFalse((boolean)actualNormal.containsNaN());
            torus3D.evaluatePoint3DCollision((Point3DReadOnly)actualClosestPoint, (Point3DBasics)expectedClosestPoint, (Vector3DBasics)expectedNormal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-9);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = random.nextDouble() * torus3D.getTubeRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            expectedClosestPoint.scaleAdd(torus3D.getTubeRadius(), (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            expectedNormal.set(orthogonalToTubeAxis);
            Assertions.assertTrue((boolean)torus3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-9);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)torus3D.getTubeRadius(), (double)torus3D.getRadius());
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            expectedClosestPoint.scaleAdd(torus3D.getTubeRadius(), (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            expectedNormal.set(orthogonalToTubeAxis);
            Assertions.assertFalse((boolean)torus3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-9);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-9);
        }
    }

    @Test
    void testApplyTransform() {
        RigidBodyTransform transform;
        Torus3D expected;
        Torus3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextTorus3D((Random)random);
            expected = new Torus3D((Torus3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPosition().applyTransform((Transform)transform);
            expected.getAxis().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)expected, (Torus3DReadOnly)actual, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextTorus3D((Random)random);
            expected = new Torus3D((Torus3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPosition().applyTransform((Transform)transform);
            expected.getAxis().applyTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)expected, (Torus3DReadOnly)actual, (double)1.0E-9);
        }
    }

    @Test
    void testApplyInverseTransform() {
        RigidBodyTransform transform;
        Torus3D expected;
        Torus3D original;
        Torus3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextTorus3D((Random)random);
            original = new Torus3D((Torus3DReadOnly)actual);
            expected = new Torus3D((Torus3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPosition().applyInverseTransform((Transform)transform);
            expected.getAxis().applyInverseTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyInverseTransform((Transform)transform);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)expected, (Torus3DReadOnly)actual, (double)1.0E-9);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)original, (Torus3DReadOnly)actual, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextTorus3D((Random)random);
            original = new Torus3D((Torus3DReadOnly)actual);
            expected = new Torus3D((Torus3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPosition().applyInverseTransform((Transform)transform);
            expected.getAxis().applyInverseTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyInverseTransform((Transform)transform);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)expected, (Torus3DReadOnly)actual, (double)1.0E-9);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertTorus3DEquals((Torus3DReadOnly)original, (Torus3DReadOnly)actual, (double)1.0E-9);
        }
    }

    @Test
    void testDistance() throws Exception {
        double distanceFromTubeAxis;
        Vector3D orthogonalToTubeAxis;
        Vector3D tubeAxis;
        Point3D pointOnTubeCenter;
        Vector3D orthogonalToAxis;
        Torus3D torus3D;
        int i;
        Random random = new Random(20478904L);
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = random.nextDouble() * torus3D.getTubeRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            Assertions.assertEquals((double)0.0, (double)torus3D.distance((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)torus3D.getTubeRadius(), (double)torus3D.getRadius());
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            Assertions.assertEquals((double)(distanceFromTubeAxis - torus3D.getTubeRadius()), (double)torus3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-9);
        }
    }

    @Test
    void testSignedDistance() throws Exception {
        double distanceFromTubeAxis;
        Vector3D orthogonalToTubeAxis;
        Vector3D tubeAxis;
        Point3D pointOnTubeCenter;
        Vector3D orthogonalToAxis;
        Torus3D torus3D;
        int i;
        Random random = new Random(20478904L);
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = random.nextDouble() * torus3D.getTubeRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            Assertions.assertEquals((double)(distanceFromTubeAxis - torus3D.getTubeRadius()), (double)torus3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)torus3D.getTubeRadius(), (double)torus3D.getRadius());
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            Assertions.assertEquals((double)(distanceFromTubeAxis - torus3D.getTubeRadius()), (double)torus3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-9);
        }
    }

    @Test
    void testOrthogonalProjection() throws Exception {
        double distanceFromTubeAxis;
        Vector3D orthogonalToTubeAxis;
        Vector3D tubeAxis;
        Point3D pointOnTubeCenter;
        Vector3D orthogonalToAxis;
        Torus3D torus3D;
        int i;
        Random random = new Random(9387125L);
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Point3D pointOnAxis = new Point3D();
            pointOnAxis.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)torus3D.getAxis(), (Tuple3DReadOnly)torus3D.getPosition());
            Point3DBasics actualProjection = torus3D.orthogonalProjectionCopy((Point3DReadOnly)pointOnAxis);
            Assertions.assertFalse((boolean)actualProjection.containsNaN());
            Point3D expectedProjection = new Point3D();
            torus3D.evaluatePoint3DCollision((Point3DReadOnly)actualProjection, (Point3DBasics)expectedProjection, (Vector3DBasics)new Vector3D());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)actualProjection, (double)1.0E-9);
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = random.nextDouble() * torus3D.getTubeRadius();
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            Assertions.assertNull((Object)torus3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)torus3D.getAxis(), (boolean)true);
            pointOnTubeCenter = new Point3D();
            pointOnTubeCenter.scaleAdd(torus3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getPosition());
            tubeAxis = new Vector3D();
            tubeAxis.cross((Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)torus3D.getAxis());
            orthogonalToTubeAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)tubeAxis, (boolean)true);
            distanceFromTubeAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)torus3D.getTubeRadius(), (double)torus3D.getRadius());
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceFromTubeAxis, (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            Point3D expectedProjection = new Point3D();
            expectedProjection.scaleAdd(torus3D.getTubeRadius(), (Tuple3DReadOnly)orthogonalToTubeAxis, (Tuple3DReadOnly)pointOnTubeCenter);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)torus3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-9);
        }
    }

    @Test
    void testGetSupportingVertex() throws Exception {
        Random random = new Random(546161L);
        Torus3D torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
        Vector3D supportDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> torus3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
    }

    @Test
    void testGetBoundingBox() throws Exception {
        Random random = new Random(36342L);
        for (int i = 0; i < 1000; ++i) {
            Torus3D torus3D = EuclidShapeRandomTools.nextTorus3D((Random)random);
            Cylinder3D cylinder3D = new Cylinder3D((Point3DReadOnly)torus3D.getPosition(), (Vector3DReadOnly)torus3D.getAxis(), torus3D.getTubeRadius(), torus3D.getRadius() + torus3D.getTubeRadius());
            BoundingBox3DReadOnly expectedBoundingBox = cylinder3D.getBoundingBox();
            BoundingBox3DReadOnly actualBoundingBox = torus3D.getBoundingBox();
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expectedBoundingBox, (BoundingBox3DReadOnly)actualBoundingBox, (double)1.0E-9);
        }
    }

    @Test
    public void testGeometricallyEquals() {
        int i;
        Random random = new Random(89725L);
        double epsilon = 1.0E-7;
        double radius = 1.0 + random.nextDouble();
        double tubeRadius = random.nextDouble();
        Point3D position = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Vector3D axis = EuclidCoreRandomTools.nextVector3D((Random)random);
        Torus3D firstTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
        Torus3D secondTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
        Assertions.assertTrue((boolean)firstTorus.geometricallyEquals(secondTorus, epsilon));
        Assertions.assertTrue((boolean)secondTorus.geometricallyEquals(firstTorus, epsilon));
        Assertions.assertTrue((boolean)firstTorus.geometricallyEquals(firstTorus, epsilon));
        Assertions.assertTrue((boolean)secondTorus.geometricallyEquals(secondTorus, epsilon));
        for (i = 0; i < 1000; ++i) {
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            axis = EuclidCoreRandomTools.nextVector3D((Random)random);
            radius = 1.0 + random.nextDouble();
            tubeRadius = random.nextDouble();
            firstTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
            secondTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
            secondTorus.applyTransform((Transform)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            Assertions.assertFalse((boolean)firstTorus.geometricallyEquals(secondTorus, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            axis = EuclidCoreRandomTools.nextVector3D((Random)random);
            radius = 1.0 + random.nextDouble();
            tubeRadius = random.nextDouble();
            firstTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
            secondTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius + 0.99 * epsilon, tubeRadius);
            Assertions.assertTrue((boolean)firstTorus.geometricallyEquals(secondTorus, epsilon));
            secondTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius + 0.99 * epsilon);
            Assertions.assertTrue((boolean)firstTorus.geometricallyEquals(secondTorus, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            axis = EuclidCoreRandomTools.nextVector3D((Random)random);
            radius = 1.0 + random.nextDouble();
            tubeRadius = random.nextDouble();
            firstTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
            secondTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius + 1.01 * epsilon, tubeRadius);
            Assertions.assertFalse((boolean)firstTorus.geometricallyEquals(secondTorus, epsilon));
            secondTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius + 1.01 * epsilon);
            Assertions.assertFalse((boolean)firstTorus.geometricallyEquals(secondTorus, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            axis = EuclidCoreRandomTools.nextVector3D((Random)random);
            radius = 1.0 + random.nextDouble();
            tubeRadius = random.nextDouble();
            firstTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
            secondTorus = new Torus3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, radius, tubeRadius);
            Assertions.assertTrue((boolean)firstTorus.geometricallyEquals(secondTorus, epsilon));
            secondTorus.getAxis().negate();
            Assertions.assertTrue((boolean)firstTorus.geometricallyEquals(secondTorus, epsilon));
        }
    }
}

