/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidEllipsoid3DTools;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public class Ellipsoid3DTest {
    private static final double EPSILON = 1.0E-10;

    @Test
    void testConstructors() throws Exception {
        Ellipsoid3D ellipsoid3D;
        Pose3D pose;
        RotationMatrix orientation;
        Point3D position;
        double radiusZ;
        double radiusY;
        double radiusX;
        int i;
        Random random = new Random(45675654L);
        Ellipsoid3D ellipsoid3D2 = new Ellipsoid3D();
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(1.0, 1.0, 1.0), (Tuple3DReadOnly)ellipsoid3D2.getRadii(), (double)1.0E-10);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ellipsoid3D2.getPosition());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)ellipsoid3D2.getOrientation(), (double)1.0E-10);
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            Ellipsoid3D ellipsoid3D3 = new Ellipsoid3D(radiusX, radiusY, radiusZ);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(radiusX, radiusY, radiusZ), (Tuple3DReadOnly)ellipsoid3D3.getRadii(), (double)1.0E-10);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ellipsoid3D3.getPosition());
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)ellipsoid3D3.getOrientation(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Ellipsoid3D ellipsoid3D4 = new Ellipsoid3D((Point3DReadOnly)position, (Orientation3DReadOnly)orientation, radiusX, radiusY, radiusZ);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(radiusX, radiusY, radiusZ), (Tuple3DReadOnly)ellipsoid3D4.getRadii(), (double)1.0E-10);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)position, (Tuple3DReadOnly)ellipsoid3D4.getPosition(), (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)ellipsoid3D4.getOrientation(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            pose = new Pose3D((Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
            ellipsoid3D = new Ellipsoid3D((Pose3DReadOnly)pose, radiusX, radiusY, radiusZ);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(radiusX, radiusY, radiusZ), (Tuple3DReadOnly)ellipsoid3D.getRadii(), (double)1.0E-10);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)position, (Tuple3DReadOnly)ellipsoid3D.getPosition(), (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)ellipsoid3D.getOrientation(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            double sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            double sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            pose = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position);
            ellipsoid3D = new Ellipsoid3D((RigidBodyTransformReadOnly)pose, sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(sizeX, sizeY, sizeZ), (Tuple3DReadOnly)ellipsoid3D.getRadii(), (double)1.0E-10);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)position, (Tuple3DReadOnly)ellipsoid3D.getPosition(), (double)1.0E-10);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)ellipsoid3D.getOrientation(), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Ellipsoid3D original = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Ellipsoid3D copy = new Ellipsoid3D((Ellipsoid3DReadOnly)original);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)original, (Ellipsoid3DReadOnly)copy, (double)1.0E-10);
        }
    }

    @Test
    void testSetToNaN() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Ellipsoid3D ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)ellipsoid3D.containsNaN());
            Assertions.assertFalse((boolean)ellipsoid3D.getPose().containsNaN());
            Assertions.assertFalse((boolean)ellipsoid3D.getPosition().containsNaN());
            Assertions.assertFalse((boolean)ellipsoid3D.getOrientation().containsNaN());
            Assertions.assertFalse((boolean)ellipsoid3D.getRadii().containsNaN());
            ellipsoid3D.setToNaN();
            Assertions.assertTrue((boolean)ellipsoid3D.containsNaN());
            Assertions.assertTrue((boolean)ellipsoid3D.getPose().containsNaN());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)ellipsoid3D.getPosition());
            EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)ellipsoid3D.getOrientation());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)ellipsoid3D.getRadii());
        }
    }

    @Test
    void testSetToZero() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Ellipsoid3D ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((Tuple3DReadOnly)ellipsoid3D.getPosition(), 1.0E-10));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((Tuple3DReadOnly)ellipsoid3D.getRadii(), 1.0E-10));
            Assertions.assertFalse((boolean)new RotationMatrix().epsilonEquals((Matrix3DReadOnly)ellipsoid3D.getOrientation(), 1.0E-10));
            ellipsoid3D.setToZero();
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ellipsoid3D.getPosition());
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)ellipsoid3D.getOrientation(), (double)1.0E-10);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ellipsoid3D.getRadii());
        }
    }

    @Test
    void testSetters() throws Exception {
        Ellipsoid3D actual;
        Ellipsoid3D expected;
        int i;
        Random random = new Random(45837543L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.set(expected);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.set((Ellipsoid3DReadOnly)expected);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.set((Point3DReadOnly)expected.getPosition(), (Orientation3DReadOnly)expected.getOrientation(), expected.getRadiusX(), expected.getRadiusY(), expected.getRadiusZ());
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.set((Pose3DReadOnly)new Pose3D((Tuple3DReadOnly)expected.getPosition(), (Orientation3DReadOnly)expected.getOrientation()), expected.getRadiusX(), expected.getRadiusY(), expected.getRadiusZ());
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((Pose3DReadOnly)new Pose3D(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((Pose3DReadOnly)new Pose3D(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((Pose3DReadOnly)new Pose3D(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.set((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)expected.getOrientation(), (Tuple3DReadOnly)expected.getPosition()), expected.getRadiusX(), expected.getRadiusY(), expected.getRadiusZ());
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.set((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)expected.getOrientation(), (Tuple3DReadOnly)expected.getPosition()), new double[]{expected.getRadiusX(), expected.getRadiusY(), expected.getRadiusZ()});
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{-0.1, 1.0, 1.0}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{1.0, -0.1, 1.0}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{1.0, 1.0, -0.1}));
    }

    @Test
    void testSetRadii() throws Exception {
        Random random = new Random(0x536566L);
        for (int i = 0; i < 1000; ++i) {
            double radiusX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            double radiusY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            double radiusZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            Ellipsoid3D ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)radiusX, (double)ellipsoid3D.getRadiusX(), (double)1.0E-10));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)radiusY, (double)ellipsoid3D.getRadiusY(), (double)1.0E-10));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)radiusZ, (double)ellipsoid3D.getRadiusZ(), (double)1.0E-10));
            ellipsoid3D.getRadii().set(radiusX, radiusY, radiusZ);
            Assertions.assertEquals((double)radiusX, (double)ellipsoid3D.getRadiusX(), (double)1.0E-10);
            Assertions.assertEquals((double)radiusY, (double)ellipsoid3D.getRadiusY(), (double)1.0E-10);
            Assertions.assertEquals((double)radiusZ, (double)ellipsoid3D.getRadiusZ(), (double)1.0E-10);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().getRadii().set(-0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().getRadii().set(1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ellipsoid3D().getRadii().set(1.0, 1.0, -0.1));
    }

    @Test
    void testIsPointInside() throws Exception {
        Vector3D translation;
        double radiusInUnitSphere;
        Ellipsoid3D ellipsoid3D;
        int i;
        Random random = new Random(3656L);
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            radiusInUnitSphere = random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            translation.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            Point3D pointInside = new Point3D((Tuple3DReadOnly)translation);
            ellipsoid3D.transformToWorld((Transformable)pointInside);
            Assertions.assertTrue((boolean)ellipsoid3D.isPointInside((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            radiusInUnitSphere = 1.0 + random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            translation.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            Point3D pointOutside = new Point3D((Tuple3DReadOnly)translation);
            ellipsoid3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ellipsoid3D.isPointInside((Point3DReadOnly)pointOutside));
        }
    }

    @Test
    void testEvaluatePoint3DCollision() throws Exception {
        double rzSquare;
        double rySquare;
        double rxSquare;
        Vector3D translation;
        double radiusInUnitSphere;
        Ellipsoid3D ellipsoid3D;
        int i;
        Random random = new Random(345345L);
        Point3D actualClosestPointWorld = new Point3D();
        Point3D actualClosestPointLocal = new Point3D();
        Vector3D actualNormal = new Vector3D();
        Vector3D expectedNormal = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random, (double)0.001, (double)2.0);
            radiusInUnitSphere = random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            Point3D pointInside = new Point3D((Tuple3DReadOnly)translation);
            pointInside.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            ellipsoid3D.transformToWorld((Transformable)pointInside);
            Assertions.assertTrue((boolean)ellipsoid3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPointWorld, (Vector3DBasics)actualNormal));
            actualClosestPointLocal.set(actualClosestPointWorld);
            ellipsoid3D.transformToLocal((Transformable)actualClosestPointLocal);
            Assertions.assertEquals((double)0.0, (double)EuclidShapeTools.signedDistanceBetweenPoint3DAndEllipsoid3D((Point3DReadOnly)actualClosestPointLocal, (Vector3DReadOnly)ellipsoid3D.getRadii()), (double)1.0E-10, (String)("Iteration: " + i));
            expectedNormal.sub((Tuple3DReadOnly)actualClosestPointWorld, (Tuple3DReadOnly)pointInside);
            expectedNormal.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-10);
            expectedNormal.set((Tuple3DReadOnly)actualClosestPointLocal);
            rxSquare = ellipsoid3D.getRadiusX() * ellipsoid3D.getRadiusX();
            rySquare = ellipsoid3D.getRadiusY() * ellipsoid3D.getRadiusY();
            rzSquare = ellipsoid3D.getRadiusZ() * ellipsoid3D.getRadiusZ();
            expectedNormal.scale(1.0 / rxSquare, 1.0 / rySquare, 1.0 / rzSquare);
            expectedNormal.normalize();
            ellipsoid3D.transformToWorld((Transformable)expectedNormal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random, (double)0.001, (double)2.0);
            radiusInUnitSphere = 1.0 + random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            Point3D pointOutside = new Point3D((Tuple3DReadOnly)translation);
            pointOutside.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            ellipsoid3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ellipsoid3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPointWorld, (Vector3DBasics)actualNormal));
            actualClosestPointLocal.set(actualClosestPointWorld);
            ellipsoid3D.transformToLocal((Transformable)actualClosestPointLocal);
            Assertions.assertEquals((double)0.0, (double)EuclidShapeTools.signedDistanceBetweenPoint3DAndEllipsoid3D((Point3DReadOnly)actualClosestPointLocal, (Vector3DReadOnly)ellipsoid3D.getRadii()), (double)1.0E-10, (String)("Iteration: " + i));
            expectedNormal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)actualClosestPointWorld);
            expectedNormal.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-10);
            expectedNormal.set((Tuple3DReadOnly)actualClosestPointLocal);
            rxSquare = ellipsoid3D.getRadiusX() * ellipsoid3D.getRadiusX();
            rySquare = ellipsoid3D.getRadiusY() * ellipsoid3D.getRadiusY();
            rzSquare = ellipsoid3D.getRadiusZ() * ellipsoid3D.getRadiusZ();
            expectedNormal.scale(1.0 / rxSquare, 1.0 / rySquare, 1.0 / rzSquare);
            expectedNormal.normalize();
            ellipsoid3D.transformToWorld((Transformable)expectedNormal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random, (double)0.001, (double)2.0);
            Vector3D translation2 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D pointOnSurface = new Point3D((Tuple3DReadOnly)translation2);
            pointOnSurface.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            ellipsoid3D.transformToWorld((Transformable)pointOnSurface);
            Assertions.assertTrue((boolean)ellipsoid3D.evaluatePoint3DCollision((Point3DReadOnly)pointOnSurface, (Point3DBasics)actualClosestPointWorld, (Vector3DBasics)actualNormal));
            actualClosestPointLocal.set(actualClosestPointWorld);
            ellipsoid3D.transformToLocal((Transformable)actualClosestPointLocal);
            Assertions.assertEquals((double)0.0, (double)EuclidShapeTools.signedDistanceBetweenPoint3DAndEllipsoid3D((Point3DReadOnly)actualClosestPointLocal, (Vector3DReadOnly)ellipsoid3D.getRadii()), (double)1.0E-10, (String)("Iteration: " + i));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)pointOnSurface, (Tuple3DReadOnly)actualClosestPointWorld, (double)1.0E-10);
            expectedNormal.set((Tuple3DReadOnly)actualClosestPointLocal);
            double rxSquare2 = ellipsoid3D.getRadiusX() * ellipsoid3D.getRadiusX();
            double rySquare2 = ellipsoid3D.getRadiusY() * ellipsoid3D.getRadiusY();
            double rzSquare2 = ellipsoid3D.getRadiusZ() * ellipsoid3D.getRadiusZ();
            expectedNormal.scale(1.0 / rxSquare2, 1.0 / rySquare2, 1.0 / rzSquare2);
            expectedNormal.normalize();
            ellipsoid3D.transformToWorld((Transformable)expectedNormal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random, (double)0.001, (double)2.0);
            Point3D point = new Point3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.5));
            if (random.nextBoolean()) {
                point.setX(0.0);
            }
            if (random.nextBoolean()) {
                point.setY(0.0);
            }
            if (random.nextBoolean()) {
                point.setZ(0.0);
            }
            ellipsoid3D.transformToWorld((Transformable)point);
            ellipsoid3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)actualClosestPointWorld, (Vector3DBasics)actualNormal);
            actualClosestPointLocal.set(actualClosestPointWorld);
            ellipsoid3D.transformToLocal((Transformable)actualClosestPointLocal);
            Assertions.assertEquals((double)0.0, (double)EuclidShapeTools.signedDistanceBetweenPoint3DAndEllipsoid3D((Point3DReadOnly)actualClosestPointLocal, (Vector3DReadOnly)ellipsoid3D.getRadii()), (double)1.0E-10, (String)("Iteration: " + i));
            expectedNormal.set((Tuple3DReadOnly)actualClosestPointLocal);
            double rxSquare3 = ellipsoid3D.getRadiusX() * ellipsoid3D.getRadiusX();
            double rySquare3 = ellipsoid3D.getRadiusY() * ellipsoid3D.getRadiusY();
            double rzSquare3 = ellipsoid3D.getRadiusZ() * ellipsoid3D.getRadiusZ();
            expectedNormal.scale(1.0 / rxSquare3, 1.0 / rySquare3, 1.0 / rzSquare3);
            expectedNormal.normalize();
            ellipsoid3D.transformToWorld((Transformable)expectedNormal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-10);
        }
    }

    @Test
    void testApplyTransform() {
        RigidBodyTransform transform;
        Ellipsoid3D expected;
        Ellipsoid3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            expected = new Ellipsoid3D((Ellipsoid3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPose().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            expected = new Ellipsoid3D((Ellipsoid3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPose().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    void testApplyInverseTransform() {
        RigidBodyTransform transform;
        Ellipsoid3D expected;
        Ellipsoid3D original;
        Ellipsoid3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            original = new Ellipsoid3D((Ellipsoid3DReadOnly)actual);
            expected = new Ellipsoid3D((Ellipsoid3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPose().applyInverseTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)original, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            original = new Ellipsoid3D((Ellipsoid3DReadOnly)actual);
            expected = new Ellipsoid3D((Ellipsoid3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPose().applyInverseTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)expected, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertEllipsoid3DEquals((Ellipsoid3DReadOnly)original, (Ellipsoid3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    void testDistance() throws Exception {
        Vector3D translation;
        double radiusInUnitSphere;
        Ellipsoid3D ellipsoid3D;
        int i;
        Random random = new Random(2147385L);
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            radiusInUnitSphere = random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            Point3D pointInside = new Point3D((Tuple3DReadOnly)translation);
            pointInside.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            ellipsoid3D.transformToWorld((Transformable)pointInside);
            Assertions.assertEquals((double)0.0, (double)ellipsoid3D.distance((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            radiusInUnitSphere = 1.0 + random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            Point3D pointOutsideLocal = new Point3D((Tuple3DReadOnly)translation);
            pointOutsideLocal.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            Point3D pointOutsideWorld = new Point3D((Tuple3DReadOnly)pointOutsideLocal);
            ellipsoid3D.transformToWorld((Transformable)pointOutsideWorld);
            double expectedDistance = Math.max(0.0, EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D((Vector3DReadOnly)ellipsoid3D.getRadii(), (Point3DReadOnly)pointOutsideLocal));
            Assertions.assertEquals((double)expectedDistance, (double)ellipsoid3D.distance((Point3DReadOnly)pointOutsideWorld), (double)1.0E-10, (String)("Iteration: " + i));
        }
    }

    @Test
    void testSignedDistance() throws Exception {
        double expectedDistance;
        Vector3D translation;
        double radiusInUnitSphere;
        Ellipsoid3D ellipsoid3D;
        int i;
        Random random = new Random(2147385L);
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            radiusInUnitSphere = random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            Point3D pointInsideLocal = new Point3D((Tuple3DReadOnly)translation);
            pointInsideLocal.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            Point3D pointInsideWorld = new Point3D((Tuple3DReadOnly)pointInsideLocal);
            ellipsoid3D.transformToWorld((Transformable)pointInsideWorld);
            expectedDistance = EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D((Vector3DReadOnly)ellipsoid3D.getRadii(), (Point3DReadOnly)pointInsideLocal);
            Assertions.assertEquals((double)expectedDistance, (double)ellipsoid3D.signedDistance((Point3DReadOnly)pointInsideWorld), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            radiusInUnitSphere = 1.0 + random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            Point3D pointOutsideLocal = new Point3D((Tuple3DReadOnly)translation);
            pointOutsideLocal.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            Point3D pointOutsideWorld = new Point3D((Tuple3DReadOnly)pointOutsideLocal);
            ellipsoid3D.transformToWorld((Transformable)pointOutsideWorld);
            expectedDistance = EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D((Vector3DReadOnly)ellipsoid3D.getRadii(), (Point3DReadOnly)pointOutsideLocal);
            Assertions.assertEquals((double)expectedDistance, (double)ellipsoid3D.signedDistance((Point3DReadOnly)pointOutsideWorld), (double)1.0E-10);
        }
    }

    @Test
    void testOrthogonalProjection() throws Exception {
        Vector3D translation;
        double radiusInUnitSphere;
        Ellipsoid3D ellipsoid3D;
        int i;
        Random random = new Random(4157885L);
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            radiusInUnitSphere = random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            Point3D pointInside = new Point3D((Tuple3DReadOnly)translation);
            pointInside.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            ellipsoid3D.transformToWorld((Transformable)pointInside);
            Assertions.assertNull((Object)ellipsoid3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            radiusInUnitSphere = 1.0 + random.nextDouble();
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)radiusInUnitSphere);
            Point3D pointOutside = new Point3D((Tuple3DReadOnly)translation);
            pointOutside.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            ellipsoid3D.transformToWorld((Transformable)pointOutside);
            Point3D expectedProjection = new Point3D();
            ellipsoid3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)expectedProjection, (Vector3DBasics)new Vector3D());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)ellipsoid3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-10);
        }
    }

    @Test
    void testIntersectionWith() throws Exception {
        Ellipsoid3D ellipsoid3D;
        int i;
        Random random = new Random(10688467L);
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Point3D expectedIntersection1 = new Point3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0));
            expectedIntersection1.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            Point3D expectedIntersection2 = new Point3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0));
            expectedIntersection2.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            ellipsoid3D.transformToWorld((Transformable)expectedIntersection1);
            ellipsoid3D.transformToWorld((Transformable)expectedIntersection2);
            Line3D line = new Line3D((Point3DReadOnly)expectedIntersection1, (Point3DReadOnly)expectedIntersection2);
            line.getPoint().scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)line.getDirection(), (Tuple3DReadOnly)line.getPoint());
            Point3D actualIntersection1 = new Point3D();
            Point3D actualIntersection2 = new Point3D();
            Assertions.assertEquals((int)2, (int)ellipsoid3D.intersectionWith((Line3DReadOnly)line, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedIntersection1, (Tuple3DReadOnly)actualIntersection1, (double)1.0E-10);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedIntersection2, (Tuple3DReadOnly)actualIntersection2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Vector3D direction = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Point3D pointOnEllipsoid = new Point3D((Tuple3DReadOnly)direction);
            Vector3D normal = new Vector3D((Tuple3DReadOnly)direction);
            pointOnEllipsoid.scale(ellipsoid3D.getRadiusX(), ellipsoid3D.getRadiusY(), ellipsoid3D.getRadiusZ());
            normal.scale(1.0 / ellipsoid3D.getRadiusX(), 1.0 / ellipsoid3D.getRadiusY(), 1.0 / ellipsoid3D.getRadiusZ());
            normal.normalize();
            Vector3D lineDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true);
            Point3D pointOnLine = new Point3D();
            pointOnLine.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)normal, (Tuple3DReadOnly)pointOnEllipsoid);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random), (Tuple3DReadOnly)lineDirection, (Tuple3DReadOnly)pointOnLine);
            Line3D line = new Line3D((Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
            ellipsoid3D.transformToWorld((Transformable)line);
            Assertions.assertEquals((int)0, (int)ellipsoid3D.intersectionWith((Line3DReadOnly)line, null, null));
        }
    }

    @Test
    public void testGeometricallyEquals() {
        Ellipsoid3D ellipsoid1;
        AxisAngle axisAngle;
        Ellipsoid3D ellipsoid2;
        double radiusY1;
        double radiusX1;
        RigidBodyTransform pose;
        Ellipsoid3D secondEllipsoid;
        double radiusZ;
        double radiusY;
        double radiusX;
        int i;
        Random random = new Random(89725L);
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            radiusX = random.nextDouble();
            radiusY = random.nextDouble();
            radiusZ = random.nextDouble();
            Ellipsoid3D firstEllipsoid = new Ellipsoid3D(radiusX, radiusY, radiusZ);
            secondEllipsoid = new Ellipsoid3D(radiusX, radiusY, radiusZ);
            Assertions.assertTrue((boolean)firstEllipsoid.geometricallyEquals(secondEllipsoid, 1.0E-10), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)secondEllipsoid.geometricallyEquals(firstEllipsoid, 1.0E-10), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)firstEllipsoid.geometricallyEquals(firstEllipsoid, 1.0E-10), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)secondEllipsoid.geometricallyEquals(secondEllipsoid, 1.0E-10), (String)("Iteration: " + i));
            firstEllipsoid = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radiusX, radiusY, radiusZ);
            secondEllipsoid = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radiusX, radiusY, radiusZ);
            Assertions.assertTrue((boolean)firstEllipsoid.geometricallyEquals(secondEllipsoid, 1.0E-10), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)secondEllipsoid.geometricallyEquals(firstEllipsoid, 1.0E-10), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)firstEllipsoid.geometricallyEquals(firstEllipsoid, 1.0E-10), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)secondEllipsoid.geometricallyEquals(secondEllipsoid, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.1);
            pose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            radiusX1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            radiusY1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(radiusX1 + 2.0 * epsilon), (double)(radiusX1 + 1.0));
            double radiusZ1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(radiusY1 + 2.0 * epsilon), (double)(radiusY1 + 1.0));
            double radiusX2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double radiusY2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(radiusX2 + 2.0 * epsilon), (double)(radiusX2 + 1.0));
            double radiusZ2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(radiusY2 + 2.0 * epsilon), (double)(radiusY2 + 1.0));
            Vector3D radii1 = new Vector3D(radiusX1, radiusY1, radiusZ1);
            Vector3D radii2 = new Vector3D(radiusX2, radiusY2, radiusZ2);
            Ellipsoid3D ellipsoid12 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose, radiusX1, radiusY1, radiusZ1);
            Ellipsoid3D ellipsoid22 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose, radiusX2, radiusY2, radiusZ2);
            Assertions.assertTrue((ellipsoid12.geometricallyEquals(ellipsoid22, 1.0E-10) == radii1.geometricallyEquals(radii2, 1.0E-10) ? 1 : 0) != 0, (String)("Iteration: " + i));
            Assertions.assertTrue((ellipsoid12.geometricallyEquals(ellipsoid22, epsilon) == radii1.geometricallyEquals(radii2, epsilon) ? 1 : 0) != 0, (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.1);
            pose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            radiusX1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(2.0 * epsilon), (double)10.0);
            radiusY1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(radiusX1 + 2.0 * epsilon), (double)(radiusX1 + 1.0));
            double radiusZ1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)(radiusY1 + 2.0 * epsilon), (double)(radiusY1 + 1.0));
            Vector3D radii1 = new Vector3D(radiusX1, radiusY1, radiusZ1);
            Ellipsoid3D ellipsoid13 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose, radii1.getX(), radii1.getY(), radii1.getZ());
            Vector3D radii2 = new Vector3D();
            radii2.add((Tuple3DReadOnly)radii1, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon)));
            Ellipsoid3D ellipsoid23 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose, radii2.getX(), radii2.getY(), radii2.getZ());
            Assertions.assertTrue((ellipsoid13.geometricallyEquals(ellipsoid23, epsilon) == radii1.geometricallyEquals(radii2, epsilon) ? 1 : 0) != 0, (String)("Iteration: " + i));
            radii2.add((Tuple3DReadOnly)radii1, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon)));
            ellipsoid23 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose, radii2.getX(), radii2.getY(), radii2.getZ());
            Assertions.assertTrue((ellipsoid13.geometricallyEquals(ellipsoid23, epsilon) == radii1.geometricallyEquals(radii2, epsilon) ? 1 : 0) != 0, (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusX2 = random.nextDouble();
            double radiusY2 = random.nextDouble();
            double radiusZ2 = random.nextDouble();
            Ellipsoid3D firstEllipsoid = new Ellipsoid3D(radiusX2, radiusY2, radiusZ2);
            Ellipsoid3D secondEllipsoid2 = new Ellipsoid3D(radiusX2, radiusY2, radiusZ2);
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)9.900000000000001E-11);
            secondEllipsoid2.getPose().appendTranslation((Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)firstEllipsoid.geometricallyEquals(secondEllipsoid2, 1.0E-10), (String)("Iteration: " + i));
            secondEllipsoid2 = new Ellipsoid3D(radiusX2, radiusY2, radiusZ2);
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.01E-10);
            secondEllipsoid2.getPose().appendTranslation((Tuple3DReadOnly)translation);
            Assertions.assertFalse((boolean)firstEllipsoid.geometricallyEquals(secondEllipsoid2, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose3 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            radiusX = random.nextDouble();
            radiusY = random.nextDouble();
            radiusZ = random.nextDouble();
            Ellipsoid3D firstEllipsoid = new Ellipsoid3D((RigidBodyTransformReadOnly)pose3, radiusX, radiusY, radiusZ);
            secondEllipsoid = new Ellipsoid3D((RigidBodyTransformReadOnly)pose3, radiusX, radiusY, radiusZ);
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)9.900000000000001E-11);
            secondEllipsoid.getPose().appendTranslation((Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)firstEllipsoid.geometricallyEquals(secondEllipsoid, 1.0E-10), (String)("Iteration: " + i));
            secondEllipsoid = new Ellipsoid3D((RigidBodyTransformReadOnly)pose3, radiusX, radiusY, radiusZ);
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.01E-10);
            secondEllipsoid.getPose().appendTranslation((Tuple3DReadOnly)translation);
            Assertions.assertFalse((boolean)firstEllipsoid.geometricallyEquals(secondEllipsoid, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radius = random.nextDouble();
            Point3D position = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            RigidBodyTransform pose1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), (Tuple3DReadOnly)position);
            RigidBodyTransform pose2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), (Tuple3DReadOnly)position);
            Ellipsoid3D ellipsoid14 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose1, radius, radius, radius);
            ellipsoid2 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radius, radius, radius);
            Assertions.assertTrue((boolean)ellipsoid14.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid2.getRadii().set(radius + 9.900000000000001E-11, radius + 9.900000000000001E-11, radius + 9.900000000000001E-11);
            Assertions.assertTrue((boolean)ellipsoid14.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid2.getRadii().set(radius + 1.19E-10, radius + 9.900000000000001E-11, radius + 7.900000000000001E-11);
            Assertions.assertTrue((boolean)ellipsoid14.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid2.getRadii().set(radius + 9.900000000000001E-11, radius + 1.19E-10, radius + 7.900000000000001E-11);
            Assertions.assertTrue((boolean)ellipsoid14.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid2.getRadii().set(radius + 1.01E-10, radius + 1.01E-10, radius + 1.01E-10);
            Assertions.assertFalse((boolean)ellipsoid14.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid2.getRadii().set(radius + 1.1100000000000002E-10, radius + 1.01E-10, radius + 9.100000000000001E-11);
            Assertions.assertFalse((boolean)ellipsoid14.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radius = random.nextDouble();
            Point3D position = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            RigidBodyTransform pose1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), (Tuple3DReadOnly)position);
            RigidBodyTransform pose2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random), (Tuple3DReadOnly)position);
            Ellipsoid3D ellipsoid15 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose1, radius, radius, radius);
            Vector3D radii = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            radii.absolute();
            double average = (radii.getX() + radii.getY() + radii.getZ()) / 3.0;
            radii.scale(average / radii.length());
            Ellipsoid3D ellipsoid24 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radii.getX(), radii.getY(), radii.getZ());
            Assertions.assertFalse((boolean)ellipsoid15.geometricallyEquals(ellipsoid24, 1.0E-10), (String)("Iteration: " + i));
            radii = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            radii.setX(radii.getY());
            radii.absolute();
            average = (radii.getX() + radii.getY() + radii.getZ()) / 3.0;
            radii.scale(average / radii.length());
            ellipsoid24 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radii.getX(), radii.getY(), radii.getZ());
            Assertions.assertFalse((boolean)ellipsoid15.geometricallyEquals(ellipsoid24, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusXY = random.nextDouble();
            double radiusZ3 = random.nextDouble();
            RigidBodyTransform pose4 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid16 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose4, radiusXY, radiusXY, radiusZ3);
            ellipsoid2 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose4, radiusXY, radiusXY, radiusZ3);
            Assertions.assertTrue((boolean)ellipsoid16.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid2.getPose().appendYawRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid16.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid2.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid16.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid2.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid16.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusXZ = random.nextDouble();
            double radiusY3 = random.nextDouble();
            RigidBodyTransform pose5 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid17 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose5, radiusXZ, radiusY3, radiusXZ);
            ellipsoid2 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose5, radiusXZ, radiusY3, radiusXZ);
            Assertions.assertTrue((boolean)ellipsoid17.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid2.getPose().appendPitchRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid17.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid2.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid17.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid2.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid17.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusX3 = random.nextDouble();
            double radiusYZ = random.nextDouble();
            RigidBodyTransform pose6 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid18 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose6, radiusX3, radiusYZ, radiusYZ);
            ellipsoid2 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose6, radiusX3, radiusYZ, radiusYZ);
            Assertions.assertTrue((boolean)ellipsoid18.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid2.getPose().appendRollRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid18.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(1.0, 0.0, 0.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid2.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid18.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid2.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid18.geometricallyEquals(ellipsoid2, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose7 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            radiusX = random.nextDouble();
            double radiusY4 = random.nextDouble();
            double radiusZ4 = random.nextDouble();
            Ellipsoid3D ellipsoid19 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose7, radiusX, radiusY4, radiusZ4);
            Ellipsoid3D ellipsoid25 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose7, radiusX, radiusY4, radiusZ4);
            int axis = random.nextInt(3);
            switch (axis) {
                case 0: {
                    ellipsoid25.getPose().appendRollRotation(Math.PI);
                    break;
                }
                case 1: {
                    ellipsoid25.getPose().appendPitchRotation(Math.PI);
                    break;
                }
                case 2: {
                    ellipsoid25.getPose().appendYawRotation(Math.PI);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected axis value: " + axis);
                }
            }
            Assertions.assertTrue((boolean)ellipsoid19.geometricallyEquals(ellipsoid25, 1.0E-10), (String)("Iteration: " + i));
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.5707963267948966);
            switch (axis) {
                case 0: {
                    ellipsoid25.getPose().appendRollRotation(angle);
                    break;
                }
                case 1: {
                    ellipsoid25.getPose().appendPitchRotation(angle);
                    break;
                }
                case 2: {
                    ellipsoid25.getPose().appendYawRotation(angle);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected axis value: " + axis);
                }
            }
            Assertions.assertFalse((boolean)ellipsoid19.geometricallyEquals(ellipsoid25, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendYawRotation(1.5707963267948966);
            double radiusX4 = random.nextDouble();
            double radiusY5 = random.nextDouble();
            double heightZ = random.nextDouble();
            ellipsoid1 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose1, radiusX4, radiusY5, heightZ);
            Ellipsoid3D ellipsoid26 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radiusY5, radiusX4, heightZ);
            Assertions.assertTrue((boolean)ellipsoid1.geometricallyEquals(ellipsoid26, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendPitchRotation(1.5707963267948966);
            double radiusX5 = random.nextDouble();
            double radiusY6 = random.nextDouble();
            double radiusZ5 = random.nextDouble();
            ellipsoid1 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose1, radiusX5, radiusY6, radiusZ5);
            Ellipsoid3D ellipsoid27 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radiusZ5, radiusY6, radiusX5);
            Assertions.assertTrue((boolean)ellipsoid1.geometricallyEquals(ellipsoid27, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendRollRotation(1.5707963267948966);
            double radiusX6 = random.nextDouble();
            double radiusY7 = random.nextDouble();
            double radiusZ6 = random.nextDouble();
            ellipsoid1 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose1, radiusX6, radiusY7, radiusZ6);
            Ellipsoid3D ellipsoid28 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radiusX6, radiusZ6, radiusY7);
            Assertions.assertTrue((boolean)ellipsoid1.geometricallyEquals(ellipsoid28, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendYawRotation(1.5707963267948966);
            pose2.appendPitchRotation(1.5707963267948966);
            double radiusX7 = random.nextDouble();
            double radiusY8 = random.nextDouble();
            double radiusZ7 = random.nextDouble();
            ellipsoid1 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose1, radiusX7, radiusY8, radiusZ7);
            Ellipsoid3D ellipsoid29 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radiusZ7, radiusX7, radiusY8);
            Assertions.assertTrue((boolean)ellipsoid1.geometricallyEquals(ellipsoid29, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendYawRotation(1.5707963267948966);
            pose2.appendRollRotation(1.5707963267948966);
            double radiusX8 = random.nextDouble();
            double radiusY9 = random.nextDouble();
            double radiusZ8 = random.nextDouble();
            ellipsoid1 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose1, radiusX8, radiusY9, radiusZ8);
            Ellipsoid3D ellipsoid210 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose2, radiusY9, radiusZ8, radiusX8);
            Assertions.assertTrue((boolean)ellipsoid1.geometricallyEquals(ellipsoid210, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusXY = random.nextDouble();
            double radiusZ9 = random.nextDouble();
            RigidBodyTransform pose8 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid110 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose8, radiusXY, radiusXY, radiusZ9);
            Ellipsoid3D ellipsoid211 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose8, radiusZ9, radiusXY, radiusXY);
            ellipsoid211.getPose().appendPitchRotation(1.5707963267948966);
            Assertions.assertTrue((boolean)ellipsoid110.geometricallyEquals(ellipsoid211, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid211.getPose().appendRollRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid110.geometricallyEquals(ellipsoid211, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(1.0, 0.0, 0.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid211.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid110.geometricallyEquals(ellipsoid211, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid211.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid110.geometricallyEquals(ellipsoid211, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusXY = random.nextDouble();
            double radiusZ10 = random.nextDouble();
            RigidBodyTransform pose9 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid111 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose9, radiusXY, radiusXY, radiusZ10);
            Ellipsoid3D ellipsoid212 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose9, radiusXY, radiusZ10, radiusXY);
            ellipsoid212.getPose().appendRollRotation(1.5707963267948966);
            Assertions.assertTrue((boolean)ellipsoid111.geometricallyEquals(ellipsoid212, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid212.getPose().appendPitchRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid111.geometricallyEquals(ellipsoid212, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid212.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid111.geometricallyEquals(ellipsoid212, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid212.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid111.geometricallyEquals(ellipsoid212, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusXZ = random.nextDouble();
            double radiusY10 = random.nextDouble();
            RigidBodyTransform pose10 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid112 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose10, radiusXZ, radiusY10, radiusXZ);
            Ellipsoid3D ellipsoid213 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose10, radiusY10, radiusXZ, radiusXZ);
            ellipsoid213.getPose().appendYawRotation(1.5707963267948966);
            Assertions.assertTrue((boolean)ellipsoid112.geometricallyEquals(ellipsoid213, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid213.getPose().appendRollRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid112.geometricallyEquals(ellipsoid213, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(1.0, 0.0, 0.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid213.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid112.geometricallyEquals(ellipsoid213, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid213.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid112.geometricallyEquals(ellipsoid213, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusXZ = random.nextDouble();
            double radiusY11 = random.nextDouble();
            RigidBodyTransform pose11 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid113 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose11, radiusXZ, radiusY11, radiusXZ);
            Ellipsoid3D ellipsoid214 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose11, radiusXZ, radiusXZ, radiusY11);
            ellipsoid214.getPose().appendRollRotation(1.5707963267948966);
            Assertions.assertTrue((boolean)ellipsoid113.geometricallyEquals(ellipsoid214, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid214.getPose().appendYawRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid113.geometricallyEquals(ellipsoid214, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid214.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid113.geometricallyEquals(ellipsoid214, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid214.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid113.geometricallyEquals(ellipsoid214, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusYZ = random.nextDouble();
            double radiusX9 = random.nextDouble();
            RigidBodyTransform pose12 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid114 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose12, radiusX9, radiusYZ, radiusYZ);
            Ellipsoid3D ellipsoid215 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose12, radiusYZ, radiusX9, radiusYZ);
            ellipsoid215.getPose().appendYawRotation(1.5707963267948966);
            Assertions.assertTrue((boolean)ellipsoid114.geometricallyEquals(ellipsoid215, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid215.getPose().appendPitchRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid114.geometricallyEquals(ellipsoid215, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid215.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid114.geometricallyEquals(ellipsoid215, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid215.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid114.geometricallyEquals(ellipsoid215, 1.0E-10), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double radiusYZ = random.nextDouble();
            double radiusX10 = random.nextDouble();
            RigidBodyTransform pose13 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Ellipsoid3D ellipsoid115 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose13, radiusX10, radiusYZ, radiusYZ);
            Ellipsoid3D ellipsoid216 = new Ellipsoid3D((RigidBodyTransformReadOnly)pose13, radiusYZ, radiusYZ, radiusX10);
            ellipsoid216.getPose().appendPitchRotation(1.5707963267948966);
            Assertions.assertTrue((boolean)ellipsoid115.geometricallyEquals(ellipsoid216, 1.0E-10), (String)("Iteration: " + i));
            ellipsoid216.getPose().appendYawRotation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Assertions.assertTrue((boolean)ellipsoid115.geometricallyEquals(ellipsoid216, 1.0E-10), (String)("Iteration: " + i));
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (boolean)true);
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, Math.PI);
            ellipsoid216.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)ellipsoid115.geometricallyEquals(ellipsoid216, 1.0E-10), (String)("Iteration: " + i));
            axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)3.041592653589793));
            ellipsoid216.getPose().multiply((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertFalse((boolean)ellipsoid115.geometricallyEquals(ellipsoid216, 1.0E-10), (String)("Iteration: " + i));
        }
    }

    @Test
    void testGetSupportingVertex() throws Exception {
        Random random = new Random(546161L);
        for (int i = 0; i < 1000; ++i) {
            Ellipsoid3D ellipsoid = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            Vector3D supportDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3DReadOnly supportingVertex = ellipsoid.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)ellipsoid.isPointInside(supportingVertex, 1.0E-10));
            Point3D supportingVertexTranslated = new Point3D();
            supportDirection.normalize();
            supportingVertexTranslated.scaleAdd(1.0E-6, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Assertions.assertFalse((boolean)ellipsoid.isPointInside((Point3DReadOnly)supportingVertexTranslated, 1.0E-10));
            for (int j = 0; j < 100; ++j) {
                Vector3D orthogonalToSupportDirection = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)supportDirection, (boolean)true);
                Point3D pointSupposedlyOutside = new Point3D();
                pointSupposedlyOutside.scaleAdd(1.0E-4 * ellipsoid.getRadii().length(), (Tuple3DReadOnly)orthogonalToSupportDirection, (Tuple3DReadOnly)supportingVertex);
                Assertions.assertFalse((boolean)ellipsoid.isPointInside((Point3DReadOnly)pointSupposedlyOutside, 1.0E-10));
            }
            supportingVertexTranslated.scaleAdd(1.0E-8, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Assertions.assertFalse((boolean)ellipsoid.isPointInside((Point3DReadOnly)supportingVertexTranslated, 1.0E-10));
            Vector3D actualNormal = new Vector3D();
            ellipsoid.evaluatePoint3DCollision(supportingVertex, (Point3DBasics)new Point3D(), (Vector3DBasics)actualNormal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)actualNormal, (double)1.0E-10);
        }
    }

    @Test
    void testGetBoundingBox() throws Exception {
        Random random = new Random(36342L);
        for (int i = 0; i < 1000; ++i) {
            Ellipsoid3D ellipsoid3D = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            BoundingBox3D expectedBoundingBox = new BoundingBox3D();
            expectedBoundingBox.setToNaN();
            Vector3D supportDirection = new Vector3D((Tuple3DReadOnly)Axis3D.X);
            expectedBoundingBox.updateToIncludePoint(ellipsoid3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(ellipsoid3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Y);
            expectedBoundingBox.updateToIncludePoint(ellipsoid3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(ellipsoid3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Z);
            expectedBoundingBox.updateToIncludePoint(ellipsoid3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(ellipsoid3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            BoundingBox3DReadOnly actualBoundingBox = ellipsoid3D.getBoundingBox();
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expectedBoundingBox, (BoundingBox3DReadOnly)actualBoundingBox, (double)1.0E-10);
        }
    }
}

