/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.tools;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Triangle3D;
import us.ihmc.euclid.geometry.interfaces.Triangle3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.shape.convexPolytope.tools.IcoSphereFactory;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tuple3D.Point3D;

public class IcoSphereFactoryTest {
    private static final double ROUNDING = 1.0E-6;
    public static final double EPSILON = 1.0E-12;

    @Test
    void testIcosahedron() throws Exception {
        int recursionLevel = 0;
        IcoSphereFactory.TriangleMesh3D icoSphere = IcoSphereFactory.newIcoSphere((int)recursionLevel);
        List vertices = icoSphere.getVertices();
        Assertions.assertEquals((int)12, (int)vertices.size());
        Assertions.assertEquals((int)20, (int)icoSphere.getNumberOfTriangles());
        int numerOfEdges = icoSphere.getNumberOfTriangles() * 3 / 2;
        Assertions.assertEquals((int)vertices.size(), (int)(numerOfEdges - icoSphere.getNumberOfTriangles() + 2));
        this.assertVerticesAreUnique(vertices, 1.0E-6);
        this.assertVerticesOnUnitSphere(vertices);
        IcoSphereFactoryTest.checkTriangleProperties(icoSphere.getAllTriangles(), recursionLevel);
        for (Triangle3D triangle : icoSphere.getAllTriangles()) {
            double expectedEdgeLength = EuclidShapeTools.icosahedronEdgeLength((double)1.0);
            Assertions.assertEquals((double)expectedEdgeLength, (double)triangle.getAB());
            Assertions.assertEquals((double)expectedEdgeLength, (double)triangle.getBC());
            Assertions.assertEquals((double)expectedEdgeLength, (double)triangle.getCA());
        }
    }

    @Test
    void testIcosphereRecursion1() throws Exception {
        int recursionLevel = 1;
        IcoSphereFactory.TriangleMesh3D icoSphere = IcoSphereFactory.newIcoSphere((int)recursionLevel);
        List vertices = icoSphere.getVertices();
        Assertions.assertEquals((int)42, (int)vertices.size());
        Assertions.assertEquals((int)80, (int)icoSphere.getNumberOfTriangles());
        int numerOfEdges = icoSphere.getNumberOfTriangles() * 3 / 2;
        Assertions.assertEquals((int)vertices.size(), (int)EuclidPolytopeTools.computeConvexPolytopeNumberOfVertices((int)icoSphere.getNumberOfTriangles(), (int)numerOfEdges));
        this.assertVerticesAreUnique(vertices, 1.0E-6);
        this.assertVerticesOnUnitSphere(vertices);
        IcoSphereFactoryTest.checkTriangleProperties(icoSphere.getAllTriangles(), recursionLevel);
    }

    @Test
    void testIcosphereRecursion2() throws Exception {
        int recursionLevel = 2;
        IcoSphereFactory.TriangleMesh3D icoSphere = IcoSphereFactory.newIcoSphere((int)recursionLevel);
        List vertices = icoSphere.getVertices();
        Assertions.assertEquals((int)320, (int)icoSphere.getNumberOfTriangles());
        int numerOfEdges = icoSphere.getNumberOfTriangles() * 3 / 2;
        Assertions.assertEquals((int)vertices.size(), (int)EuclidPolytopeTools.computeConvexPolytopeNumberOfVertices((int)icoSphere.getNumberOfTriangles(), (int)numerOfEdges));
        this.assertVerticesAreUnique(vertices, 1.0E-6);
        this.assertVerticesOnUnitSphere(vertices);
        IcoSphereFactoryTest.checkTriangleProperties(icoSphere.getAllTriangles(), recursionLevel);
    }

    @Test
    void testIcosphereRecursion3() throws Exception {
        int recursionLevel = 3;
        IcoSphereFactory.TriangleMesh3D icoSphere = IcoSphereFactory.newIcoSphere((int)recursionLevel);
        List vertices = icoSphere.getVertices();
        Assertions.assertEquals((int)1280, (int)icoSphere.getNumberOfTriangles());
        int numerOfEdges = icoSphere.getNumberOfTriangles() * 3 / 2;
        Assertions.assertEquals((int)vertices.size(), (int)EuclidPolytopeTools.computeConvexPolytopeNumberOfVertices((int)icoSphere.getNumberOfTriangles(), (int)numerOfEdges));
        this.assertVerticesAreUnique(vertices, 1.0E-6);
        this.assertVerticesOnUnitSphere(vertices);
        IcoSphereFactoryTest.checkTriangleProperties(icoSphere.getAllTriangles(), recursionLevel);
    }

    @Test
    void testIcosphereRecursion4() throws Exception {
        int recursionLevel = 4;
        IcoSphereFactory.TriangleMesh3D icoSphere = IcoSphereFactory.newIcoSphere((int)recursionLevel);
        List vertices = icoSphere.getVertices();
        Assertions.assertEquals((int)2562, (int)vertices.size());
        Assertions.assertEquals((int)5120, (int)icoSphere.getNumberOfTriangles());
        int numerOfEdges = icoSphere.getNumberOfTriangles() * 3 / 2;
        Assertions.assertEquals((int)vertices.size(), (int)EuclidPolytopeTools.computeConvexPolytopeNumberOfVertices((int)icoSphere.getNumberOfTriangles(), (int)numerOfEdges));
        this.assertVerticesAreUnique(vertices, 1.0E-6);
        this.assertVerticesOnUnitSphere(vertices);
        IcoSphereFactoryTest.checkTriangleProperties(icoSphere.getAllTriangles(), recursionLevel);
    }

    private void assertVerticesOnUnitSphere(List<Point3D> vertices) {
        vertices.forEach(vertex -> Assertions.assertEquals((double)1.0, (double)vertex.distanceFromOrigin(), (double)1.0E-12, (String)"Vertex not on unit-sphere."));
    }

    private void assertVerticesAreUnique(List<Point3D> vertices, double epsilon) {
        long numberOfDistinctVertices = vertices.stream().map(vertex -> this.round((Point3D)vertex, epsilon)).distinct().count();
        Assertions.assertEquals((long)vertices.size(), (long)numberOfDistinctVertices);
    }

    private Point3D round(Point3D value, double precision) {
        return new Point3D(this.round(value.getX(), precision), this.round(value.getY(), precision), this.round(value.getZ(), precision));
    }

    private double round(double value, double precision) {
        return (double)((long)(value / precision)) * precision;
    }

    private static void checkTriangleProperties(List<Triangle3D> icoSphereTrianges, int recursionLevel) {
        if (recursionLevel == 0) {
            icoSphereTrianges.forEach(triangle -> Assertions.assertTrue((boolean)triangle.isEquilateral(1.0E-12), (String)("Not equilateral: " + triangle.getAB() + ", " + triangle.getBC() + ", " + triangle.getCA())));
            Triangle3D firstTriangle = icoSphereTrianges.get(0);
            double expectedEdgeLength = firstTriangle.getAB();
            icoSphereTrianges.stream().mapToDouble(Triangle3DReadOnly::getAB).forEach(actualEdgeLength -> Assertions.assertEquals((double)expectedEdgeLength, (double)actualEdgeLength, (double)1.0E-12, (String)"Edges are not all of same length."));
            double expectedArea = firstTriangle.getArea();
            for (int i = 1; i < icoSphereTrianges.size(); ++i) {
                Assertions.assertEquals((double)expectedArea, (double)icoSphereTrianges.get(i).getArea(), (double)1.0E-12);
            }
        } else {
            int expectedNumberOfEquilateralTriangles = 20;
            int actualNumberOfEquilateralTriangles = (int)icoSphereTrianges.stream().filter(triangle -> triangle.isEquilateral(1.0E-12)).count();
            Assertions.assertEquals((int)expectedNumberOfEquilateralTriangles, (int)actualNumberOfEquilateralTriangles);
        }
    }
}

