/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class QuaternionConversionTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testAxisAngleToQuaternion() throws Exception {
        Random random = new Random(484514L);
        double minMaxAngleRange = Math.PI * 2;
        Quaternion expectedQuaternion = new Quaternion();
        Quaternion actualQuaternion = new Quaternion();
        for (int i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            double angle = axisAngle.getAngle();
            double ux = axisAngle.getX();
            double uy = axisAngle.getY();
            double uz = axisAngle.getZ();
            double qs = EuclidCoreTools.cos((double)(angle / 2.0));
            double qx = ux * EuclidCoreTools.sin((double)(angle / 2.0));
            double qy = uy * EuclidCoreTools.sin((double)(angle / 2.0));
            double qz = uz * EuclidCoreTools.sin((double)(angle / 2.0));
            expectedQuaternion.setUnsafe(qx, qy, qz, qs);
            QuaternionConversion.convertAxisAngleToQuaternion((double)ux, (double)uy, (double)uz, (double)angle, (QuaternionBasics)actualQuaternion);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
        }
        double scale = random.nextDouble();
        AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
        double angle = axisAngle.getAngle();
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        QuaternionConversion.convertAxisAngleToQuaternion((double)ux, (double)uy, (double)uz, (double)angle, (QuaternionBasics)expectedQuaternion);
        QuaternionConversion.convertAxisAngleToQuaternion((double)(scale * ux), (double)(scale * uy), (double)(scale * uz), (double)angle, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
        EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
        QuaternionConversion.convertAxisAngleToQuaternion((double)0.0, (double)0.0, (double)0.0, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)actualQuaternion);
        QuaternionConversion.convertAxisAngleToQuaternion((double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        QuaternionConversion.convertAxisAngleToQuaternion((double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        QuaternionConversion.convertAxisAngleToQuaternion((double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        QuaternionConversion.convertAxisAngleToQuaternion((double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        for (int i = 0; i < 100; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            AxisAngle axisAngleCopy = new AxisAngle((Orientation3DReadOnly)axisAngle);
            angle = axisAngle.getAngle();
            ux = axisAngle.getX();
            uy = axisAngle.getY();
            uz = axisAngle.getZ();
            QuaternionConversion.convertAxisAngleToQuaternion((double)ux, (double)uy, (double)uz, (double)angle, (QuaternionBasics)expectedQuaternion);
            QuaternionConversion.convertAxisAngleToQuaternion((AxisAngleReadOnly)axisAngle, (QuaternionBasics)actualQuaternion);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            Assertions.assertTrue((boolean)axisAngle.equals((AxisAngleReadOnly)axisAngleCopy));
        }
    }

    @Test
    public void testMatrixToQuaternion() throws Exception {
        double m21;
        double m12;
        double m02;
        double m20;
        double m10;
        double m01;
        double m22;
        double m11;
        double m00;
        int i;
        Random random = new Random(2135L);
        Quaternion expectedQuaternion = new Quaternion();
        Quaternion actualQuaternion = new Quaternion();
        RotationMatrix rotationMatrix = new RotationMatrix();
        double minMaxAngleRange = Math.PI;
        for (i = 0; i < 1000; ++i) {
            expectedQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random, (double)minMaxAngleRange);
            double qx = expectedQuaternion.getX();
            double qy = expectedQuaternion.getY();
            double qz = expectedQuaternion.getZ();
            double qs = expectedQuaternion.getS();
            m00 = 1.0 - 2.0 * (qy * qy + qz * qz);
            m11 = 1.0 - 2.0 * (qx * qx + qz * qz);
            m22 = 1.0 - 2.0 * (qx * qx + qy * qy);
            m01 = 2.0 * (qx * qy - qz * qs);
            m10 = 2.0 * (qx * qy + qz * qs);
            m20 = 2.0 * (qx * qz - qy * qs);
            m02 = 2.0 * (qx * qz + qy * qs);
            m12 = 2.0 * (qy * qz - qx * qs);
            m21 = 2.0 * (qy * qz + qx * qs);
            rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D randomVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            randomVector.normalize();
            expectedQuaternion.setUnsafe(randomVector.getX(), randomVector.getY(), randomVector.getZ(), 0.0);
            double qx = expectedQuaternion.getX();
            double qy = expectedQuaternion.getY();
            double qz = expectedQuaternion.getZ();
            double qs = expectedQuaternion.getS();
            m00 = 1.0 - 2.0 * (qy * qy + qz * qz);
            m11 = 1.0 - 2.0 * (qx * qx + qz * qz);
            m22 = 1.0 - 2.0 * (qx * qx + qy * qy);
            m01 = 2.0 * (qx * qy - qz * qs);
            m10 = 2.0 * (qx * qy + qz * qs);
            m20 = 2.0 * (qx * qz - qy * qs);
            m02 = 2.0 * (qx * qz + qy * qs);
            m12 = 2.0 * (qy * qz - qx * qs);
            m21 = 2.0 * (qy * qz + qx * qs);
            rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
        }
        double sqrt2Over2 = EuclidCoreTools.squareRoot((double)2.0) / 2.0;
        m22 = 1.0;
        m11 = 1.0;
        m00 = 1.0;
        m12 = 0.0;
        m02 = 0.0;
        m01 = 0.0;
        m21 = 0.0;
        m20 = 0.0;
        m10 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)actualQuaternion);
        m00 = 1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 0.0;
        m12 = -1.0;
        m20 = 0.0;
        m21 = 1.0;
        m22 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getS(), (double)1.0E-12);
        m00 = 1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)1.0, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getS(), (double)1.0E-12);
        m00 = 0.0;
        m01 = 0.0;
        m02 = 1.0;
        m10 = 0.0;
        m11 = 1.0;
        m12 = 0.0;
        m20 = -1.0;
        m21 = 0.0;
        m22 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getS(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)1.0, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getS(), (double)1.0E-12);
        m00 = 0.0;
        m01 = -1.0;
        m02 = 0.0;
        m10 = 1.0;
        m11 = 0.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = 1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getS(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = 1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)1.0, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getS(), (double)1.0E-12);
        m00 = 0.0;
        m01 = 1.0;
        m02 = 0.0;
        m10 = 1.0;
        m11 = 0.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getS(), (double)1.0E-12);
        m00 = 0.0;
        m01 = 0.0;
        m02 = 1.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 1.0;
        m21 = 0.0;
        m22 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getS(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 0.0;
        m12 = 1.0;
        m20 = 0.0;
        m21 = 1.0;
        m22 = 0.0;
        rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)sqrt2Over2, (double)actualQuaternion.getZ(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualQuaternion.getS(), (double)1.0E-12);
        rotationMatrix.setUnsafe(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        rotationMatrix.setUnsafe(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        rotationMatrix.setUnsafe(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        rotationMatrix.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN);
        QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
    }

    @Test
    public void testYawPitchRollToQuaternion() throws Exception {
        Quaternion expectedQuaternion = new Quaternion();
        Quaternion actualQuaternion = new Quaternion();
        RotationMatrix rotationMatrix = new RotationMatrix();
        double deltaAngle = 0.3141592653589793;
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double pitch = -1.5707963267948966; pitch <= 1.5707963267948966; pitch += deltaAngle) {
                for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                    double cYaw = EuclidCoreTools.cos((double)yaw);
                    double sYaw = EuclidCoreTools.sin((double)yaw);
                    double cPitch = EuclidCoreTools.cos((double)pitch);
                    double sPitch = EuclidCoreTools.sin((double)pitch);
                    double cRoll = EuclidCoreTools.cos((double)roll);
                    double sRoll = EuclidCoreTools.sin((double)roll);
                    double m00 = cYaw * cPitch;
                    double m01 = cYaw * sPitch * sRoll - sYaw * cRoll;
                    double m02 = cYaw * sPitch * cRoll + sYaw * sRoll;
                    double m10 = sYaw * cPitch;
                    double m11 = sYaw * sPitch * sRoll + cYaw * cRoll;
                    double m12 = sYaw * sPitch * cRoll - cYaw * sRoll;
                    double m20 = -sPitch;
                    double m21 = cPitch * sRoll;
                    double m22 = cPitch * cRoll;
                    rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
                    QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)rotationMatrix, (QuaternionBasics)expectedQuaternion);
                    QuaternionConversion.convertYawPitchRollToQuaternion((double)yaw, (double)pitch, (double)roll, (QuaternionBasics)actualQuaternion);
                    EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
                    EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
                }
            }
        }
        QuaternionConversion.convertYawPitchRollToQuaternion((double)0.0, (double)0.0, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)actualQuaternion);
        QuaternionConversion.convertYawPitchRollToQuaternion((double)Double.NaN, (double)0.0, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        QuaternionConversion.convertYawPitchRollToQuaternion((double)0.0, (double)Double.NaN, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        QuaternionConversion.convertYawPitchRollToQuaternion((double)0.0, (double)0.0, (double)Double.NaN, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
    }

    @Test
    public void testRotationVectorToQuaternion() throws Exception {
        int i;
        Random random = new Random(32047230L);
        double minMaxAngleRange = Math.PI * 2;
        Quaternion expectedQuaternion = new Quaternion();
        Quaternion actualQuaternion = new Quaternion();
        for (int i2 = 0; i2 < 1000; ++i2) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            double rx = axisAngle.getX() * axisAngle.getAngle();
            double ry = axisAngle.getY() * axisAngle.getAngle();
            double rz = axisAngle.getZ() * axisAngle.getAngle();
            QuaternionConversion.convertAxisAngleToQuaternion((AxisAngleReadOnly)axisAngle, (QuaternionBasics)expectedQuaternion);
            QuaternionConversion.convertRotationVectorToQuaternion((double)rx, (double)ry, (double)rz, (QuaternionBasics)actualQuaternion);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
        }
        QuaternionConversion.convertRotationVectorToQuaternion((double)0.0, (double)0.0, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertQuaternionIsSetToZero((QuaternionReadOnly)actualQuaternion);
        QuaternionConversion.convertRotationVectorToQuaternion((double)Double.NaN, (double)0.0, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        QuaternionConversion.convertRotationVectorToQuaternion((double)0.0, (double)Double.NaN, (double)0.0, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        QuaternionConversion.convertRotationVectorToQuaternion((double)0.0, (double)0.0, (double)Double.NaN, (QuaternionBasics)actualQuaternion);
        EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)actualQuaternion);
        Vector3D rotationVector = new Vector3D();
        Vector3D rotationVectorCopy = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            EuclidCoreRandomTools.randomizeTuple3D((Random)random, (Tuple3DReadOnly)new Point3D(minMaxAngleRange, minMaxAngleRange, minMaxAngleRange), (Tuple3DBasics)rotationVector);
            rotationVectorCopy.set(rotationVector);
            double rx = rotationVector.getX();
            double ry = rotationVector.getY();
            double rz = rotationVector.getZ();
            QuaternionConversion.convertRotationVectorToQuaternion((double)rx, (double)ry, (double)rz, (QuaternionBasics)expectedQuaternion);
            QuaternionConversion.convertRotationVectorToQuaternion((Vector3DReadOnly)rotationVector, (QuaternionBasics)actualQuaternion);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            Assertions.assertTrue((boolean)rotationVector.equals((Tuple3DReadOnly)rotationVectorCopy));
        }
        minMaxAngleRange = 1.0E-8;
        for (i = 0; i < 10000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            double rx = axisAngle.getX() * axisAngle.getAngle();
            double ry = axisAngle.getY() * axisAngle.getAngle();
            double rz = axisAngle.getZ() * axisAngle.getAngle();
            QuaternionConversion.convertAxisAngleToQuaternion((AxisAngleReadOnly)axisAngle, (QuaternionBasics)expectedQuaternion);
            QuaternionConversion.convertRotationVectorToQuaternion((double)rx, (double)ry, (double)rz, (QuaternionBasics)actualQuaternion);
            EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
            EuclidCoreTestTools.assertQuaternionIsUnitary((QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
        }
    }
}

