/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import java.util.function.Predicate;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameTuple2DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Tuple2DBasicsTest;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class FrameTuple2DBasicsTest<F extends FrameTuple2DBasics>
extends FrameTuple2DReadOnlyTest<F> {
    public abstract Tuple2DBasics createRandomFramelessTuple(Random var1);

    @Test
    public void testSet() throws Exception {
        ReferenceFrame differentFrame;
        int differenceFrameIndex;
        FrameTuple2DBasics actual;
        ReferenceFrame initialFrame;
        int initialFrameIndex;
        Tuple2DBasics expected;
        ReferenceFrame[] referenceFrames;
        int i;
        Random random = new Random(5472L);
        for (i = 0; i < 1000; ++i) {
            referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            expected = this.createRandomFramelessTuple(random);
            initialFrameIndex = random.nextInt(referenceFrames.length);
            initialFrame = referenceFrames[initialFrameIndex];
            actual = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals((Tuple2DReadOnly)actual, 1.0E-15));
            actual.set(initialFrame, (Tuple2DReadOnly)expected);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-15);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((Tuple2DReadOnly)this.createRandomFramelessTuple(random));
            Assertions.assertFalse((boolean)expected.epsilonEquals((Tuple2DReadOnly)actual, 1.0E-15));
            expected.set((Tuple2DReadOnly)actual);
            differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, (Tuple2DReadOnly)this.createRandomFramelessTuple(random));
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-15);
            }
        }
        for (i = 0; i < 1000; ++i) {
            referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            expected = this.createRandomFramelessTuple(random);
            initialFrameIndex = random.nextInt(referenceFrames.length);
            initialFrame = referenceFrames[initialFrameIndex];
            actual = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals((Tuple2DReadOnly)actual, 1.0E-15));
            actual.set(initialFrame, expected.getX(), expected.getY());
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-15);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((Tuple2DReadOnly)this.createRandomFramelessTuple(random));
            Assertions.assertFalse((boolean)expected.epsilonEquals((Tuple2DReadOnly)actual, 1.0E-15));
            expected.set((Tuple2DReadOnly)actual);
            differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, random.nextDouble(), random.nextDouble());
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)1.0E-15);
            }
        }
    }

    @Test
    public void testSetIncludingFrame() throws Exception {
        Exception expectedException;
        Vector2D tuple;
        FrameTuple2DBasics frameTuple;
        Object input;
        Exception expectedException2;
        Vector2D tuple2;
        ReferenceFrame newFrame;
        int i;
        Random random = new Random(2342L);
        ReferenceFrame initialFrame = ReferenceFrame.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y = random.nextDouble();
            ReferenceFrame newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple2DBasics frameTuple2 = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            Vector2D tuple3 = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple2.getReferenceFrame());
            frameTuple2.setIncludingFrame(newFrame2, x, y);
            tuple3.set(x, y);
            Assertions.assertEquals((Object)newFrame2, (Object)frameTuple2.getReferenceFrame());
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple3, (Tuple2DReadOnly)frameTuple2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D input2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple2DBasics frameTuple3 = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple3.getReferenceFrame());
            frameTuple3.setIncludingFrame(newFrame, (Tuple2DReadOnly)input2);
            tuple2.set((Tuple2DReadOnly)input2);
            Assertions.assertEquals((Object)newFrame, (Object)frameTuple3.getReferenceFrame());
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)frameTuple3, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D input3 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple2DBasics frameTuple4 = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple4.getReferenceFrame());
            frameTuple4.setIncludingFrame(newFrame, (Tuple3DReadOnly)input3);
            tuple2.set((Tuple3DReadOnly)input3);
            Assertions.assertEquals((Object)newFrame, (Object)frameTuple4.getReferenceFrame());
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)frameTuple4, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            double[] input4 = new double[random.nextInt(20)];
            for (int j = 0; j < input4.length; ++j) {
                input4[j] = random.nextDouble();
            }
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple2DBasics frameTuple5 = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple5.getReferenceFrame());
            expectedException2 = null;
            try {
                tuple2.set(input4);
            }
            catch (Exception e) {
                expectedException2 = e;
            }
            try {
                frameTuple5.setIncludingFrame(newFrame, input4);
                if (expectedException2 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame, (Object)frameTuple5.getReferenceFrame());
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)frameTuple5, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException2 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException2.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException2.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException2));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startIndex = random.nextInt(10);
            input = new double[random.nextInt(20)];
            for (int j = 0; j < ((double[])input).length; ++j) {
                input[j] = random.nextDouble();
            }
            ReferenceFrame newFrame3 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameTuple = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple.getReferenceFrame());
            expectedException = null;
            try {
                tuple.set(startIndex, input);
            }
            catch (Exception e) {
                expectedException = e;
            }
            try {
                frameTuple.setIncludingFrame(newFrame3, startIndex, input);
                if (expectedException != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame3, (Object)frameTuple.getReferenceFrame());
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple, (Tuple2DReadOnly)frameTuple, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj input5 = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple2DBasics frameTuple6 = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple6.getReferenceFrame());
            expectedException2 = null;
            try {
                tuple2.set((DMatrix)input5);
            }
            catch (Exception e) {
                expectedException2 = e;
            }
            try {
                frameTuple6.setIncludingFrame(newFrame, (DMatrix)input5);
                if (expectedException2 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame, (Object)frameTuple6.getReferenceFrame());
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)frameTuple6, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException2 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException2.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException2.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException2));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startRow = random.nextInt(10);
            input = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            ReferenceFrame newFrame4 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameTuple = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple.getReferenceFrame());
            expectedException = null;
            try {
                tuple.set(startRow, (DMatrix)input);
            }
            catch (Exception e) {
                expectedException = e;
            }
            try {
                frameTuple.setIncludingFrame(newFrame4, startRow, (DMatrix)input);
                if (expectedException != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame4, (Object)frameTuple.getReferenceFrame());
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple, (Tuple2DReadOnly)frameTuple, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startRow = random.nextInt(10);
            int column = random.nextInt(10);
            DMatrixRMaj input6 = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            ReferenceFrame newFrame5 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple2DBasics frameTuple7 = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            Vector2D tuple4 = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple7.getReferenceFrame());
            Exception expectedException3 = null;
            try {
                tuple4.set(startRow, column, (DMatrix)input6);
            }
            catch (Exception e) {
                expectedException3 = e;
            }
            try {
                frameTuple7.setIncludingFrame(newFrame5, startRow, column, (DMatrix)input6);
                if (expectedException3 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame5, (Object)frameTuple7.getReferenceFrame());
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple4, (Tuple2DReadOnly)frameTuple7, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException3 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException3.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException3.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException3));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame newFrame6 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint2D input7 = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)newFrame6);
            FrameTuple2DBasics frameTuple8 = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple8.getReferenceFrame());
            frameTuple8.setIncludingFrame((FrameTuple2DReadOnly)input7);
            tuple2.set((Tuple2DReadOnly)input7);
            Assertions.assertEquals((Object)newFrame6, (Object)frameTuple8.getReferenceFrame());
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)frameTuple8, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame newFrame7 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint3D input8 = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)newFrame7);
            FrameTuple2DBasics frameTuple9 = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector2D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple9.getReferenceFrame());
            frameTuple9.setIncludingFrame((FrameTuple3DReadOnly)input8);
            tuple2.set((Tuple3DReadOnly)input8);
            Assertions.assertEquals((Object)newFrame7, (Object)frameTuple9.getReferenceFrame());
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)frameTuple9, (double)1.0E-15);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            Tuple2DBasics expectedGeometryObject = this.createRandomFramelessTuple(random);
            expectedGeometryObject.setToZero();
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FrameTuple2DBasics frameGeometryObject = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals((Tuple2DReadOnly)frameGeometryObject, 1.0E-15));
            frameGeometryObject.setToZero();
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedGeometryObject, (Tuple2DReadOnly)frameGeometryObject, (double)1.0E-15);
            frameGeometryObject = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals((Tuple2DReadOnly)frameGeometryObject, 1.0E-15));
            frameGeometryObject.setToZero(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedGeometryObject, (Tuple2DReadOnly)frameGeometryObject, (double)1.0E-15);
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(574L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FrameTuple2DBasics frameGeometryObject = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN();
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)frameGeometryObject);
            frameGeometryObject = (FrameTuple2DBasics)this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)frameGeometryObject);
        }
    }

    @Override
    public void testOverloading() throws Exception {
        super.testOverloading();
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameTuple2DBasics.class, Tuple2DBasics.class, true, 1);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFrameTuple, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithTuple2D() throws Exception {
        FrameTypeCopier frameTypeBuilder = (frame, tuple) -> (FrameTuple2DBasics)this.createFrameTuple(frame, (Tuple2DReadOnly)tuple);
        RandomFramelessTypeBuilder framelessTypeBuilber = this::createRandomFramelessTuple;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilber, methodFilter, 10);
    }

    @Test
    public void testTuple2DBasicsFeatures() throws Exception {
        Tuple2DBasicsTest tuple2dBasicsTest = new Tuple2DBasicsTest<F>(){

            @Override
            public F createEmptyTuple() {
                return (FrameTuple2DBasics)FrameTuple2DBasicsTest.this.createEmptyFrameTuple();
            }

            @Override
            public F createTuple(double x, double y) {
                return (FrameTuple2DBasics)FrameTuple2DBasicsTest.this.createFrameTuple(x, y);
            }

            @Override
            public F createRandomTuple(Random random) {
                return (FrameTuple2DBasics)FrameTuple2DBasicsTest.this.createRandomFrameTuple(random);
            }

            @Override
            public double getEpsilon() {
                return 1.0E-15;
            }
        };
        for (Method testMethod : tuple2dBasicsTest.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            testMethod.invoke((Object)tuple2dBasicsTest, new Object[0]);
        }
    }
}

