/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose2D;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.FramePose2DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;

public class FramePose2DTest
extends FramePose2DReadOnlyTest<FramePose2D> {
    public static final double EPSILON = 1.0E-15;

    @Override
    public FramePose2D createFramePose(ReferenceFrame referenceFrame, Pose2DReadOnly pose) {
        return new FramePose2D(referenceFrame, pose);
    }

    @Test
    public void testConsistencyWithPose2D() {
        FrameTypeCopier frameTypeBuilder = (frame, pose) -> this.createFramePose(frame, (Pose2DReadOnly)pose);
        RandomFramelessTypeBuilder framelessTypeBuilder = EuclidGeometryRandomTools::nextPose2D;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilder, methodFilter, 10);
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Pose2D.class}));
        signaturesToIgnore.add(new MethodSignature("equals", new Class[]{Pose2D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Pose2D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Pose2D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FramePose2D.class, Pose2D.class, true, 1, methodFilter);
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFramePose2D, 10);
        Random random = new Random(544354L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            ReferenceFrame destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            FramePose2D source = EuclidFrameRandomTools.nextFramePose2D((Random)random, (ReferenceFrame)sourceFrame);
            FramePose2D actual = EuclidFrameRandomTools.nextFramePose2D((Random)random, (ReferenceFrame)destinationFrame);
            actual.setMatchingFrame((FramePose2DReadOnly)source);
            FramePose2D expected = new FramePose2D((FramePose2DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidGeometryTestTools.assertPose2DEquals((Pose2DReadOnly)expected, (Pose2DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFramePoint2D, 10);
    }
}

