/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;

public abstract class FrameMatrix3DReadOnlyTest<T extends FrameMatrix3DReadOnly> {
    public abstract T createFrameMatrix3D(ReferenceFrame var1, Matrix3DReadOnly var2);

    public final T createEmptyFrameMatrix3D(ReferenceFrame referenceFrame) {
        return this.createFrameMatrix3D(referenceFrame, (Matrix3DReadOnly)new Matrix3D());
    }

    public final T createRandomFrameMatrix3D(Random random) {
        return this.createRandomFrameMatrix3D(random, ReferenceFrame.getWorldFrame());
    }

    public final T createRandomFrameMatrix3D(Random random, ReferenceFrame referenceFrame) {
        return this.createFrameMatrix3D(referenceFrame, (Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random));
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFrameMatrix3D, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FramePose2DReadOnly.class, Pose2DReadOnly.class, true);
    }
}

