/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;

public abstract class FrameLineSegment2DReadOnlyTest<T extends FrameLineSegment2DReadOnly> {
    public abstract T createFrameLineSegment(ReferenceFrame var1, LineSegment2DReadOnly var2);

    public final T createRandomLineSegment(Random random) {
        return this.createRandomFrameLineSegment(random, ReferenceFrame.getWorldFrame());
    }

    public final T createRandomFrameLineSegment(Random random, ReferenceFrame referenceFrame) {
        return this.createFrameLineSegment(referenceFrame, (LineSegment2DReadOnly)EuclidGeometryRandomTools.nextLineSegment2D((Random)random));
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameLineSegment2DReadOnly.class, LineSegment2DReadOnly.class, true);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFrameLineSegment, methodFilter, 10);
    }
}

