/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3DReadOnlyTest;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;

public abstract class CommonMatrix3DBasicsTest<T extends CommonMatrix3DBasics>
extends Matrix3DReadOnlyTest<T> {
    @Test
    public void testSetDoubles() {
        Random random = new Random(345634L);
        CommonMatrix3DBasics expectedMatrix = (CommonMatrix3DBasics)this.createRandomMatrix(random);
        double m00 = expectedMatrix.getM00();
        double m01 = expectedMatrix.getM01();
        double m02 = expectedMatrix.getM02();
        double m10 = expectedMatrix.getM10();
        double m11 = expectedMatrix.getM11();
        double m12 = expectedMatrix.getM12();
        double m20 = expectedMatrix.getM20();
        double m21 = expectedMatrix.getM21();
        double m22 = expectedMatrix.getM22();
        CommonMatrix3DBasics actualMatrix = (CommonMatrix3DBasics)this.createEmptyMatrix();
        actualMatrix.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
    }

    @Test
    public void testSetToNaN() throws Exception {
        int col;
        int row;
        CommonMatrix3DBasics matrix = (CommonMatrix3DBasics)this.createEmptyMatrix();
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                Assertions.assertFalse((boolean)Double.isNaN(matrix.getElement(row, col)));
            }
        }
        matrix.setToNaN();
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                Assertions.assertTrue((boolean)Double.isNaN(matrix.getElement(row, col)));
            }
        }
    }

    @Test
    public void testSetIdentity() throws Exception {
        Random random = new Random(2342L);
        CommonMatrix3DBasics matrix = (CommonMatrix3DBasics)this.createRandomMatrix(random);
        Assertions.assertFalse((boolean)matrix.isIdentity());
        matrix.setIdentity();
        Assertions.assertTrue((boolean)matrix.isIdentity());
    }

    @Test
    public void testSetters() throws Exception {
        DMatrixRMaj denseMatrix;
        double[] array;
        RotationMatrix expectedMatrix;
        int i;
        Random random = new Random(2342L);
        for (i = 0; i < 1000; ++i) {
            expectedMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            CommonMatrix3DBasics actualMatrix = (CommonMatrix3DBasics)this.createEmptyMatrix();
            actualMatrix.set((RotationMatrixReadOnly)expectedMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            array = new double[40];
            expectedMatrix.get(array);
            CommonMatrix3DBasics actualMatrix = (CommonMatrix3DBasics)this.createEmptyMatrix();
            actualMatrix.set(array);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            array = new double[40];
            int startIndex = random.nextInt(array.length - 9);
            expectedMatrix.get(startIndex, array);
            CommonMatrix3DBasics actualMatrix = (CommonMatrix3DBasics)this.createEmptyMatrix();
            actualMatrix.set(startIndex, array);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            denseMatrix = new DMatrixRMaj(30, 30);
            expectedMatrix.get((DMatrix)denseMatrix);
            CommonMatrix3DBasics actualMatrix = (CommonMatrix3DBasics)this.createEmptyMatrix();
            actualMatrix.set((DMatrix)denseMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expectedMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            denseMatrix = new DMatrixRMaj(30, 30);
            int startRow = random.nextInt(denseMatrix.getNumRows() - 3);
            int startColumn = random.nextInt(denseMatrix.getNumCols() - 3);
            expectedMatrix.get(startRow, startColumn, (DMatrix)denseMatrix);
            CommonMatrix3DBasics actualMatrix = (CommonMatrix3DBasics)this.createEmptyMatrix();
            actualMatrix.set(startRow, startColumn, (DMatrix)denseMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
    }

    @Test
    public void testTranspose() throws Exception {
        Random random = new Random(65451L);
        for (int i = 0; i < 1000; ++i) {
            CommonMatrix3DBasics matrix = (CommonMatrix3DBasics)this.createRandomMatrix(random);
            CommonMatrix3DBasics matrixTranspose = (CommonMatrix3DBasics)this.createEmptyMatrix();
            matrixTranspose.set((Matrix3DReadOnly)matrix);
            matrixTranspose.transpose();
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertEquals((double)matrix.getElement(row, column), (double)matrixTranspose.getElement(column, row), (double)1.0E-12);
                }
            }
        }
    }
}

