/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Pose2DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public abstract class Pose2DBasicsTest<T extends Pose2DBasics> {
    private static final double EPSILON = 1.0E-7;

    public abstract T createEmptyPose2D();

    public abstract T createRandomPose2D(Random var1);

    public T copy(Pose2DReadOnly source) {
        T copy = this.createEmptyPose2D();
        copy.set(source);
        return copy;
    }

    @Test
    public void testSetToNaN() {
        Random random = new Random(70324L);
        for (int i = 0; i < 1000; ++i) {
            T toSet = this.createRandomPose2D(random);
            toSet.setToNaN();
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getYaw(), (double)1.0E-7);
        }
    }

    @Test
    public void testSetToZero() {
        Random random = new Random(70924L);
        for (int i = 0; i < 1000; ++i) {
            T toSet = this.createRandomPose2D(random);
            toSet.setToZero();
            Assertions.assertEquals((double)0.0, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)toSet.getYaw(), (double)1.0E-7);
        }
    }

    @Test
    public void testSetComponents() {
        Random random = new Random(71484L);
        for (int i = 0; i < 1000; ++i) {
            double x = random.nextDouble() - random.nextDouble();
            double y = random.nextDouble() - random.nextDouble();
            double yaw = random.nextDouble() - random.nextDouble();
            T toSet = this.createRandomPose2D(random);
            toSet.setX(x);
            toSet.setY(y);
            toSet.setYaw(yaw);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)toSet.getYaw(), (double)1.0E-7);
            toSet = this.createRandomPose2D(random);
            toSet.setPosition(x, y);
            toSet.setYaw(yaw);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)toSet.getYaw(), (double)1.0E-7);
            toSet = this.createRandomPose2D(random);
            toSet.set(x, y, yaw);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)toSet.getYaw(), (double)1.0E-7);
            toSet = this.createRandomPose2D(random);
            Vector2D tuple = new Vector2D(x, y);
            Orientation2D orientation = new Orientation2D(yaw);
            toSet.set((Tuple2DReadOnly)tuple, (Orientation2DReadOnly)orientation);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)toSet.getYaw(), (double)1.0E-7);
            toSet = this.createRandomPose2D(random);
            toSet.setPosition((Tuple2DReadOnly)tuple);
            toSet.setOrientation((Orientation2DReadOnly)orientation);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)toSet.getYaw(), (double)1.0E-7);
            toSet = this.createRandomPose2D(random);
            T toCopy = this.createEmptyPose2D();
            toCopy.set(x, y, yaw);
            toSet.set(toCopy);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)toSet.getYaw(), (double)1.0E-7);
        }
    }

    @Test
    public void testPointDistance() {
        Random random = new Random(41133L);
        Point2D point = new Point2D();
        for (int i = 0; i < 1000; ++i) {
            T firstPose = this.createRandomPose2D(random);
            T secondPose = this.copy((Pose2DReadOnly)firstPose);
            Vector2D translation = EuclidCoreRandomTools.nextVector2D((Random)random);
            double length = translation.length();
            secondPose.appendTranslation((Tuple2DReadOnly)translation);
            Assertions.assertEquals((double)length, (double)firstPose.getPositionDistance(secondPose), (double)1.0E-7);
            point.set((Tuple2DReadOnly)firstPose.getPosition());
            point.add((Tuple2DReadOnly)translation);
            Assertions.assertEquals((double)length, (double)firstPose.getPositionDistance((Point2DReadOnly)point), (double)1.0E-7);
        }
    }

    @Test
    public void testOrientationDistance() {
        Random random = new Random(59886L);
        Orientation2D orientation = new Orientation2D();
        for (int i = 0; i < 1000; ++i) {
            double angleDiff = Math.PI - Math.PI * 2 * random.nextDouble();
            T firstPose = this.createRandomPose2D(random);
            T secondPose = this.copy((Pose2DReadOnly)firstPose);
            secondPose.appendRotation(angleDiff);
            Assertions.assertEquals((double)Math.abs(angleDiff), (double)firstPose.getOrientationDistance(secondPose), (double)1.0E-7);
            orientation.set((Orientation2DReadOnly)firstPose.getOrientation());
            orientation.add(angleDiff);
            Assertions.assertEquals((double)Math.abs(angleDiff), (double)firstPose.getOrientationDistance((Orientation2DReadOnly)orientation), (double)1.0E-7);
        }
    }

    @Test
    public void testEquals() {
        int i;
        Random random = new Random(9827L);
        double x = random.nextDouble() - random.nextDouble();
        double y = random.nextDouble() - random.nextDouble();
        double yaw = random.nextDouble() - random.nextDouble();
        T firstPose = this.createEmptyPose2D();
        firstPose.set(x, y, yaw);
        T secondPose = this.createEmptyPose2D();
        secondPose.set(x, y, yaw);
        Assertions.assertTrue((boolean)firstPose.equals(secondPose));
        Assertions.assertTrue((boolean)secondPose.equals(secondPose));
        Assertions.assertTrue((boolean)firstPose.equals(firstPose));
        Assertions.assertTrue((boolean)secondPose.equals(secondPose));
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble() - random.nextDouble();
            y = random.nextDouble() - random.nextDouble();
            yaw = random.nextDouble() - random.nextDouble();
            firstPose = this.createEmptyPose2D();
            firstPose.set(x, y, yaw);
            secondPose = this.createEmptyPose2D();
            secondPose.set(x, y, yaw);
            Vector2D translation = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0E-7);
            secondPose.appendTranslation((Tuple2DReadOnly)translation);
            Assertions.assertFalse((boolean)firstPose.equals(secondPose));
        }
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble() - random.nextDouble();
            y = random.nextDouble() - random.nextDouble();
            yaw = random.nextDouble() - random.nextDouble();
            firstPose = this.createEmptyPose2D();
            firstPose.set(x, y, yaw);
            secondPose = this.createEmptyPose2D();
            secondPose.set(x, y, yaw);
            double angleDiff = (double)(random.nextBoolean() ? 1 : -1) * 1.0E-7;
            secondPose.appendRotation(angleDiff);
            Assertions.assertFalse((boolean)firstPose.equals(secondPose));
        }
    }

    @Test
    public void testEpsilonEquals() {
        int i;
        Random random = new Random(9827L);
        double x = random.nextDouble() - random.nextDouble();
        double y = random.nextDouble() - random.nextDouble();
        double yaw = random.nextDouble() - random.nextDouble();
        T firstPose = this.createEmptyPose2D();
        firstPose.set(x, y, yaw);
        T secondPose = this.createEmptyPose2D();
        secondPose.set(x, y, yaw);
        Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
        Assertions.assertTrue((boolean)secondPose.epsilonEquals(firstPose, 1.0E-7));
        Assertions.assertTrue((boolean)firstPose.epsilonEquals(firstPose, 1.0E-7));
        Assertions.assertTrue((boolean)secondPose.epsilonEquals(secondPose, 1.0E-7));
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble() - random.nextDouble();
            y = random.nextDouble() - random.nextDouble();
            yaw = random.nextDouble() - random.nextDouble();
            firstPose = this.createEmptyPose2D();
            firstPose.set(x, y, yaw);
            secondPose = this.createEmptyPose2D();
            secondPose.set(x, y, yaw);
            secondPose.setX(x + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose = this.createEmptyPose2D();
            secondPose.set(x, y, yaw);
            secondPose.setY(y + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose = this.createEmptyPose2D();
            secondPose.set(x, y, yaw);
            secondPose.setX(x + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose = this.createEmptyPose2D();
            secondPose.set(x, y, yaw);
            secondPose.setY(y + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
        }
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble() - random.nextDouble();
            y = random.nextDouble() - random.nextDouble();
            yaw = random.nextDouble() - random.nextDouble();
            firstPose = this.createEmptyPose2D();
            firstPose.set(x, y, yaw);
            secondPose = this.createEmptyPose2D();
            secondPose.set(x, y, yaw);
            double angleDiff = (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7;
            secondPose.appendRotation(angleDiff);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose = this.createEmptyPose2D();
            secondPose.set(x, y, yaw);
            angleDiff = (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7;
            secondPose.appendRotation(angleDiff);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
        }
    }
}

