/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DBasics;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Torus3DReadOnly
extends Shape3DReadOnly {
    public double getRadius();

    public double getTubeRadius();

    public Point3DReadOnly getPosition();

    public UnitVector3DReadOnly getAxis();

    @Override
    default public Point3DReadOnly getCentroid() {
        return this.getPosition();
    }

    @Override
    default public double getVolume() {
        return EuclidShapeTools.torusVolume(this.getRadius(), this.getTubeRadius());
    }

    @Override
    default public boolean containsNaN() {
        return this.getPosition().containsNaN() || this.getAxis().containsNaN() || Double.isNaN(this.getRadius()) || Double.isNaN(this.getTubeRadius());
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        return EuclidShapeTools.evaluatePoint3DTorus3DCollision(pointToCheck, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getRadius(), this.getTubeRadius(), closestPointOnSurfaceToPack, normalAtClosestPointToPack) <= 0.0;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        throw new UnsupportedOperationException("Torus3D being a concave shape cannot implement the supporting vertex feature.");
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        return EuclidShapeTools.signedDistanceBetweenPoint3DAndTorus3D(point, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getRadius(), this.getTubeRadius());
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        return EuclidShapeTools.isPoint3DInsideTorus3D(query, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getRadius(), this.getTubeRadius(), epsilon);
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        return EuclidShapeTools.orthogonalProjectionOntoTorus3D(pointToProject, this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getRadius(), this.getTubeRadius(), projectionToPack);
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        EuclidShapeTools.boundingBoxCylinder3D(this.getPosition(), (Vector3DReadOnly)this.getAxis(), this.getTubeRadius(), this.getRadius() + this.getTubeRadius(), boundingBoxToPack);
    }

    @Override
    default public boolean isConvex() {
        return false;
    }

    @Override
    default public boolean isPrimitive() {
        return true;
    }

    @Override
    default public boolean isDefinedByPose() {
        return false;
    }

    @Override
    default public Shape3DPoseReadOnly getPose() {
        return null;
    }

    @Override
    public Torus3DBasics copy();

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Torus3DReadOnly)) {
            return false;
        }
        Torus3DReadOnly other = (Torus3DReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getRadius(), (double)other.getRadius(), (double)epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getTubeRadius(), (double)other.getTubeRadius(), (double)epsilon)) {
            return false;
        }
        if (!this.getPosition().epsilonEquals((EuclidGeometry)other.getPosition(), epsilon)) {
            return false;
        }
        return this.getAxis().epsilonEquals((EuclidGeometry)other.getAxis(), epsilon);
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Torus3DReadOnly)) {
            return false;
        }
        Torus3DReadOnly other = (Torus3DReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getRadius(), (double)other.getRadius(), (double)epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)this.getTubeRadius(), (double)other.getTubeRadius(), (double)epsilon)) {
            return false;
        }
        if (!this.getPosition().geometricallyEquals((EuclidGeometry)this.getPosition(), epsilon)) {
            return false;
        }
        return EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)this.getAxis(), (Vector3DReadOnly)other.getAxis(), (double)epsilon);
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Torus3DReadOnly)) {
            return false;
        }
        Torus3DReadOnly other = (Torus3DReadOnly)geometry;
        if (!EuclidCoreTools.equals((double)this.getRadius(), (double)other.getRadius())) {
            return false;
        }
        if (!EuclidCoreTools.equals((double)this.getTubeRadius(), (double)other.getTubeRadius())) {
            return false;
        }
        if (!this.getPosition().equals((EuclidGeometry)other.getPosition())) {
            return false;
        }
        return this.getAxis().equals((EuclidGeometry)other.getAxis());
    }

    default public String toString(String format) {
        return EuclidShapeIOTools.getTorus3DString(format, this);
    }
}

