/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.tools;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.tools.EuclidEllipsoid3DTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidShapeTools {
    public static final double MIN_DISTANCE_EPSILON = 1.0E-12;

    private EuclidShapeTools() {
    }

    public static boolean isPoint3DInsideBox3D(Point3DReadOnly query, Vector3DReadOnly box3DSize, double epsilon) {
        return EuclidShapeTools.isPoint3DInsideBox3D(query.getX(), query.getY(), query.getZ(), box3DSize, epsilon);
    }

    public static boolean isPoint3DInsideBox3D(double x, double y, double z, Vector3DReadOnly box3DSize, double epsilon) {
        if (Math.abs(x) <= 0.5 * box3DSize.getX() + epsilon && Math.abs(y) <= 0.5 * box3DSize.getY() + epsilon) {
            return Math.abs(z) <= 0.5 * box3DSize.getZ() + epsilon;
        }
        return false;
    }

    public static double signedDistanceBetweenPoint3DAndBox3D(Point3DReadOnly query, Vector3DReadOnly box3DSize) {
        boolean isInside;
        double halfSizeX = 0.5 * box3DSize.getX();
        double halfSizeY = 0.5 * box3DSize.getY();
        double halfSizeZ = 0.5 * box3DSize.getZ();
        boolean bl = isInside = Math.abs(query.getX()) <= halfSizeX && Math.abs(query.getY()) <= halfSizeY && Math.abs(query.getZ()) <= halfSizeZ;
        if (isInside) {
            double dx = Math.abs(Math.abs(query.getX()) - halfSizeX);
            double dy = Math.abs(Math.abs(query.getY()) - halfSizeY);
            double dz = Math.abs(Math.abs(query.getZ()) - halfSizeZ);
            return -EuclidCoreTools.min((double)dx, (double)dy, (double)dz);
        }
        double dx = query.getX() - EuclidCoreTools.clamp((double)query.getX(), (double)halfSizeX);
        double dy = query.getY() - EuclidCoreTools.clamp((double)query.getY(), (double)halfSizeY);
        double dz = query.getZ() - EuclidCoreTools.clamp((double)query.getZ(), (double)halfSizeZ);
        return EuclidCoreTools.norm((double)dx, (double)dy, (double)dz);
    }

    public static boolean orthogonalProjectionOntoBox3D(Point3DReadOnly pointToProject, Vector3DReadOnly box3DSize, Point3DBasics projectionToPack) {
        double halfSizeX = 0.5 * box3DSize.getX();
        double halfSizeY = 0.5 * box3DSize.getY();
        double halfSizeZ = 0.5 * box3DSize.getZ();
        double xLocal = pointToProject.getX();
        double yLocal = pointToProject.getY();
        double zLocal = pointToProject.getZ();
        if (Math.abs(xLocal) > halfSizeX || Math.abs(yLocal) > halfSizeY || Math.abs(zLocal) > halfSizeZ) {
            double xLocalClamped = EuclidCoreTools.clamp((double)xLocal, (double)halfSizeX);
            double yLocalClamped = EuclidCoreTools.clamp((double)yLocal, (double)halfSizeY);
            double zLocalClamped = EuclidCoreTools.clamp((double)zLocal, (double)halfSizeZ);
            projectionToPack.set(xLocalClamped, yLocalClamped, zLocalClamped);
            return true;
        }
        return false;
    }

    public static void supportingVertexBox3D(Vector3DReadOnly supportDirection, Vector3DReadOnly box3DSize, Point3DBasics supportingVertexToPack) {
        supportingVertexToPack.set(supportDirection.getX() > 0.0 ? box3DSize.getX() : -box3DSize.getX(), supportDirection.getY() > 0.0 ? box3DSize.getY() : -box3DSize.getY(), supportDirection.getZ() > 0.0 ? box3DSize.getZ() : -box3DSize.getZ());
        supportingVertexToPack.scale(0.5);
    }

    public static void boundingBoxBox3D(Point3DReadOnly box3DPosition, RotationMatrixReadOnly box3DOrientation, Vector3DReadOnly box3DSize, BoundingBox3DBasics boundingBoxToPack) {
        double zRange;
        double yRange;
        double xRange;
        double halfSizeX = 0.5 * box3DSize.getX();
        double halfSizeY = 0.5 * box3DSize.getY();
        double halfSizeZ = 0.5 * box3DSize.getZ();
        if (box3DOrientation.isIdentity()) {
            xRange = halfSizeX;
            yRange = halfSizeY;
            zRange = halfSizeZ;
        } else {
            xRange = Math.abs(box3DOrientation.getM00()) * halfSizeX + Math.abs(box3DOrientation.getM01()) * halfSizeY + Math.abs(box3DOrientation.getM02()) * halfSizeZ;
            yRange = Math.abs(box3DOrientation.getM10()) * halfSizeX + Math.abs(box3DOrientation.getM11()) * halfSizeY + Math.abs(box3DOrientation.getM12()) * halfSizeZ;
            zRange = Math.abs(box3DOrientation.getM20()) * halfSizeX + Math.abs(box3DOrientation.getM21()) * halfSizeY + Math.abs(box3DOrientation.getM22()) * halfSizeZ;
        }
        double maxX = box3DPosition.getX() + xRange;
        double maxY = box3DPosition.getY() + yRange;
        double maxZ = box3DPosition.getZ() + zRange;
        double minX = box3DPosition.getX() - xRange;
        double minY = box3DPosition.getY() - yRange;
        double minZ = box3DPosition.getZ() - zRange;
        boundingBoxToPack.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static double evaluatePoint3DBox3DCollision(Point3DReadOnly query, Vector3DReadOnly box3DSize, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalToPack) {
        boolean isInside;
        double halfSizeX = 0.5 * box3DSize.getX();
        double halfSizeY = 0.5 * box3DSize.getY();
        double halfSizeZ = 0.5 * box3DSize.getZ();
        double xLocal = query.getX();
        double yLocal = query.getY();
        double zLocal = query.getZ();
        boolean bl = isInside = Math.abs(xLocal) <= halfSizeX && Math.abs(yLocal) <= halfSizeY && Math.abs(zLocal) <= halfSizeZ;
        if (isInside) {
            double dx = Math.abs(Math.abs(xLocal) - halfSizeX);
            double dy = Math.abs(Math.abs(yLocal) - halfSizeY);
            double dz = Math.abs(Math.abs(zLocal) - halfSizeZ);
            closestPointOnSurfaceToPack.set(xLocal, yLocal, zLocal);
            if (dx < dy) {
                if (dx < dz) {
                    closestPointOnSurfaceToPack.setX(Math.copySign(halfSizeX, xLocal));
                } else {
                    closestPointOnSurfaceToPack.setZ(Math.copySign(halfSizeZ, zLocal));
                }
            } else if (dy < dz) {
                closestPointOnSurfaceToPack.setY(Math.copySign(halfSizeY, yLocal));
            } else {
                closestPointOnSurfaceToPack.setZ(Math.copySign(halfSizeZ, zLocal));
            }
            normalToPack.setToZero();
            if (dx < dy) {
                if (dx < dz) {
                    normalToPack.setX(Math.copySign(1.0, xLocal));
                } else {
                    normalToPack.setZ(Math.copySign(1.0, zLocal));
                }
            } else if (dy < dz) {
                normalToPack.setY(Math.copySign(1.0, yLocal));
            } else {
                normalToPack.setZ(Math.copySign(1.0, zLocal));
            }
            return -EuclidCoreTools.min((double)dx, (double)dy, (double)dz);
        }
        double xLocalClamped = EuclidCoreTools.clamp((double)xLocal, (double)halfSizeX);
        double yLocalClamped = EuclidCoreTools.clamp((double)yLocal, (double)halfSizeY);
        double zLocalClamped = EuclidCoreTools.clamp((double)zLocal, (double)halfSizeZ);
        double dx = xLocal - xLocalClamped;
        double dy = yLocal - yLocalClamped;
        double dz = zLocal - zLocalClamped;
        double distance = EuclidCoreTools.norm((double)dx, (double)dy, (double)dz);
        closestPointOnSurfaceToPack.set(xLocalClamped, yLocalClamped, zLocalClamped);
        normalToPack.set(dx, dy, dz);
        normalToPack.scale(1.0 / distance);
        return distance;
    }

    public static boolean isPoint3DInsideCapsule3D(Point3DReadOnly query, Point3DReadOnly capsule3DPosition, Vector3DReadOnly capsule3DAxis, double capsule3DLength, double capsule3DRadius, double epsilon) {
        double upsizedRadius;
        double capsule3DHalfLength = 0.5 * capsule3DLength;
        double topCenterX = capsule3DPosition.getX() + capsule3DHalfLength * capsule3DAxis.getX();
        double topCenterY = capsule3DPosition.getY() + capsule3DHalfLength * capsule3DAxis.getY();
        double topCenterZ = capsule3DPosition.getZ() + capsule3DHalfLength * capsule3DAxis.getZ();
        double bottomCenterX = capsule3DPosition.getX() - capsule3DHalfLength * capsule3DAxis.getX();
        double bottomCenterY = capsule3DPosition.getY() - capsule3DHalfLength * capsule3DAxis.getY();
        double bottomCenterZ = capsule3DPosition.getZ() - capsule3DHalfLength * capsule3DAxis.getZ();
        double distanceSquared = EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D((double)query.getX(), (double)query.getY(), (double)query.getZ(), (double)topCenterX, (double)topCenterY, (double)topCenterZ, (double)bottomCenterX, (double)bottomCenterY, (double)bottomCenterZ);
        return distanceSquared <= (upsizedRadius = capsule3DRadius + epsilon) * upsizedRadius;
    }

    public static double signedDistanceBetweenPoint3DAndCapsule3D(Point3DReadOnly query, Point3DReadOnly capsule3DPosition, Vector3DReadOnly capsule3DAxis, double capsule3DLength, double capsule3DRadius) {
        double capsuleHalfLength = 0.5 * capsule3DLength;
        double topCenterX = capsule3DPosition.getX() + capsuleHalfLength * capsule3DAxis.getX();
        double topCenterY = capsule3DPosition.getY() + capsuleHalfLength * capsule3DAxis.getY();
        double topCenterZ = capsule3DPosition.getZ() + capsuleHalfLength * capsule3DAxis.getZ();
        double bottomCenterX = capsule3DPosition.getX() - capsuleHalfLength * capsule3DAxis.getX();
        double bottomCenterY = capsule3DPosition.getY() - capsuleHalfLength * capsule3DAxis.getY();
        double bottomCenterZ = capsule3DPosition.getZ() - capsuleHalfLength * capsule3DAxis.getZ();
        double distanceFromAxis = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((double)query.getX(), (double)query.getY(), (double)query.getZ(), (double)topCenterX, (double)topCenterY, (double)topCenterZ, (double)bottomCenterX, (double)bottomCenterY, (double)bottomCenterZ);
        return distanceFromAxis - capsule3DRadius;
    }

    public static boolean orthogonalProjectionOntoCapsule3D(Point3DReadOnly pointToProject, Point3DReadOnly capsule3DPosition, Vector3DReadOnly capsule3DAxis, double capsule3DLength, double capsule3DRadius, Point3DBasics projectionToPack) {
        double bottomCenterZ;
        double bottomCenterY;
        if (capsule3DRadius <= 0.0) {
            projectionToPack.setToNaN();
            return false;
        }
        if (capsule3DLength < 0.0) {
            projectionToPack.setToNaN();
            return false;
        }
        if (capsule3DLength == 0.0) {
            double distanceSquaredFromCenter = capsule3DPosition.distanceSquared(pointToProject);
            if (distanceSquaredFromCenter <= capsule3DRadius * capsule3DRadius) {
                return false;
            }
            projectionToPack.sub((Tuple3DReadOnly)pointToProject, (Tuple3DReadOnly)capsule3DPosition);
            projectionToPack.scale(capsule3DRadius / EuclidCoreTools.squareRoot((double)distanceSquaredFromCenter));
            projectionToPack.add((Tuple3DReadOnly)capsule3DPosition);
            return true;
        }
        double capsule3DHalfLength = 0.5 * capsule3DLength;
        double percentageOnAxis = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)capsule3DPosition, (Vector3DReadOnly)capsule3DAxis);
        if (Math.abs(percentageOnAxis) < capsule3DHalfLength) {
            double projectionOnAxisZ;
            double projectionOnAxisY;
            double projectionOnAxisX = capsule3DPosition.getX() + percentageOnAxis * capsule3DAxis.getX();
            double distanceSquaredFromAxis = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)projectionOnAxisX, (double)(projectionOnAxisY = capsule3DPosition.getY() + percentageOnAxis * capsule3DAxis.getY()), (double)(projectionOnAxisZ = capsule3DPosition.getZ() + percentageOnAxis * capsule3DAxis.getZ()), (Point3DReadOnly)pointToProject);
            if (distanceSquaredFromAxis <= capsule3DRadius * capsule3DRadius) {
                return false;
            }
            projectionToPack.set((Tuple3DReadOnly)pointToProject);
            projectionToPack.sub(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
            projectionToPack.scale(capsule3DRadius / EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis));
            projectionToPack.add(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
            return true;
        }
        if (percentageOnAxis > 0.0) {
            double topCenterZ;
            double topCenterY;
            double topCenterX = capsule3DPosition.getX() + capsule3DHalfLength * capsule3DAxis.getX();
            double distanceSquaredFromTopCenter = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)topCenterX, (double)(topCenterY = capsule3DPosition.getY() + capsule3DHalfLength * capsule3DAxis.getY()), (double)(topCenterZ = capsule3DPosition.getZ() + capsule3DHalfLength * capsule3DAxis.getZ()), (Point3DReadOnly)pointToProject);
            if (distanceSquaredFromTopCenter <= capsule3DRadius * capsule3DRadius) {
                return false;
            }
            projectionToPack.set((Tuple3DReadOnly)pointToProject);
            projectionToPack.sub(topCenterX, topCenterY, topCenterZ);
            projectionToPack.scale(capsule3DRadius / EuclidCoreTools.squareRoot((double)distanceSquaredFromTopCenter));
            projectionToPack.add(topCenterX, topCenterY, topCenterZ);
            return true;
        }
        double bottomCenterX = capsule3DPosition.getX() - capsule3DHalfLength * capsule3DAxis.getX();
        double distanceSquaredFromBottomCenter = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)bottomCenterX, (double)(bottomCenterY = capsule3DPosition.getY() - capsule3DHalfLength * capsule3DAxis.getY()), (double)(bottomCenterZ = capsule3DPosition.getZ() - capsule3DHalfLength * capsule3DAxis.getZ()), (Point3DReadOnly)pointToProject);
        if (distanceSquaredFromBottomCenter <= capsule3DRadius * capsule3DRadius) {
            return false;
        }
        projectionToPack.set((Tuple3DReadOnly)pointToProject);
        projectionToPack.sub(bottomCenterX, bottomCenterY, bottomCenterZ);
        projectionToPack.scale(capsule3DRadius / EuclidCoreTools.squareRoot((double)distanceSquaredFromBottomCenter));
        projectionToPack.add(bottomCenterX, bottomCenterY, bottomCenterZ);
        return true;
    }

    public static void supportingVertexCapsule3D(Vector3DReadOnly supportDirection, Point3DReadOnly capsule3DPosition, Vector3DReadOnly capsule3DAxis, double capsule3DLength, double capsule3DRadius, Point3DBasics supportingVertexToPack) {
        double dot = supportDirection.dot((Tuple3DReadOnly)capsule3DAxis);
        double capsule3DHalfLength = dot > 0.0 ? 0.5 * capsule3DLength : -0.5 * capsule3DLength;
        supportingVertexToPack.setAndScale(capsule3DRadius / supportDirection.norm(), (Tuple3DReadOnly)supportDirection);
        supportingVertexToPack.add((Tuple3DReadOnly)capsule3DPosition);
        supportingVertexToPack.scaleAdd(capsule3DHalfLength / capsule3DAxis.norm(), (Tuple3DReadOnly)capsule3DAxis, (Tuple3DReadOnly)supportingVertexToPack);
    }

    public static void boundingBoxCapsule3D(Point3DReadOnly capsule3DPosition, Vector3DReadOnly capsule3DAxis, double capsule3DLength, double capsule3DRadius, BoundingBox3DBasics boundingBoxToPack) {
        double capsule3DHalfLength = 0.5 * capsule3DLength;
        double maxX = Math.abs(capsule3DHalfLength * capsule3DAxis.getX()) + capsule3DRadius;
        double maxY = Math.abs(capsule3DHalfLength * capsule3DAxis.getY()) + capsule3DRadius;
        double maxZ = Math.abs(capsule3DHalfLength * capsule3DAxis.getZ()) + capsule3DRadius;
        double minX = -maxX + capsule3DPosition.getX();
        double minY = -maxY + capsule3DPosition.getY();
        double minZ = -maxZ + capsule3DPosition.getZ();
        boundingBoxToPack.set(minX, minY, minZ, maxX += capsule3DPosition.getX(), maxY += capsule3DPosition.getY(), maxZ += capsule3DPosition.getZ());
    }

    public static double evaluatePoint3DCapsule3DCollision(Point3DReadOnly query, Point3DReadOnly capsule3DPosition, Vector3DReadOnly capsule3DAxis, double capsule3DLength, double capsule3DRadius, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalToPack) {
        if (capsule3DRadius <= 0.0) {
            closestPointOnSurfaceToPack.setToNaN();
            normalToPack.setToNaN();
            return Double.NaN;
        }
        if (capsule3DLength < 0.0) {
            closestPointOnSurfaceToPack.setToNaN();
            normalToPack.setToNaN();
            return Double.NaN;
        }
        if (capsule3DLength == 0.0) {
            return EuclidShapeTools.evaluatePoint3DSphere3DCollision(query, capsule3DPosition, capsule3DRadius, closestPointOnSurfaceToPack, normalToPack);
        }
        double capsule3DHalfLength = 0.5 * capsule3DLength;
        double percentageOnAxis = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)query, (Point3DReadOnly)capsule3DPosition, (Vector3DReadOnly)capsule3DAxis);
        if (percentageOnAxis > capsule3DHalfLength) {
            percentageOnAxis = capsule3DHalfLength;
        } else if (percentageOnAxis < -capsule3DHalfLength) {
            percentageOnAxis = -capsule3DHalfLength;
        }
        double projectionOnAxisX = capsule3DPosition.getX() + percentageOnAxis * capsule3DAxis.getX();
        double projectionOnAxisY = capsule3DPosition.getY() + percentageOnAxis * capsule3DAxis.getY();
        double projectionOnAxisZ = capsule3DPosition.getZ() + percentageOnAxis * capsule3DAxis.getZ();
        double distanceSquaredFromAxisClosest = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)projectionOnAxisX, (double)projectionOnAxisY, (double)projectionOnAxisZ, (Point3DReadOnly)query);
        if (distanceSquaredFromAxisClosest < 1.0E-12) {
            if (Math.abs(capsule3DAxis.getY()) > 0.1 || Math.abs(capsule3DAxis.getZ()) > 0.1) {
                normalToPack.set(1.0, 0.0, 0.0);
            } else {
                normalToPack.set(0.0, 1.0, 0.0);
            }
            normalToPack.cross((Tuple3DReadOnly)capsule3DAxis);
            normalToPack.normalize();
            closestPointOnSurfaceToPack.setAndScale(capsule3DRadius, (Tuple3DReadOnly)normalToPack);
            closestPointOnSurfaceToPack.add(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
            return -capsule3DRadius;
        }
        double distanceFromAxisClosest = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxisClosest);
        normalToPack.set((Tuple3DReadOnly)query);
        normalToPack.sub(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
        normalToPack.scale(1.0 / distanceFromAxisClosest);
        closestPointOnSurfaceToPack.setAndScale(capsule3DRadius, (Tuple3DReadOnly)normalToPack);
        closestPointOnSurfaceToPack.add(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
        return distanceFromAxisClosest - capsule3DRadius;
    }

    public static boolean isPoint3DInsideCylinder3D(Point3DReadOnly query, Point3DReadOnly cylinder3DPosition, Vector3DReadOnly cylinder3DAxis, double cylinder3DLength, double cylinder3DRadius, double epsilon) {
        double radiusWithEpsilon;
        double projectionOnAxisZ;
        double projectionOnAxisY;
        double positionOnAxis = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)query, (Point3DReadOnly)cylinder3DPosition, (Vector3DReadOnly)cylinder3DAxis);
        double halfLengthPlusEpsilon = 0.5 * cylinder3DLength + epsilon;
        if (Math.abs(positionOnAxis) > halfLengthPlusEpsilon) {
            return false;
        }
        double projectionOnAxisX = cylinder3DPosition.getX() + positionOnAxis * cylinder3DAxis.getX();
        double distanceSquaredFromAxis = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)projectionOnAxisX, (double)(projectionOnAxisY = cylinder3DPosition.getY() + positionOnAxis * cylinder3DAxis.getY()), (double)(projectionOnAxisZ = cylinder3DPosition.getZ() + positionOnAxis * cylinder3DAxis.getZ()), (Point3DReadOnly)query);
        return distanceSquaredFromAxis <= (radiusWithEpsilon = cylinder3DRadius + epsilon) * radiusWithEpsilon;
    }

    public static double signedDistanceBetweenPoint3DAndCylinder3D(Point3DReadOnly query, Point3DReadOnly cylinder3DPosition, Vector3DReadOnly cylinder3DAxis, double cylinder3DLength, double cylinder3DRadius) {
        if (cylinder3DRadius <= 0.0 || cylinder3DLength <= 0.0) {
            return Double.NaN;
        }
        double positionOnAxis = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)query, (Point3DReadOnly)cylinder3DPosition, (Vector3DReadOnly)cylinder3DAxis);
        double axisToQueryX = query.getX() - (cylinder3DPosition.getX() + positionOnAxis * cylinder3DAxis.getX());
        double axisToQueryY = query.getY() - (cylinder3DPosition.getY() + positionOnAxis * cylinder3DAxis.getY());
        double axisToQueryZ = query.getZ() - (cylinder3DPosition.getZ() + positionOnAxis * cylinder3DAxis.getZ());
        double distanceSquaredFromAxis = EuclidCoreTools.normSquared((double)axisToQueryX, (double)axisToQueryY, (double)axisToQueryZ);
        double halfLength = 0.5 * cylinder3DLength;
        if (distanceSquaredFromAxis <= cylinder3DRadius * cylinder3DRadius) {
            double dr;
            if (positionOnAxis < -halfLength) {
                return -(positionOnAxis + halfLength);
            }
            if (positionOnAxis > halfLength) {
                return positionOnAxis - halfLength;
            }
            double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
            double dh = halfLength - Math.abs(positionOnAxis);
            if (dh < (dr = cylinder3DRadius - distanceFromAxis)) {
                if (positionOnAxis < 0.0) {
                    return -(positionOnAxis + halfLength);
                }
                return positionOnAxis - halfLength;
            }
            return distanceFromAxis - cylinder3DRadius;
        }
        double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
        double positionOnAxisClamped = positionOnAxis;
        if (positionOnAxisClamped < -halfLength) {
            positionOnAxisClamped = -halfLength;
        } else if (positionOnAxisClamped > halfLength) {
            positionOnAxisClamped = halfLength;
        }
        if (positionOnAxisClamped != positionOnAxis) {
            double projectionOnAxisXClamped = cylinder3DPosition.getX() + positionOnAxisClamped * cylinder3DAxis.getX();
            double projectionOnAxisYClamped = cylinder3DPosition.getY() + positionOnAxisClamped * cylinder3DAxis.getY();
            double projectionOnAxisZClamped = cylinder3DPosition.getZ() + positionOnAxisClamped * cylinder3DAxis.getZ();
            double toCylinderScale = cylinder3DRadius / distanceFromAxis;
            double closestX = axisToQueryX * toCylinderScale + projectionOnAxisXClamped;
            double closestY = axisToQueryY * toCylinderScale + projectionOnAxisYClamped;
            double closestZ = axisToQueryZ * toCylinderScale + projectionOnAxisZClamped;
            return EuclidGeometryTools.distanceBetweenPoint3Ds((double)closestX, (double)closestY, (double)closestZ, (Point3DReadOnly)query);
        }
        return distanceFromAxis - cylinder3DRadius;
    }

    public static boolean orthogonalProjectionOntoCylinder3D(Point3DReadOnly pointToProject, Point3DReadOnly cylinder3DPosition, Vector3DReadOnly cylinder3DAxis, double cylinder3DLength, double cylinder3DRadius, Point3DBasics projectionToPack) {
        if (cylinder3DRadius <= 0.0 || cylinder3DLength <= 0.0) {
            projectionToPack.setToNaN();
            return false;
        }
        double positionOnAxis = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)cylinder3DPosition, (Vector3DReadOnly)cylinder3DAxis);
        double projectionOnAxisX = cylinder3DPosition.getX() + positionOnAxis * cylinder3DAxis.getX();
        double projectionOnAxisY = cylinder3DPosition.getY() + positionOnAxis * cylinder3DAxis.getY();
        double projectionOnAxisZ = cylinder3DPosition.getZ() + positionOnAxis * cylinder3DAxis.getZ();
        double axisToQueryX = pointToProject.getX() - projectionOnAxisX;
        double axisToQueryY = pointToProject.getY() - projectionOnAxisY;
        double axisToQueryZ = pointToProject.getZ() - projectionOnAxisZ;
        double distanceSquaredFromAxis = EuclidCoreTools.normSquared((double)axisToQueryX, (double)axisToQueryY, (double)axisToQueryZ);
        double halfLength = 0.5 * cylinder3DLength;
        if (distanceSquaredFromAxis <= cylinder3DRadius * cylinder3DRadius) {
            if (positionOnAxis < -halfLength) {
                projectionToPack.scaleAdd(-positionOnAxis - halfLength, (Tuple3DReadOnly)cylinder3DAxis, (Tuple3DReadOnly)pointToProject);
                return true;
            }
            if (positionOnAxis > halfLength) {
                projectionToPack.scaleAdd(-positionOnAxis + halfLength, (Tuple3DReadOnly)cylinder3DAxis, (Tuple3DReadOnly)pointToProject);
                return true;
            }
            return false;
        }
        double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
        double positionOnAxisClamped = positionOnAxis;
        if (positionOnAxisClamped < -halfLength) {
            positionOnAxisClamped = -halfLength;
        } else if (positionOnAxisClamped > halfLength) {
            positionOnAxisClamped = halfLength;
        }
        if (positionOnAxisClamped != positionOnAxis) {
            double projectionOnAxisXClamped = cylinder3DPosition.getX() + positionOnAxisClamped * cylinder3DAxis.getX();
            double projectionOnAxisYClamped = cylinder3DPosition.getY() + positionOnAxisClamped * cylinder3DAxis.getY();
            double projectionOnAxisZClamped = cylinder3DPosition.getZ() + positionOnAxisClamped * cylinder3DAxis.getZ();
            double toCylinderScale = cylinder3DRadius / distanceFromAxis;
            double closestX = axisToQueryX * toCylinderScale + projectionOnAxisXClamped;
            double closestY = axisToQueryY * toCylinderScale + projectionOnAxisYClamped;
            double closestZ = axisToQueryZ * toCylinderScale + projectionOnAxisZClamped;
            projectionToPack.set(closestX, closestY, closestZ);
            return true;
        }
        projectionToPack.set(axisToQueryX, axisToQueryY, axisToQueryZ);
        projectionToPack.scale(cylinder3DRadius / distanceFromAxis);
        projectionToPack.add(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
        return true;
    }

    public static void supportingVertexCylinder3D(Vector3DReadOnly supportDirection, Point3DReadOnly cylinder3DPosition, Vector3DReadOnly cylinder3DAxis, double cylinder3DLength, double cylinder3DRadius, Point3DBasics supportingVertexToPack) {
        supportingVertexToPack.set((Tuple3DReadOnly)supportDirection);
        double axisNormInverse = 1.0 / cylinder3DAxis.norm();
        double dot = supportDirection.dot((Tuple3DReadOnly)cylinder3DAxis) * axisNormInverse;
        supportingVertexToPack.setAndScale(dot * axisNormInverse, (Tuple3DReadOnly)cylinder3DAxis);
        supportingVertexToPack.sub((Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertexToPack);
        double distanceSquaredFromAxis = supportingVertexToPack.distanceFromOriginSquared();
        if (distanceSquaredFromAxis < 1.0E-12) {
            supportingVertexToPack.set((Tuple3DReadOnly)cylinder3DPosition);
        } else {
            supportingVertexToPack.scale(cylinder3DRadius / EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis));
            supportingVertexToPack.add((Tuple3DReadOnly)cylinder3DPosition);
        }
        double cylinder3DHalfLength = dot > 0.0 ? 0.5 * cylinder3DLength : -0.5 * cylinder3DLength;
        supportingVertexToPack.scaleAdd(cylinder3DHalfLength * axisNormInverse, (Tuple3DReadOnly)cylinder3DAxis, (Tuple3DReadOnly)supportingVertexToPack);
    }

    public static void boundingBoxCylinder3D(Point3DReadOnly cylinder3DPosition, Vector3DReadOnly cylinder3DAxis, double cylinder3DLength, double cylinder3DRadius, BoundingBox3DBasics boundingBoxToPack) {
        double cylinder3DHalfLength = 0.5 * cylinder3DLength;
        double invNormSquared = 1.0 / cylinder3DAxis.normSquared();
        double capMinMaxX = Math.max(0.0, cylinder3DRadius * EuclidCoreTools.squareRoot((double)(1.0 - cylinder3DAxis.getX() * cylinder3DAxis.getX() * invNormSquared)));
        double capMinMaxY = Math.max(0.0, cylinder3DRadius * EuclidCoreTools.squareRoot((double)(1.0 - cylinder3DAxis.getY() * cylinder3DAxis.getY() * invNormSquared)));
        double capMinMaxZ = Math.max(0.0, cylinder3DRadius * EuclidCoreTools.squareRoot((double)(1.0 - cylinder3DAxis.getZ() * cylinder3DAxis.getZ() * invNormSquared)));
        double maxX = Math.abs(cylinder3DHalfLength * cylinder3DAxis.getX()) + capMinMaxX;
        double maxY = Math.abs(cylinder3DHalfLength * cylinder3DAxis.getY()) + capMinMaxY;
        double maxZ = Math.abs(cylinder3DHalfLength * cylinder3DAxis.getZ()) + capMinMaxZ;
        double minX = -maxX + cylinder3DPosition.getX();
        double minY = -maxY + cylinder3DPosition.getY();
        double minZ = -maxZ + cylinder3DPosition.getZ();
        boundingBoxToPack.set(minX, minY, minZ, maxX += cylinder3DPosition.getX(), maxY += cylinder3DPosition.getY(), maxZ += cylinder3DPosition.getZ());
    }

    public static double evaluatePoint3DCylinder3DCollision(Point3DReadOnly query, Point3DReadOnly cylinder3DPosition, Vector3DReadOnly cylinder3DAxis, double cylinder3DLength, double cylinder3DRadius, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalToPack) {
        if (cylinder3DRadius <= 0.0 || cylinder3DLength <= 0.0) {
            closestPointOnSurfaceToPack.setToNaN();
            normalToPack.setToNaN();
            return Double.NaN;
        }
        double positionOnAxis = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)query, (Point3DReadOnly)cylinder3DPosition, (Vector3DReadOnly)cylinder3DAxis);
        double projectionOnAxisX = cylinder3DPosition.getX() + positionOnAxis * cylinder3DAxis.getX();
        double projectionOnAxisY = cylinder3DPosition.getY() + positionOnAxis * cylinder3DAxis.getY();
        double projectionOnAxisZ = cylinder3DPosition.getZ() + positionOnAxis * cylinder3DAxis.getZ();
        double axisToQueryX = query.getX() - projectionOnAxisX;
        double axisToQueryY = query.getY() - projectionOnAxisY;
        double axisToQueryZ = query.getZ() - projectionOnAxisZ;
        double distanceSquaredFromAxis = EuclidCoreTools.normSquared((double)axisToQueryX, (double)axisToQueryY, (double)axisToQueryZ);
        double halfLength = 0.5 * cylinder3DLength;
        if (distanceSquaredFromAxis <= cylinder3DRadius * cylinder3DRadius) {
            double dr;
            if (positionOnAxis < -halfLength) {
                closestPointOnSurfaceToPack.scaleAdd(-positionOnAxis - halfLength, (Tuple3DReadOnly)cylinder3DAxis, (Tuple3DReadOnly)query);
                normalToPack.setAndNegate((Tuple3DReadOnly)cylinder3DAxis);
                return -(positionOnAxis + halfLength);
            }
            if (positionOnAxis > halfLength) {
                closestPointOnSurfaceToPack.scaleAdd(-positionOnAxis + halfLength, (Tuple3DReadOnly)cylinder3DAxis, (Tuple3DReadOnly)query);
                normalToPack.set((Tuple3DReadOnly)cylinder3DAxis);
                return positionOnAxis - halfLength;
            }
            double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
            double dh = halfLength - Math.abs(positionOnAxis);
            if (dh < (dr = cylinder3DRadius - distanceFromAxis)) {
                if (positionOnAxis < 0.0) {
                    closestPointOnSurfaceToPack.scaleAdd(-positionOnAxis - halfLength, (Tuple3DReadOnly)cylinder3DAxis, (Tuple3DReadOnly)query);
                    normalToPack.setAndNegate((Tuple3DReadOnly)cylinder3DAxis);
                    return -(positionOnAxis + halfLength);
                }
                closestPointOnSurfaceToPack.scaleAdd(-positionOnAxis + halfLength, (Tuple3DReadOnly)cylinder3DAxis, (Tuple3DReadOnly)query);
                normalToPack.set((Tuple3DReadOnly)cylinder3DAxis);
                return positionOnAxis - halfLength;
            }
            if (distanceSquaredFromAxis < 1.0E-12) {
                if (Math.abs(cylinder3DAxis.getY()) > 0.1 || Math.abs(cylinder3DAxis.getZ()) > 0.1) {
                    normalToPack.set(1.0, 0.0, 0.0);
                } else {
                    normalToPack.set(0.0, 1.0, 0.0);
                }
                normalToPack.cross((Tuple3DReadOnly)cylinder3DAxis);
                normalToPack.normalize();
                closestPointOnSurfaceToPack.setAndScale(cylinder3DRadius, (Tuple3DReadOnly)normalToPack);
                closestPointOnSurfaceToPack.add(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
                return -cylinder3DRadius;
            }
            normalToPack.set(axisToQueryX, axisToQueryY, axisToQueryZ);
            normalToPack.scale(1.0 / distanceFromAxis);
            closestPointOnSurfaceToPack.setAndScale(cylinder3DRadius, (Tuple3DReadOnly)normalToPack);
            closestPointOnSurfaceToPack.add(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
            return distanceFromAxis - cylinder3DRadius;
        }
        double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
        double positionOnAxisClamped = positionOnAxis;
        if (positionOnAxisClamped < -halfLength) {
            positionOnAxisClamped = -halfLength;
        } else if (positionOnAxisClamped > halfLength) {
            positionOnAxisClamped = halfLength;
        }
        if (positionOnAxisClamped != positionOnAxis) {
            double projectionOnAxisXClamped = cylinder3DPosition.getX() + positionOnAxisClamped * cylinder3DAxis.getX();
            double projectionOnAxisYClamped = cylinder3DPosition.getY() + positionOnAxisClamped * cylinder3DAxis.getY();
            double projectionOnAxisZClamped = cylinder3DPosition.getZ() + positionOnAxisClamped * cylinder3DAxis.getZ();
            double toCylinderScale = cylinder3DRadius / distanceFromAxis;
            double closestX = axisToQueryX * toCylinderScale + projectionOnAxisXClamped;
            double closestY = axisToQueryY * toCylinderScale + projectionOnAxisYClamped;
            double closestZ = axisToQueryZ * toCylinderScale + projectionOnAxisZClamped;
            double dX = query.getX() - closestX;
            double dY = query.getY() - closestY;
            double dZ = query.getZ() - closestZ;
            double distance = EuclidCoreTools.norm((double)dX, (double)dY, (double)dZ);
            closestPointOnSurfaceToPack.set(closestX, closestY, closestZ);
            if (distance < 1.0E-12) {
                if (positionOnAxis > 0.0) {
                    normalToPack.set((Tuple3DReadOnly)cylinder3DAxis);
                } else {
                    normalToPack.setAndNegate((Tuple3DReadOnly)cylinder3DAxis);
                }
            } else {
                normalToPack.set(dX, dY, dZ);
                normalToPack.scale(1.0 / distance);
            }
            return distance;
        }
        normalToPack.set(axisToQueryX, axisToQueryY, axisToQueryZ);
        normalToPack.scale(1.0 / distanceFromAxis);
        closestPointOnSurfaceToPack.setAndScale(cylinder3DRadius, (Tuple3DReadOnly)normalToPack);
        closestPointOnSurfaceToPack.add(projectionOnAxisX, projectionOnAxisY, projectionOnAxisZ);
        return distanceFromAxis - cylinder3DRadius;
    }

    public static boolean isPoint3DInsideEllipsoid3D(Point3DReadOnly query, Vector3DReadOnly ellipsoid3DRadii, double epsilon) {
        double scaledZ;
        double scaledY;
        double scaledX = query.getX() / (ellipsoid3DRadii.getX() + epsilon);
        return EuclidCoreTools.normSquared((double)scaledX, (double)(scaledY = query.getY() / (ellipsoid3DRadii.getY() + epsilon)), (double)(scaledZ = query.getZ() / (ellipsoid3DRadii.getZ() + epsilon))) <= 1.0;
    }

    public static double signedDistanceBetweenPoint3DAndEllipsoid3D(Point3DReadOnly query, Vector3DReadOnly ellipsoid3DRadii) {
        double xRadius = ellipsoid3DRadii.getX();
        double yRadius = ellipsoid3DRadii.getY();
        double zRadius = ellipsoid3DRadii.getZ();
        double scaleFactor = 1.0 / EuclidCoreTools.norm((double)(query.getX() / xRadius), (double)(query.getY() / yRadius), (double)(query.getZ() / zRadius));
        return query.distanceFromOrigin() * (1.0 - scaleFactor);
    }

    public static boolean orthogonalProjectionOntoEllipsoid3D(Point3DReadOnly pointToProject, Vector3DReadOnly ellipsoid3DRadii, Point3DBasics projectionToPack) {
        double distance = EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D(ellipsoid3DRadii, pointToProject, projectionToPack);
        return distance > 0.0;
    }

    public static void supportingVertexEllipsoid3D(Vector3DReadOnly supportDirection, Vector3DReadOnly ellipsoid3DRadii, Point3DBasics supportingVertexToPack) {
        double nx = supportDirection.getX();
        double ny = supportDirection.getY();
        double nz = supportDirection.getZ();
        double nLength = EuclidCoreTools.norm((double)nx, (double)ny, (double)nz);
        supportingVertexToPack.set(nx *= ellipsoid3DRadii.getX() / nLength, ny *= ellipsoid3DRadii.getY() / nLength, nz *= ellipsoid3DRadii.getZ() / nLength);
        supportingVertexToPack.scale(ellipsoid3DRadii.getX(), ellipsoid3DRadii.getY(), ellipsoid3DRadii.getZ());
        supportingVertexToPack.scale(1.0 / EuclidCoreTools.norm((double)nx, (double)ny, (double)nz));
    }

    public static void boundingBoxEllipsoid3D(Point3DReadOnly ellipsoid3DPosition, RotationMatrixReadOnly ellipsoid3DOrientation, Vector3DReadOnly ellipsoid3DRadii, BoundingBox3DBasics boundingBoxToPack) {
        double zRange;
        double yRange;
        double xRange;
        if (ellipsoid3DOrientation.isIdentity()) {
            xRange = ellipsoid3DRadii.getX();
            yRange = ellipsoid3DRadii.getY();
            zRange = ellipsoid3DRadii.getZ();
        } else {
            double m00 = ellipsoid3DOrientation.getM00() * ellipsoid3DOrientation.getM00();
            double m01 = ellipsoid3DOrientation.getM01() * ellipsoid3DOrientation.getM01();
            double m02 = ellipsoid3DOrientation.getM02() * ellipsoid3DOrientation.getM02();
            double m10 = ellipsoid3DOrientation.getM10() * ellipsoid3DOrientation.getM10();
            double m11 = ellipsoid3DOrientation.getM11() * ellipsoid3DOrientation.getM11();
            double m12 = ellipsoid3DOrientation.getM12() * ellipsoid3DOrientation.getM12();
            double m20 = ellipsoid3DOrientation.getM20() * ellipsoid3DOrientation.getM20();
            double m21 = ellipsoid3DOrientation.getM21() * ellipsoid3DOrientation.getM21();
            double m22 = ellipsoid3DOrientation.getM22() * ellipsoid3DOrientation.getM22();
            double rx = ellipsoid3DRadii.getX() * ellipsoid3DRadii.getX();
            double ry = ellipsoid3DRadii.getY() * ellipsoid3DRadii.getY();
            double rz = ellipsoid3DRadii.getZ() * ellipsoid3DRadii.getZ();
            xRange = EuclidCoreTools.squareRoot((double)(m00 * rx + m01 * ry + m02 * rz));
            yRange = EuclidCoreTools.squareRoot((double)(m10 * rx + m11 * ry + m12 * rz));
            zRange = EuclidCoreTools.squareRoot((double)(m20 * rx + m21 * ry + m22 * rz));
        }
        double maxX = ellipsoid3DPosition.getX() + xRange;
        double maxY = ellipsoid3DPosition.getY() + yRange;
        double maxZ = ellipsoid3DPosition.getZ() + zRange;
        double minX = ellipsoid3DPosition.getX() - xRange;
        double minY = ellipsoid3DPosition.getY() - yRange;
        double minZ = ellipsoid3DPosition.getZ() - zRange;
        boundingBoxToPack.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static double evaluatePoint3DEllipsoid3DCollision(Point3DReadOnly query, Vector3DReadOnly ellipsoid3DRadii, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalToPack) {
        double distance = EuclidEllipsoid3DTools.distancePoint3DEllipsoid3D(ellipsoid3DRadii, query, closestPointOnSurfaceToPack);
        if (distance != 0.0) {
            normalToPack.sub((Tuple3DReadOnly)query, (Tuple3DReadOnly)closestPointOnSurfaceToPack);
            normalToPack.scale(1.0 / distance);
        } else {
            normalToPack.set((Tuple3DReadOnly)closestPointOnSurfaceToPack);
            double rxSquare = ellipsoid3DRadii.getX() * ellipsoid3DRadii.getX();
            double rySquare = ellipsoid3DRadii.getY() * ellipsoid3DRadii.getY();
            double rzSquare = ellipsoid3DRadii.getZ() * ellipsoid3DRadii.getZ();
            normalToPack.scale(1.0 / rxSquare, 1.0 / rySquare, 1.0 / rzSquare);
            normalToPack.normalize();
        }
        return distance;
    }

    public static double computeRamp3DLength(Vector3DReadOnly ramp3DSize) {
        return EuclidShapeTools.computeRamp3DLength(ramp3DSize.getX(), ramp3DSize.getZ());
    }

    public static double computeRamp3DLength(double ramp3DSizeX, double ramp3DSizeZ) {
        return EuclidCoreTools.norm((double)ramp3DSizeX, (double)ramp3DSizeZ);
    }

    public static double computeRamp3DIncline(Vector3DReadOnly ramp3DSize) {
        return EuclidShapeTools.computeRamp3DIncline(ramp3DSize.getX(), ramp3DSize.getZ());
    }

    public static double computeRamp3DIncline(double ramp3DSizeX, double ramp3DSizeZ) {
        return EuclidCoreTools.atan((double)(ramp3DSizeZ / ramp3DSizeX));
    }

    public static void computeRamp3DCentroid(Shape3DPoseReadOnly ramp3DPose, Vector3DReadOnly size, Point3DBasics centroidToPack) {
        double xLocal = 0.6666666666666666 * size.getX();
        double yLocal = 0.0;
        double zLocal = 0.3333333333333333 * size.getZ();
        if (ramp3DPose == null) {
            centroidToPack.set(xLocal, yLocal, zLocal);
        } else {
            if (ramp3DPose.hasRotation()) {
                RotationMatrixReadOnly ramp3DRotation = ramp3DPose.getRotation();
                xWorld = ramp3DRotation.getM00() * xLocal + ramp3DRotation.getM02() * zLocal;
                yWorld = ramp3DRotation.getM10() * xLocal + ramp3DRotation.getM12() * zLocal;
                zWorld = ramp3DRotation.getM20() * xLocal + ramp3DRotation.getM22() * zLocal;
            } else {
                xWorld = xLocal;
                yWorld = yLocal;
                zWorld = zLocal;
            }
            centroidToPack.set(xWorld += ramp3DPose.getTranslationX(), yWorld += ramp3DPose.getTranslationY(), zWorld += ramp3DPose.getTranslationZ());
        }
    }

    public static boolean isPoint3DInsideRamp3D(Point3DReadOnly query, Vector3DReadOnly ramp3DSize, double epsilon) {
        if (query.getZ() < -epsilon) {
            return false;
        }
        if (query.getX() > ramp3DSize.getX() + epsilon) {
            return false;
        }
        double halfWidth = 0.5 * ramp3DSize.getY() + epsilon;
        if (query.getY() < -halfWidth || query.getY() > halfWidth) {
            return false;
        }
        double rampLength = EuclidShapeTools.computeRamp3DLength(ramp3DSize);
        double rampDirectionX = ramp3DSize.getX() / rampLength;
        double rampDirectionZ = ramp3DSize.getZ() / rampLength;
        return rampDirectionX * query.getZ() - query.getX() * rampDirectionZ <= epsilon;
    }

    public static double signedDistanceBetweenPoint3DAndRamp3D(Point3DReadOnly query, Vector3DReadOnly ramp3DSize) {
        double rampLength = EuclidShapeTools.computeRamp3DLength(ramp3DSize);
        double rampDirectionX = ramp3DSize.getX() / rampLength;
        double rampDirectionZ = ramp3DSize.getZ() / rampLength;
        double rampNormalX = -rampDirectionZ;
        double rampNormalZ = rampDirectionX;
        double halfWidth = 0.5 * ramp3DSize.getY();
        if (query.getZ() < 0.0) {
            double xClosest = EuclidCoreTools.clamp((double)query.getX(), (double)0.0, (double)ramp3DSize.getX());
            double yClosest = EuclidCoreTools.clamp((double)query.getY(), (double)(-halfWidth), (double)halfWidth);
            double zClosest = 0.0;
            if (xClosest == query.getX() && yClosest == query.getY()) {
                return -query.getZ();
            }
            return EuclidGeometryTools.distanceBetweenPoint3Ds((double)xClosest, (double)yClosest, (double)zClosest, (Point3DReadOnly)query);
        }
        if (query.getX() > ramp3DSize.getX() || EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)query.getX(), (double)query.getZ(), (double)ramp3DSize.getX(), (double)ramp3DSize.getZ(), (double)rampNormalX, (double)rampNormalZ, (boolean)false)) {
            double xClosest = ramp3DSize.getX();
            double yClosest = EuclidCoreTools.clamp((double)query.getY(), (double)(-halfWidth), (double)halfWidth);
            double zClosest = EuclidCoreTools.clamp((double)query.getZ(), (double)0.0, (double)ramp3DSize.getZ());
            if (yClosest == query.getY() && zClosest == query.getZ()) {
                return query.getX() - ramp3DSize.getX();
            }
            return EuclidGeometryTools.distanceBetweenPoint3Ds((double)xClosest, (double)yClosest, (double)zClosest, (Point3DReadOnly)query);
        }
        if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)query.getX(), (double)query.getZ(), (double)0.0, (double)0.0, (double)rampNormalX, (double)rampNormalZ, (boolean)true)) {
            double xClosest = 0.0;
            double yClosest = EuclidCoreTools.clamp((double)query.getY(), (double)(-halfWidth), (double)halfWidth);
            double zClosest = 0.0;
            return EuclidGeometryTools.distanceBetweenPoint3Ds((double)xClosest, (double)yClosest, (double)zClosest, (Point3DReadOnly)query);
        }
        if (Math.abs(query.getY()) > halfWidth) {
            double yClosest = Math.copySign(halfWidth, query.getY());
            if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)query.getX(), (double)query.getZ(), (double)0.0, (double)0.0, (double)rampDirectionX, (double)rampDirectionZ, (boolean)false)) {
                return Math.abs(query.getY()) - halfWidth;
            }
            double dot = query.getX() * rampDirectionX + query.getZ() * rampDirectionZ;
            double xClosest = dot * rampDirectionX;
            double zClosest = dot * rampDirectionZ;
            return EuclidGeometryTools.distanceBetweenPoint3Ds((double)xClosest, (double)yClosest, (double)zClosest, (Point3DReadOnly)query);
        }
        if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)query.getX(), (double)query.getZ(), (double)0.0, (double)0.0, (double)rampDirectionX, (double)rampDirectionZ, (boolean)true)) {
            return rampDirectionX * query.getZ() - query.getX() * rampDirectionZ;
        }
        double distanceToRightFace = -(-halfWidth - query.getY());
        double distanceToLeftFace = halfWidth - query.getY();
        double distanceToRearFace = ramp3DSize.getX() - query.getX();
        double distanceToBottomFace = query.getZ();
        double distanceToSlopeFace = -(rampDirectionX * query.getZ() - query.getX() * rampDirectionZ);
        double minDistance = distanceToRightFace;
        if (minDistance > distanceToLeftFace) {
            minDistance = distanceToLeftFace;
        }
        if (minDistance > distanceToRearFace) {
            minDistance = distanceToRearFace;
        }
        if (minDistance > distanceToBottomFace) {
            minDistance = distanceToBottomFace;
        }
        if (minDistance > distanceToSlopeFace) {
            minDistance = distanceToSlopeFace;
        }
        return -minDistance;
    }

    public static boolean orthogonalProjectionOntoRamp3D(Point3DReadOnly pointToProject, Vector3DReadOnly ramp3DSize, Point3DBasics projectionToPack) {
        double rampLength = EuclidShapeTools.computeRamp3DLength(ramp3DSize);
        double rampDirectionX = ramp3DSize.getX() / rampLength;
        double rampDirectionZ = ramp3DSize.getZ() / rampLength;
        double rampNormalX = -rampDirectionZ;
        double rampNormalZ = rampDirectionX;
        double xQuery = pointToProject.getX();
        double yQuery = pointToProject.getY();
        double zQuery = pointToProject.getZ();
        double halfWidth = 0.5 * ramp3DSize.getY();
        if (zQuery < 0.0) {
            double xClosest = EuclidCoreTools.clamp((double)xQuery, (double)0.0, (double)ramp3DSize.getX());
            double yClosest = EuclidCoreTools.clamp((double)yQuery, (double)(-halfWidth), (double)halfWidth);
            double zClosest = 0.0;
            projectionToPack.set(xClosest, yClosest, zClosest);
            return true;
        }
        if (xQuery > ramp3DSize.getX() || EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)xQuery, (double)zQuery, (double)ramp3DSize.getX(), (double)ramp3DSize.getZ(), (double)rampNormalX, (double)rampNormalZ, (boolean)false)) {
            double xClosest = ramp3DSize.getX();
            double yClosest = EuclidCoreTools.clamp((double)yQuery, (double)(-halfWidth), (double)halfWidth);
            double zClosest = EuclidCoreTools.clamp((double)zQuery, (double)0.0, (double)ramp3DSize.getZ());
            projectionToPack.set(xClosest, yClosest, zClosest);
            return true;
        }
        if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)xQuery, (double)zQuery, (double)0.0, (double)0.0, (double)rampNormalX, (double)rampNormalZ, (boolean)true)) {
            double xClosest = 0.0;
            double yClosest = EuclidCoreTools.clamp((double)yQuery, (double)(-halfWidth), (double)halfWidth);
            double zClosest = 0.0;
            projectionToPack.set(xClosest, yClosest, zClosest);
            return true;
        }
        if (Math.abs(yQuery) > halfWidth) {
            double yClosest = Math.copySign(halfWidth, yQuery);
            if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)xQuery, (double)zQuery, (double)0.0, (double)0.0, (double)rampDirectionX, (double)rampDirectionZ, (boolean)false)) {
                double xClosest = xQuery;
                double zClosest = zQuery;
                projectionToPack.set(xClosest, yClosest, zClosest);
                return true;
            }
            double dot = xQuery * rampDirectionX + zQuery * rampDirectionZ;
            double xClosest = dot * rampDirectionX;
            double zClosest = dot * rampDirectionZ;
            projectionToPack.set(xClosest, yClosest, zClosest);
            return true;
        }
        if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)xQuery, (double)zQuery, (double)0.0, (double)0.0, (double)rampDirectionX, (double)rampDirectionZ, (boolean)true)) {
            double dot = xQuery * rampDirectionX + zQuery * rampDirectionZ;
            double xClosest = dot * rampDirectionX;
            double yClosest = yQuery;
            double zClosest = dot * rampDirectionZ;
            projectionToPack.set(xClosest, yClosest, zClosest);
            return true;
        }
        return false;
    }

    public static void supportingVectexRamp3D(Vector3DReadOnly supportDirection, Vector3DReadOnly ramp3DSize, Point3DBasics supportingVertexToPack) {
        if (supportDirection.getZ() < 0.0) {
            supportingVertexToPack.setX(supportDirection.getX() > 0.0 ? ramp3DSize.getX() : 0.0);
            supportingVertexToPack.setZ(0.0);
        } else if (supportDirection.getX() > 0.0) {
            supportingVertexToPack.setX(ramp3DSize.getX());
            supportingVertexToPack.setZ(supportDirection.getZ() > 0.0 ? ramp3DSize.getZ() : 0.0);
        } else {
            double rampInclineTanArgument;
            double directionInclineTanArgument = -supportDirection.getX() / supportDirection.getZ();
            if (directionInclineTanArgument > (rampInclineTanArgument = ramp3DSize.getZ() / ramp3DSize.getX())) {
                supportingVertexToPack.setX(0.0);
                supportingVertexToPack.setZ(0.0);
            } else {
                supportingVertexToPack.setX(ramp3DSize.getX());
                supportingVertexToPack.setZ(ramp3DSize.getZ());
            }
        }
        supportingVertexToPack.setY(supportDirection.getY() > 0.0 ? 0.5 * ramp3DSize.getY() : -0.5 * ramp3DSize.getY());
    }

    public static double evaluatePoint3DRamp3DCollision(Point3DReadOnly query, Vector3DReadOnly ramp3DSize, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalToPack) {
        double distanceToSlopeFace;
        double distanceToBottomFace;
        double rampLength = EuclidShapeTools.computeRamp3DLength(ramp3DSize);
        double rampDirectionX = ramp3DSize.getX() / rampLength;
        double rampDirectionZ = ramp3DSize.getZ() / rampLength;
        double rampNormalX = -rampDirectionZ;
        double rampNormalZ = rampDirectionX;
        double xLocalQuery = query.getX();
        double yLocalQuery = query.getY();
        double zLocalQuery = query.getZ();
        double halfWidth = 0.5 * ramp3DSize.getY();
        if (zLocalQuery < 0.0) {
            double xClosest = EuclidCoreTools.clamp((double)xLocalQuery, (double)0.0, (double)ramp3DSize.getX());
            double yClosest = EuclidCoreTools.clamp((double)yLocalQuery, (double)(-halfWidth), (double)halfWidth);
            double zClosest = 0.0;
            closestPointOnSurfaceToPack.set(xClosest, yClosest, zClosest);
            if (xClosest == xLocalQuery && yClosest == yLocalQuery) {
                normalToPack.setAndNegate((Tuple3DReadOnly)Axis3D.Z);
                return -zLocalQuery;
            }
            return EuclidShapeTools.computeNormalAndDistanceFromClosestPoint(xLocalQuery, yLocalQuery, zLocalQuery, xClosest, yClosest, zClosest, normalToPack);
        }
        if (xLocalQuery > ramp3DSize.getX() || EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)xLocalQuery, (double)zLocalQuery, (double)ramp3DSize.getX(), (double)ramp3DSize.getZ(), (double)rampNormalX, (double)rampNormalZ, (boolean)false)) {
            double xClosest = ramp3DSize.getX();
            double yClosest = EuclidCoreTools.clamp((double)yLocalQuery, (double)(-halfWidth), (double)halfWidth);
            double zClosest = EuclidCoreTools.clamp((double)zLocalQuery, (double)0.0, (double)ramp3DSize.getZ());
            closestPointOnSurfaceToPack.set(xClosest, yClosest, zClosest);
            if (yClosest == yLocalQuery && zClosest == zLocalQuery) {
                normalToPack.set((Tuple3DReadOnly)Axis3D.X);
                return xLocalQuery - ramp3DSize.getX();
            }
            return EuclidShapeTools.computeNormalAndDistanceFromClosestPoint(xLocalQuery, yLocalQuery, zLocalQuery, xClosest, yClosest, zClosest, normalToPack);
        }
        if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)xLocalQuery, (double)zLocalQuery, (double)0.0, (double)0.0, (double)rampNormalX, (double)rampNormalZ, (boolean)true)) {
            double xClosest = 0.0;
            double yClosest = EuclidCoreTools.clamp((double)yLocalQuery, (double)(-halfWidth), (double)halfWidth);
            double zClosest = 0.0;
            closestPointOnSurfaceToPack.set(xClosest, yClosest, zClosest);
            return EuclidShapeTools.computeNormalAndDistanceFromClosestPoint(xLocalQuery, yLocalQuery, zLocalQuery, xClosest, yClosest, zClosest, normalToPack);
        }
        if (Math.abs(yLocalQuery) > halfWidth) {
            double yClosest = Math.copySign(halfWidth, yLocalQuery);
            if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)xLocalQuery, (double)zLocalQuery, (double)0.0, (double)0.0, (double)rampDirectionX, (double)rampDirectionZ, (boolean)false)) {
                double xClosest = xLocalQuery;
                double zClosest = zLocalQuery;
                closestPointOnSurfaceToPack.set(xClosest, yClosest, zClosest);
                if (yLocalQuery >= 0.0) {
                    normalToPack.set((Tuple3DReadOnly)Axis3D.Y);
                } else {
                    normalToPack.setAndNegate((Tuple3DReadOnly)Axis3D.Y);
                }
                return Math.abs(yLocalQuery) - halfWidth;
            }
            double dot = xLocalQuery * rampDirectionX + zLocalQuery * rampDirectionZ;
            double xClosest = dot * rampDirectionX;
            double zClosest = dot * rampDirectionZ;
            closestPointOnSurfaceToPack.set(xClosest, yClosest, zClosest);
            return EuclidShapeTools.computeNormalAndDistanceFromClosestPoint(xLocalQuery, yLocalQuery, zLocalQuery, xClosest, yClosest, zClosest, normalToPack);
        }
        if (EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)xLocalQuery, (double)zLocalQuery, (double)0.0, (double)0.0, (double)rampDirectionX, (double)rampDirectionZ, (boolean)true)) {
            double dot = xLocalQuery * rampDirectionX + zLocalQuery * rampDirectionZ;
            double xClosest = dot * rampDirectionX;
            double yClosest = yLocalQuery;
            double zClosest = dot * rampDirectionZ;
            closestPointOnSurfaceToPack.set(xClosest, yClosest, zClosest);
            normalToPack.set(rampNormalX, 0.0, rampNormalZ);
            return rampDirectionX * zLocalQuery - xLocalQuery * rampDirectionZ;
        }
        double distanceToRightFace = -(-halfWidth - yLocalQuery);
        double distanceToLeftFace = halfWidth - yLocalQuery;
        double distanceToRearFace = ramp3DSize.getX() - xLocalQuery;
        if (EuclidShapeTools.isFirstValueMinimum(distanceToRightFace, distanceToLeftFace, distanceToRearFace, distanceToBottomFace = zLocalQuery, distanceToSlopeFace = -(rampDirectionX * zLocalQuery - xLocalQuery * rampDirectionZ))) {
            closestPointOnSurfaceToPack.set(xLocalQuery, -halfWidth, zLocalQuery);
            normalToPack.setAndNegate((Tuple3DReadOnly)Axis3D.Y);
            return -distanceToRightFace;
        }
        if (EuclidShapeTools.isFirstValueMinimum(distanceToLeftFace, distanceToRearFace, distanceToBottomFace, distanceToSlopeFace)) {
            closestPointOnSurfaceToPack.set(xLocalQuery, halfWidth, zLocalQuery);
            normalToPack.set((Tuple3DReadOnly)Axis3D.Y);
            return -distanceToLeftFace;
        }
        if (EuclidShapeTools.isFirstValueMinimum(distanceToRearFace, distanceToBottomFace, distanceToSlopeFace)) {
            closestPointOnSurfaceToPack.set(ramp3DSize.getX(), yLocalQuery, zLocalQuery);
            normalToPack.set((Tuple3DReadOnly)Axis3D.X);
            return -distanceToRearFace;
        }
        if (distanceToBottomFace <= distanceToSlopeFace) {
            closestPointOnSurfaceToPack.set(xLocalQuery, yLocalQuery, 0.0);
            normalToPack.setAndNegate((Tuple3DReadOnly)Axis3D.Z);
            return -distanceToBottomFace;
        }
        double dot = xLocalQuery * rampDirectionX + zLocalQuery * rampDirectionZ;
        double xClosest = dot * rampDirectionX;
        double yClosest = yLocalQuery;
        double zClosest = dot * rampDirectionZ;
        closestPointOnSurfaceToPack.set(xClosest, yClosest, zClosest);
        normalToPack.set(rampNormalX, 0.0, rampNormalZ);
        return -distanceToSlopeFace;
    }

    private static double computeNormalAndDistanceFromClosestPoint(double xLocalQuery, double yLocalQuery, double zLocalQuery, double xLocalClosest, double yLocalClosest, double zLocalClosest, Vector3DBasics normalToPack) {
        double dx = xLocalQuery - xLocalClosest;
        double dy = yLocalQuery - yLocalClosest;
        double dz = zLocalQuery - zLocalClosest;
        double distance = EuclidCoreTools.norm((double)dx, (double)dy, (double)dz);
        normalToPack.set(dx, dy, dz);
        normalToPack.scale(1.0 / distance);
        return distance;
    }

    public static boolean isFirstValueMinimum(double possibleMin, double value1, double value2, double value3, double value4) {
        return possibleMin <= value1 && possibleMin <= value2 && possibleMin <= value3 && possibleMin <= value4;
    }

    public static boolean isFirstValueMinimum(double possibleMin, double value1, double value2, double value3) {
        return possibleMin <= value1 && possibleMin <= value2 && possibleMin <= value3;
    }

    public static boolean isFirstValueMinimum(double possibleMin, double value1, double value2) {
        return possibleMin <= value1 && possibleMin <= value2;
    }

    public static boolean isFirstValueMaximum(double possibleMax, double value1, double value2, double value3, double value4) {
        return possibleMax >= value1 && possibleMax >= value2 && possibleMax >= value3 && possibleMax >= value4;
    }

    public static boolean isFirstValueMaximum(double possibleMax, double value1, double value2, double value3) {
        return possibleMax >= value1 && possibleMax >= value2 && possibleMax >= value3;
    }

    public static boolean isFirstValueMaximum(double possibleMax, double value1, double value2) {
        return possibleMax >= value1 && possibleMax >= value2;
    }

    public static boolean isPoint3DInsideSphere3D(Point3DReadOnly query, Point3DReadOnly sphere3DPosition, double sphere3DRadius, double epsilon) {
        double radiusWithEpsilon = sphere3DRadius + epsilon;
        return sphere3DPosition.distanceSquared(query) <= radiusWithEpsilon * radiusWithEpsilon;
    }

    public static double signedDistanceBetweenPoint3DAndSphere3D(Point3DReadOnly query, Point3DReadOnly sphere3DPosition, double sphere3DRadius) {
        return sphere3DPosition.distance(query) - sphere3DRadius;
    }

    public static boolean orthogonalProjectionOntoSphere3D(Point3DReadOnly pointToProject, Point3DReadOnly sphere3DPosition, double sphere3DRadius, Point3DBasics projectionToPack) {
        double distanceSquared = sphere3DPosition.distanceSquared(pointToProject);
        if (distanceSquared <= sphere3DRadius * sphere3DRadius) {
            return false;
        }
        projectionToPack.sub((Tuple3DReadOnly)pointToProject, (Tuple3DReadOnly)sphere3DPosition);
        projectionToPack.scale(sphere3DRadius / EuclidCoreTools.squareRoot((double)distanceSquared));
        projectionToPack.add((Tuple3DReadOnly)sphere3DPosition);
        return true;
    }

    public static void supportingVertexSphere3D(Vector3DReadOnly supportDirection, Point3DReadOnly sphere3DPosition, double sphere3DRadius, Point3DBasics supportingVertexToPack) {
        supportingVertexToPack.scaleAdd(sphere3DRadius / supportDirection.norm(), (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)sphere3DPosition);
    }

    public static double evaluatePoint3DSphere3DCollision(Point3DReadOnly query, Point3DReadOnly sphere3DPosition, double sphere3DRadius, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalToPack) {
        double distance = sphere3DPosition.distance(query);
        if (distance > 1.0E-12) {
            closestPointOnSurfaceToPack.sub((Tuple3DReadOnly)query, (Tuple3DReadOnly)sphere3DPosition);
            closestPointOnSurfaceToPack.scale(sphere3DRadius / distance);
            normalToPack.sub((Tuple3DReadOnly)query, (Tuple3DReadOnly)sphere3DPosition);
            normalToPack.scale(1.0 / distance);
        } else {
            closestPointOnSurfaceToPack.set(0.0, 0.0, sphere3DRadius);
            normalToPack.set(0.0, 0.0, 1.0);
        }
        closestPointOnSurfaceToPack.add((Tuple3DReadOnly)sphere3DPosition);
        return distance - sphere3DRadius;
    }

    public static boolean isPoint3DInsideTorus3D(Point3DReadOnly query, Point3DReadOnly torus3DPosition, Vector3DReadOnly torus3DAxis, double torus3DRadius, double torus3DTubeRadius, double epsilon) {
        double positionOnAxis = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)query, (Point3DReadOnly)torus3DPosition, (Vector3DReadOnly)torus3DAxis);
        double projectionOnAxisX = torus3DPosition.getX() + positionOnAxis * torus3DAxis.getX();
        double projectionOnAxisY = torus3DPosition.getY() + positionOnAxis * torus3DAxis.getY();
        double projectionOnAxisZ = torus3DPosition.getZ() + positionOnAxis * torus3DAxis.getZ();
        double distanceSquaredFromAxis = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)projectionOnAxisX, (double)projectionOnAxisY, (double)projectionOnAxisZ, (Point3DReadOnly)query);
        double tubeRadiusWithEpsilon = torus3DTubeRadius + epsilon;
        double outerRadius = torus3DRadius + tubeRadiusWithEpsilon;
        double innerRadius = torus3DRadius - tubeRadiusWithEpsilon;
        if (distanceSquaredFromAxis > outerRadius * outerRadius || distanceSquaredFromAxis < innerRadius * innerRadius) {
            return false;
        }
        double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
        return EuclidCoreTools.normSquared((double)(distanceFromAxis - torus3DRadius), (double)positionOnAxis) <= tubeRadiusWithEpsilon * tubeRadiusWithEpsilon;
    }

    public static double signedDistanceBetweenPoint3DAndTorus3D(Point3DReadOnly query, Point3DReadOnly torus3DPosition, Vector3DReadOnly torus3DAxis, double torus3DRadius, double torus3DTubeRadius) {
        double projectionOnAxisZ;
        double projectionOnAxisY;
        double torus3DPositionX = torus3DPosition.getX();
        double torus3DPositionY = torus3DPosition.getY();
        double torus3DPositionZ = torus3DPosition.getZ();
        double torus3DAxisX = torus3DAxis.getX();
        double torus3DAxisY = torus3DAxis.getY();
        double torus3DAxisZ = torus3DAxis.getZ();
        if (!(torus3DAxis instanceof UnitVector3DReadOnly)) {
            double normInverse = 1.0 / EuclidCoreTools.norm((double)torus3DAxisX, (double)torus3DAxisY, (double)torus3DAxisZ);
            torus3DAxisX *= normInverse;
            torus3DAxisY *= normInverse;
            torus3DAxisZ *= normInverse;
        }
        double dx = query.getX() - torus3DPositionX;
        double dy = query.getY() - torus3DPositionY;
        double dz = query.getZ() - torus3DPositionZ;
        double positionOnAxis = dx * torus3DAxisX + dy * torus3DAxisY + dz * torus3DAxisZ;
        double projectionOnAxisX = torus3DPosition.getX() + positionOnAxis * torus3DAxisX;
        double distanceSquaredFromAxis = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)projectionOnAxisX, (double)(projectionOnAxisY = torus3DPosition.getY() + positionOnAxis * torus3DAxisY), (double)(projectionOnAxisZ = torus3DPosition.getZ() + positionOnAxis * torus3DAxisZ), (Point3DReadOnly)query);
        if (distanceSquaredFromAxis < 1.0E-12) {
            return EuclidCoreTools.norm((double)torus3DRadius, (double)positionOnAxis) - torus3DTubeRadius;
        }
        double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
        return EuclidCoreTools.norm((double)(distanceFromAxis - torus3DRadius), (double)positionOnAxis) - torus3DTubeRadius;
    }

    public static boolean orthogonalProjectionOntoTorus3D(Point3DReadOnly pointToProject, Point3DReadOnly torus3DPosition, Vector3DReadOnly torus3DAxis, double torus3DRadius, double torus3DTubeRadius, Point3DBasics projectionToPack) {
        double zInPlane;
        double yInPlane;
        double z;
        double y;
        double percentageOnAxis;
        double x = pointToProject.getX() - torus3DPosition.getX();
        double xInPlane = x - (percentageOnAxis = TupleTools.dot((double)x, (double)(y = pointToProject.getY() - torus3DPosition.getY()), (double)(z = pointToProject.getZ() - torus3DPosition.getZ()), (Tuple3DReadOnly)torus3DAxis)) * torus3DAxis.getX();
        double distanceSquaredFromAxis = EuclidCoreTools.normSquared((double)xInPlane, (double)(yInPlane = y - percentageOnAxis * torus3DAxis.getY()), (double)(zInPlane = z - percentageOnAxis * torus3DAxis.getZ()));
        if (distanceSquaredFromAxis < 1.0E-12) {
            double zNonCollinearToAxis;
            double yNonCollinearToAxis;
            double xNonCollinearToAxis;
            if (Math.abs(torus3DAxis.getY()) > 0.1 || Math.abs(torus3DAxis.getZ()) > 0.1) {
                xNonCollinearToAxis = 1.0;
                yNonCollinearToAxis = 0.0;
                zNonCollinearToAxis = 0.0;
            } else {
                xNonCollinearToAxis = 0.0;
                yNonCollinearToAxis = 1.0;
                zNonCollinearToAxis = 0.0;
            }
            double xOrthogonalToAxis = yNonCollinearToAxis * torus3DAxis.getZ() - zNonCollinearToAxis * torus3DAxis.getY();
            double yOrthogonalToAxis = zNonCollinearToAxis * torus3DAxis.getX() - xNonCollinearToAxis * torus3DAxis.getZ();
            double zOrthogonalToAxis = xNonCollinearToAxis * torus3DAxis.getY() - yNonCollinearToAxis * torus3DAxis.getX();
            double norm = EuclidCoreTools.norm((double)xOrthogonalToAxis, (double)yOrthogonalToAxis, (double)zOrthogonalToAxis);
            double distanceFromTubeCenter = EuclidCoreTools.norm((double)percentageOnAxis, (double)torus3DRadius);
            double scale = torus3DTubeRadius / distanceFromTubeCenter;
            double resultDistanceFromAxis = torus3DRadius - torus3DRadius * scale;
            double resultPositionOnAxis = percentageOnAxis * scale;
            projectionToPack.set(xOrthogonalToAxis, yOrthogonalToAxis, zOrthogonalToAxis);
            projectionToPack.scale(resultDistanceFromAxis / norm);
            projectionToPack.scaleAdd(resultPositionOnAxis, (Tuple3DReadOnly)torus3DAxis, (Tuple3DReadOnly)projectionToPack);
            projectionToPack.add((Tuple3DReadOnly)torus3DPosition);
            return true;
        }
        double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
        if (EuclidCoreTools.normSquared((double)(distanceFromAxis - torus3DRadius), (double)percentageOnAxis) <= torus3DTubeRadius * torus3DTubeRadius) {
            return false;
        }
        double scale = torus3DRadius / distanceFromAxis;
        double xTubeCenter = xInPlane * scale + torus3DPosition.getX();
        double yTubeCenter = yInPlane * scale + torus3DPosition.getY();
        double zTubeCenter = zInPlane * scale + torus3DPosition.getZ();
        double distanceFromTubeCenter = EuclidGeometryTools.distanceBetweenPoint3Ds((double)xTubeCenter, (double)yTubeCenter, (double)zTubeCenter, (Point3DReadOnly)pointToProject);
        projectionToPack.set((Tuple3DReadOnly)pointToProject);
        projectionToPack.sub(xTubeCenter, yTubeCenter, zTubeCenter);
        projectionToPack.scale(torus3DTubeRadius / distanceFromTubeCenter);
        projectionToPack.add(xTubeCenter, yTubeCenter, zTubeCenter);
        return true;
    }

    public static double evaluatePoint3DTorus3DCollision(Point3DReadOnly query, Point3DReadOnly torus3DPosition, Vector3DReadOnly torus3DAxis, double torus3DRadius, double torus3DTubeRadius, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalToPack) {
        double zTubeCenter;
        double yTubeCenter;
        double zInPlane;
        double yInPlane;
        double z;
        double y;
        double percentageOnAxis;
        double x;
        double xInPlane;
        double distanceSquaredFromAxis;
        double torus3DPositionX = torus3DPosition.getX();
        double torus3DPositionY = torus3DPosition.getY();
        double torus3DPositionZ = torus3DPosition.getZ();
        double torus3DAxisX = torus3DAxis.getX();
        double torus3DAxisY = torus3DAxis.getY();
        double torus3DAxisZ = torus3DAxis.getZ();
        if (!(torus3DAxis instanceof UnitVector3DReadOnly)) {
            double normInverse = 1.0 / EuclidCoreTools.norm((double)torus3DAxisX, (double)torus3DAxisY, (double)torus3DAxisZ);
            torus3DAxisX *= normInverse;
            torus3DAxisY *= normInverse;
            torus3DAxisZ *= normInverse;
        }
        if ((distanceSquaredFromAxis = EuclidCoreTools.normSquared((double)(xInPlane = (x = query.getX() - torus3DPositionX) - (percentageOnAxis = x * torus3DAxisX + (y = query.getY() - torus3DPositionY) * torus3DAxisY + (z = query.getZ() - torus3DPositionZ) * torus3DAxisZ) * torus3DAxisX), (double)(yInPlane = y - percentageOnAxis * torus3DAxisY), (double)(zInPlane = z - percentageOnAxis * torus3DAxisZ))) < 1.0E-12) {
            if (Math.abs(torus3DAxis.getY()) > 0.1 || Math.abs(torus3DAxis.getZ()) > 0.1) {
                normalToPack.set(1.0, 0.0, 0.0);
            } else {
                normalToPack.set(0.0, 1.0, 0.0);
            }
            normalToPack.cross((Tuple3DReadOnly)torus3DAxis);
            normalToPack.normalize();
            double distanceFromTubeCenter = EuclidCoreTools.norm((double)percentageOnAxis, (double)torus3DRadius);
            double scale = torus3DTubeRadius / distanceFromTubeCenter;
            double resultDistanceFromAxis = torus3DRadius - torus3DRadius * scale;
            double resultPositionOnAxis = percentageOnAxis * scale;
            closestPointOnSurfaceToPack.set((Tuple3DReadOnly)normalToPack);
            closestPointOnSurfaceToPack.scale(resultDistanceFromAxis);
            closestPointOnSurfaceToPack.set(resultPositionOnAxis * torus3DAxisX + closestPointOnSurfaceToPack.getX(), resultPositionOnAxis * torus3DAxisY + closestPointOnSurfaceToPack.getY(), resultPositionOnAxis * torus3DAxisZ + closestPointOnSurfaceToPack.getZ());
            closestPointOnSurfaceToPack.add(torus3DPositionX, torus3DPositionY, torus3DPositionZ);
            normalToPack.scale(-torus3DRadius);
            normalToPack.set(percentageOnAxis * torus3DAxisX + normalToPack.getX(), percentageOnAxis * torus3DAxisY + normalToPack.getY(), percentageOnAxis * torus3DAxisZ + normalToPack.getZ());
            normalToPack.scale(1.0 / distanceFromTubeCenter);
            return distanceFromTubeCenter - torus3DTubeRadius;
        }
        double distanceFromAxis = EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis);
        double scale = torus3DRadius / distanceFromAxis;
        double xTubeCenter = xInPlane * scale + torus3DPositionX;
        double distanceSquaredFromTubeCenter = EuclidGeometryTools.distanceSquaredBetweenPoint3Ds((double)xTubeCenter, (double)(yTubeCenter = yInPlane * scale + torus3DPositionY), (double)(zTubeCenter = zInPlane * scale + torus3DPositionZ), (Point3DReadOnly)query);
        if (distanceSquaredFromTubeCenter < 1.0E-12) {
            normalToPack.set(torus3DAxisX, torus3DAxisY, torus3DAxisZ);
            closestPointOnSurfaceToPack.set(xTubeCenter, yTubeCenter, zTubeCenter);
            closestPointOnSurfaceToPack.scaleAdd(torus3DTubeRadius, (Tuple3DReadOnly)normalToPack, (Tuple3DReadOnly)closestPointOnSurfaceToPack);
            return -torus3DTubeRadius;
        }
        double distanceFromTubeCenter = EuclidCoreTools.squareRoot((double)distanceSquaredFromTubeCenter);
        normalToPack.set((Tuple3DReadOnly)query);
        normalToPack.sub(xTubeCenter, yTubeCenter, zTubeCenter);
        normalToPack.scale(1.0 / distanceFromTubeCenter);
        closestPointOnSurfaceToPack.setAndScale(torus3DTubeRadius, (Tuple3DReadOnly)normalToPack);
        closestPointOnSurfaceToPack.add(xTubeCenter, yTubeCenter, zTubeCenter);
        return distanceFromTubeCenter - torus3DTubeRadius;
    }

    public static void supportingVertexCircle3D(Vector3DReadOnly supportDirection, Point3DReadOnly circle3DPosition, Vector3DReadOnly circle3DAxis, double circle3DRadius, Point3DBasics supportingVertexToPack) {
        supportingVertexToPack.set((Tuple3DReadOnly)supportDirection);
        double dot = supportDirection.dot((Tuple3DReadOnly)circle3DAxis);
        supportingVertexToPack.setAndScale(dot / circle3DAxis.normSquared(), (Tuple3DReadOnly)circle3DAxis);
        supportingVertexToPack.sub((Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertexToPack);
        double distanceSquaredFromCenter = supportingVertexToPack.distanceFromOriginSquared();
        if (distanceSquaredFromCenter < 1.0E-12) {
            double zNonCollinearToAxis;
            double yNonCollinearToAxis;
            double xNonCollinearToAxis;
            if (Math.abs(circle3DAxis.getY()) > 0.1 || Math.abs(circle3DAxis.getZ()) > 0.1) {
                xNonCollinearToAxis = 1.0;
                yNonCollinearToAxis = 0.0;
                zNonCollinearToAxis = 0.0;
            } else {
                xNonCollinearToAxis = 0.0;
                yNonCollinearToAxis = 1.0;
                zNonCollinearToAxis = 0.0;
            }
            double xOrthogonalToAxis = yNonCollinearToAxis * circle3DAxis.getZ() - zNonCollinearToAxis * circle3DAxis.getY();
            double yOrthogonalToAxis = zNonCollinearToAxis * circle3DAxis.getX() - xNonCollinearToAxis * circle3DAxis.getZ();
            double zOrthogonalToAxis = xNonCollinearToAxis * circle3DAxis.getY() - yNonCollinearToAxis * circle3DAxis.getX();
            supportingVertexToPack.set(xOrthogonalToAxis, yOrthogonalToAxis, zOrthogonalToAxis);
            supportingVertexToPack.scale(circle3DRadius / EuclidCoreTools.norm((double)xOrthogonalToAxis, (double)yOrthogonalToAxis, (double)zOrthogonalToAxis));
        } else {
            supportingVertexToPack.scale(circle3DRadius / EuclidCoreTools.squareRoot((double)distanceSquaredFromCenter));
        }
        supportingVertexToPack.add((Tuple3DReadOnly)circle3DPosition);
    }

    public static void innerSupportingVertexTorus3D(Vector3DReadOnly supportDirection, Point3DReadOnly torus3DPosition, Vector3DReadOnly torus3DAxis, double torus3DRadius, double torus3DTubeRadius, Point3DBasics supportingVertexToPack) {
        double torus3DAxisX = torus3DAxis.getX();
        double torus3DAxisY = torus3DAxis.getY();
        double torus3DAxisZ = torus3DAxis.getZ();
        supportingVertexToPack.setAndNegate((Tuple3DReadOnly)supportDirection);
        double dot = TupleTools.dot((Tuple3DReadOnly)supportingVertexToPack, (Tuple3DReadOnly)torus3DAxis);
        supportingVertexToPack.setAndScale(dot / torus3DAxis.normSquared(), (Tuple3DReadOnly)torus3DAxis);
        supportingVertexToPack.add((Tuple3DReadOnly)supportDirection);
        supportingVertexToPack.negate();
        double distanceSquaredFromCenter = supportingVertexToPack.distanceFromOriginSquared();
        if (distanceSquaredFromCenter < 1.0E-12) {
            double zNonCollinearToAxis;
            double yNonCollinearToAxis;
            double xNonCollinearToAxis;
            if (Math.abs(torus3DAxisY) > 0.1 || Math.abs(torus3DAxisZ) > 0.1) {
                xNonCollinearToAxis = 1.0;
                yNonCollinearToAxis = 0.0;
                zNonCollinearToAxis = 0.0;
            } else {
                xNonCollinearToAxis = 0.0;
                yNonCollinearToAxis = 1.0;
                zNonCollinearToAxis = 0.0;
            }
            double xOrthogonalToAxis = yNonCollinearToAxis * torus3DAxisZ - zNonCollinearToAxis * torus3DAxisY;
            double yOrthogonalToAxis = zNonCollinearToAxis * torus3DAxisX - xNonCollinearToAxis * torus3DAxisZ;
            double zOrthogonalToAxis = xNonCollinearToAxis * torus3DAxisY - yNonCollinearToAxis * torus3DAxisX;
            supportingVertexToPack.set(xOrthogonalToAxis, yOrthogonalToAxis, zOrthogonalToAxis);
            supportingVertexToPack.scale(torus3DRadius / EuclidCoreTools.norm((double)xOrthogonalToAxis, (double)yOrthogonalToAxis, (double)zOrthogonalToAxis));
        } else {
            supportingVertexToPack.scale(torus3DRadius / EuclidCoreTools.squareRoot((double)distanceSquaredFromCenter));
        }
        double tubeCenterX = supportingVertexToPack.getX();
        double tubeCenterY = supportingVertexToPack.getY();
        double tubeCenterZ = supportingVertexToPack.getZ();
        double toTubeCenterX = tubeCenterX / torus3DRadius;
        double toTubeCenterY = tubeCenterY / torus3DRadius;
        double toTubeCenterZ = tubeCenterZ / torus3DRadius;
        double tubeLocalAxisX = torus3DAxisY * toTubeCenterZ - torus3DAxisZ * toTubeCenterY;
        double tubeLocalAxisY = torus3DAxisZ * toTubeCenterX - torus3DAxisX * toTubeCenterZ;
        double tubeLocalAxisZ = torus3DAxisX * toTubeCenterY - torus3DAxisY * toTubeCenterX;
        double tubeLocalAxisNormSqured = EuclidCoreTools.normSquared((double)tubeLocalAxisX, (double)tubeLocalAxisY, (double)tubeLocalAxisZ);
        dot = TupleTools.dot((double)tubeLocalAxisX, (double)tubeLocalAxisY, (double)tubeLocalAxisZ, (Tuple3DReadOnly)supportDirection) / tubeLocalAxisNormSqured;
        supportingVertexToPack.set(supportDirection.getX() - dot * tubeLocalAxisX, supportDirection.getY() - dot * tubeLocalAxisY, supportDirection.getZ() - dot * tubeLocalAxisZ);
        distanceSquaredFromCenter = supportingVertexToPack.distanceFromOriginSquared();
        if (distanceSquaredFromCenter < 1.0E-12) {
            supportingVertexToPack.set(tubeLocalAxisX, tubeLocalAxisY, tubeLocalAxisZ);
            supportingVertexToPack.scale(-torus3DTubeRadius / EuclidCoreTools.squareRoot((double)tubeLocalAxisNormSqured));
        } else {
            supportingVertexToPack.scale(torus3DTubeRadius / EuclidCoreTools.squareRoot((double)distanceSquaredFromCenter));
        }
        supportingVertexToPack.add(tubeCenterX, tubeCenterY, tubeCenterZ);
        supportingVertexToPack.add((Tuple3DReadOnly)torus3DPosition);
    }

    public static double boxVolume(double sizeX, double sizeY, double sizeZ) {
        return sizeX * sizeY * sizeZ;
    }

    public static double capsuleVolume(double radius, double length) {
        return Math.PI * radius * radius * (1.3333333333333333 * radius + length);
    }

    public static double coneVolume(double height, double radius) {
        return Math.PI * radius * radius * height / 3.0;
    }

    public static double cylinderVolume(double length, double radius) {
        return Math.PI * radius * radius * length;
    }

    public static double ellipsoidVolume(double radiusX, double radiusY, double radiusZ) {
        return 4.1887902047863905 * radiusX * radiusY * radiusZ;
    }

    public static double icosahedronVolume(double edgeLength) {
        return edgeLength * edgeLength * edgeLength * (5.0 * (3.0 + EuclidCoreTools.squareRoot((double)5.0))) / 12.0;
    }

    public static double pyramidVolume(double height, double baseLength, double baseWidth) {
        return baseLength * baseWidth * height / 3.0;
    }

    public static double rampVolume(double sizeX, double sizeY, double sizeZ) {
        return 0.5 * EuclidShapeTools.boxVolume(sizeX, sizeY, sizeZ);
    }

    public static double sphereVolume(double radius) {
        return EuclidShapeTools.ellipsoidVolume(radius, radius, radius);
    }

    public static double tetrahedronVolume(Point3DReadOnly a, Point3DReadOnly b, Point3DReadOnly c, Point3DReadOnly d) {
        double x = (c.getY() - a.getY()) * (d.getZ() - a.getZ()) - (c.getZ() - a.getZ()) * (d.getY() - a.getY());
        double y = (c.getZ() - a.getZ()) * (d.getX() - a.getX()) - (c.getX() - a.getX()) * (d.getZ() - a.getZ());
        double z = (c.getX() - a.getX()) * (d.getY() - a.getY()) - (c.getY() - a.getY()) * (d.getX() - a.getX());
        return Math.abs(x * (b.getX() - a.getX()) + y * (b.getY() - a.getY()) + z * (b.getZ() - a.getZ())) / 6.0;
    }

    public static double torusVolume(double radius, double tubeRadius) {
        return 19.739208802178716 * radius * tubeRadius * tubeRadius;
    }

    public static double icosahedronEdgeLength(double radius) {
        return radius / EuclidCoreTools.sin((double)1.2566370614359172);
    }

    public static double icosahedronRadius(double edgeLength) {
        return edgeLength * EuclidCoreTools.sin((double)1.2566370614359172);
    }

    public static boolean geometricallyEquals(Point3DReadOnly expected, Point3DReadOnly actual, Vector3DReadOnly normal, double normalEpsilon, double tangentialEpsilon) {
        double normalX = normal.getX();
        double normalY = normal.getY();
        double normalZ = normal.getZ();
        return EuclidShapeTools.geometricallyEquals(expected, actual, normalX, normalY, normalZ, normalEpsilon, tangentialEpsilon);
    }

    public static boolean geometricallyEquals(Point3DReadOnly expected, Point3DReadOnly actual, double normalX, double normalY, double normalZ, double normalEpsilon, double tangentialEpsilon) {
        double errorZ;
        double errorY;
        double errorX;
        double errorNormal;
        double normalLengthSquared = EuclidCoreTools.normSquared((double)normalX, (double)normalY, (double)normalZ);
        if (!EuclidCoreTools.epsilonEquals((double)1.0, (double)normalLengthSquared, (double)1.0E-12)) {
            double normalLengthInverse = 1.0 / EuclidCoreTools.fastSquareRoot((double)normalLengthSquared);
            normalX *= normalLengthInverse;
            normalY *= normalLengthInverse;
            normalZ *= normalLengthInverse;
        }
        if (!EuclidCoreTools.isZero((double)(errorNormal = (errorX = expected.getX() - actual.getX()) * normalX + (errorY = expected.getY() - actual.getY()) * normalY + (errorZ = expected.getZ() - actual.getZ()) * normalZ), (double)normalEpsilon)) {
            return false;
        }
        double errorNormalX = errorNormal * normalX;
        double errorNormalY = errorNormal * normalY;
        double errorNormalZ = errorNormal * normalZ;
        double errorTangentialX = errorX - errorNormalX;
        double errorTangentialY = errorY - errorNormalY;
        double errorTangentialZ = errorZ - errorNormalZ;
        double errorTangential = EuclidCoreTools.norm((double)errorTangentialX, (double)errorTangentialY, (double)errorTangentialZ);
        return EuclidCoreTools.isZero((double)errorTangential, (double)tangentialEpsilon);
    }
}

