/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.impl;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractHalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class AbstractVertex3D<Vertex extends AbstractVertex3D<Vertex, Edge, Face>, Edge extends AbstractHalfEdge3D<Vertex, Edge, Face>, Face extends AbstractFace3D<Vertex, Edge, Face>>
implements Vertex3DReadOnly,
Point3DBasics {
    private double x;
    private double y;
    private double z;
    private final List<Edge> associatedEdges = new ArrayList<Edge>();

    public AbstractVertex3D() {
        this.setToZero();
    }

    public AbstractVertex3D(double x, double y, double z) {
        this.set(x, y, z);
    }

    public AbstractVertex3D(Point3DReadOnly position) {
        this.set((Tuple3DReadOnly)position);
    }

    public List<Edge> getAssociatedEdges() {
        return this.associatedEdges;
    }

    public Edge getAssociatedEdge(int index) {
        return (Edge)((AbstractHalfEdge3D)this.associatedEdges.get(index));
    }

    public boolean removeAssociatedEdge(Edge edgeToRemove) {
        return this.associatedEdges.remove(edgeToRemove);
    }

    public void clearAssociatedEdgeList() {
        this.associatedEdges.clear();
    }

    public boolean addAssociatedEdge(Edge edgeToAdd) {
        if (!this.isEdgeAssociated((HalfEdge3DReadOnly)edgeToAdd)) {
            if (((AbstractHalfEdge3D)edgeToAdd).getOrigin() != this) {
                throw new IllegalArgumentException("A vertex's associated edges should originate from this same vertex.");
            }
            this.associatedEdges.add(edgeToAdd);
            return true;
        }
        return false;
    }

    public Edge getEdgeTo(Vertex3DReadOnly destination) {
        return (Edge)((AbstractHalfEdge3D)Vertex3DReadOnly.super.getEdgeTo(destination));
    }

    @Override
    public int getNumberOfAssociatedEdges() {
        return this.getAssociatedEdges().size();
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object object) {
        if (object instanceof Vertex3DReadOnly) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((double)this.x, (double)this.y, (double)this.z);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

