/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryFactories;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractHalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractVertex3D;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.BoxPolytope3DView;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

class BoxPolytope3D
implements BoxPolytope3DView {
    private final Box3D box3D;
    private final Face xMinFace;
    private final Face yMinFace;
    private final Face zMinFace;
    private final Face xMaxFace;
    private final Face yMaxFace;
    private final Face zMaxFace;
    private final List<Face> faces;
    private final List<HalfEdge> edges;
    private final List<Vertex> vertices;

    BoxPolytope3D(Box3D box3D) {
        this.box3D = box3D;
        DoubleSupplier xMin = () -> -0.5 * box3D.getSizeX();
        DoubleSupplier yMin = () -> -0.5 * box3D.getSizeY();
        DoubleSupplier zMin = () -> -0.5 * box3D.getSizeZ();
        DoubleSupplier xMax = () -> 0.5 * box3D.getSizeX();
        DoubleSupplier yMax = () -> 0.5 * box3D.getSizeY();
        DoubleSupplier zMax = () -> 0.5 * box3D.getSizeZ();
        Vertex v0 = new Vertex(xMax, yMax, zMax);
        Vertex v1 = new Vertex(xMax, yMin, zMax);
        Vertex v2 = new Vertex(xMin, yMin, zMax);
        Vertex v3 = new Vertex(xMin, yMax, zMax);
        Vertex v4 = new Vertex(xMax, yMax, zMin);
        Vertex v5 = new Vertex(xMax, yMin, zMin);
        Vertex v6 = new Vertex(xMin, yMin, zMin);
        Vertex v7 = new Vertex(xMin, yMax, zMin);
        HalfEdge xMinE0 = new HalfEdge(v3, v2);
        HalfEdge xMinE1 = new HalfEdge(v2, v6);
        HalfEdge xMinE2 = new HalfEdge(v6, v7);
        HalfEdge xMinE3 = new HalfEdge(v7, v3);
        HalfEdge yMinE0 = new HalfEdge(v1, v5);
        HalfEdge yMinE1 = new HalfEdge(v5, v6);
        HalfEdge yMinE2 = new HalfEdge(v6, v2);
        HalfEdge yMinE3 = new HalfEdge(v2, v1);
        HalfEdge zMinE0 = new HalfEdge(v4, v7);
        HalfEdge zMinE1 = new HalfEdge(v7, v6);
        HalfEdge zMinE2 = new HalfEdge(v6, v5);
        HalfEdge zMinE3 = new HalfEdge(v5, v4);
        HalfEdge xMaxE0 = new HalfEdge(v0, v4);
        HalfEdge xMaxE1 = new HalfEdge(v4, v5);
        HalfEdge xMaxE2 = new HalfEdge(v5, v1);
        HalfEdge xMaxE3 = new HalfEdge(v1, v0);
        HalfEdge yMaxE0 = new HalfEdge(v0, v3);
        HalfEdge yMaxE1 = new HalfEdge(v3, v7);
        HalfEdge yMaxE2 = new HalfEdge(v7, v4);
        HalfEdge yMaxE3 = new HalfEdge(v4, v0);
        HalfEdge zMaxE0 = new HalfEdge(v0, v1);
        HalfEdge zMaxE1 = new HalfEdge(v1, v2);
        HalfEdge zMaxE2 = new HalfEdge(v2, v3);
        HalfEdge zMaxE3 = new HalfEdge(v3, v0);
        DoubleSupplier xFaceAreaSupplier = () -> box3D.getSizeY() * box3D.getSizeZ();
        DoubleSupplier yFaceAreaSupplier = () -> box3D.getSizeX() * box3D.getSizeZ();
        DoubleSupplier zFaceAreaSupplier = () -> box3D.getSizeX() * box3D.getSizeY();
        Shape3DPose pose = box3D.getPose();
        this.xMinFace = new Face("x-min", EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)pose.getXAxis()), xFaceAreaSupplier, xMinE0, xMinE1, xMinE2, xMinE3);
        this.yMinFace = new Face("y-min", EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)pose.getYAxis()), yFaceAreaSupplier, yMinE0, yMinE1, yMinE2, yMinE3);
        this.zMinFace = new Face("z-min", EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)pose.getZAxis()), zFaceAreaSupplier, zMinE0, zMinE1, zMinE2, zMinE3);
        this.xMaxFace = new Face("x-max", pose.getXAxis(), xFaceAreaSupplier, xMaxE0, xMaxE1, xMaxE2, xMaxE3);
        this.yMaxFace = new Face("y-max", pose.getYAxis(), yFaceAreaSupplier, yMaxE0, yMaxE1, yMaxE2, yMaxE3);
        this.zMaxFace = new Face("z-max", pose.getZAxis(), zFaceAreaSupplier, zMaxE0, zMaxE1, zMaxE2, zMaxE3);
        this.faces = Collections.unmodifiableList(Arrays.asList(this.xMinFace, this.yMinFace, this.zMinFace, this.xMaxFace, this.yMaxFace, this.zMaxFace));
        this.edges = Collections.unmodifiableList(this.faces.stream().flatMap(f -> f.getEdges().stream()).collect(Collectors.toList()));
        this.vertices = Collections.unmodifiableList(Arrays.asList(v0, v1, v2, v3, v4, v5, v6, v7));
        box3D.addChangeListeners(this.vertices);
        box3D.addChangeListeners(this.faces);
    }

    @Override
    public Face getXMinFace() {
        return this.xMinFace;
    }

    @Override
    public Face getYMinFace() {
        return this.yMinFace;
    }

    @Override
    public Face getZMinFace() {
        return this.zMinFace;
    }

    @Override
    public Face getXMaxFace() {
        return this.xMaxFace;
    }

    @Override
    public Face getYMaxFace() {
        return this.yMaxFace;
    }

    @Override
    public Face getZMaxFace() {
        return this.zMaxFace;
    }

    @Override
    public Box3DReadOnly getOwner() {
        return this.box3D;
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public List<HalfEdge> getHalfEdges() {
        return this.edges;
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    private class Vertex
    extends AbstractVertex3D<Vertex, HalfEdge, Face>
    implements Shape3DChangeListener {
        private final Point3DReadOnly positionLocal;
        private boolean dirty = true;

        private Vertex(DoubleSupplier xLocal, DoubleSupplier yLocal, DoubleSupplier zLocal) {
            this.positionLocal = EuclidCoreFactories.newLinkedPoint3DReadOnly((DoubleSupplier)xLocal, (DoubleSupplier)yLocal, (DoubleSupplier)zLocal);
        }

        @Override
        public void changed() {
            this.dirty = true;
        }

        private void update() {
            if (this.dirty) {
                this.dirty = false;
                BoxPolytope3D.this.box3D.getPose().transform(this.positionLocal, this);
            }
        }

        @Override
        public double getX() {
            this.update();
            return super.getX();
        }

        @Override
        public double getY() {
            this.update();
            return super.getY();
        }

        @Override
        public double getZ() {
            this.update();
            return super.getZ();
        }
    }

    private class HalfEdge
    extends AbstractHalfEdge3D<Vertex, HalfEdge, Face> {
        private HalfEdge(Vertex origin, Vertex destination) {
            super(origin, destination);
        }

        void findAndSetTwin() {
            HalfEdge edgeTo = (HalfEdge)((Vertex)this.getDestination()).getEdgeTo(this.getOrigin());
            if (edgeTo != null) {
                this.setTwin(edgeTo);
                ((HalfEdge)this.getTwin()).setTwin(this);
            }
        }
    }

    private class Face
    extends AbstractFace3D<Vertex, HalfEdge, Face>
    implements Shape3DChangeListener {
        private final String name;
        private final HalfEdge e0;
        private final HalfEdge e1;
        private final HalfEdge e2;
        private final HalfEdge e3;
        private final BoundingBox3DBasics boundingBox;
        private final Point3DBasics centroid;
        private final Vector3DReadOnly normalLocal;
        private final Vector3DBasics normal;
        private final DoubleSupplier areaSupplier;
        private boolean isBoundingBoxDirty;
        private boolean isCentroidDirty;
        private boolean isNormalDirty;

        private Face(String name, Vector3DReadOnly normalLocal, DoubleSupplier areaSupplier, HalfEdge e0, HalfEdge e1, HalfEdge e2, HalfEdge e3) {
            super(null, 0.0);
            this.boundingBox = EuclidGeometryFactories.newObservableBoundingBox3DBasics(null, (axis, bound) -> this.updateBoundingBox());
            this.centroid = EuclidCoreFactories.newObservablePoint3DBasics(null, axis -> this.updateCentroidAndArea());
            this.normal = EuclidCoreFactories.newObservableVector3DBasics(null, axis -> this.updateNormal());
            this.isBoundingBoxDirty = true;
            this.isCentroidDirty = true;
            this.isNormalDirty = true;
            this.name = name;
            this.normalLocal = normalLocal;
            this.areaSupplier = areaSupplier;
            this.e0 = e0;
            this.e1 = e1;
            this.e2 = e2;
            this.e3 = e3;
            this.initialize(Arrays.asList(e0, e1, e2, e3), normalLocal);
            e0.findAndSetTwin();
            e1.findAndSetTwin();
            e2.findAndSetTwin();
            e3.findAndSetTwin();
        }

        @Override
        public void changed() {
            this.isBoundingBoxDirty = true;
            this.isCentroidDirty = true;
            this.isNormalDirty = true;
        }

        @Override
        public void updateBoundingBox() {
            if (this.isBoundingBoxDirty) {
                this.isBoundingBoxDirty = false;
                super.updateBoundingBox();
            }
        }

        @Override
        public void updateCentroidAndArea() {
            if (this.isCentroidDirty) {
                this.isCentroidDirty = false;
                this.centroid.add((Tuple3DReadOnly)this.e0.getOrigin(), (Tuple3DReadOnly)this.e1.getOrigin());
                this.centroid.add((Tuple3DReadOnly)this.e2.getOrigin());
                this.centroid.add((Tuple3DReadOnly)this.e3.getOrigin());
                this.centroid.scale(0.25);
            }
        }

        @Override
        public void updateNormal() {
            if (this.isNormalDirty) {
                this.isNormalDirty = false;
                this.normal.set((Tuple3DReadOnly)this.normalLocal);
            }
        }

        @Override
        public Point3DBasics getCentroid() {
            return this.centroid;
        }

        @Override
        public Vector3DBasics getNormal() {
            return this.normal;
        }

        @Override
        public double getArea() {
            return this.areaSupplier.getAsDouble();
        }

        @Override
        public BoundingBox3DBasics getBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public String toString() {
            return "Box3D Face " + this.name + " " + super.toString();
        }
    }
}

