/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeConstructionTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidPolytopeTools {
    private EuclidPolytopeTools() {
    }

    public static int computeConvexPolytopeNumberOfVertices(int numberOfFaces, int numberOfEdges) {
        return numberOfEdges - numberOfFaces + 2;
    }

    public static Vector3D crossProductOfLineSegment3Ds(Point3DReadOnly lineSegmentStart1, Point3DReadOnly lineSegmentEnd1, Point3DReadOnly lineSegmentStart2, Point3DReadOnly lineSegmentEnd2) {
        Vector3D crossProduct = new Vector3D();
        EuclidPolytopeTools.crossProductOfLineSegment3Ds(lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2, (Vector3DBasics)crossProduct);
        return crossProduct;
    }

    public static void crossProductOfLineSegment3Ds(Point3DReadOnly lineSegmentStart1, Point3DReadOnly lineSegmentEnd1, Point3DReadOnly lineSegmentStart2, Point3DReadOnly lineSegmentEnd2, Vector3DBasics crossProductToPack) {
        double direction1X = lineSegmentEnd1.getX() - lineSegmentStart1.getX();
        double direction1Y = lineSegmentEnd1.getY() - lineSegmentStart1.getY();
        double direction1Z = lineSegmentEnd1.getZ() - lineSegmentStart1.getZ();
        double direction2X = lineSegmentEnd2.getX() - lineSegmentStart2.getX();
        double direction2Y = lineSegmentEnd2.getY() - lineSegmentStart2.getY();
        double direction2Z = lineSegmentEnd2.getZ() - lineSegmentStart2.getZ();
        double crossX = direction1Y * direction2Z - direction1Z * direction2Y;
        double crossY = direction1Z * direction2X - direction1X * direction2Z;
        double crossZ = direction1X * direction2Y - direction1Y * direction2X;
        crossProductToPack.set(crossX, crossY, crossZ);
    }

    public static boolean isPoint3DOnLeftSideOfLine3D(Point3DReadOnly point, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine, Vector3DReadOnly planeNormal) {
        return EuclidPolytopeTools.isPoint3DOnSideOfLine3D(point, firstPointOnLine, secondPointOnLine, planeNormal, true);
    }

    public static boolean isPoint3DOnLeftSideOfLine3D(Point3DReadOnly point, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Vector3DReadOnly planeNormal) {
        return EuclidPolytopeTools.isPoint3DOnSideOfLine3D(point, pointOnLine, lineDirection, planeNormal, true);
    }

    public static boolean isPoint3DOnRightSideOfLine3D(Point3DReadOnly point, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine, Vector3DReadOnly planeNormal) {
        return EuclidPolytopeTools.isPoint3DOnSideOfLine3D(point, firstPointOnLine, secondPointOnLine, planeNormal, false);
    }

    public static boolean isPoint3DOnRightSideOfLine3D(Point3DReadOnly point, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Vector3DReadOnly planeNormal) {
        return EuclidPolytopeTools.isPoint3DOnSideOfLine3D(point, pointOnLine, lineDirection, planeNormal, false);
    }

    public static boolean isPoint3DOnSideOfLine3D(double pointX, double pointY, double pointZ, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ, double planeNormalX, double planeNormalY, double planeNormalZ, boolean testLeftSide) {
        double dx = pointX - pointOnLineX;
        double dy = pointY - pointOnLineY;
        double dz = pointZ - pointOnLineZ;
        double crossX = lineDirectionY * dz - lineDirectionZ * dy;
        double crossY = lineDirectionZ * dx - lineDirectionX * dz;
        double crossZ = lineDirectionX * dy - lineDirectionY * dx;
        double dotProduct = crossX * planeNormalX + crossY * planeNormalY + crossZ * planeNormalZ;
        if (testLeftSide) {
            return dotProduct > 0.0;
        }
        return dotProduct < 0.0;
    }

    public static boolean isPoint3DOnSideOfLine3D(Point3DReadOnly point, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine, Vector3DReadOnly planeNormal, boolean testLeftSide) {
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double pointOnLineZ = firstPointOnLine.getZ();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        double lineDirectionZ = secondPointOnLine.getZ() - firstPointOnLine.getZ();
        return EuclidPolytopeTools.isPoint3DOnSideOfLine3D(point.getX(), point.getY(), point.getZ(), pointOnLineX, pointOnLineY, pointOnLineZ, lineDirectionX, lineDirectionY, lineDirectionZ, planeNormal.getX(), planeNormal.getY(), planeNormal.getZ(), testLeftSide);
    }

    public static boolean isPoint3DOnSideOfLine3D(Point3DReadOnly point, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Vector3DReadOnly planeNormal, boolean testLeftSide) {
        return EuclidPolytopeTools.isPoint3DOnSideOfLine3D(point.getX(), point.getY(), point.getZ(), pointOnLine.getX(), pointOnLine.getY(), pointOnLine.getZ(), lineDirection.getX(), lineDirection.getY(), lineDirection.getZ(), planeNormal.getX(), planeNormal.getY(), planeNormal.getZ(), testLeftSide);
    }

    public static double distanceSquaredToClosestHalfEdge3D(Point3DReadOnly query, List<? extends HalfEdge3DReadOnly> halfEdges) {
        if (halfEdges.isEmpty()) {
            return Double.NaN;
        }
        double minDistanceSquared = halfEdges.get(0).distanceSquared(query);
        for (int edgeIndex = 1; edgeIndex < halfEdges.size(); ++edgeIndex) {
            minDistanceSquared = Math.min(minDistanceSquared, halfEdges.get(edgeIndex).distanceSquared(query));
        }
        return minDistanceSquared;
    }

    public static double distanceToClosestHalfEdge3D(Point3DReadOnly query, List<? extends HalfEdge3DReadOnly> halfEdges) {
        return EuclidCoreTools.squareRoot((double)EuclidPolytopeTools.distanceSquaredToClosestHalfEdge3D(query, halfEdges));
    }

    public static <F extends Face3DReadOnly, E extends HalfEdge3DReadOnly> List<E> computeSilhouette(List<F> faces, Point3DReadOnly observer, double epsilon) {
        return EuclidPolytopeTools.computeSilhouette(faces, observer, epsilon, null);
    }

    public static <F extends Face3DReadOnly, E extends HalfEdge3DReadOnly> List<E> computeSilhouette(List<F> faces, Point3DReadOnly observer, double epsilon, Collection<F> visibleFacesToPack) {
        if (faces.isEmpty()) {
            return null;
        }
        if (faces.size() == 1) {
            return ((Face3DReadOnly)faces.get(0)).getEdges();
        }
        Face3DReadOnly leastVisibleFace = null;
        double minimumDistance = Double.POSITIVE_INFINITY;
        if (visibleFacesToPack == null) {
            visibleFacesToPack = new HashSet<F>();
        }
        visibleFacesToPack.clear();
        for (int faceIndex = 0; faceIndex < faces.size(); ++faceIndex) {
            Face3DReadOnly face = (Face3DReadOnly)faces.get(faceIndex);
            double signedDistance = face.signedDistanceFromSupportPlane(observer);
            if (signedDistance <= epsilon) {
                if (!(signedDistance >= -epsilon) || !face.isPointDirectlyAboveOrBelow(observer)) continue;
                return null;
            }
            if (signedDistance < minimumDistance) {
                leastVisibleFace = face;
                minimumDistance = signedDistance;
            }
            visibleFacesToPack.add(face);
        }
        if (visibleFacesToPack.isEmpty()) {
            return null;
        }
        if (visibleFacesToPack.size() > 1) {
            for (Face3DReadOnly visibleFace : visibleFacesToPack) {
                boolean hasAtLeastOneVisibleNeighbor = false;
                for (int edgeIndex = 0; edgeIndex < visibleFace.getNumberOfEdges(); ++edgeIndex) {
                    if (!visibleFacesToPack.contains(visibleFace.getNeighbor(edgeIndex))) continue;
                    hasAtLeastOneVisibleNeighbor = true;
                    break;
                }
                if (hasAtLeastOneVisibleNeighbor) continue;
                return null;
            }
        }
        HalfEdge3DReadOnly silhouetteStartEdge = null;
        for (int neighborIndex = 0; neighborIndex < leastVisibleFace.getNumberOfEdges(); ++neighborIndex) {
            Face3DReadOnly neighbor = leastVisibleFace.getNeighbor(neighborIndex);
            if (visibleFacesToPack.contains(neighbor)) continue;
            silhouetteStartEdge = leastVisibleFace.getEdge(neighborIndex).getTwin();
            break;
        }
        assert (silhouetteStartEdge != null);
        ArrayList<HalfEdge3DReadOnly> silhouette = new ArrayList<HalfEdge3DReadOnly>();
        silhouette.add(silhouetteStartEdge);
        Vertex3DReadOnly currentVertex = silhouetteStartEdge.getDestination();
        while (currentVertex != silhouetteStartEdge.getOrigin()) {
            boolean foundNextEdge = false;
            for (HalfEdge3DReadOnly halfEdge3DReadOnly : currentVertex.getAssociatedEdges()) {
                if (visibleFacesToPack.contains(halfEdge3DReadOnly.getFace()) || !visibleFacesToPack.contains(halfEdge3DReadOnly.getTwin().getFace())) continue;
                silhouette.add(halfEdge3DReadOnly);
                currentVertex = halfEdge3DReadOnly.getDestination();
                foundNextEdge = true;
                break;
            }
            if (foundNextEdge) continue;
            throw new RuntimeException("Failed collecting the silhouette's edges");
        }
        return silhouette;
    }

    public static <F extends Face3DReadOnly, E extends HalfEdge3DReadOnly> List<F> computeInPlaneFacesAroundSilhouette(Point3DReadOnly query, Collection<E> silhouette, double epsilon) {
        ArrayList<Face3DReadOnly> inPlaneFacesToPack = new ArrayList<Face3DReadOnly>();
        for (HalfEdge3DReadOnly edge : silhouette) {
            Face3DReadOnly face = edge.getFace();
            if (inPlaneFacesToPack.contains(face) || !EuclidPolytopeTools.arePoint3DAndFace3DInPlane(query, face, epsilon)) continue;
            inPlaneFacesToPack.add(face);
        }
        return inPlaneFacesToPack;
    }

    public static boolean arePoint3DAndFace3DInPlane(Point3DReadOnly query, Face3DReadOnly face, double epsilon) {
        double distanceToPlane = face.distanceFromSupportPlane(query);
        if (distanceToPlane <= epsilon) {
            return true;
        }
        if (distanceToPlane >= 4.0 * epsilon) {
            return false;
        }
        Point3D average = new Point3D();
        Vector3D normal = new Vector3D((Tuple3DReadOnly)face.getNormal());
        ArrayList<? extends Vertex3DReadOnly> extendedFaceVertices = new ArrayList<Vertex3DReadOnly>(face.getVertices());
        extendedFaceVertices.add((Vertex3DReadOnly)query);
        EuclidPolytopeConstructionTools.updateFace3DNormal(extendedFaceVertices, (Point3DBasics)average, (Vector3DBasics)normal);
        for (Point3DReadOnly point3DReadOnly : extendedFaceVertices) {
            if (!(EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)point3DReadOnly, (Point3DReadOnly)average, (Vector3DReadOnly)normal) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean arePoint3DAndHalfEdge3DInLine(Point3DReadOnly query, HalfEdge3DReadOnly halfEdge, double epsilon) {
        if (halfEdge.distanceFromSupportLine(query) <= epsilon) {
            return true;
        }
        return halfEdge.getOrigin().distanceSquared(query) > halfEdge.getDestination().distanceSquared(query) ? EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)halfEdge.getDestination(), (Point3DReadOnly)query, (Point3DReadOnly)halfEdge.getOrigin()) <= epsilon : EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)halfEdge.getOrigin(), (Point3DReadOnly)query, (Point3DReadOnly)halfEdge.getDestination()) <= epsilon;
    }

    public static boolean tetrahedronContainsOrigin(Point3DReadOnly p0, Point3DReadOnly p1, Point3DReadOnly p2, Point3DReadOnly p3) {
        Vector3D n = EuclidPolytopeTools.crossProductOfLineSegment3Ds(p0, p1, p0, p2);
        if (TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)p0) > 0.0 == TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)p3) > 0.0) {
            return false;
        }
        n = EuclidPolytopeTools.crossProductOfLineSegment3Ds(p1, p2, p1, p3);
        if (TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)p1) > 0.0 == TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)p0) > 0.0) {
            return false;
        }
        n = EuclidPolytopeTools.crossProductOfLineSegment3Ds(p1, p2, p1, p3);
        if (TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)p2) > 0.0 == TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)p1) > 0.0) {
            return false;
        }
        n = EuclidPolytopeTools.crossProductOfLineSegment3Ds(p3, p0, p3, p1);
        return TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)p3) > 0.0 != TupleTools.dot((Tuple3DReadOnly)n, (Tuple3DReadOnly)p2) > 0.0;
    }

    public static boolean isFace3DConcyclic(Face3DReadOnly face3D, double epsilon) {
        return EuclidPolytopeTools.isConvexPolygon3DConcyclic(face3D.getVertices(), face3D.getNumberOfEdges(), epsilon);
    }

    public static boolean isConvexPolygon3DConcyclic(List<? extends Point3DReadOnly> convexPolygon3D, int numberOfVertices, double epsilon) {
        if (numberOfVertices == 0) {
            return false;
        }
        if (numberOfVertices <= 3) {
            return true;
        }
        int interval = Math.max(1, numberOfVertices / 3);
        Point3DReadOnly A = convexPolygon3D.get(0);
        int indexB = interval;
        Point3DReadOnly B = convexPolygon3D.get(indexB);
        int indexC = 2 * interval;
        Point3DReadOnly C = convexPolygon3D.get(indexC);
        double ux = B.getX() - C.getX();
        double uy = B.getY() - C.getY();
        double uz = B.getZ() - C.getZ();
        double vx = A.getX() - C.getX();
        double vy = A.getY() - C.getY();
        double vz = A.getZ() - C.getZ();
        double wx = A.getX() - B.getX();
        double wy = A.getY() - B.getY();
        double wz = A.getZ() - B.getZ();
        double uSquared = EuclidCoreTools.normSquared((double)ux, (double)uy, (double)uz);
        double vSquared = EuclidCoreTools.normSquared((double)vx, (double)vy, (double)vz);
        double wSquared = EuclidCoreTools.normSquared((double)wx, (double)wy, (double)wz);
        double uv = ux * vx + uy * vy + uz * vz;
        double uw = ux * wx + uy * wy + uz * wz;
        double vw = vx * wx + vy * wy + vz * wz;
        double ucwx = wy * uz - wz * uy;
        double ucwy = wz * ux - wx * uz;
        double ucwz = wx * uy - wy * ux;
        double ucwSquared = 0.5 / EuclidCoreTools.normSquared((double)ucwx, (double)ucwy, (double)ucwz);
        if (!Double.isFinite(ucwSquared)) {
            return false;
        }
        double alpha = uSquared * vw * ucwSquared;
        double beta = -vSquared * uw * ucwSquared;
        double gamma = wSquared * uv * ucwSquared;
        double px = alpha * A.getX() + beta * B.getX() + gamma * C.getX();
        double py = alpha * A.getY() + beta * B.getY() + gamma * C.getY();
        double pz = alpha * A.getZ() + beta * B.getZ() + gamma * C.getZ();
        double distanceSquaredReference = EuclidCoreTools.normSquared((double)(px - C.getX()), (double)(py - C.getY()), (double)(pz - C.getZ()));
        for (int i = 1; i < numberOfVertices; ++i) {
            Point3DReadOnly vertex;
            double distanceSquared;
            if (i == indexB || i == indexC || EuclidCoreTools.epsilonEquals((double)distanceSquaredReference, (double)(distanceSquared = EuclidCoreTools.normSquared((double)(px - (vertex = convexPolygon3D.get(i)).getX()), (double)(py - vertex.getY()), (double)(pz - vertex.getZ()))), (double)epsilon)) continue;
            return false;
        }
        return true;
    }
}

