/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.tools;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidShapeTestTools {
    private static final String DEFAULT_FORMAT = EuclidCoreTestTools.DEFAULT_FORMAT;

    private EuclidShapeTestTools() {
    }

    public static void assertEuclidShape3DCollisionResultEquals(EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals(null, expected, actual, epsilon);
    }

    public static void assertEuclidShape3DCollisionResultEquals(String messagePrefix, EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidShape3DCollisionResultEquals(String messagePrefix, EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
        }
        if (!expected.epsilonEquals(actual, epsilon)) {
            if (expected.areShapesColliding() != actual.areShapesColliding()) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
            } else {
                Vector3D differenceNormalOnA = new Vector3D();
                differenceNormalOnA.sub((Tuple3DReadOnly)expected.getNormalOnA(), (Tuple3DReadOnly)actual.getNormalOnA());
                Vector3D differenceNormalOnB = new Vector3D();
                differenceNormalOnB.sub((Tuple3DReadOnly)expected.getNormalOnB(), (Tuple3DReadOnly)actual.getNormalOnB());
                Object difference = "[";
                difference = (String)difference + "distance: " + Math.abs(expected.getSignedDistance() - actual.getSignedDistance());
                difference = (String)difference + ", pointOnA: " + expected.getPointOnA().distance(actual.getPointOnA()) + ", normalOnA: " + differenceNormalOnA.norm();
                difference = (String)difference + ", pointOnB: " + expected.getPointOnB().distance(actual.getPointOnB()) + ", normalOnB: " + differenceNormalOnB.norm();
                difference = (String)difference + "]";
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)difference, (String)format);
            }
        }
    }

    public static void assertEuclidShape3DCollisionResultGeometricallyEquals(EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertEuclidShape3DCollisionResultGeometricallyEquals(EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals(null, expected, actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double epsilon) {
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon, DEFAULT_FORMAT);
    }

    public static void assertEuclidShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double epsilon, String format) {
        EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals(messagePrefix, expected, actual, epsilon, epsilon, epsilon, format);
    }

    public static void assertEuclidShape3DCollisionResultGeometricallyEquals(String messagePrefix, EuclidShape3DCollisionResultReadOnly expected, EuclidShape3DCollisionResultReadOnly actual, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
        }
        if (!expected.geometricallyEquals(actual, distanceEpsilon, pointTangentialEpsilon, normalEpsilon)) {
            if (expected.areShapesColliding() != actual.areShapesColliding()) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)format);
            } else {
                Vector3D differenceNormalOnA = new Vector3D();
                differenceNormalOnA.sub((Tuple3DReadOnly)expected.getNormalOnA(), (Tuple3DReadOnly)actual.getNormalOnA());
                Vector3D differenceNormalOnB = new Vector3D();
                differenceNormalOnB.sub((Tuple3DReadOnly)expected.getNormalOnB(), (Tuple3DReadOnly)actual.getNormalOnB());
                Object difference = "[";
                difference = (String)difference + "distance: " + Math.abs(expected.getSignedDistance() - actual.getSignedDistance());
                difference = (String)difference + ", pointOnA: " + expected.getPointOnA().distance(actual.getPointOnA()) + ", normalOnA: " + differenceNormalOnA.norm();
                difference = (String)difference + ", pointOnB: " + expected.getPointOnB().distance(actual.getPointOnB()) + ", normalOnB: " + differenceNormalOnB.norm();
                difference = (String)difference + "]";
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (EuclidGeometry)expected, (EuclidGeometry)actual, (String)difference, (String)format);
            }
        }
    }

    public static void assertConvexPolytope3DGeneralIntegrity(ConvexPolytope3DReadOnly convexPolytope3D) {
        EuclidShapeTestTools.assertConvexPolytope3DGeneralIntegrity(null, convexPolytope3D);
    }

    public static void assertConvexPolytope3DGeneralIntegrity(String messagePrefix, ConvexPolytope3DReadOnly convexPolytope3D) {
        if (convexPolytope3D.getCentroid().containsNaN()) {
            EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)"The polytope's centroid contains NaN.");
        }
        if (convexPolytope3D.getNumberOfFaces() > 1) {
            int verticesSize = convexPolytope3D.getVertices().size();
            int halfEdgesSize = convexPolytope3D.getHalfEdges().size();
            int facesSize = convexPolytope3D.getFaces().size();
            int expectedNumberOfVertices = EuclidPolytopeTools.computeConvexPolytopeNumberOfVertices(facesSize, halfEdgesSize / 2);
            if (verticesSize != expectedNumberOfVertices) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)("Inconsistent data size, expected " + expectedNumberOfVertices + " vertices but was " + verticesSize));
            }
        }
        EuclidShapeTestTools.assertConvexPolytope3DFacesIntegrity(messagePrefix, convexPolytope3D);
        EuclidShapeTestTools.assertConvexPolytope3DHalfEdgesIntegrity(messagePrefix, convexPolytope3D);
        EuclidShapeTestTools.assertConvexPolytope3DVerticesIntegrity(messagePrefix, convexPolytope3D);
    }

    private static void assertConvexPolytope3DFacesIntegrity(String messagePrefix, ConvexPolytope3DReadOnly convexPolytope3D) {
        HashSet<Face3DReadOnly> faceSet = new HashSet<Face3DReadOnly>();
        for (int faceIndex = 0; faceIndex < convexPolytope3D.getNumberOfFaces(); ++faceIndex) {
            Face3DReadOnly face = convexPolytope3D.getFace(faceIndex);
            if (faceSet.add(face)) continue;
            EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face is a duplicate."));
        }
        Vector3D toOrigin = new Vector3D();
        Vector3D toDestination = new Vector3D();
        Vector3D toCentroid = new Vector3D();
        Vector3D cross = new Vector3D();
        if (convexPolytope3D.getNumberOfFaces() == 1) {
            for (int faceIndex = 0; faceIndex < convexPolytope3D.getNumberOfFaces(); ++faceIndex) {
                HalfEdge3DReadOnly edge;
                int edgeIndex;
                Face3DReadOnly face = convexPolytope3D.getFace(faceIndex);
                Point3DReadOnly centroid = face.getCentroid();
                Vector3DReadOnly normal = face.getNormal();
                List<? extends HalfEdge3DReadOnly> edges = face.getEdges();
                for (edgeIndex = 0; edgeIndex < edges.size(); ++edgeIndex) {
                    edge = edges.get(edgeIndex);
                    if (edge.getFace() != face) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge does not this face as its face."));
                    }
                    if (!edges.contains(edge.getNext())) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's next does not belong to this face."));
                    }
                    if (!edges.contains(edge.getPrevious())) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's previous does not belong to this face."));
                    }
                    if (edges.indexOf(edge.getNext()) == (edgeIndex + 1) % edges.size()) continue;
                    EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's next is not at the next index in the list."));
                }
                if (edges.size() < 3) continue;
                for (edgeIndex = 0; edgeIndex < edges.size(); ++edgeIndex) {
                    edge = edges.get(edgeIndex);
                    if (edge.getFace() != face) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge does not this face as its face."));
                    }
                    if (!edges.contains(edge.getNext())) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's next does not belong to this face."));
                    }
                    if (!edges.contains(edge.getPrevious())) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's previous does not belong to this face."));
                    }
                    if (edges.indexOf(edge.getNext()) != (edgeIndex + 1) % edges.size()) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's next is not at the next index in the list."));
                    }
                    toOrigin.sub((Tuple3DReadOnly)edge.getOrigin(), (Tuple3DReadOnly)centroid);
                    toDestination.sub((Tuple3DReadOnly)edge.getDestination(), (Tuple3DReadOnly)centroid);
                    cross.cross((Tuple3DReadOnly)toDestination, (Tuple3DReadOnly)toOrigin);
                    if (!(cross.dot((Tuple3DReadOnly)normal) < 0.0)) continue;
                    EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge is orientated counter-clockwise."));
                }
            }
        } else {
            for (int faceIndex = 0; faceIndex < convexPolytope3D.getNumberOfFaces(); ++faceIndex) {
                Face3DReadOnly face = convexPolytope3D.getFace(faceIndex);
                Point3DReadOnly centroid = face.getCentroid();
                Vector3DReadOnly normal = face.getNormal();
                List<? extends HalfEdge3DReadOnly> edges = face.getEdges();
                toCentroid.sub((Tuple3DReadOnly)centroid, (Tuple3DReadOnly)convexPolytope3D.getCentroid());
                if (toCentroid.dot((Tuple3DReadOnly)normal) < 0.0) {
                    if (convexPolytope3D.getVolume() < convexPolytope3D.getConstructionEpsilon()) {
                        System.out.println("WARNING: " + EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)(faceIndex + "th face's normal might be pointing towards the inside of the polytope.")));
                    } else {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face's normal is pointing towards the inside of the polytope."));
                    }
                }
                for (int edgeIndex = 0; edgeIndex < edges.size(); ++edgeIndex) {
                    HalfEdge3DReadOnly edge = edges.get(edgeIndex);
                    Face3DReadOnly neighbor = edge.getTwin().getFace();
                    if (edge.getFace() != face) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge does not this face as its face."));
                    }
                    if (!edges.contains(edge.getNext())) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's next does not belong to this face."));
                    }
                    if (!edges.contains(edge.getPrevious())) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's previous does not belong to this face."));
                    }
                    if (edges.indexOf(edge.getNext()) != (edgeIndex + 1) % edges.size()) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge's next is not at the next index in the list."));
                    }
                    toOrigin.sub((Tuple3DReadOnly)edge.getOrigin(), (Tuple3DReadOnly)centroid);
                    toDestination.sub((Tuple3DReadOnly)edge.getDestination(), (Tuple3DReadOnly)centroid);
                    cross.cross((Tuple3DReadOnly)toDestination, (Tuple3DReadOnly)toOrigin);
                    if (cross.dot((Tuple3DReadOnly)normal) < 0.0) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face: the " + edgeIndex + "th edge is orientated counter-clockwise."));
                    }
                    if (!EuclidGeometryTools.isPoint3DAbovePlane3D((Point3DReadOnly)neighbor.getCentroid(), (Point3DReadOnly)face.getCentroid(), (Vector3DReadOnly)face.getNormal())) continue;
                    if (face.signedDistanceFromSupportPlane(neighbor.getCentroid()) < convexPolytope3D.getConstructionEpsilon()) {
                        System.out.println("WARNING: " + EuclidCoreTestTools.addPrefixToMessage((String)messagePrefix, (String)(faceIndex + "th face might be concave with respect to a neighor, the " + convexPolytope3D.getFaces().indexOf(neighbor) + "th face.")));
                        continue;
                    }
                    EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(faceIndex + "th face is concave with respect to a neighor, the " + convexPolytope3D.getFaces().indexOf(neighbor) + "th face."));
                }
            }
        }
    }

    private static void assertConvexPolytope3DHalfEdgesIntegrity(String messagePrefix, ConvexPolytope3DReadOnly convexPolytope3D) {
        HalfEdge3DReadOnly halfEdge;
        int halfEdgeIndex;
        HashSet<HalfEdge3DReadOnly> halfEdgeSet = new HashSet<HalfEdge3DReadOnly>();
        for (halfEdgeIndex = 0; halfEdgeIndex < convexPolytope3D.getNumberOfHalfEdges(); ++halfEdgeIndex) {
            halfEdge = convexPolytope3D.getHalfEdge(halfEdgeIndex);
            if (halfEdgeSet.add(halfEdge)) continue;
            EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge is a duplicate."));
        }
        for (halfEdgeIndex = 0; halfEdgeIndex < convexPolytope3D.getNumberOfHalfEdges(); ++halfEdgeIndex) {
            halfEdge = convexPolytope3D.getHalfEdge(halfEdgeIndex);
            Vertex3DReadOnly origin = halfEdge.getOrigin();
            Vertex3DReadOnly destination = halfEdge.getDestination();
            HalfEdge3DReadOnly twin = halfEdge.getTwin();
            HalfEdge3DReadOnly next = halfEdge.getNext();
            HalfEdge3DReadOnly previous = halfEdge.getPrevious();
            Face3DReadOnly face = halfEdge.getFace();
            if (convexPolytope3D.getNumberOfFaces() > 1 && twin == null) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's twin is null."));
            }
            if (next == null) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's next is null."));
            }
            if (previous == null) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's previous is null."));
            }
            if (face == null) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's face is null."));
            }
            if (twin != null && (origin != twin.getDestination() || destination != twin.getOrigin())) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge is inconsistent with its twin."));
            }
            if (origin != previous.getDestination()) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge is not attached to its previous."));
            }
            if (destination != next.getOrigin()) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge is not attached to its next."));
            }
            if (halfEdge.getFace() != previous.getFace()) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge does not share the same face as its previous."));
            }
            if (halfEdge.getFace() != next.getFace()) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge does not share the same face as its next."));
            }
            if (!origin.getAssociatedEdges().contains(halfEdge)) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge is not associated to its origin."));
            }
            if (origin != destination && destination.getAssociatedEdges().contains(halfEdge)) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge should not be associated to its origin."));
            }
            if (!halfEdge.getFace().getEdges().contains(halfEdge)) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's face does not declare it as one of its edges."));
            }
            if (!convexPolytope3D.getFaces().contains(face)) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's face is not registered as a polytope face."));
            }
            if (twin != null && !convexPolytope3D.getHalfEdges().contains(twin)) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's twin is not registered as a polytope half-edge."));
            }
            if (!convexPolytope3D.getHalfEdges().contains(next)) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's next is not registered as a polytope half-edge."));
            }
            if (!convexPolytope3D.getHalfEdges().contains(previous)) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's previous is not registered as a polytope half-edge."));
            }
            if (!convexPolytope3D.getVertices().contains(origin)) {
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's origin is not registered as a polytope vertex."));
            }
            if (convexPolytope3D.getVertices().contains(destination)) continue;
            EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(halfEdgeIndex + "th half-edge's destination is not registered as a polytope vertex."));
        }
    }

    private static void assertConvexPolytope3DVerticesIntegrity(String messagePrefix, ConvexPolytope3DReadOnly convexPolytope3D) {
        Vertex3DReadOnly vertex;
        int vertexIndex;
        HashSet<Vertex3DReadOnly> vertexSet = new HashSet<Vertex3DReadOnly>();
        for (vertexIndex = 0; vertexIndex < convexPolytope3D.getNumberOfVertices(); ++vertexIndex) {
            vertex = convexPolytope3D.getVertex(vertexIndex);
            if (vertexSet.add(vertex)) continue;
            EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(vertexIndex + "th vertex is a duplicate."));
        }
        for (vertexIndex = 0; vertexIndex < convexPolytope3D.getNumberOfVertices(); ++vertexIndex) {
            vertex = convexPolytope3D.getVertex(vertexIndex);
            Collection<? extends HalfEdge3DReadOnly> associatedEdges = vertex.getAssociatedEdges();
            HashSet<Face3DReadOnly> connectedFaces = new HashSet<Face3DReadOnly>();
            for (HalfEdge3DReadOnly halfEdge3DReadOnly : associatedEdges) {
                if (vertex != halfEdge3DReadOnly.getOrigin()) {
                    EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(vertexIndex + "th vertex is not the origin of an associated edge."));
                }
                if (!connectedFaces.add(halfEdge3DReadOnly.getFace())) {
                    EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)("The connected faces to " + vertexIndex + "th vertex are not unique."));
                }
                if (convexPolytope3D.getNumberOfFaces() > 1) {
                    if (halfEdge3DReadOnly.getDestination().getEdgeTo(vertex) == null) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(vertexIndex + "th vertex has an edge which destination does not have an edge going back to it."));
                    }
                    if (halfEdge3DReadOnly.getDestination().getEdgeTo(vertex) != halfEdge3DReadOnly.getTwin()) {
                        EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(vertexIndex + "th vertex has an edge which destination's return edge is not the twin."));
                    }
                }
                if (!halfEdge3DReadOnly.getFace().getVertices().contains(vertex)) {
                    EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(vertexIndex + "th vertex has an edge which face does not delare it."));
                }
                if (!convexPolytope3D.getFaces().contains(halfEdge3DReadOnly.getFace())) {
                    EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(vertexIndex + "th vertex has an edge's face which is not registered as a polytope face."));
                }
                if (!convexPolytope3D.getHalfEdges().contains(halfEdge3DReadOnly)) {
                    EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(vertexIndex + "th vertex has an edge which is not registered as a polytope edge."));
                }
                if (convexPolytope3D.getVertices().contains(halfEdge3DReadOnly.getDestination())) continue;
                EuclidCoreTestTools.throwAssertionError((String)messagePrefix, (String)(vertexIndex + "th vertex has an edge's destination which is not registered as a polytope vertex."));
            }
        }
    }
}

