/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Shape3DPoseReadOnly
extends RigidBodyTransformReadOnly {
    public RotationMatrixReadOnly getShapeOrientation();

    public Point3DReadOnly getShapePosition();

    default public RotationMatrixReadOnly getRotation() {
        return this.getShapeOrientation();
    }

    default public Point3DReadOnly getTranslation() {
        return this.getShapePosition();
    }

    public Vector3DReadOnly getXAxis();

    public Vector3DReadOnly getYAxis();

    public Vector3DReadOnly getZAxis();

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Shape3DPoseReadOnly)) {
            return false;
        }
        Shape3DPoseReadOnly other = (Shape3DPoseReadOnly)geometry;
        return this.getShapePosition().epsilonEquals((EuclidGeometry)other.getShapePosition(), epsilon) && this.getShapeOrientation().epsilonEquals((EuclidGeometry)other.getShapeOrientation(), epsilon);
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Shape3DPoseReadOnly)) {
            return false;
        }
        Shape3DPoseReadOnly other = (Shape3DPoseReadOnly)geometry;
        return this.getShapePosition().equals((EuclidGeometry)other.getShapePosition()) && this.getShapeOrientation().equals((EuclidGeometry)other.getShapeOrientation());
    }

    default public String toString(String format) {
        return EuclidShapeIOTools.getShape3DPoseString(format, this);
    }
}

